<?php
session_start();
$idRol = $_SESSION['idRol'];
switch ($idRol) {
    case 1:
        $rol = true;
        break;
    case 2:
        $rol = true;
        break;
    default:
        $rol = false;
        break;
}
if ($_SESSION['status'] != "ok" || $rol != true)
    header("location: logout.php");

include_once '../common/screenPortions.php';
include_once '../brules/KoolControls/KoolGrid/koolgrid.php';
require_once '../brules/KoolControls/KoolAjax/koolajax.php';
require_once '../brules/KoolControls/KoolCalendar/koolcalendar.php';
include_once '../brules/KoolControls/KoolGrid/ext/datasources/MySQLiDataSource.php';
$localization = "../brules/KoolControls/KoolCalendar/localization/es.xml";
//include_once '../brules/usuariosObj.php';
//include_once '../brules/vehiculosObj.php';
include_once '../brules/catEscalonamientoObj.php';

//establecer la zona horaria
$dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
$dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual


$escalonamientosObj = new catEscalonamientoObj();
$result = $escalonamientosObj->GetEscalonamientosGrid();

?>

<?php echo getHeaderTemplate('Alarmas', $_SESSION['myusername'], $_SESSION["rol"]); ?>

<?php echo getSideBarTemplate(); ?>

<section role="main" class="content-body">
    <header class="page-header">
        <h2>Escalonamientos</h2>

        <div class="right-wrapper pull-right">
            <ol class="breadcrumbs">
                <li>
                    <a href="patrullas.php">
                        <i class="fa fa-home"></i>
                    </a>
                </li>
                <li><span>Escalonamientos</span></li>
            </ol>

            <a class="sidebar-right-toggle" data-open="sidebar-right">
                <i class="fa fa-chevron-left"></i>
            </a>
        </div>
    </header>

    <!-- start: page -->
    <div class="row">
        <div class="col-md-12 panle-gral">
            <section class="panel">
                <header class="panel-heading">
                    <div class="panel-actions">
                        <!-- <a href="#" class="fa fa-caret-down"></a> -->
                        <!-- <a href="#" class="fa fa-times"></a> -->
                    </div>

                    <h2 class="panel-title">Escalonamientos</h2>
                    <p class="panel-subtitle"></p>
                </header>
                <div class="panel-body">
                    <br>
                    <div class="row">
                        <form name="grids" method="post">
                            <?php
                            echo $koolajax->Render();
                            echo '<div id="contsGrid">';
                            if ($result != null) {
                                echo $result->Render();
                            }
                            echo '</div>';
                            ?>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <!-- end: page -->


    <!--Viejo modal-->
    <div class="modal fade" id="popup_usr_datos" role="dialog" style="display:none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title"> Datos de alarma </h4>
                </div>
                <form role="form" id="formDeuda" name="formDeuda" method="post" action="" enctype="multipart/form-data">
                    <input type="hidden" name="idDeuda" id="idDeuda" value="0">
                    <div class="row">
                        <div class="col-md-1"></div>
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="content-data-usr">
                                        <div class="claveUsrModal">
                                            <label><b>Clave: <b></label>
                                            <label id="claveUsrMdl"></label>
                                        </div>
                                        <div class="nombreUsrModal">
                                            <label><b>Nombre: </b></label>
                                            <label id="nombreUsrMdl"></label>
                                        </div>
                                        <div class="apellidoPUsrModal">
                                            <label><b>Apellido Paterno: </b></label>
                                            <label id="apellidoPUsrMdl"></label>
                                        </div>
                                        <div class="apellidoMUsrModal">
                                            <label><b>Apellido Materno: </b></label>
                                            <label id="apellidoMUsrMdl"></label>
                                        </div>
                                        <div class="telefonoUsrModal">
                                            <label><b>Tel&eacute;fono: </b></label>
                                            <label id="telefonoUsrMdl"></label>
                                        </div>
                                        <div class="calleUsrModal">
                                            <label><b>Calle: </b></label>
                                            <label id="calleUsrMdl"></label>
                                        </div>
                                        <div class="numeroUsrModal">
                                            <label><b>N&uacute;mero: </b></label>
                                            <label id="numeroUsrMdl"></label>
                                        </div>
                                        <div class="coloniaUsrModal">
                                            <label><b>Colonia: </b></label>
                                            <label id="coloniaUsrMdl"></label>
                                        </div>
                                        <div class="cpUsrModal">
                                            <label><b>C.P: </b></label>
                                            <label id="cpUsrMdl"></label>
                                        </div>
                                        <div class="numComiteUsrModal">
                                            <label><b>Num comit&eacute;: </b></label>
                                            <label id="numComiteUsrMdl"></label>
                                        </div>
                                        <div class="fechaCreacionUsrModal">
                                            <label><b>Fecha alta: </b></label>
                                            <label id="fechaCreacionUsrMdl"></label>
                                        </div>
                                        <div class="fechaActUsrModal">
                                            <label><b>Ultima modificaci&oacute;n: </b></label>
                                            <label id="fechaActUsrMdl"></label>
                                        </div>
                                        <div class="validoUsrModal">
                                            <label><b>Valido: </b></label>
                                            <!-- Rounded switch -->
                                            <label class="switch">
                                                <input id="validoUsrMdl" type="checkbox">
                                                <span class="slider round"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnCerrarModalDeuda">Cerrar</button>
                                </div>
                                <div class="col-md-3">
                                    <!--<a class="btn btn-primary" id="btnGuardarDeuda" onclick="guardarDeuda()">Cerrar</a>-->
                                </div>
                                <div class="col-md-1"></div>
                            </div><br><br>
                        </div>
                        <div class="col-md-1"></div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalCheckupAlarma" role="dialog" style="display:none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h3 class="modal-title"> Check-Up </h3>
                </div>

                <div class="row">
                            <h4 class="alarmaCheckupClss" id="alarmaCheckupClss"></h4>
                </div>

                <div class="row">
                    <div class="col-md-1"></div>
                    <div class="col-md-10">

                    <table class="table">
                        <thead>
                            <tr>
                                <th><strong>REVISION</strong></th>
                                <th><strong>ESTADO</strong></th>
                                <th><strong>ACCION</strong></th>
                                <th><strong>NUEVO ESTADO</strong></th>
                                <th><strong>MENSAJES</strong></th>
                            </tr>
                        </thead>
                        <tbody id="contentCheckup">   

                        </tbody>
		    	
                    </table>
		    	<foot id="footerCheckup">

                        </foot>
                        <div class="col-md-1"></div>

                        <br>
                        <br>
                    </div>
                    <div class="col-md-1"></div>
                </div>

                <div class="boton-cerrar">
                    <!--<a class="btn btn-primary" id="btnGuardarDeuda" onclick="guardarDeuda()">Cerrar</a>-->
                    <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnCerrarModalDeuda">
                        Cerrar
                    </button>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    function encenderAlarmaButton(idVehiculo, accion, historico) {
        alertify.confirm('Encender Alarma', 'Estas seguro que quieres encender la alarma?', function() {
            encenderAlarma(idVehiculo, 1, 1);
            alertify.success('Alarma encendida');
        }, function() {
            alertify.warning('Cancelado');
        });
    }

    function apagarAlarmaButton(idVehiculo, accion, historico) {
        alertify.confirm('Apagar Alarma', 'Estas seguro que quieres apagar la alarma?', function() {
            encenderAlarma(idVehiculo, 0, 1);
            alertify.success('Alarma apagada');
        }, function() {
            alertify.warning('Cancelado');
        });
    }

    //Realizamos check-up de alarma
    function checkupAlarma(idAlarma, matriculaAlarma) {

        $("#alarmaCheckupClss").html(matriculaAlarma);
        
        //Mostramos loadings
        var htmlContentCheckup = showLoading("contentCheckup");

        //Enviamos datos para realizar check
        var params = {
            funct: "verifyDevice",
            idAlarma: idAlarma
        };

        ajaxData(params, function(data) {
            console.log("verifyDevice");
            console.log(data);

            var desbloqueoObj={};
            var estadoObj={};
            var tokenObj={};
            var servidorObj={};
            var enLineaObj={};
            var mensajeObj={};
            var deviceIdObj={};
            

            if (data.success) {

                var htmlCheckupTable="";

                //Bloque de BLOQUEADA
                //hideLoading("checkBloqueoAlarma", htmlCheckBloqueoAlarma);
                if (data.bloqueada == "updated") {

                    //La alarma estaba como ocupada sin peticion asignada y se actualizo como disponible
                    desbloqueoObj.estado="Bloqueada";
                    desbloqueoObj.accion="Desbloquear";
                    desbloqueoObj.nuevoEstado = "Desbloqueada";
                    desbloqueoObj.notas="*";
                    //$("#checkBloqueoAlarma").html("CORRECTAMENTE DESBLOQUEADA <span class='fa fa-check-circle'></span>");

                } else if (data.bloqueada == "no updated") {

                    //La alarma esta como ocupada sin peticion activa pero no se pudo actualizar por algun error
                    desbloqueoObj.estado="Bloqueada";
                    desbloqueoObj.accion="Desbloquear";
                    desbloqueoObj.nuevoEstado = "Bloqueada";
                    desbloqueoObj.notas="No se pudo desbloquear alarma, verifique configuracion manual e intentelo mas tarde";
                    
                    //$("#checkBloqueoAlarma").html("NO DESBLOQUEADA <span class='fa fa-exclamation-triangle'></span>");
                } else if (data.bloqueada == "ok") {

                    //La alarma no esta en estado de ocupada y no se realio ninguna accion
                    desbloqueoObj.estado="Desbloqueada";
                    desbloqueoObj.accion="Ninguna";
                    desbloqueoObj.nuevoEstado = "*";
                    desbloqueoObj.notas="*";
                    
                    //$("#checkBloqueoAlarma").html("DESBLOQUEADA <span class='fa fa-check-circle'></span>");
                } else {
                    //Intentelo mas tarde
                    alertify.warning("Intentalo mas tarde");
                    desbloqueoObj.estado="No definido";
                    desbloqueoObj.accion="No definido";
                    desbloqueoObj.nuevoEstado = "No definido";
                    desbloqueoObj.notas="Verifique su conexion o revise la configuracion e intentelo mas tarde";
                    
                }

                //Bloque de ESTADO 
                //hideLoading("checkEstadoAlarma", htmlCheckEstadoAlarma);
                if(data.estado == "on"){
                    //La alarma esta disponible
                    estadoObj.estado="Encendida";
                    estadoObj.accion="Apagar";
                    estadoObj.nuevoEstado = "Apagada";
                    estadoObj.notas="*";

                    //$("#checkEstadoAlarma").html("ALARMA FUE APAGADA<span class='fa fa-check-circle'></span>");

                }else if(data.estado =="off"){
                    //El token no se pudo actualizar por algun error
                    estadoObj.estado="Apagada";
                    estadoObj.accion="Ninguna";
                    estadoObj.nuevoEstado = "*";
                    estadoObj.notas="*";

                    //$("#checkEstadoAlarma").html("ALARMA APAGADA<span class='fa fa-check-circle'></span>");
                }else{
                    //Intentelo mas tarde
                    estadoObj.estado="No definido";
                    estadoObj.accion="No definido";
                    estadoObj.nuevoEstado = "No definido";
                    estadoObj.notas="Verifique su conexion o revise la configuracion e intentelo mas tarde";
                }


                //Bloque de TOKEN
                //hideLoading("checkTokenAlarma", htmlCheckTokenAlarma);
                if (data.token == "updated") {
                    //El token fue actualizado
                    tokenObj.estado="Expirado";
                    tokenObj.accion="Actualizar";
                    tokenObj.nuevoEstado = "Actualizado";
                    tokenObj.notas="*";

                    //$("#checkTokenAlarma").html("ACTUALIZADO <span class='fa fa-check-circle'></span>");
                } else if (data.token == "no updated") {
                    //El token no se pudo actualizar por algun error
                    tokenObj.estado="Expirado";
                    tokenObj.accion="Actualizar";
                    tokenObj.nuevoEstado = "Expirado";
                    tokenObj.notas="No se pudo actualizar el token verifique su conexion o los datos de cuenta";

                    //$("#checkTokenAlarma").html("NO ACTUALIZADO <span class='fa fa-exclamation-triangle'></span>");
                } else if (data.token == "ok") {
                    //El token sigue siendo el correcto
                    tokenObj.estado="Correcto";
                    tokenObj.accion="Ninguna";
                    tokenObj.nuevoEstado = "*";
                    tokenObj.notas="*";

                    //$("#checkTokenAlarma").html("CORRECTO <span class='fa fa-check-circle'></span>");
                } else {
                    //Intentelo mas tarde
                    alertify.warning("Intentalo mas tarde");
                    tokenObj.estado="No definido";
                    tokenObj.accion="No definido";
                    tokenObj.nuevoEstado = "No definido";
                    tokenObj.notas="Verifique su conexion o revise la configuracion e intentelo mas tarde";
                }

                //Bloque de SERVIDOR
                //hideLoading("checkServidorAlarma", htmlCheckServidorAlarma);
                if (data.servidor == "updated") {
                    //El servidor fue actualizado
                    servidorObj.estado="Incorrecto";
                    servidorObj.accion="Actualizar";
                    servidorObj.nuevoEstado = "Actualizado";
                    servidorObj.notas="*";

                    //$("#checkServidorAlarma").html("ACTUALIZADO <span class='fa fa-check-circle'></span>");
                } else if (data.servidor == "no updated") {
                    //El servidor no se pudo actualizar por algun error
                    servidorObj.estado="Incorrecto";
                    servidorObj.accion="Actualizar";
                    servidorObj.nuevoEstado = "Incorrecto";
                    servidorObj.notas="No se pudo actualizar el servidor, intentelo mas tarde";

                    //$("#checkServidorAlarma").html("NO ACTUALIZADO <span class='fa fa-exclamation-triangle'></span>");
                } else if (data.servidor == "ok") {
                    //El servidor sigue siendo el correcto
                    servidorObj.estado="Correcto";
                    servidorObj.accion="Ninguna";
                    servidorObj.nuevoEstado = "*";
                    servidorObj.notas="*";

                    //$("#checkServidorAlarma").html("CORRECTO <span class='fa fa-check-circle'></span>");
                } else {
                    //Intentelo mas tarde
                    alertify.warning("Intentalo mas tarde");
                    servidorObj.estado="No definido";
                    servidorObj.accion="No definido";
                    servidorObj.nuevoEstado = "No definido";
                    servidorObj.notas="Verifique su conexion o revise la configuracion e intentelo mas tarde";
                }

                
                //Bloque de EN LINEA
                //hideLoading("checkEnLineaAlarma", htmlContentCheckup);
                if (data.enLinea) {
                    enLineaObj.estado="En linea";
                    enLineaObj.accion="Ninguna";
                    enLineaObj.nuevoEstado = "*";
                    enLineaObj.notas="*";

                    //$("#checkEnLineaAlarma").html("EN LINEA <span class='fa fa-check-circle'></span>");
                } else if(data.enLinea == "unknow"){
                    enLineaObj.estado="No definido";
                    enLineaObj.accion="No definido";
                    enLineaObj.nuevoEstado = "No definido";
                    enLineaObj.notas="Verifique su conexion o revise la configuracion e intentelo mas tarde";
                } else {
                    //Alarma no disponible
                    enLineaObj.estado="Fuera de linea";
                    enLineaObj.accion="Ninguna";
                    enLineaObj.nuevoEstado = "*";
                    enLineaObj.notas="*";

                    //$("#checkEnLineaAlarma").html("FUERA DE LINEA <span class='fa fa-exclamation-triangle'></span>");
                }

                //ERROR DE SERVER
                if(data.mensaje == "unknow"){
                    mensajeObj.notas="Ocurrio un error desconocido, intentelo mas tarde";
                }else if(data.mensaje == "server"){
                    mensajeObj.notas="El servidor registrado no coincide con los registrados dentro de la base de datos";
                }else if(data.mensaje == "timeout"){
                    mensajeObj.notas="Error de conexion, dispositivo fuera de linea o sin corriente, verificar dipositivo fisicamente";
                }else{
                    mensajeObj.notas="*";
                }

                //ERROR DEVICEID
                if(data.deviceId=="unknow"){
                    deviceIdObj.notas="Se encontro un error en el deviceId, se tiene que corregir antes de ponder realizar el analisis";
                }else{
                    deviceIdObj.notas="**";
                }

                

                //HTML BLOQUEO
                htmlCheckupTable+= "<tr>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= "Bloqueo";
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= desbloqueoObj.estado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= desbloqueoObj.accion;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= desbloqueoObj.nuevoEstado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= desbloqueoObj.notas;
                    htmlCheckupTable+= "</td>";
                htmlCheckupTable+= "</tr>";

                //HTML ESTADO
                htmlCheckupTable+= "<tr>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= "Encendido logico";
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= estadoObj.estado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= estadoObj.accion;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= estadoObj.nuevoEstado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= estadoObj.notas;
                    htmlCheckupTable+= "</td>";
                htmlCheckupTable+= "</tr>";

                //HTML TOKEN
                htmlCheckupTable+= "<tr>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= "Token";
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= tokenObj.estado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= tokenObj.accion;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= tokenObj.nuevoEstado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= tokenObj.notas;
                    htmlCheckupTable+= "</td>";
                htmlCheckupTable+= "</tr>";

                //HTML SERVIDOR
                htmlCheckupTable+= "<tr>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= "Servidor";
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= servidorObj.estado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= servidorObj.accion;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= servidorObj.nuevoEstado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= servidorObj.notas;
                    htmlCheckupTable+= "</td>";
                htmlCheckupTable+= "</tr>";

                //HTML EN LINEA
                htmlCheckupTable+= "<tr>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= "En linea";
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= enLineaObj.estado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= enLineaObj.accion;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= enLineaObj.nuevoEstado;
                    htmlCheckupTable+= "</td>";
                    htmlCheckupTable+= "<td>";
                        htmlCheckupTable+= enLineaObj.notas;
                    htmlCheckupTable+= "</td>";
                htmlCheckupTable+= "</tr>";

                //HTML FOOTER NOTES
                var htmlCheckupTableFooter= "";
                htmlCheckupTableFooter+= "<tr>";
                    htmlCheckupTableFooter+="<td class='footerContent'>";
                        htmlCheckupTableFooter+="<div class='titleNotasFooter'>";
                            htmlCheckupTableFooter+="Mensajes generales";
                        htmlCheckupTableFooter+="</div>";
                        htmlCheckupTableFooter+="<div class='contentNotasFooter'>";
                            htmlCheckupTableFooter+=deviceIdObj.notas;
                        htmlCheckupTableFooter+="</div>";
                        htmlCheckupTableFooter+="<div class='contentNotasFooter'>";
                            htmlCheckupTableFooter+=mensajeObj.notas;
                        htmlCheckupTableFooter+="</div>";
                    htmlCheckupTableFooter+="</td>";
                htmlCheckupTableFooter+= "</tr>";

                hideLoading("contentCheckup", htmlContentCheckup);
               

                $("#footerCheckup").html("");
                $("#footerCheckup").html(htmlCheckupTableFooter);
                $("#contentCheckup").html("");
                $("#contentCheckup").html(htmlCheckupTable);
                

            } else {
                alertify.warning("No se pudo realizar el check-up intentelo mas tarde");
            }

        });
    }
</script>

<?php echo getFooterTemplate(); ?>