<?php
session_start();

$idRol = $_SESSION['idRol'];
switch ($idRol) {
	case 1:
	case 2:
	case 5:
	case 6:
	case 7:
	case 9:
		$rol = true;
		break;

	default:
		$rol = false;
		break;
}

if ($_SESSION['status'] != "ok" || $rol != true) {
	header("location: logout.php");
}

$localization = "../brules/KoolControls/KoolCalendar/localization/es.xml";
include_once '../brules/KoolControls/KoolGrid/koolgrid.php';
require_once '../brules/KoolControls/KoolAjax/koolajax.php';
require_once '../brules/KoolControls/KoolCalendar/koolcalendar.php';
include_once '../brules/KoolControls/KoolGrid/ext/datasources/MySQLiDataSource.php';
include_once '../brules/KoolControls/KoolGrid/ext/datasources/AdvancedArrayDataSource.php';
include_once '../common/screenPortions.php';
include_once '../common/globalFunctions.php';
include_once '../brules/cambiosUsuariosObj.php';
include_once '../brules/peticionesObj.php';

$gbFuncts = new globalFunctions();
$cmbUsuariosObj = new cambiosUsuariosObj();

// establecer la zona horaria
$dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
$dateTime = $dateByZone->format('Y-m-d H:i:s');

$fechaInicio = isset($_GET['formFechaInicio']) ? $_GET['formFechaInicio'] : $gbFuncts->getFormattedDate("-7 day", "Y-m-d");
$fechaFin = isset($_GET['formFechaFin']) ? $_GET['formFechaFin'] : $gbFuncts->getFormattedDate("now", "Y-m-d");

$grid = $cmbUsuariosObj->getCambiosUsuariosByDateGrid($fechaInicio, $fechaFin);
?>

<?php
$htmlExtra = '
	<style>
		.modal__title {
			margin-top: 30px;
			font-weight: bold;
			color: black;
		}

		.bold {
			color: rgba(0,0,0, 0.8);
			font-weight: bold;
		}
	</style>
';
echo getHeaderTemplate('Historial Cambios en Usuarios', $_SESSION['myusername'], $_SESSION["rol"], false, false, $htmlExtra);

echo getSideBarTemplate();
?>

<section role="main" class="content-body">
	<header class="page-header">
		<h2>Historial de Cambios en Usuarios</h2>

		<div class="right-wrapper pull-right">
			<ol class="breadcrumbs">
				<li>
					<a href="patrullas.php">
						<i class="fa fa-home"></i>
					</a>
				</li>
				<li>
                    <span>Historial de Cambios en Usuarios</span>
                </li>
			</ol>

			<a class="sidebar-right-toggle" data-open="sidebar-right">
				<i class="fa fa-chevron-left"></i>
			</a>
		</div>
	</header>

	<!-- start: page -->
	<div class="row">
		<div class="col-md-12">
			<section class="panel">
				<header class="panel-heading">
					<div class="panel-actions">
						<a href="#" class="fa fa-caret-down"></a>
					</div>
					<h2 class="panel-title">Historial de Cambios en Usuarios</h2>
					<p class="panel-subtitle">En este panel se podr&aacute; analizar el historial de cambios que se han realizado a los usuarios por d&iacute;a.</p>
				</header>

				<div class="panel-body">
					<div class="row left1">
						<div class="col-xs-4 text-right"><label>Ver historico: </label> </div>
						<div class="col-xs-8">
							<select class="form-control" name="vista" id="vista" onchange="cambiarVista(this)">
								<option value=''>Seleccione...</option>
								<option value='histPeticiones'>Peticiones</option>
								<option value='historicoalarmas' >Alarmas (encendido manual)</option>
								<option value='historicocron'>Cronjob</option>
								<option value='historicotoken'>Token</option>
								<!-- <option value='historicoCambiosUsuarios' selected=''>Cambios en Usuarios</option> -->
								<option value='histPatrullero'>Asignaciones patrulleros</option>
								<option value='histAccesosPatrulleros'>Accesos patrulleros</option>
							</select>
						</div>
					</div>

					<div class="row right1">
						<form id="formActualizarLista" action="historicoCambiosUsuarios.php" method="GET" class="form">
							<div class="col-xs-12">
								<label for="formFechaInicio">De: </label>
								<input type="date" id="formFechaInicio" name="formFechaInicio">
								<label for="formFechaFin">Hasta: </label>
								<input type="date" id="formFechaFin" name="formFechaFin">
								<input type="button" class="btn btn-success" value="Actualizar" onclick="actualizarLista()">
								<button class="btn btn-default" onclick="descargarReporte()">
									Descargar Reporte
								</button>
							</div>
						</form>
					</div>
                    
					<br />
					<div class="row">
						<form name="grids" method="post">
							<?php
							echo $koolajax->Render();
							echo '<div id="contsGrid">';
							if ($grid != null) {
								echo $grid->Render();
							}
							echo '</div>';
							?>
						</form>
					</div>
				</div>
			</section>
		</div>
	</div>
	<!-- end: page -->
</section>

<script>
  /**
   * Sustituye comas por saltos de l�nea
   */
  const HTMLArray = document.getElementsByClassName('kgrCell');
  const arrayOfCells = Array.from(HTMLArray);
  arrayOfCells.map((cell) => {
    cell.childNodes[0].innerHTML = cell.childNodes[0].innerHTML.split(",")
    .join("<div style='width:100%; height: .3px; background-color:#eee'></div>");
  })


	var frmFechaInicio = document.getElementById("formFechaInicio");
	var frmFechaFin = document.getElementById("formFechaFin");
    frmFechaInicio.value = '<?php echo $fechaInicio; ?>';
	frmFechaFin.value = '<?php echo $fechaFin; ?>';

    function actualizarLista() {
        let newFechaInicio = new Date(frmFechaInicio.value);
        let newFechaFin = new Date(frmFechaFin.value);

        if (newFechaFin < newFechaInicio) {
            alertify.warning("La fecha de fin no puede ser menor a la fecha de inicio.");
        } else {
            document.getElementById('formActualizarLista').submit();
        }
	}

	function descargarReporte() {
		let repFechaInicio = frmFechaInicio.value;
        let repFechaFin = frmFechaFin.value;
		
		window.open("../ajaxcall2/exportaReporteCambiosUsuarios.php?fechaInicio=" + repFechaInicio + "&fechaFin=" + repFechaFin, '_blank');

		// if (fechaPeticiones != "" && fechaPeticiones != null && fechaPeticionessFin != "" && fechaPeticionessFin != null) {
			// window.open("../ajaxcall2/exportaReportePeticiones.php?fechaPeticiones=" + fechaPeticiones+"&fechaPeticionFin="+fechaPeticionessFin, '_blank');
			//location.href = "../ajaxcall2/exportaReportePeticiones.php?fechaPeticiones=" + fechaPeticiones+"&fechaPeticionFin="+fechaPeticionessFin;
		// }
	}
</script>

<?php
$jsExtra = '';
echo getFooterTemplate($jsExtra);
?>