<?php
class shellyB
{
    public function SwithPlug($token, $alarmaId, $bool, $shellyserver)
    {
        $accion = ($bool) ? "on" : "off";
        $cul = curl_init();
        curl_setopt_array($cul, array(
            CURLOPT_URL => $shellyserver.'device/relay/control',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('id' => $alarmaId, 
            'auth_key' => $token,
            'channel' => '0',
            'turn' => $accion),
        ));
        $respnse = curl_exec($cul);
        $status = curl_getinfo($cul, CURLINFO_HTTP_CODE);
        if($status == 401){
            $this->SwithPlug($token,$alarmaId,$bool,$shellyserver);
        }
       
        curl_close($cul);
        return [$status,$respnse];
    }
    public function respuesta_de_api($token, $alarmaId, $shellyserver)
    {
         sleep(2);
       
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $shellyserver . 'device/status?id=' . $alarmaId . '&auth_key=' . $token,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $response = curl_exec($curl);
        $bear = curl_getinfo($curl, CURLINFO_HTTP_CODE);
      
        curl_close($curl);
        //var_dump($bear);
        //var_dump( $response);
        // exit;
        return [$bear, $response];
    }
    public function LineaShelly($token, $alarmaId, $shellyserver,$tipodipositivo)
    {
        // modificacion para saber  que tipo de shelly es.
        sleep(2);
        switch ($tipodipositivo) {
            case 'shelly':
                $tipo = 1;
                break;
            case 'shelly-Mini':
                $tipo = 2;
                break;    
            
            default:
                # code...
                break;
        }
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $shellyserver . 'device/status?id=' . $alarmaId . '&auth_key=' . $token,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
       
        $response = curl_exec($curl); 
        //sleep(2);
       
        $json = json_decode($response, true);
        $flitado = $json['data']['online'];
        // modificacion para saber si esta prendido el shelly depende del modelo 
        if ($tipo == 1){
            // api v1
           $status = $json["data"]["device_status"]["relays"][0]["ison"];
        }elseif($tipo == 2){
            // api v2
           $status = $json["data"]["device_status"]["switch:0"]["output"];
        }
        curl_close($curl);
        // var_dump($json);
        // exit;
        return [$flitado, $status];
    }
    public function obtenerEstadoCompleto($token, $alarmaId, $shellyserver, $tipodipositivo)
    {
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $shellyserver . 'device/status?id=' . $alarmaId . '&auth_key=' . $token,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        curl_close($curl);

        // Parsear JSON solo si respuesta es exitosa y vlida
        $online = null;
        $estadoSwitch = null;

        if ($status == 200) {
            $json = json_decode($response, true);

            if (isset($json['data']['online'])) {
                $online = $json['data']['online'];
            }

            // Determinar tipo y extraer estado
            switch ($tipodipositivo) {
                case 'shelly':
                    // api v1
                    $estadoSwitch = $json["data"]["device_status"]["relays"][0]["ison"] ?? null;
                    break;
                case 'shelly-Mini':
                    // api v2
                    $estadoSwitch = $json["data"]["device_status"]["switch:0"]["output"] ?? null;
                    break;
                default:
                    // Si no se reconoce el tipo, dejar null o manejar error
                    $estadoSwitch = null;
            }
        }

        return [
            'http_code' => $status,
            'raw_response' => $response,
            'online' => $online,
            'switch_status' => $estadoSwitch
        ];
    }
}