<?php 
function get($url, $data, $method = "GET", $content = "normal", $cookies = false) {
    // Inicializa una nueva sesi n de cURL
    $ch = curl_init();

    // Configura los datos y encabezados seg n el tipo de contenido
    if ($content == "json") {
        // Si el contenido es JSON, codifica los datos como JSON
        $data_string = json_encode($data);
        // Define los encabezados para contenido JSON
        $headers = [
            'Content-Type: application/json',
            'Accept: */*',
            'User-Agent: PHP'
        ];
    } else {
        // Si el contenido es URL-encoded, codifica los datos como una cadena de consulta
        $data_string = http_build_query($data);
        // Define los encabezados para contenido URL-encoded
        $headers = [
            'Content-Type: application/x-www-form-urlencoded',
            'User-Agent: PHP'
        ];
    }

    // Configura el m todo HTTP y los datos a enviar
    if ($method == "POST") {
        // Si el m todo es POST, establece las opciones correspondientes en cURL
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    } else {
        // Para otros m todos (GET, PUT, DELETE, etc.)
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        if ($method == "GET") {
            // Si el m todo es GET, agrega los datos como par metros de la URL
            $url .= '?' . $data_string;
        } else {
            // Para otros m todos, env a los datos en el cuerpo de la solicitud
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        }
    }

    // Establece la URL para la solicitud
    curl_setopt($ch, CURLOPT_URL, $url);
    // Indica que se desea el resultado como una cadena
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // Establece los encabezados HTTP
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    // Incluye los encabezados de respuesta en el resultado
    curl_setopt($ch, CURLOPT_HEADER, true);

    // Ejecuta la solicitud cURL y obtiene la respuesta
    $response = curl_exec($ch);

    // Maneja los errores de cURL
    if (curl_errno($ch)) {
        return 'Error:' . curl_error($ch);
    }

    // Separa los encabezados y el cuerpo de la respuesta
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $header = substr($response, 0, $header_size);
    $body = substr($response, $header_size);

    // Cierra la sesi n cURL
    curl_close($ch);

    // Analiza las cookies de los encabezados de respuesta si se requiere
    $cookies_array = [];
    if ($cookies) {
        preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $header, $matches);
        foreach ($matches[1] as $item) {
            parse_str($item, $cookie);
            $cookies_array = array_merge($cookies_array, $cookie);
        }
    }

    // // Intenta decodificar el cuerpo de la respuesta como JSON
    $decoded_body = json_decode($body, true);
    // if (json_last_error() === JSON_ERROR_NONE) {
    //     // Si es JSON v lido, devuelve el cuerpo decodificado y las cookies (si se solicitaron)
    //     return $cookies ? [$decoded_body, $cookies_array] : $decoded_body;
    // } else {
    //     // Si no es JSON v lido, devuelve el cuerpo original y las cookies (si se solicitaron)
    //     return $cookies ? [$body, $cookies_array] : $body;
    // }
	
	
	if (json_last_error() === 0) {
		if($cookies) {
			return $decoded_body;
		} else {
			return $decoded_body;
		}
	} else {
		if($cookies) {
			return array($body, $cookies_array);
		} else {
			return $body;
		}
	}
}


 class TpLinkFramelova{
	//930eacef-de1b-474e-bef3-704d6244fa0c
	public function returnToken($user, $password) {
		$terminal = "930eacef-de1b-474e-bef3-704d6244fa0c";

		$response =get(
			"https://wap.tplinkcloud.com/", 
			json_decode('{"method":"login","params":{"cloudUserName":"'.$user.'","appType":"Kasa_iOS","terminalUUID":"'.$terminal.'","cloudPassword":"'.$password.'"}}'), 
			"POST", 
			"json", 
			true
		);
		// if($response['error_code'] == 0) {
			//setcookie ("tplink_token",$response["result"]['token'], time() + (3600*24*20));
			//return $response["result"]['token'];
			return $response;
		// } else {
			//return $response['error_code'];
			//throw new Exception("Invalid credentials");
		// }
		
	}

    public function plugSwitch($useUrl, $token, $device, $bool) {
        $switchData = array(
			"method" => "passthrough", 
			"params" => array(
				"deviceId" => "".$device['deviceId']."", 
				"requestData" => '{"system":{"set_relay_state":{"state":'.(($bool)?1:0).'}}}'
			)
		);
		
        $url = $useUrl."/?token=".$token."";
      

        $response = get($url, $switchData, "POST", "json");
       
        return $response;
	}

	//Consulta de estatus por alarma
	public function verifyStatus($useUrl, $token, $deviceId) {
		set_time_limit(0);

		$data = array(
			"method" => "passthrough",
			"params" => array(
				"deviceId" => $deviceId,
				"requestData"=> '{"system":{"get_sysinfo":null}}'
			)
		);

        $url = $useUrl."/?token=".$token."";
		$response = get($url, $data, "POST", "json");
		return $response;
	}

	//Validamos el servidor por deviceId de alarma (consideramos que siempre esta correcto el token y el deviceId)
	public function verifyServer($token, $deviceId, $server){

		$serverFound = "";
		$servidores = array(
			"https://use1-wap.tplinkcloud.com", 
			"https://aps1-wap.tplinkcloud.com", 
			"https://eu-wap.tplinkcloud.com"
		);

		$clave = array_search($server, $servidores);
		if (!$clave) {
			set_time_limit(0);

			$content = array(
				"method" => "getDeviceList"
			);
			$url = "https://wap.tplinkcloud.com?token=$token";
			$response = get($url, $content, "POST", "json");
			
			$deviceList = $response["result"]["deviceList"];
			foreach ($deviceList as $device) {
				if ($device['deviceId'] == $deviceId) {
					$res = array("equals" => false, "serverFound" =>  $device['appServerUrl']);
					return $res;
				}
			}
		} else {
			foreach ($servidores as $servidor) {

				$response = $this->getDeviceList($servidor, $token);
				$deviceList = $response["result"]["deviceList"];
				foreach ($deviceList as $device) {
					
					if ($device['deviceId'] == $deviceId) {

						$serverFound = $device['appServerUrl'];
						if ($serverFound != $server) {
							$res = array("equals" => false, "serverFound" => $serverFound);
							return $res;
						}
					}
				}
			}
		}
		$res = array("equals" => true);
	}

	public function getDeviceList($useUrl, $token) {
		set_time_limit(0);
		$switchData = array("method" => "getDeviceList");
        $url = $useUrl."/?token=".$token."";
		$response = get($url, $switchData, "POST", "json");
		
		// $plugs = array();
		// for ($i = 0; $i < count($response); $i++) {
		// 	$urlPlug = $response[$i]['appServerUrl']."/?token=".$token."";
		// 	//$plugJson = array("method" => "passthrough", "params" => array("deviceId" =>  $response[$i]['deviceId'], "requestData" => '{"schedule":{"get_next_action":{}},"system":{"get_sysinfo":{}}}'));
		// 	//$plugstate = json_decode(get($urlPlug, $plugJson, "POST", "json")['result']['responseData'], JSON_PRETTY_PRINT);
		// 	$plugs[$i] = array("deviceId" => $response[$i]['deviceId'],
		// 		"name" => $response[$i]['alias'],
		// 		"deviceName" => $response[$i]['deviceName']." ".$response[$i]['deviceModel'],
		// 		"mac" => $response[$i]['deviceMac'],
		// 		"useUrl" => $response[$i]['appServerUrl'],
		// 		"working" => $response[$i]['status'],
		// 		//"relay_status" => (($plugstate['error_code'] != 0)?"off":(($plugstate['system']['get_sysinfo']['relay_state'] == 0)?'off':'on')),
		// 		//"geo" => array("lat" => "".(($plugstate['system']['get_sysinfo']['latitude'])?$plugstate['system']['get_sysinfo']['latitude']:0)."", "lon" => "".(($plugstate['system']['get_sysinfo']['longitude'])?$plugstate['system']['get_sysinfo']['longitude']:0).""),
		// 		"Ids" => array("fwId" => $response[$i]['fwId'], "hwId" =>  $response[$i]['hwId'], "oemId" => $response[$i]['oemId']));
		// }
		// return $plugs;

		
		//return json_decode($response);
		return $response;


		/*
		//$response = '{"error_code":0,"result":{"deviceList":[{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006CD2F3B1E81028ABFEC1DBC9A2C871C2742AE","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"006","deviceMac":"74DA885D4E62","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006C8D6C1657099F723D2D5B332273C1B65C599","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"075","deviceMac":"68FF7B7209FC","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006A3C3AB6BD394A0F150780B0A24301B9B82B8","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"061","deviceMac":"98DAC409B20F","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006AAD8DCB35B6FA3C79BD0A3BB4BDF1B9BE789","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"040","deviceMac":"98DAC409B205","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006B8332FE6F6F6E0631822BD6D8BC41B643150","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"069","deviceMac":"68FF7B71FBDB","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006FEBE75F1CA01CBDD1E023513983E1C352B1A","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"031","deviceMac":"74DA8895FC13","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/eu-wap.tplinkcloud.com","deviceRegion":"eu-west-1","deviceId":"8006821B942826B81FAF8F0F6B19BF7D1B99579D","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"062","deviceMac":"68FF7BC57321","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"800680B46C80B602C570754331E83E721B651370","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"074","deviceMac":"68FF7B71F5B0","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80067F577286D849AE87CAC667CF62831B64D68F","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"067","deviceMac":"68FF7B71F5AB","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.2 Build 180528 Rel.114402","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"800607D311D0F8EE83C834DD0037EA1F1B654B5E","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"080","deviceMac":"68FF7B71F31A","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/eu-wap.tplinkcloud.com","deviceRegion":"eu-west-1","deviceId":"8006AF8787B71A58E63952EA155F397D1B9BE585","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"041","deviceMac":"98DAC409B1FC","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006CD9B389F52E446BF193331AF495C1B65EC0B","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"072","deviceMac":"68FF7B71F35A","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006403A84762BA648121521819FD6031B65FA3B","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"073","deviceMac":"68FF7B71FA00","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006CF32B06ECE76F647479A40BFDA031C2723EA","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"018","deviceMac":"74DA885D4F1D","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006664C9B63DAA9622D645D818045161C277BF2","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"025","deviceMac":"74DA885D500B","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80069D69F7CEB10F241685EB7D5B1A521B9B8CAB","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"057","deviceMac":"68FF7BC565C2","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006A53333B87646FF32DD9C9B8AD22A1B658055","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"066","deviceMac":"68FF7B71F568","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006BF0536DD286D2241F97C2B5ABBB71B65F005","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"068","deviceMac":"68FF7B7209BB","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006D181D3DC942E13D6DB5DDAB064A91C7564FB","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"026","deviceMac":"CC32E5CD0EA4","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006D45BBA3EC848BFE6B8976FBF7CC11C279E0D","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"024","deviceMac":"74DA885D4FD1","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006EF89B9D0D2C9B1C8201443DF27A81B9A290B","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"063","deviceMac":"68FF7BC57A1E","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006DC6087F5A953AAEFB6EB148C0A241B99F33E","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"064","deviceMac":"68FF7BC5741D","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80068EF20E6F81E777052E326B115A7C1B645122","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"082","deviceMac":"68FF7B71F3BA","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006F2C3F0C09CC2F7B36BC444656DEA1C273C5A","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"009","deviceMac":"74DA885D4EDE","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006D19318ABE45AF2C1CF809D519C5A1C27EA79","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"013","deviceMac":"74DA885D510C","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"800647F7079AC3C96EBB9AD003E78A881B640D21","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"028","deviceMac":"68FF7B71F98B","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"800678D75DBD38E3812BF1C602C8BAB31B9BF4E6","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"030","deviceMac":"68FF7BC567C6","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80063140A14B235978BD8C56E98BD1C01C27C8C7","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"001","deviceMac":"74DA885D4EA6","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"800611D0B24202EE02543C97BFECC9081B9B750E","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"036","deviceMac":"68FF7BC5661C","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006185AA18DE437B67604447F55643A1C279CC1","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"017","deviceMac":"74DA885D4F7C","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/eu-wap.tplinkcloud.com","deviceRegion":"eu-west-1","deviceId":"800656F7BA4FB5F8B63F575C7BBA8B7D1C27DAD5","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"014","deviceMac":"74DA885D4F75","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"800603B334163C8D592EB8F913573F1F1B9AE48F","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"038","deviceMac":"68FF7BC57717","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80069CA715B70EE8809C9848CC214F281B9B58A1","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"033","deviceMac":"98DAC409B208","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80069563EE50E1AA8BE0103D851083D41B65B8A7","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"070","deviceMac":"68FF7B71F9F7","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80067A74F54B31F4FC2164AE916D57F11B997766","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"060","deviceMac":"68FF7BC5814E","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006804B09A0643DCBF2E0AA66962E0C1B658704","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"Framelova-391","deviceMac":"68FF7B71F303","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"800653D250707C58536FA1C06C4465E41B9A7FA5","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"049","deviceMac":"68FF7BC56C90","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006233F1AD8831AF457876AB909FBD01B99503F","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"010","deviceMac":"68FF7BC572E1","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80061296008A7C97FEA456D0FC7AA3AD1B9A02F9","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"044","deviceMac":"68FF7BC56F8B","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"800620A5E527C12B1B443144C96D08151B645F1A","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"076","deviceMac":"68FF7B71F3F2","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006E6E45420803A3E605EEE747B27391B9AB1D0","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"056","deviceMac":"68FF7BC571FE","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80064FA4D1E763B8FABEF47BBECE63D01C35D655","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"008","deviceMac":"74DA8895FB4E","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80066FF44D9B4D566DF03BABD16723AC1C75160E","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"027","deviceMac":"CC32E5CD0E45","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006A1DC4FE0A30D4951D3D856ED436D1C2777AA","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"023","deviceMac":"74DA885D4FFD","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006251BA910086B12E1DED3FA4A002F1C276828","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"007","deviceMac":"74DA885D4DCC","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006519C4DFE8A9FAF671E6A77E9A6B61B99E4A8","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"051","deviceMac":"68FF7BC57306","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006A7EFB801AA10ED163C0A3B9608671C277026","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"012","deviceMac":"74DA885D4E47","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006EE7D6B428457FD0C0E21E832F7511C35A0E0","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"016","deviceMac":"74DA8895FBF9","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006A5406B6CC6FAAD3C2119BC60ACF71C2765DD","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"004","deviceMac":"74DA885D4FFE","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80060ECB28C25E6EFC2DB49C6C15BA3D1B652ED3","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"081","deviceMac":"68FF7B71F980","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/eu-wap.tplinkcloud.com","deviceRegion":"eu-west-1","deviceId":"80061B4BF8572192FA207354D1DCA5811B993E61","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"047","deviceMac":"68FF7BC5832D","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80065296472D723DBE5FA13BFF54D1481B9BF043","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"042","deviceMac":"98DAC409B203","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006326C661277B02F2DB673142433B71B9B7886","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"052","deviceMac":"98DAC409B1FE","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006D5317BF8190D1CB277E048D80E5C1B9B5870","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"032","deviceMac":"98DAC409B207","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80066C7EE2DFD13723425EDCE413447F1C275B9C","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"Framelova-1","deviceMac":"74DA885D4E4A","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/eu-wap.tplinkcloud.com","deviceRegion":"eu-west-1","deviceId":"8006EDBB11FAD6B9E4C4EA0BCF79C66E1C27CBD4","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"021","deviceMac":"74DA885D5022","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"800665A4BBFED29921514E3861783DB31B9BE3BB","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"059","deviceMac":"68FF7BC56920","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006BEB594D7B2B37EFD53079CC328991C2782CE","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"022","deviceMac":"74DA885D5122","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80065D361C70CC62D03A73190F432D661B9A50C4","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"065","deviceMac":"68FF7BC57B4D","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006FDAC70591267DBE46D47BE62B3361C27FDBC","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"002","deviceMac":"74DA885D4DF7","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80066C007FAB7B9AE697099119C112C71B9AF7AF","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"045","deviceMac":"68FF7BC57165","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006A8EBD844C58265A3C564EEB7935C1C274D56","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"003","deviceMac":"74DA885D50F0","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006A0F122C2A7406D3CC8C6C9D3A5D81B9B13FA","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"053","deviceMac":"98DAC409B200","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006FCDB71E14CFC1D59DFAF0BF41F4A1B9A2D73","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"037","deviceMac":"68FF7BC57155","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006E46CCB48312D0D4952AB1FC0D9371C272348","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"005","deviceMac":"74DA885D4F72","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"80069846295949DE0F250B49002A020E1B9BF47F","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"039","deviceMac":"68FF7BC56B80","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80063285E00F4106BA7B7F61351CC9D01B65BEC4","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"077","deviceMac":"68FF7B71F36D","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006B0DE148864E10F212743D31D59391B9B34DF","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"043","deviceMac":"98DAC409B213","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80067114DEC334A518F2171E8D530CE41B99BC12","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"035","deviceMac":"68FF7BC58349","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191118 Rel.140307","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80065AE7D1A695B347A5D2F3D7B9C350195D0F94","deviceName":"Smart Wi-Fi Plug","deviceHwVer":"2.0","alias":"Viejo","deviceMac":"B04E260D4BA3","oemId":"80CB8C7ED4CAD7DA4570979BFF731BA1","deviceModel":"HS100(US)","hwId":"0DC28CDD0B7E6C55F52AD35B8B68277E","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"800685C815D811208B6CA35EC7FB05E31C3591C1","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"020","deviceMac":"74DA8895FC20","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"8006E1A94122829150BFBD9DD93951021C272CA2","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"015","deviceMac":"74DA885D4F22","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/eu-wap.tplinkcloud.com","deviceRegion":"eu-west-1","deviceId":"8006E46F48432C7375E2E16250FF6AD81B99E6C1","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"034","deviceMac":"68FF7BC57D1C","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/use1-wap.tplinkcloud.com","deviceRegion":"us-east-1","deviceId":"80068763F680FDD7011DEFC93F1F072C1C274A60","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"019","deviceMac":"74DA885D500C","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":true,"status":1},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.0.18 Build 191113 Rel.105413","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"800667EA0423D2D61F7B7E2D371958941C27119A","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"3.3","alias":"011","deviceMac":"74DA885D4F03","oemId":"16DD56EA45BADD08327504B19CFBA217","deviceModel":"HS105(US)","hwId":"E48B1F649DC598BDE89F2216EE4FACAA","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"800654668CE694C9C9A8A0D8C23895DB1B65441D","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"029","deviceMac":"68FF7B71FEC2","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006C2CB1203E73EF9965A8CD36C8D571B9ACDD8","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"046","deviceMac":"68FF7BC56D55","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0},{"deviceType":"IOT.SMARTPLUGSWITCH","role":0,"fwVer":"1.5.6 Build 191114 Rel.104204","appServerUrl":"https:\/\/aps1-wap.tplinkcloud.com","deviceRegion":"ap-southeast-1","deviceId":"8006E046CE66E6214474D4B69FB387C61B9A5634","deviceName":"Smart Wi-Fi Plug Mini","deviceHwVer":"1.0","alias":"058","deviceMac":"68FF7BC573BC","oemId":"003E098AF0D44D4BAB796B3F6A7A830E","deviceModel":"HS105(US)","hwId":"E5D7E6089B060EF662783C23AE110522","fwId":"00000000000000000000000000000000","isSameRegion":false,"status":0}]}}';
		*/

	}
 }

?>