<?php
/*
 *  © 2017 Framelova. All rights reserved. Privacy Policy
 *  Creado: 24/01/2017
 *  Por: J. Carlos Ramirez G - JCRG
 *  Descripción: Functions need for sent emails
 */

$dirname = dirname(__DIR__);
include_once  $dirname.'/common/class.phpmailer.php';
include_once  $dirname.'/common/class.smtp.php';
include_once  'sendinblue.php';

class EmailFunctions{
  private $_replySendInBlue = 'no-responder@alertasach.com';
    
	 //Metodo que ejecuta el envio el correo
    private function SendDataMail($subject, $email, $mailHtml){
        $sfrom = 'CSB EMG <tester@framelova.info>';
        // $sfrom = 'CSB EMG <noresponder@serviciospublicos.com.mx>';
        $sheader= $this->GetHeader($sfrom,'');
        $res = mail($email,$subject,$mailHtml,$sheader);

        if($res!=true) {
           $statusSend = '0';
        } else {
           $statusSend = '1';
        }

        return $statusSend;
    }
  	//Header del email
  	private function GetHeader($sfrom, $bcc){
        $sheader = "From:".$sfrom."\nReply-To:".$sfrom."\n";
        if($bcc != ''){
            $sheader=$sheader.'Bcc:'.$bcc."\n";
        }
    		$sheader=$sheader."X-Mailer:PHP/".phpversion()."\n";
    		$sheader=$sheader."Mime-Version: 1.0\n";
        $sheader=$sheader."X-Priority: 3\n";
        $sheader=$sheader."X-MSMail-Priority: Normal\n";
		    $sheader=$sheader."Content-Type: text/html; charset=utf-8";        

        return $sheader;
    }

    //Metodo encargado para enviar correos usando phpmailer
    public function EmailSmptNoPass($email="",$nombreEmail="", $body="",$subject="",$attached=""){
        include '../common/config.php';

        $mail = new PHPMailer();
        $mail->CharSet = "UTF-8";
        $mail->IsSMTP(); // telling the class to use SMTP
        $mail->Host = $smtp_host; // SMTP server
        $mail->SMTPAuth = true;                  // enable SMTP authentication
        $mail->SMTPKeepAlive = true;
        $mail->Port = $smtp_Port;                    // set the SMTP port for the GMAIL server
        $mail->Username = $smtp_Username; // SMTP account username
        $mail->Password = $smtp_Password;        // SMTP account password
        $mail->SMTPSecure = $smtp_SMTPSecure;
        $mail->SetFrom($email_from, $name_from);


        $mail->addAddress($email, "");


        $mail->Subject = $subject;
        $mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
        $mail->MsgHTML($body);

        //adjuntar documento
        if($attached!=""){
          $mail->AddAttachment($attached); // ruta del archivo
        }

        if(!$mail->Send()) {
            $statusSend = '0';
            //$statusSend = "Mailer Error: " . $mail->ErrorInfo;
          } else {
            $statusSend = '1';
          }

        return $statusSend;
    }

    //Metodo encargado para enviar correos usando phpmailer
    public function EmailSmptNoPassCustom($email="",$nombreEmail="", $body="",$subject="",$attached="", $nameServer="", $emailServer=""){      
        if($nameServer!=""){
          $nameServer = $nameServer;
        }else{
          $nameServer = "CSB EMG";
        }
        if($emailServer!=""){
          $emailServer = $emailServer;
        }else{
          // $emailServer = "noresponder@serviciospublicos.com.mx";
          $emailServer = "tester@framelova.info";
        }

        $mail = new PHPMailer();
        $mail->CharSet = "UTF-8";
        $mail->SetFrom($emailServer, $nameServer);        
        // $mail->AddReplyTo("carlos.ramirez@framelova.com", "Z Motors");
        
        $mail->AddAddress($email, "");
        // $mail->AddBCC("carlos.ramirez@framelova.com", "");        
        $mail->Subject = $subject;
        $mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
        $mail->MsgHTML($body);

        //adjuntar documento
        if($attached!=""){
          //Para los videos
          /*
          $arrMimetypes = array("mov"=>"video/quicktime", "mp4"=>"video/mp4");
          $archivoExt = strtolower(pathinfo(basename($attached),PATHINFO_EXTENSION));
          if($archivoExt=="mov" || $archivoExt=="mp4"){
            echo "Entre--";
            $mail->AddAttachment($attached, "", "", $arrMimetypes[$archivoExt]);
          }else{
            $mail->AddAttachment($attached); // ruta del archivo
          }
          */
          $mail->AddAttachment($attached); // ruta del archivo
        }

        if(!$mail->Send()) {
            $statusSend = '0';
          } else {
            $statusSend = '1';
          }

        return $statusSend;
    }


     //>>>>>>>>METODOS ENCARGADOS PARA CONTRUIR Y ENVIAR EL CORREO


    
    public function EnviarDatosDeAcceso($email, $nombreUsuario, $passCliente, $nombreComite)
    {
      $subject = 'Datos de acceso';

      //$mailHtml = $this->datosAccesoMailBody($nombreUsuario, $email, $passCliente);
      //$resMail =  $this->EmailSmptNoPass($email, $nombreUsuario, $mailHtml, $subject, "");
      //$resMail =  1;

      //Implementamos Send in Blue | JGP 23/08/2020
      $mailHtml = $this->datosAccesoMailBodyEncode($nombreUsuario, $email, $passCliente, $nombreComite);
      
      $sendin = new sendinblue();

      $sendin->__set("to", $email);
      $sendin->__set("replyTo", "no-responder@alertasach.com");
      $sendin->__set("subject", $subject);
      $sendin->__set("htmlContent", $mailHtml);

      $resMail = $sendin->send();

      return $resMail;
    }

    public function RecuperarDatosDeAcceso($email, $nombreUsuario, $passCliente)
    {
      $subject = 'Recuperar contraseña';
      //$mailHtml = $this->recuperarDatosAccesoMailBody($nombreUsuario, $email, $passCliente);
      //$resMail =  $this->EmailSmptNoPass($email, $nombreUsuario, $mailHtml, $subject, "");
      

      //Implementamos Send in Blue | JGP 23/08/2020
      // //Regresar
      $mailHtml = $this->recuperarDatosAccesoMailBodyEncode($nombreUsuario, $email, $passCliente);
      
      $sendin = new sendinblue();

      $sendin->__set("to", $email);
      $sendin->__set("replyTo", "no-responder@alertasach.com");
      $sendin->__set("subject", $subject);
      $sendin->__set("htmlContent", $mailHtml);

      $resMail = $sendin->send();
      
      return $resMail;      
    }
    

    public function EnviarCodigo($subject, $email, $codigo)
    {
      //PARA SMTP
      //$mailHtml = $this->EnviarCodigoBody($codigo);
      //$resMail =  $this->EmailSmptNoPass($email,"", $mailHtml,$subject);//HABILITAR
      //$resMail = 1;//DESHABILITAR

      //Implementamos Send in Blue | JGP 23/08/2020
      $mailHtml = $this->EnviarCodigoBodyEncode($codigo);
      
      
      $sendin = new sendinblue();

      $sendin->__set("to", $email);
      $sendin->__set("replyTo", "no-responder@alertasach.com");
      $sendin->__set("subject", $subject);
      $sendin->__set("htmlContent", $mailHtml);

      $resMail = $sendin->send();

      return $resMail;
    }

    public function EnviarDatosAcceso($subject, $email, $password)
    {
     // $email = "jair.castaneda@framelova.com";
     $mailHtml = $this->EnviarDatosAccesoBody($email, $password);
     // echo $mailHtml;
      // die();
     // $resMail =  $this->SendDataMail($subject, $email, $mailHtml);//HABILITAR
      // $resMail = 1;//DESHABILITAR
     return $resMail;
    }

   //Enviar buzon ciudadano 
    public function enviarBuzonCiudadano($subject, $email, $datos, $archivo)
    {
      $mailHtml = $this->enviarBuzonCiudadanoBody($datos, $subject, $archivo);
      // echo $mailHtml;          
      $resMail = $this->EmailSmptNoPass($email, "", $mailHtml, $subject, $archivo); 
      return $resMail;
    }

    //Solicitar nueva contrasenia
    public function reseteoContrasenia($email, $nombreUsuario, $idUsuario)
    {
      $subject = 'Solicitar contraseña';
      //  $mailHtml = $this->reseteoContraseniaMailBody($nombreUsuario, $email, $idUsuario);      
      $mailHtml = $this->reseteoContraseniaMailBodyEncode($nombreUsuario, $email, $idUsuario);      
      
      //$resMail = $this->EmailSmptNoPass($email, "", $mailHtml, $subject, "");  //Comento ahora enviamos con Send in Blue

      // //Implementamos Send in Blue | JGP 23/08/2020
      $sendin = new sendinblue();

      $sendin->__set("to", $email);
      $sendin->__set("replyTo", "no-responder@alertasach.com");
      $sendin->__set("subject", $subject);
      $sendin->__set("htmlContent", $mailHtml);

      $resMail = $sendin->send();

      return $resMail;
    }


    //>>>>>>>>CUERPOS HTML  

  //Cuerpo generico para correos de Codigo
   private function EnviarCodigoBody($codigo){
      $dirname = dirname(__DIR__);
      include  $dirname.'/common/config.php';
      // $segObj = new seguridadObj();
      // $param1 = $segObj->encriptarCadena('param1='.$idUsuario);
        $html = '<html><body style="background:white;">';
            $html .= '<table style="width:600px;" >';
                $html .= "<tbody>";                
                // $html .='<tr><img src="'.$siteURL.'/images/logo.png" width="80" /></tr>';
                   $html .= "<tr>";
                       $html .= '<td style="padding: 10px;"><h3>C&oacute;digo de verificaci&oacute;n</h3></td>';
                   $html .= "</tr>";
                   $html .= "<tbody>";
                   $html .= "<tr>";
                       $html .= '<td style="padding: 10px;">
                                  Para validar su cuenta introduzca este c&oacute;digo en el campo de la aplicaci&oacute;n<br>
                                  <b>'.$codigo.'</b>
                                </td>';
                   $html .= "</tr>";
                $html .= "</tbody>";
                $html .= "<tfoot>";
                    $html .= "<tr>";
                        $html .= '<td style="font-size: 12px; margin-top: 30px;"><br/>Este mensaje es enviado de forma autom&aacute;tica favor de no responder.</td>';
                    $html .= "</tr>";
                $html .= "</tfoot>";
            $html .= '</table>';
        $html .= '</body></html>';
        return $html;
    }

    //Cadena para utilizar con Send in Blue
    private function EnviarCodigoBodyEncode($codigo){
      $dirname = dirname(__DIR__);
      include  $dirname.'/common/config.php';

        $html = '<html><body style=\"background:white;\">';
        $html .= '<table style=\"width:600px;\">';
        $html .= "<tbody>";                
        $html .= "<tr>";
        $html .= '<td style=\"padding: 10px;\"><h3>C&oacute;digo de verificaci&oacute;n<\/h3><\/td>';
        $html .= "<\/tr>";
        $html .= "<tbody>";
        $html .= "<tr>";
        $html .= '<td style=\"padding: 10px;\">';
        $html .= 'Para validar su cuenta introduzca este c&oacute;digo en el campo de la aplicaci&oacute;n<br>';
        $html .= '<b>'.$codigo.'<\/b>';
        $html .= '<\/td>';
        $html .= "<\/tr>";
        $html .= "<\/tbody>";
        $html .= "<tfoot>";
        $html .= "<tr>";
        $html .= '<td style=\"font-size: 12px; margin-top: 30px;\"><br\/>Este mensaje es enviado de forma autom&aacute;tica favor de no responder.<\/td>';
        $html .= "<\/tr>";
        $html .= "<\/tfoot>";
        $html .= '<\/table>';
        $html .= '<\/body><\/html>';
        return $html;
    }

    //Cuerpo generico para correos de Datos de acceso
    private function EnviarDatosAccesoBody($correo, $password){
      $dirname = dirname(__DIR__);
      include  $dirname.'/common/config.php';
      // $segObj = new seguridadObj();
      // $param1 = $segObj->encriptarCadena('param1='.$idUsuario);

       $html = '<html><body style="background:white;">';
            $html .= '<table style="width:600px;" >';               
                $html .= "<tbody>";
               $html .='<tr><img src="../images/logo--.png" /></tr>';
                   $html .= "<tr>";  
                      $html .= '<td style="padding: 10px;"><h3>Datos de Acceso a su Cuenta</h3></td>';
                   $html .= "</tr>";      
                   $html .= "<tbody>";
                   $html .= "<tr>";  
                       $html .= '<td style="padding: 10px;">
                                 Correo: '.$correo.'
                               </td>';
                      $html .= '<td style="padding: 10px;">
                                 Contraseña: '.$password.'
                                </td>';                       
                   $html .= "</tr>";      
                $html .= "</tbody>";
                $html .= "<tfoot>";
                    $html .= "<tr>";
                        $html .= '<td style="font-size: 12px; margin-top: 30px;"><br/>Este mensaje es enviado de forma automática favor de no responder.</td>';
                    $html .= "</tr>"; 
                $html .= "</tfoot>";
            $html .= '</table>';        
        $html .= '</body></html>';
        return $html;
    }
    
    //Html para correo de datos de acceso
    private function recuperarDatosAccesoMailBody($nombre, $email, $password){
        $html = '<html><body>';
            // $html .= '<table style="width:600px;" >';               
            //     $html .= "<tbody>";
            //        $html .= "<tr>";  
            //            $html .= '<td style="padding: 10px;">Estimado '.$nombre.' recibimos su solicitud de recuperacion de contraseña.</td>';                       
            //        $html .= "</tr>";      
            //        $html .= "<tbody>";
            //        $html .= "<tr>";  
            //            $html .= '<td style="padding: 10px;">Sus datos de acceso son:.</td>';
            //            $html .= '<td>E-mail: '.$email.'<br> Contraseña: '.$password.'</td>';
            //        $html .= "</tr>";      
            //     $html .= "</tbody>";
            //     $html .= "<tfoot>";
            //         $html .= "<tr>";
            //             $html .= '<td style="font-size: 12px; margin-top: 30px;"><br/>Este mensaje es enviado de forma automática favor de no responder.</td>';
            //         $html .= "</tr>"; 
            //     $html .= "</tfoot>";
            // $html .= '</table>';

          $html .= '<table style="width:600px;" >';            
              $html .= '<tbody>';
                $html .= '<tr>';
                  $html .= '<td colspan="2" style="padding: 10px;">Estimado <b>'.$nombre.'</b>, recibimos su solicitud de recuperación de contraseña. tus datos de acceso a la aplicación son:</td>';
                $html .= '</tr>';
              $html .= '</tbody>';
              $html .= '<tbody>';
                $html .= '<tr>';
                  $html .= '<td width="115"><b>E-mail:</b></td>';
                  $html .= '<td width="475">'.$email.'</td>';
                $html .= '</tr>';
                $html .= '<tr>';
                  $html .= '<td><b>Contraseña</b></td>';
                  $html .= '<td>'.$password.'</td>';
                $html .= '</tr>';
                $html .= '<tr>';
                  $html .= '<td colspan="2">&nbsp;</td>';
                $html .= '</tr>';
                $html .= '<tr>';
                  $html .= '<td colspan="2"><p>Una vez iniciado sesión podrás cambiar tu contraseña <br/> en la sección de perfil.</p></td>';
                $html .= '</tr>';
                $html .= '<tr>';
                  $html .= '<td colspan="2">&nbsp;</td>';
                $html .= '</tr>';
              $html .= '</tbody>';
              $html .= '<tfoot>';
                $html .= '<tr>';
                  $html .= '<td colspan="2" style="font-size: 12px; margin-top: 30px;">Este mensaje es enviado de forma automática favor de no responder.</td>';
                $html .= '</tr>';
              $html .= '</tfoot>';
          $html .= '</table>';


        $html .= '</body></html>';
        return $html;
    }

    private function recuperarDatosAccesoMailBodyEncode($nombre, $email, $password){
      $html = '<html><body>';
        $html .= '<table style=\"width:600px;\" >';            
            $html .= '<tbody>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\" style=\"padding: 10px;\">Estimado <b>'.$nombre.'<\/b>, recibimos su solicitud de recuperación de contraseña. tus datos de acceso a la aplicación son:<\/td>';
              $html .= '</tr>';
            $html .= '<\/tbody>';
            $html .= '<tbody>';
              $html .= '<tr>';
                $html .= '<td width=\"115\"><b>E-mail:<\/b><\/td>';
                $html .= '<td width=\"475\">'.$email.'<\/td>';
              $html .= '<\/tr>';
              $html .= '<tr>';
                $html .= '<td><b>Contraseña<\/b><\/td>';
                $html .= '<td>'.$password.'<\/td>';
              $html .= '<\/tr>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\">&nbsp;<\/td>';
              $html .= '<\/tr>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\"><p>Una vez iniciado sesión podrás cambiar tu contraseña <br\/> en la sección de perfil.<\/p><\/td>';
              $html .= '<\/tr>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\">&nbsp;<\/td>';
              $html .= '<\/tr>';
            $html .= '<\/tbody>';
            $html .= '<tfoot>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\" style=\"font-size: 12px; margin-top: 30px;\">Este mensaje es enviado de forma automática favor de no responder.<\/td>';
              $html .= '<\/tr>';
            $html .= '<\/tfoot>';
        $html .= '<\/table>';


      $html .= '<\/body><\/html>';
      return $html;
  }

    private function datosAccesoMailBody($nombre, $email, $password){
        $html = '<html><body>';

            // $html .= '<table style="width:600px;" >';               
            //     $html .= "<tbody>";
            //        $html .= "<tr>";  
            //            $html .= '<td style="padding: 10px;">Estimado '.$nombre.' los datos de acceso a su cuenta aguilar son:</td>';
            //            $html .= '<td>E-mail: '.$email.'<br> Contraseña: '.$password.'</td>';
            //        $html .= "</tr>";      
            //     $html .= "</tbody>";

            //     $html .= "<tfoot>";
            //         $html .= "<tr>";
            //             $html .= '<td style="font-size: 12px; margin-top: 30px;"><br/>Este mensaje es enviado de forma automática favor de no responder.</td>';
            //         $html .= "</tr>"; 
            //     $html .= "</tfoot>";
            // $html .= '</table>';  

            $html .= '<table style="width:600px;" >';            
              $html .= '<tbody>';
                $html .= '<tr>';
                  $html .= '<td colspan="2" style="padding: 10px;">Estimado <b>'.$nombre.'</b>, tus datos de acceso a la aplicación son:</td>';
                $html .= '</tr>';
              $html .= '</tbody>';
              $html .= '<tbody>';
                $html .= '<tr>';
                  $html .= '<td width="115"><b>Email:</b></td>';
                  $html .= '<td width="475">'.$email.'</td>';
                $html .= '</tr>';
                $html .= '<tr>';
                  $html .= '<td><b>Contraseña</b></td>';
                  $html .= '<td>'.$password.'</td>';
                $html .= '</tr>';
                $html .= '<tr>';
                  $html .= '<td colspan="2">&nbsp;</td>';
                $html .= '</tr>';
                // $html .= '<tr>';
                //   $html .= '<td colspan="2"><p>Una vez iniciado sesión podrás cambiar tu contraseña <br/> en la sección de perfil.</p></td>';
                // $html .= '</tr>';
                $html .= '<tr>';
                  $html .= '<td colspan="2">&nbsp;</td>';
                $html .= '</tr>';
              $html .= '</tbody>';
              $html .= '<tfoot>';
                $html .= '<tr>';
                  $html .= '<td colspan="2" style="font-size: 12px; margin-top: 30px;">Este mensaje es enviado de forma automática favor de no responder.</td>';
                $html .= '</tr>';
              $html .= '</tfoot>';
            $html .= '</table>';


        $html .= '</body></html>';

        return $html;
    }

    //Para enviar usando Send in blue
    private function datosAccesoMailBodyEncode($nombre, $email, $password, $nombreComite){
      $html = '<html><body>';
          $html .= '<table style=\"width:600px; padding: 10px 15px; font-size: 12px;\" >'; 

            $html .= '<tbody>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\" style=\"padding-top: 25px;\" >Estimado <b>'.$nombre.'<\/b>, tus datos de acceso a la aplicación son:<\/td>';
              $html .= '<\/tr>';
            $html .= '<\/tbody>';

            $html .= '<tbody>';
              $html .= '<tr>';
                $html .= '<td width=\"115\" style=\"padding-top: 20px; padding-left: 25px;\"><b>E-mail:<\/b><\/td>';
                $html .= '<td width=\"475\" style=\"padding-top: 20px;\">'.$email.'<\/td>';
              $html .= '<\/tr>';
              $html .= '<tr>';
                $html .= '<td style=\"padding-left: 25px;\"><b>Contraseña:<\/b><\/td>';
                $html .= '<td>'.$password.'<\/td>';
              $html .= '<\/tr>';
            $html .= '<\/tbody>';

    if ($nombreComite != "") {
      $html .= '<tbody>';
      $html .= '<tr>';
      $html .= '<td colspan=\"2\" style=\"padding-top: 25px;\">Fuiste registrado en el comit&eacute; <b>' . $nombreComite . '<\/b>.<\/td>';
      $html .= '<\/tr>';
      $html .= '<\/tbody>';
    }
    
            $html .= '<tfoot>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\" style=\"padding-top: 40px; font-weight: bold; font-style: italic;\">Este mensaje es enviado de forma autom&aacute;tica, favor de no responder.<\/td>';
              $html .= '<\/tr>';
            $html .= '<\/tfoot>';
          $html .= '<\/table>';
      $html .= '<\/body><\/html>';

      return $html;
  }


    //Cuerpo del correo buzon ciudadano
    private function enviarBuzonCiudadanoBody($arrDatos, $subject, $archivo=""){
      $dirname = dirname(__DIR__);
      include  $dirname.'/common/config.php';
      
      $opc_anonimo_bc = $arrDatos->opc_anonimo_bc;
      // $tipo_contacto_bc = $arrDatos->tipo_contacto_bc; //Subjet
      $mensaje_bc = $arrDatos->mensaje_bc;  //mensaje
      $opc_testigo_bc = (count($arrDatos->opc_testigo_bc)>0)?"Si":"No";
      $nombre_bc = $arrDatos->nombre_bc;  //Nombre cuidadano
      $telefono_bc = $arrDatos->telefono_bc;  //tel cuidadano
      $opc_segdenuncia_bc = (count($arrDatos->opc_segdenuncia_bc)>0)?"Si":"No";

      //Para cuando lleva un video
      $archivoExt = strtolower(pathinfo(basename($archivo),PATHINFO_EXTENSION));
      $video = "";
      if($archivoExt=="mov" || $archivoExt=="mp4"){
          $archivoExpl = explode("testsites/", $archivo);          
          $video = $siteURL.$archivoExpl[1];
      }      
    
      $html = '<html><body style="background:white;">';
          $html .= '<table style="width:600px;" >';
              $html .= "<tbody>";
                 // $html .='<tr><img src="'.$siteURL.'/images/logo.png" width="80" /></tr>';
                 $html .= "<tr>";
                     $html .= '<td style="padding: 10px;"><h3>Reporte buz&oacute;n ciudadano: '.$subject.'</h3></td>';
                 $html .= "</tr>";
                 $html .= "<tbody>";
                 $html .= "<tr>";
                     $html .= '<td style="padding: 10px;">
                                 <div><b>Mensaje:</b> '.$mensaje_bc.'</div> 
                                 <div><b>Fue testigo:</b> '.$opc_testigo_bc.'</div> 
                                 <div>';

                                  if(count($opc_anonimo_bc)==0){
                                    $html .= '<div><b>Nombre:</b> '.$nombre_bc.'</div>';
                                    $html .= '<div><b>Tel&eacute;fono:</b> '.$telefono_bc.'</div>';
                                    $html .= '<div><b>Seguimiento a su denuncia:</b> '.$opc_segdenuncia_bc.'</div>';
                                  } 
                                  //ruta del video  
                                  if($video!=""){
                                    $html .= '<div><b>Video:</b> <a href="'.$video.'">Descargar</a></div>';
                                      // $html .= '<video width="320" height="240" controls>';
                                      //   $html .= '<source src="'.$video.'" type="video/mp4">';
                                      //   $html .= '<source src="'.$video.'" type="video/ogg">';
                                      //   $html .= '<source src="'.$video.'" type="video/quicktime">';
                                      //   $html .= 'Your browser does not support the video tag.';
                                      // $html .= '</video>';
                                  }
                        $html .= '</div>
                              </td>';
                 $html .= "</tr>";
              $html .= "</tbody>";
              $html .= "<tfoot>";
                  $html .= "<tr>";
                      $html .= '<td style="font-size: 12px; margin-top: 30px;"><br/>Este mensaje es enviado de forma autom&aacute;tica favor de no responder.</td>';
                  $html .= "</tr>";
              $html .= "</tfoot>";
          $html .= '</table>';
      $html .= '</body></html>';
      return $html;
    }


    //Html para correo de datos de acceso
    private function reseteoContraseniaMailBody($nombre, $email, $idUsuario){
      $dirname = dirname(__DIR__);
      include  $dirname.'/common/config.php';
      $segObj = new seguridadObj();
      $param1 = $segObj->encriptarCadena('param1='.$idUsuario);

        $html = '<html><body>';
        $html .= '<table style="width:600px;">';               
        $html .= "<tbody>";
        $html .= "<tr>";  
        $html .= '<td style="padding: 10px;">Estimado '.$nombre.' recibimos su solicitud de recuperacion de contraseña.</td>';                       
        $html .= "</tr>";      
        $html .= "<tbody>";
        $html .= "<tr>";  
        $html .= '<td style="padding: 10px;">';
        $html .= 'Da clic en el siguiente enlace para recibir una nueva contraseña <a href="'.$siteURL.'extras/recuperar_contrasena.php?'.$param1.'">'.$siteURL.'extras/recuperar_contrasena.php?'.$param1.'</a> <br/>';
        $html .= 'Si el enlace no funciona, puedes copiar y pegar la dirección URL en tu navegador. <br/><br/>';
        $html .= 'Si usted no ha solicitado la recuperación de su contraseña haga caso omiso de este correo.<br/>';
        $html .= 'Saludos.';
        $html .= '</td>';
        $html .= "</tr>";      
        $html .= "</tbody>";
        $html .= "<tfoot>";
        $html .= "<tr>";
        $html .= '<td style="font-size: 12px; margin-top: 30px;"><br/>Este mensaje es enviado de forma automática favor de no responder.</td>';
        $html .= "</tr>"; 
        $html .= "</tfoot>";
        $html .= '</table>';        
        $html .= '</body></html>';
        return $html;
    }



    private function reseteoContraseniaMailBodyEncode($nombre, $email, $idUsuario){
      $dirname = dirname(__DIR__);
      include  $dirname.'/common/config.php';
      $segObj = new seguridadObj();
      $param1 = $segObj->encriptarCadena('param1='.$idUsuario);

        $html = '<html><body>';
            $html .= '<table style=\"width:600px;\" >';               
                $html .= "<tbody>";
                   $html .= "<tr>";  
                       $html .= '<td style=\"padding: 10px;\">Estimado '.$nombre.' recibimos su solicitud de recuperacion de contraseña.<\/td>';                       
                   $html .= "<\/tr>";      
                   $html .= "<tbody>";
                   $html .= "<tr>";  
                       $html .= '<td style=\"padding: 10px;\">';
                       $html .= 'Da clic en el siguiente enlace para recibir una nueva contraseña <a target="_blank" href=\"'.$siteURLEncode.'extras\/recuperar_contrasena.php?'.$param1.'\">'.$siteURLEncode.'extras\/recuperar_contrasena.php?'.$param1.'<\/a> <br\/>';
                       $html .=  "Si el enlace no funciona, puedes copiar y pegar la dirección URL en tu navegador. <br\/><br\/>";
                       $html .=  "Si usted no ha solicitado la recuperación de su contraseña haga caso omiso de este correo.<br\/>";
                       $html .=  "Saludos.";
                       $html .= "<\/td>";                       
                   $html .= "<\/tr>";      
                $html .= "<\/tbody>";
                $html .= "<tfoot>";
                    $html .= "<tr>";
                        $html .= '<td style=\"font-size: 12px; margin-top: 30px;\"><br\/>Este mensaje es enviado de forma automática favor de no responder.<\/td>';
                    $html .= "<\/tr>"; 
                $html .= "<\/tfoot>";
            $html .= '<\/table>';        
        $html .= '<\/body><\/html>';
        return $html;
    }

    public function enviarMailPeticionNoAtendida($subject, $email, $idPeticion)
    {
      // // $email = "jair.castaneda@framelova.com";
      // $mailHtml = $this->EnviarCodigoBody($codigo);
      // // echo $mailHtml;
      // $resMail =  $this->EmailSmptNoPass($email,"", $mailHtml,$subject);//HABILITAR
      // // $resMail = 1;//DESHABILITAR
      
      //Implementamos Send in Blue | JGP 23/08/2020
      $mailHtml = $this->PeticionsinAtenderBodyEncode($idPeticion);
      
      $sendin = new sendinblue();

      $sendin->__set("to", $email);
      $sendin->__set("replyTo", "no-responder@alertasach.com");
      $sendin->__set("subject", $subject);
      $sendin->__set("htmlContent", $mailHtml);

      $resMail = $sendin->send();

      return $resMail;
    }

    //Cadena para utilizar con Send in Blue
    private function PeticionsinAtenderBodyEncode($idPeticion){
      $dirname = dirname(__DIR__);
      include  $dirname.'/common/config.php';

        $html = '<html><body style=\"background:white;\">';
        $html .= '<table style=\"width:600px;\">';
        $html .= "<tbody>";                
        $html .= "<tr>";
        $html .= '<td style=\"padding: 10px;\"><h3>Hay peticiones sin atender<\/h3><\/td>';
        $html .= "<\/tr>";
        $html .= "<tbody>";
        $html .= "<tr>";
        $html .= '<td style=\"padding: 10px;\">';
        $html .= 'El sistema recibio una peticion de emergencia y no ha sido atendida!';
        $html .= '<\/td>';
        $html .= '<td style=\"padding: 10px;\">';
        $html .= '<b> idPeticion sin atender: '.$idPeticion.'<\/b>';
        $html .= '<\/td>';
        $html .= "<\/tr>";
        $html .= "<\/tbody>";
        $html .= "<tfoot>";
        $html .= "<tr>";
        $html .= '<td style=\"font-size: 12px; margin-top: 30px;\"><br\/>Este mensaje es enviado de forma autom&aacute;tica favor de no responder.<\/td>';
        $html .= "<\/tr>";
        $html .= "<\/tfoot>";
        $html .= '<\/table>';
        $html .= '<\/body><\/html>';
        return $html;
    }

    public function NotificarCiudadanoPieValido($email) {
      $subject = 'Cuenta Autorizada';
      $mailHtml = $this->NotificarCiudadanoPieValidoBody();
      $resMail =  $this->EmailSmptNoPass($email, "", $mailHtml, $subject, "");
      
      return $resMail; 
    }

    private function NotificarCiudadanoPieValidoBody(){
      $dirname = dirname(__DIR__);
      include  $dirname.'/common/config.php';

      $html  = '<html><body>';
      $html .= '<table style="width:600px;">';

      $html .= '<tbody>';
      $html .= '<tr><td style="padding: 10px;">';
      $html .= '<h2>Cuenta Autorizada</h2>';
      $html .= '</td></tr>';
      $html .= '</tbody';

      $html .= '<tbody>';
      $html .= '<tr><td style="padding: 10px;">';
      $html .= '<p style="font-size: 12px;">Estimado usuario, le informamos que su cuenta ha sido validada y autorizada, por lo que desde este momento puede hacer uso de la aplicación SACH Ciudadano Alerta. <br><br>Muchas gracias.</p>';
      $html .= '</td></tr>';     
      $html .= "</tbody>";

      $html .= '<tfoot>';
      $html .= '<tr><td style="margin-top: 30px;">';
      $html .= '<p style="font-size: 12px;"><b>Este mensaje es enviado de forma automática, favor de no responder.</b></p>';
      $html .= '</td></tr>'; 
      $html .= '</tfoot>';

      $html .= '</table>';        
      $html .= '</body></html>';

      return $html;
    }

    public function EnviarDatosDeAccesoUsuariosAdministrativos ($email, $nombreUsuario, $passCliente)
    {
      $subject = 'Datos de acceso';

      //$mailHtml = $this->datosAccesoMailBody($nombreUsuario, $email, $passCliente);
      //$resMail =  $this->EmailSmptNoPass($email, $nombreUsuario, $mailHtml, $subject, "");
      //$resMail =  1;

      //Implementamos Send in Blue | JGP 23/08/2020
      $mailHtml = $this->htmlContent($nombreUsuario, $email, $passCliente);
      $sendin = new sendinblue();

      $sendin->__set("to", $email);
      $sendin->__set("replyTo", "no-responder@alertasach.com");
      $sendin->__set("subject", $subject);
      $sendin->__set("htmlContent", $mailHtml);

      $resMail = $sendin->send();

      return $resMail;
    }

    private function htmlContent ($nombre, $email, $password){
      $html = '<html><body>';
          $html .= '<table style=\"width:600px; padding: 10px 15px; font-size: 12px;\" >'; 

            $html .= '<tbody>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\" style=\"padding-top: 25px;\" >Estimado <b>'.$nombre.'<\/b>, tus datos de acceso a la plataforma son:<\/td>';
              $html .= '<\/tr>';
            $html .= '<\/tbody>';

            $html .= '<tbody>';
              $html .= '<tr>';
                $html .= '<td width=\"115\" style=\"padding-top: 20px; padding-left: 25px;\"><b>E-mail:<\/b><\/td>';
                $html .= '<td width=\"475\" style=\"padding-top: 20px;\">'.$email.'<\/td>';
              $html .= '<\/tr>';
              $html .= '<tr>';
                $html .= '<td style=\"padding-left: 25px;\"><b>Contraseña:<\/b><\/td>';
                $html .= '<td>'.$password.'<\/td>';
              $html .= '<\/tr>';
    
            $html .= '<tfoot>';
              $html .= '<tr>';
                $html .= '<td colspan=\"2\" style=\"padding-top: 40px; font-weight: bold; font-style: italic;\">Este mensaje es enviado de forma autom&aacute;tica, favor de no responder.<\/td>';
              $html .= '<\/tr>';
            $html .= '<\/tfoot>';
          $html .= '<\/table>';
      $html .= '<\/body><\/html>';

      return $html;
  }

}
