<?php
/*
 *  © 2012 Framelova. All rights reserved. Privacy Policy
 *  Creado: 27/10/2015
 *  Por: Jonathan Guerrero Pérez - JGP
 *  Descripción: User Object
 */
$pathDB = 'database/';
$pathComm = 'brules/';
$config = 'common/';

if(file_exists('../database/QuestionnairesDB.php')){
    $pathDB = '../database/';
    $pathComm = '../brules/';
    $config = '../common/';
}

// require_once $pathComm."KoolControls/KoolGrid/koolgrid.php";
// require_once $pathComm."KoolControls/KoolAjax/koolajax.php";
// include_once $pathComm.'KoolControls/KoolGrid/ext/datasources/MySQLiDataSource.php';
 include_once $pathDB.'QuestionnairesDB.php';
require_once 'CompanyObj.php';
require_once 'LanguageObj.php';


class Questionnaires{

    //Private Fields
    private $_idQuestionary = 0;
    private $_questionaryName = '';
    private $_questionaryDesc = '';
    private $_companyId = '';
    private $_active = 1;

    //Get set Methods
    public function setIdQuestionary($value)
    {$this->_idQuestionary = $value;}
    public function getIdQuestionary()
    {return $this->_idQuestionary;}

    public function setQuestionaryName($value)
    {$this->_questionaryName = $value;}
    public function getQuestionaryName()
    {return $this->_questionaryName;}

    public function setQuestionaryDesc($value)
    {$this->_questionaryDesc = $value;}
    public function getQuestionaryDesc()
    {return $this->_questionaryDesc;}

    public function setCompanyId($value)
    {$this->_companyId = $value;}
    public function getCompanyId()
    {return $this->_companyId;}


    public function setActive($value){$this->_active = $value;}
    public function getActive(){return $this->_active;}

    //Public Methods

    //Get the Operator grid
    public function GetQuestionnairesGrid(){
        $DataServices = new DataServices();
        $dbConnQ = $DataServices->getConnection();
        $dbConnE = $DataServices->getConnection();
        $dsLang = new MySQLiDataSource($dbConnQ);
        $dsQuest = new MySQLiDataSource($dbConnE);

        $qDB = new QuestionnairesDB();
        $dsQuest = $qDB->QuestionnairesDataSet($dsQuest,'questionnaires');
        $dsLang = $qDB->LanQuestDataSet($dsLang,'languagestoquestionnaire');
        $grid = new KoolGrid("grid");

        $table_detail = new GridTableView();
        $table_detail->Width = "100%";
    	$table_detail->DataSource = $dsLang;
    	$table_detail->AddRelationField("idQuestionary","idQuestionary");
        $table_detail->AllowEditing = true;
        $table_detail->ShowFunctionPanel = true;
        //$table_detail->EditSettings->Mode = "Inline";
        $table_detail->EditSettings->Mode = "Form";
        $table_detail->AutoGenerateEditColumn = true;
        $table_detail->AutoGenerateInsertColumn = true;
        $table_detail->AutoGenerateDeleteColumn = true;

        $this->defineColumnChild($table_detail, "idQuestionary", "ID Padre", true);
        $this->defineColumnChild($table_detail, "idLanQuest", "ID Hijo", true);
        $this->defineColumnChild($table_detail, "idLanguage", "Idioma", false, 1);
        $this->defineColumnChild($table_detail, "active", "Activo", false);
        $this->defineColumnChild($table_detail, "actionsChid", "Acciones", false);

        $grid->AllowResizing = true;
        $grid->MasterTable->DataSource = $dsQuest;
    	$grid->MasterTable->AutoGenerateExpandColumn = true;
    	////$grid->MasterTable->AutoGenerateColumns = true;
        $grid->MasterTable->AddDetailTable($table_detail);


        $this->defineGrid($grid, $dsQuest, $dsLang, 'questionnaires');

        $this->defineColumn($grid, "idQuestionary", "ID", true);
        $this->defineColumn($grid, "questionaryName", "Nombre Cuestionario", false, 1);
        $this->defineColumn($grid, "questionaryDesc", "Descripci&oacute;n", false);
        $this->defineColumn($grid, "companyId", "Cliente", false, 1);
        $this->defineColumn($grid, "url", "Url", false);
        $this->defineColumn($grid, "active", "Activo", false);
        $this->defineColumnEdit($grid, 'questionnaires');


        //pocess grid
        $grid->Process();

        //$grid->ClientSettings->ClientEvents["OnStartInsert"] = "Handle_OnStartInsert";

        //$grid->ClientSettings->ClientEvents["OnBeforeStartInsert"] = "OnBeforeStartInsert";
        //$grid->ClientSettings->ClientEvents["OnConfirmInsert"] = "OnConfirmInsert";

        // $grid->ClientSettings->ClientEvents["OnCancelInsert"] = "OnCancelInsert";
        // $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "OnRowStartEdit";
        // $grid->ClientSettings->ClientEvents["OnRowConfirmEdit"] = "OnRowConfirmEdit";
        // $grid->ClientSettings->ClientEvents["OnRowCancelEdit"] = "OnRowCancelEdit";


        return $grid;
    }

    //Private Functions
    private function defineGrid($grid, $ds)
    {
        //create and define grid
        $grid->scriptFolder = "../brules/KoolControls/KoolGrid";
        $grid->styleFolder="default";
        $grid->Width = "760px";

        $grid->RowAlternative = true;
        $grid->AjaxEnabled = true;
        $grid->AjaxLoadingImage =  "../brules/KoolControls/KoolAjax/loading/5.gif";
        $grid->Localization->Load("../brules/KoolControls/KoolGrid/localization/es.xml");

        $grid->AllowInserting = true;
        $grid->AllowEditing = true;
        $grid->AllowDeleting = true;
        $grid->AllowSorting = true;
        $grid->ColumnWrap = true;

        $grid->MasterTable->DataSource = $ds;
        $grid->MasterTable->AutoGenerateColumns = false;
        $grid->MasterTable->Pager = new GridPrevNextAndNumericPager();

        //Show Function Panel
    	$grid->MasterTable->ShowFunctionPanel = true;
    	//Insert Settings
    	$grid->MasterTable->InsertSettings->Mode = "Form";
            $grid->MasterTable->EditSettings->Mode = "form";
            //$grid->MasterTable->EditSettings->InputFocus = "HideGrid";
            $grid->MasterTable->EditSettings->Mode = "Inline";
    	$grid->MasterTable->InsertSettings->ColumnNumber = 1;

            //Register Client-side event handler
    	$grid->ClientSettings->ClientEvents["OnBeforeRowDelete"] = "Handle_OnBeforeRowDelete";

    }

     //define the grid columns
    private function defineColumn($grid,$name_field, $name_header, $read_only, $validator=0)
    {
        if ($name_field == 'active') {
            $column = new GridBooleanColumn();
            $column->UseCheckBox = true;
        }
        elseif ($name_field == 'companyId') {
            $column = new GridDropDownColumn();

            $companyObj = new Company();
            $companiesArr = $companyObj->GetAllCompanies();
            $column->AddItem('-- Selecciona --','');

            foreach($companiesArr as $item)
                $column->AddItem($item->getName(),$item->getIDCompany());
        }
        elseif ($name_field == 'url') {
            $column = new GridCustomColumn();
            $config = 'common/';
            if(file_exists('../common/config.php')){
                $config = '../common/';
            }
            require $config.'config.php';
            $column->ItemTemplate = $finalServer.'cuestionario.php?idQ={idQuestionary}&idC={companyId}';
            $column->Align = "center";
            $column->HeaderText = "Acci&oacute;n";
            $column->Width = "100px";
        }

//        elseif ($name_field == 'controls') {
//           $column = new GridCustomColumn();
//           $column->ItemTemplate = '<a href="javascript:void(0);" onclick="ir_controles({idQuestionary});" class="irControles" >Ir</a>';
//           $column->Align = "center";
//        }
        else
        {   //create and define columns
            $column = new gridboundcolumn();
        }

        if($validator > 0)
            $column->addvalidator($this->GetValidator ($validator));


        $column->DataField = $name_field;
        $column->HeaderText = $name_header;
        $column->ReadOnly = $read_only;
        if ($name_field == 'idQuestionary') {
            $column->Visible = false;
        }
        $grid->MasterTable->AddColumn($column);
    }

         //define the grid columns
    private function defineColumnChild($table_detail, $name_field, $name_header, $read_only, $validator=0)
    {
        if ($name_field == 'active') {
            $column = new GridBooleanColumn();
            $column->UseCheckBox = true;
        }
        elseif ($name_field == 'idLanguage') {
            $column = new GridDropDownColumn();

            $langObj = new Language();
            $langArr = $langObj->GetAllLanguages(true);
            $column->AddItem('-- Selecciona --','');

            foreach($langArr as $item)
                $column->AddItem($item->getName(),$item->getIDLanguage());
        }
        elseif ($name_field == 'actionsChid') {
           $column = new GridCustomColumn();
           $column->HeaderText = "Acciones";
           $column->ItemTemplate = '<a type="button" class="kgrLinkEdit " href="javascript:void(0);" onclick="crear_formulario({idLanguage},{idQuestionary});" >Crear/Editar formulario</a>'
                   . '   <a type="button" class="copiarEncuesta" href="#fancyCopiarEncuesta" onclick="inicializaCopiarEncuesta({companyId},{idQuestionary},{idLanguage})">Duplicar</a>';
           $column->Align = "center";
        }
        else
        {   //create and define columns
            $column = new gridboundcolumn();
        }

        if($name_field == 'idQuestionary'){
            $column->Visible = false;
        }

        if($name_field == 'idLanQuest'){
            $column->Sort = 1;
            $column->Visible = false;
        }

        if($validator > 0)
            $column->addvalidator($this->GetValidator ($validator));

        $column->DataField = $name_field;
        $column-> HeaderText = $name_header;
        $column->ReadOnly = $read_only;
        $table_detail->addcolumn($column);

    }
    private function GetValidator($type){

        switch ($type) {
            case 1: //required
                $validator = new RequiredFieldValidator();
                $validator->ErrorMessage = "Campo requerido";
                return $validator;
                break;
        }
    }

    private function defineColumnEdit($grid)
    {
        $column = new grideditdeletecolumn();
        $column->Align = "center";
        $column-> HeaderText = "Acciones";
        $grid->MasterTable->AddColumn($column);

    }

    //obtener el cuestionario activo
    public function GetQuestionnairesActiveByCompany($idcompany){
        $objDS = new QuestionnairesDB();

        $result = $objDS->GetQuestionnairesActiveByCompany($idcompany);


        if ($result)
        {
            $myRows = mysqli_fetch_array($result);
            if($myRows == false) return;
            $this->_idQuestionary = $myRows['idQuestionary'];
            $this->_questionaryName = $myRows['questionaryName'];
            $this->_questionaryDesc = $myRows['questionaryDesc'];
            $this->_companyId = $myRows['companyId'];
            $this->_active = $myRows['active'];
        }
    }

    //obtener el cuestionario activo por su id
    public function QuestionaryById($idQ){
        $objDS = new QuestionnairesDB();

        $result = $objDS->QuestionaryById($idQ);


        if ($result)
        {
            $myRows = mysqli_fetch_array($result);
            if($myRows == false) return;
            $this->_idQuestionary = $myRows['idQuestionary'];
            $this->_questionaryName = $myRows['questionaryName'];
            $this->_questionaryDesc = $myRows['questionaryDesc'];
            $this->_companyId = $myRows['companyId'];
            $this->_active = $myRows['active'];
        }
    }

    public function QuestionaryByIdCliente($idCliente){
        $objDS = new QuestionnairesDB();
        $arrRes = array();
        $result = $objDS->QuestionaryByIdCliente($idCliente);


        if ($result)
        {
            while($myRows = mysqli_fetch_array($result))
            {
                $tmp = new Questionnaires();

                $tmp->setIdQuestionary($myRows['idQuestionary']);
                $tmp->setQuestionaryName($myRows['questionaryName']);
                $tmp->setQuestionaryDesc($myRows['questionaryDesc']);
                $tmp->setCompanyId($myRows['companyId']);
                $tmp->setActive($myRows['active']);

                $arrRes[$tmp->getIdQuestionary()] = $tmp;
            }

        }

        return $arrRes;
    }

    public function GetLanguageQuestionnaireByIDQuestionnaryAndIdLanguage($idEncuesta, $idIdioma)
    {
        $objDS = new QuestionnairesDB();
        $result = $objDS->GetLanguageQuestionnaireByIDQuestionnaryAndIdLanguageDB($idEncuesta, $idIdioma);
        $array = array();

        if ($result)
        {
             $myRows = mysqli_fetch_array($result);
            if($myRows == false){ return false;}
            else {return true;}
        }
    }

    public function InsertLanguageQuestionnaire($idEncuesta, $idIdioma)
    {
        $objDS = new QuestionnairesDB();
        $result = $objDS->InsertLanguageQuestionnaireDB($idEncuesta, $idIdioma);

        return $result;
    }

    public function InsertQuestionnaire($nombre, $descripcion, $cliente)
    {
        $objDS = new QuestionnairesDB();
        $result = $objDS->InsertQuestionnaireDB($nombre, $descripcion, $cliente);

        return $result;
    }


}
?>
