<?php
$dirname = dirname(__DIR__);
include_once $dirname."/database/calificarAtencionDB.php";
include_once $dirname.'/database/datosBD.php';
include_once $dirname.'/brules/configuracionesGridObj.php';

class calificarAtencionObj extends configuracionesGridObj {

    public function getOpinionsByDateGrid($startDate, $endDate) {
        $calificarAtencionDB = new calificarAtencionDB();
        $datosBD = new datosBD();
        $data = array();

        $result = $calificarAtencionDB->getOpinionsByDateDB($startDate, $endDate);
        $opinions = $datosBD->arrDatosObj($result);   
        foreach ($opinions as $opinion) {
            $data[] = array(
                "idOpinion" => $opinion->idOpinion, 
                "usuario" => $opinion->nombreUsuario, 
                "comentario" => $opinion->comentario, 
                "fechaCreacion" => $opinion->fechaCreacion,
                "comite" => $opinion->nombreComite,
                "rol" => $opinion->rol,
            );
        }

        $grid = new KoolGrid("CalificacionesGrid");
        $gridData = new AdvancedArrayDataSource($data);
        $configGrid = new configuracionesGridObj();
        $configGrid->defineGrid($grid, $gridData);
        $configGrid->defineColumn($grid, "idOpinion", "ID", false, true);
        $configGrid->defineColumn($grid, "comite", "Comite", true, true);
        $configGrid->defineColumn($grid, "usuario", "Usuario", true, true);
        $configGrid->defineColumn($grid, "rol", "Rol", true, true);
        $configGrid->defineColumn($grid, "comentario", "Comentario", true, true);
        $configGrid->defineColumn($grid, "fechaCreacion", "Fecha Comentado", true, true);
        $grid->Process();
        
        return $grid;
    }

    public function crearOpinionCalificarAtencionObj($dataForm, $idUsuario) {
        $calificarAtencionDB = new calificarAtencionDB();
        $calificarAtencionDB->crearOpinionCalificarAtencionDB($dataForm, $idUsuario);
    }
}