<?php
$dirname = dirname(__DIR__);
include_once $dirname.'/brules/configuracionesGridObj.php';
include_once $dirname.'/database/datosBD.php';
include_once $dirname."/database/cambiosUsuariosDB.php";

class cambiosUsuariosObj extends configuracionesGridObj {

    public function insertCambioUsuario($usuarioMonitor, $idUsuario, $campo, $valorAnterior, $valorNuevo) {
        $cambUsuarios = new cambiosUsuariosDB();

        $result = $cambUsuarios->insertCambioUsuarioDB($usuarioMonitor, $idUsuario, $campo, $valorAnterior, $valorNuevo);
        return $result;
    }

    public function insertCambioDatosUsuario($usuarioMonitor, $idUsuario, $campo, $valorAnterior, $valorNuevo) {
      $cambUsuarios = new cambiosUsuariosDB();

      $result = $cambUsuarios->insertCambioUsuarioDB($usuarioMonitor, $idUsuario, $campo, json_encode($valorAnterior), json_encode($valorNuevo));
      return $result;
  }

    public function getCambiosUsuariosByDate($fechaInicio, $fechaFin) {
        $dtsBD = new datosBD();
        $cambUsuarios = new cambiosUsuariosDB();
        
        $result = $cambUsuarios->getCambiosUsuariosByDateDB($fechaInicio, $fechaFin);
        $cambiosUsuarios = $dtsBD->arrDatosObj($result);

        return $cambiosUsuarios;
    }

    public function getCambiosUsuariosByDateGrid($fechaInicio, $fechaFin) {
        $cambiosUsuarios = $this->getCambiosUsuariosByDate($fechaInicio, $fechaFin);

        $data = array();
        foreach ($cambiosUsuarios as $cambioUsuario) {

            $campo = $cambioUsuario->campo; 
            $valorAnterior = json_decode($cambioUsuario->valorAnterior);
            $valorNuevo = json_decode($cambioUsuario->valorNuevo);
            if ($campo == "idComite") {
                $campo = "Comit&eacute;";
                $valorAnterior = $valorAnterior->nombre;
                $valorNuevo = $valorNuevo->nombre;
            }

            $data[] = array(
                "idCambioUsuario" => $cambioUsuario->idCambioUsuario, 
                "usuarioMonitor" => $cambioUsuario->usuarioMonitor, 
                "nombreMonitor" => $cambioUsuario->nombreMonitor, 
                "usuarioId" => $cambioUsuario->usuarioId, 
                "nombreUsuario" => $cambioUsuario->nombreUsuario, 
                "campo" => $campo,
                "valorAnterior" => $valorAnterior,
                "valorNuevo" => $valorNuevo,
                "fechaCreacion" => $cambioUsuario->fechaCreacion,
            );
        }

        $grid = new KoolGrid("CambiosUsuariosGrid");
        $gridDataSource = new AdvancedArrayDataSource($data);
        $configGrid = new configuracionesGridObj();
        $configGrid->defineGrid($grid, $gridDataSource);
        $configGrid->defineColumn($grid, "idCambioUsuario", "Id Cambio", true, true, 0 , "", "50px");
        $configGrid->defineColumn($grid, "usuarioMonitor", "Id Usuario Monitor", false, true);
        $configGrid->defineColumn($grid, "nombreMonitor", "Usuario Monitor", true, true);
        $configGrid->defineColumn($grid, "usuarioId", "Id Usuario", false, true);
        $configGrid->defineColumn($grid, "nombreUsuario", "Usuario", true, true);
        $configGrid->defineColumn($grid, "campo", "Campo", true, true);
        $configGrid->defineColumn($grid, "valorAnterior", "Valor Anterior", true, true);
        $configGrid->defineColumn($grid, "valorNuevo", "Nuevo Valor", true, true);
        $configGrid->defineColumn($grid, "fechaCreacion", "Fecha del Cambio", true, true);
        $grid->Process();
        
        return $grid;
    }
}