<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/catTipoVehiculosDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class catTipoVehiculosObj  extends configuracionesGridObj{
    private $_idTipoVehiculo = 0;
    private $_nombre = '';
    private $_activo = 0;
    private $_imagen = '';
    private $_fechaCreacion = '';
    private $_usuarioRegistroId = 0;
    private $_fechaActualizacion = '';
    private $_usuarioActualizacionId = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function TipoVehiculosPorId($id)
    {
        $ds = new catTipoVehiculosDB();
        $obj = new catTipoVehiculosObj();
        $datosBD = new datosBD();
        $result = $ds->TipoVehiculosPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtTipoVehiculos($campo = "", $textoBuscar = "", $empresaId = ""){
        $array = array();
        $ds = new catTipoVehiculosDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTipoVehiculosDB($campo, $textoBuscar, $empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosTipoVehiculos($empresaId = ""){
        $array = array();
        $ds = new catTipoVehiculosDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosTipoVehiculosDB($empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Grid personal
     public function ObtTipoVehiculosGrid($usuarioId = ""){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new catTipoVehiculosDB();
        $ds = $uDB->TipoVehiculosDataSet($ds, $usuarioId);
        $grid = new KoolGrid("TipoVehiculosGrid");

        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idTipoVehiculo", "ID", false, true);
        // $configGrid->defineColumn($grid, "empresaId", "Empresa", true, false, 1, "90px");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1);
        $configGrid->defineColumn($grid, "activo", "Activo", true, false, 0);
        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }
    //Private Functions
    

}
