<?php
$dirname = dirname(__DIR__);
// include_once  $dirname.'/database/catConfiguracionesDB.php';
// include_once  $dirname.'/database/datosBD.php';
// include_once  $dirname.'/brules/catInstitucionesObj.php';
include_once  $dirname.'/brules/catComiteObj.php';
include_once  $dirname.'/brules/catCuentasObj.php';
include_once  $dirname.'/brules/usuariosObj.php';

class configuracionesGridObj {
    
    //Define el grid
    protected function defineGrid($grid, $ds)
    {   
        // $grid->id // Es el nombre del grid
        // echo "<pre>";
        // print_r($grid->id);
        // echo "</pre>";
        //create and define grid
        $grid->scriptFolder = "../brules/KoolControls/KoolGrid";
        $grid->styleFolder="office2010blue";
        $grid->Width = "100%";
        $grid->AllowScrolling = false;
        //$grid->MasterTable->Height = "540px";
        //$grid->MasterTable->ColumnWidth = "130px";
        $grid->RowAlternative = true;
        $grid->AjaxEnabled = true;
        $grid->AjaxLoadingImage =  "../brules/KoolControls/KoolAjax/loading/5.gif";
        $grid->Localization->Load("../brules/KoolControls/KoolGrid/localization/es.xml");
        $grid->AllowInserting = true;
        $grid->AllowEditing = true;
        $grid->AllowDeleting = true;
        $grid->AllowSorting = true;
        $grid->ColumnWrap = true;        
        $grid->AllowResizing = true;
        $grid->MasterTable->DataSource = $ds;
        $grid->MasterTable->AutoGenerateColumns = false;
        $grid->MasterTable->Pager = new GridPrevNextAndNumericPager();
        $grid->MasterTable->Pager->ShowPageSize = true;
        $grid->MasterTable->Pager->PageSizeOptions = "10,25,50,100,150";

        if($_SESSION['idRol']==1){
            //Show Function Panel
            $grid->MasterTable->ShowFunctionPanel = true; 
        }
        //Insert Settings
        $grid->MasterTable->InsertSettings->Mode = "Form";
        $grid->MasterTable->EditSettings->Mode = "Form";
        $grid->MasterTable->InsertSettings->ColumnNumber = 1;
        $grid->ClientSettings->ClientEvents["OnRowConfirmEdit"] = "Handle_OnRowConfirmEdit";
        $grid->ClientSettings->ClientEvents["OnConfirmInsert"] = "Handle_OnConfirmInsert";        
        $grid->ClientSettings->ClientEvents["OnRowDelete"] = "Handle_OnRowDelete";

        switch ($grid->id) {
            case 'patentes_competencia': 
                $grid->Width = "960px";                                
            break;
            case 'uso_estadisticas': 
                $grid->Width = "1000px";
                $grid->MasterTable->ShowFunctionPanel = false; //Show Function Panel
                // $grid->MasterTable->Pager->Position = "top";//Show both pager
                // $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                // $grid->MasterTable->FunctionPanel->ShowRefreshButton = true;
            break;
            case 'usuarios';
                $grid->MasterTable->ShowFunctionPanel = true; //Show Function Panel
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->MasterTable->Width = "100%";
		$grid->MasterTable->AllowScrolling = false;
            break;
            case 'Alarmas';
                $grid->MasterTable->ShowFunctionPanel = true; //Show Function Panel
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->Width = "auto";    
                $grid->MasterTable->Width = "100%";
                $grid->MasterTable->AllowScrolling = true;                            
            break;
            case 'HistoricosGrid';
                $grid->MasterTable->ShowFunctionPanel = true; //Show Function Panel
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
            break;
            case 'historialpeticiones':
                $grid->Width = "100%";    
                $grid->MasterTable->Width = "100%";
                $grid->MasterTable->AllowScrolling = true;
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->MasterTable->FunctionPanel->ShowRefreshButton = true;
            break;
            case "CalificacionesGrid":
                $grid->MasterTable->ShowFunctionPanel = true;
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
            break;
            case "CambiosUsuariosGrid":
                $grid->MasterTable->Width = "940px";
                $grid->MasterTable->ShowFunctionPanel = true;
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
            break;
            case 'historialcodigosvalidacion':
              $grid->MasterTable->AllowScrolling = true;
              $grid->MasterTable->Width = "100%";
              $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
            break;
            case 'peticiones_patrulleros':
                $grid->MasterTable->AllowScrolling = true;
                $grid->MasterTable->Width = "100%";
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->MasterTable->FunctionPanel->ShowRefreshButton = false;
            break;
            case 'accesos_patrulleros':
              $grid->MasterTable->AllowScrolling = true;
              $grid->MasterTable->Width = "100%";
              $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
              $grid->MasterTable->FunctionPanel->ShowRefreshButton = false;
            break;
            case 'unidadesPatrullas':
              $grid->MasterTable->AllowScrolling = true;
              $grid->MasterTable->Width = "100%";
              $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
              $grid->MasterTable->FunctionPanel->ShowRefreshButton = true;
            break;
            case 'botonSilencioso':
            case 'botonesllaveros':
                $grid->MasterTable->AllowScrolling = true;
                $grid->MasterTable->Width = "100%";
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->MasterTable->FunctionPanel->ShowRefreshButton = true;
              break;
	        case 'gridMascotas':
                $grid->MasterTable->AllowScrolling = true;
                $grid->MasterTable->Width = "100%";
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->MasterTable->FunctionPanel->ShowRefreshButton = true;
            break;
            case 'gridPersonas':
                $grid->MasterTable->AllowScrolling = true;
                $grid->MasterTable->Width = "100%";
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->MasterTable->FunctionPanel->ShowRefreshButton = true;
            break;
            case 'gridBuzonCiudadano':
                $grid->MasterTable->AllowScrolling = false;
                $grid->MasterTable->Width = "100%";
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->MasterTable->FunctionPanel->ShowRefreshButton = true;
            break;
	        case 'usuariosAdministrativo';
                $grid->MasterTable->ShowFunctionPanel = true; //Show Function Panel
                $grid->MasterTable->FunctionPanel->ShowInsertButton = false;
                $grid->ClientSettings->ClientEvents["OnLoad"] = "Handle_OnLoad";
                $grid->MasterTable->Width = "100%";
            break;
        }   
    }

    //define la columna del grid
    protected function defineColumn($grid, $name_field, $name_header, $visible=true, $read_only=false, $validator=0, $field_type="", $width = "90px")
    {           
        $column = new gridboundcolumn();
        if($name_field == 'activo') {
            $column = new GridBooleanColumn();
            $column->UseCheckBox = true;
            $column->Align = "center";
            // $column->CheckBox = true;
        }

        if($grid->id=="usuarios"){
            if ($name_field == 'idUsuario') {
                $column->Sort=-1;
            }else if($name_field == 'idRol') {
                $column = new GridDropDownColumn();
                $rolObj = new rolesObj();
                $rolArr = $rolObj->GetAllRoles();
                $column->AddItem('-- Seleccionar --',NULL);
                foreach($rolArr as $rolTmp)
                {                
                    $column->AddItem($rolTmp->rol,$rolTmp->idRol);             
                }
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen 
            }  
            elseif($name_field == 'valido') {
                $column = new GridDropDownColumn();
                $column->AddItem('Valido', 1);
                $column->AddItem('Sin Validar', 0);

                $column = new GridBooleanColumn();
                $column->UseCheckBox = true;
                $column->Align = "center";
                // $column->CheckBox = true;

                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen
            }
            elseif($name_field == 'nombre'){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }
            elseif($name_field == 'tipoUsuario'){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter", "Contain");//Only show 3 chosen 
            }
            elseif($name_field == 'email'){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            } elseif($name_field == 'nombreComite'){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }elseif($name_field == 'idComite'){
                $column = new GridDropDownColumn();
                $catComiteObj = new catComiteObj();
                $comArr = $catComiteObj->GetAllComites();
                $column->AddItem('-- Seleccionar --',NULL);
                foreach($comArr as $comTmp){                
                    $column->AddItem($comTmp->nombre, $comTmp->idComite);             
                }
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen 
            }
        }else if($grid->id=='Alarmas'){
            if ($name_field == 'idVehiculo') {
                $column->Sort=-1;
            }
            elseif($name_field == 'idComite'){
                $column = new GridDropDownColumn();
                $catComiteObj = new catComiteObj();
                $comArr = $catComiteObj->GetAllComites();
                $column->AddItem('-- Seleccionar --',NULL);
                foreach($comArr as $comTmp){                
                    $column->AddItem($comTmp->nombre, $comTmp->idComite);             
                }
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen 
            }
            elseif($name_field == 'activo'){
                $column = new GridBooleanColumn();
                $column->UseCheckBox = true;
                $column->Align = "center";
            }
            elseif($name_field == 'soloComite') {
                $column = new GridBooleanColumn();
                $column->UseCheckBox = true;
                $column->Align = "center";
                // $column->CheckBox = true;
            }else if($name_field == 'matricula'){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }else if($name_field == 'cuenta'){
                $column = new GridDropDownColumn();
                $catCuentasObj = new catCuentasObj();
                $cuentas = $catCuentasObj->GetAllCuentas();
                $column->AddItem('-- Seleccionar --', NULL);
                foreach($cuentas as $cuenta){      
                    //$column->AddItem($valorQueSeMostrar�, $valorQueSeTomar�ParaActualizar);          
                    $column->AddItem($cuenta->nombre, $cuenta->nombre);            
                }
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen 
            }
        }elseif($grid->id=='HistoricosGrid'){
            if($name_field == "alarma"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }elseif($name_field == "usuario"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }
            elseif($name_field == "accion"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }elseif($name_field=="texto"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }elseif($name_field=="cuenta"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }elseif($name_field == "tokenAnt"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }elseif($name_field == "tokenNuevo"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }
        }elseif($grid->id=='comites'){
            if($name_field == "mostrar"){
                $column = new GridBooleanColumn();
                $column->UseCheckBox = true;
                $column->Align = "center";

                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen 
            }else if($name_field == "nombre"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }
        }else if($grid->id=='historialpeticiones'){
            if ($name_field == 'idPeticion') {
                $column->Sort=-1;
            }else if($name_field == "usuario_peticion"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }else if($name_field == "nombre_usuario_turno"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }else if($name_field == "comite"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }
        }else if($grid->id=='historialcodigosvalidacion'){
            if ($name_field == 'idCodigoVal') {
                $column->Sort=-1;
            }
        } else if($grid->id=="usuariosAdministrativo"){
            if ($name_field == 'idUsuario') {
                $column->Sort=-1;
            }else if($name_field == 'idRol') {
                $column = new GridDropDownColumn();
                $rolObj = new rolesObj();
                $rolArr = $rolObj->GetAllRoles();
                $column->AddItem('-- Seleccionar --',NULL);
                foreach($rolArr as $rolTmp)
                {                
                    $column->AddItem($rolTmp->rol,$rolTmp->idRol);             
                }
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen 
            }
            elseif($name_field == 'valido') {
                $column = new GridDropDownColumn();
                $column->AddItem('Valido', 1);
                $column->AddItem('Sin Validar', 0);

                $column = new GridBooleanColumn();
                $column->UseCheckBox = true;
                $column->Align = "center";
                // $column->CheckBox = true;

                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen
            }
            elseif($name_field == 'nombre'){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }
            elseif($name_field == 'tipoUsuario'){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter", "Contain");//Only show 3 chosen 
            }
            elseif($name_field == 'email'){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }
            
        } else if($grid->id=="gridPersonas"){
            if($name_field == "nombrePersona"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            } else if($name_field == "lugarExtravio"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }else if($name_field == "fechaExtraviado2"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }else if($name_field == "fechaCreacion"){
                $column = new gridboundcolumn();
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal","Contain");//Only show 3 chosen 
            }
        } else if($grid->id=="telefonosEmergenciaGrid"){
            if($name_field == 'tipoTelefono'){
                $column = new GridDropDownColumn();
                $column->AddItem("Oficina", 0);
                $column->AddItem("Whatsapp", 1);             
                
                $column->AllowFiltering = true;
                $column->FilterOptions  = array("No_Filter","Equal");//Only show 3 chosen 
            }
        }

        switch($grid->id) {
            case "CambiosUsuariosGrid":
                switch($name_field) {
                    case "idCambioUsuario":
                        $column->Sort = -1;
                        break;
                }
                break;
        }

        // if($grid->id=="instituciones_poblacion"){
        //     if($name_field == 'catInstitutoId') {
        //         $column = new GridDropDownColumn();
        //         $catInstitucionObj = new catInstitucionesObj();
        //         $catInstitucionesArr = $catInstitucionObj->obtCatInstituciones(1);
        //         // echo "<pre>";
        //         // print_r($catInstitucionesArr);
        //         // echo "</pre>";
        //         $column->AddItem('-- Seleccionar --',NULL);
        //         foreach($catInstitucionesArr as $catInstitucionTmp)
        //         {                
        //             $column->AddItem($catInstitucionTmp->nombre, $catInstitucionTmp->idCatInstituto);             
        //         }
        //     }
        // }

        /*if($grid->id=="patentes_competencia"){
            if($name_field == 'esPatente') {
                $column = new GridDropDownColumn();
                $column->AddItem('No',0);
                $column->AddItem('Si',1);
            }
            elseif ($name_field == 'presentacion') {
                $column = new GridTextAreaColumn();
                $column->AllowHtmlRender = false;
                $column->BoxHeight = "50px";
            }
            elseif ($name_field == 'cicloTratamiendo') {
                $column = new GridTextAreaColumn();
                $column->AllowHtmlRender = false;
                $column->BoxHeight = "50px";    
            }
        }

        if($grid->id=="uso_estadisticas"){
            if($name_field == 'usuarioId') {
                $column = new GridDropDownColumn();
                $usuarioObj = new usuariosObj();
                $colUsuarios = $usuarioObj->obtTodosUsuarios();
                foreach($colUsuarios as $usuarioTmp)
                {                
                    $column->AddItem($usuarioTmp->nombre, $usuarioTmp->idUsuario);             
                }
            }            
        }*/
        
        
        //Valida si es requerido
        if($validator > 0){
            $column->addvalidator($this->GetValidator($validator));
        }

        //Tipo de validacion
        if($field_type != ""){
            $column->addvalidator($this->GetValidatorFieldType($field_type));
        }

        $column->Visible = $visible;
        $column->DataField = $name_field;
        $column->HeaderText = $name_header;
        $column->ReadOnly = $read_only;
        $column->Width = $width;
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }

    //validar campo
    private function GetValidator($type){
        switch ($type) {
            case 1: //required
                $validator = new RequiredFieldValidator();
                $validator->ErrorMessage = "Campo requerido";
                return $validator;
                break;            
        }
    }

    //valido el tipo del campo
    private function GetValidatorFieldType($field_type){
        switch ($field_type) {
            case "INT":
                $validatorTmp = new RegularExpressionValidator();
                $validatorTmp->ValidationExpression = "/^([0-9])+$/"; 
                $validatorTmp->ErrorMessage = "Campo tipo entero";
                return $validatorTmp;
            break;
            case "FLOAT":
                $validatorTmp = new RegularExpressionValidator();
                $validatorTmp->ValidationExpression = "/^([.0-9])+$/";
                $validatorTmp->ErrorMessage = "Campo tipo flotante";
                return $validatorTmp;
            break;
            case "EMAIL":
                $validatorTmp = new RegularExpressionValidator();
                // $validatorTmp->ValidationExpression = "/^\w+@[a-zA-Z_]+?\.[a-zA-Z]{2,3}$/";
                $validatorTmp->ValidationExpression = "/^[a-zA-Z_\-\.0-9]+@[a-zA-Z_]+?\.[a-zA-Z]{2,3}$/";
                $validatorTmp->ErrorMessage = "Campo tipo email";
                return $validatorTmp;
            break;
            case "TEL":
                $validator = new RegularExpressionValidator();
                $validator->ValidationExpression = "/^([0-9])+$/"; // Only accept integer.
                $validator->ErrorMessage = "Escriba un valor numerico";
                return $validator;
                break;
            break;
        }
    }

    //define la columna de acciones
    protected function defineColumnEdit($grid, $rolUsuarioPedido = '', $idRol = ""){
        $column = new GridCustomColumn();
        if($grid->id=="usuarios"){
            if ($rolUsuarioPedido == '3,10' ) {
                $column->ItemTemplate = '<a id="btnModal_{idUsuario}" href="#modal" onclick="muestraCiudadano({idUsuario})" data-toggle="modal" data-target="#popup_usr_datos"><img class="iconoDesactivar" src="../images/flash-edit.png" /><!--<i class="fa-solid fa-bolt-lightning"></i>--></a>
                <!--<a id="btnModal_{idUsuario}" class="mb-xs mt-xs mr-xs modal-sizes btn btn-default" href="#modalMD" onclick="muestraCiudadano({idUsuario})">Medium</a>-->';
            } 
            else if($rolUsuarioPedido && $rolUsuarioPedido != 4){
                $column->ItemTemplate = '<a href="frmUsuario.php?id={idUsuario}" class="kgrLinkEdit"></a>' .
                // '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>';
                    '<a class="kgrLinkDelete" onclick="eliminarUsuario({idUsuario})" href="javascript:void 0" title="Eliminar"></a>';
            } else if($rolUsuarioPedido && $rolUsuarioPedido == 4){
                //accciones grid patrullero

                //$column->ItemTemplate = '<a href="frmPatrullero.php?id={idUsuario}" class="kgrLinkEdit"></a>' .
                 $column->ItemTemplate = 
                    '<a id="btnInactivarPat_{idUsuario}" onclick="activaInactivaPatrullero({idUsuario},{activo})" href="javascript:void 0" title="Activar o deshabilitar patrullero"><img class="iconoDesactivar" src="../images/flash-edit.png" /> </a>' .
                    '<a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>' .
                    '<a class="kgrLinkDelete" onclick="eliminarUsuario({idUsuario})" href="javascript:void 0" title="Eliminar"></a>';
                }
            if (($idRol == "1" || $idRol == "5" )&& $rolUsuarioPedido != 4) {
                $column->ItemTemplate .= '<a class="" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"><img class="iconoDesactivar" src="../images/editar.png" /></a>' .
                    '<a class="kgrLinkDelete" onclick="eliminarUsuario({idUsuario})" href="javascript:void 0" title="Eliminar"></a>';
            }
        }  elseif($grid->id=="Alarmas"){
            if($rolUsuarioPedido == '5' || $rolUsuarioPedido == '6' || $rolUsuarioPedido == '9'){
                $column->ItemTemplate = ' '
                    . '<a class="btn" href="#modalCheckupAlarma" data-toggle="modal" data-target="#modalCheckupAlarma" title="Check-up" onclick="checkupAlarma({idVehiculo},\'{matricula}\')">Check-Up</a>'           
                    . '<a onclick="encenderAlarmaButton({idVehiculo},1,1)" href="javascript:void 0" title="Encender Alarma"><img class="iconoDesactivar" src="../images/activar.jpg" /></a>'
                    . '<a onclick="apagarAlarmaButton({idVehiculo},0,1)" href="javascript:void 0" title="Apagar Alarma"><img class="iconoDesactivar" src="../images/desactivar.png" /></a>';
            } if($rolUsuarioPedido == '5'){
                $column->ItemTemplate = ' '
                    . '<a class="btn" href="#modalCheckupAlarma" data-toggle="modal" data-target="#modalCheckupAlarma" title="Check-up" onclick="checkupAlarma({idVehiculo},\'{matricula}\')">Check-Up</a>'           
                    . '<a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
                    . '<a onclick="encenderAlarmaButton({idVehiculo},1,1)" href="javascript:void 0" title="Encender Alarma"><img class="iconoDesactivar" src="../images/activar.jpg" /></a>'
                    . '<a onclick="apagarAlarmaButton({idVehiculo},0,1)" href="javascript:void 0" title="Apagar Alarma"><img class="iconoDesactivar" src="../images/desactivar.png" /></a>';
            } else{
                $column->ItemTemplate = ' '
                    . '<a class="btn" href="#modalCheckupAlarma" data-toggle="modal" data-target="#modalCheckupAlarma" title="Check-up" onclick="checkupAlarma({idVehiculo},\'{matricula}\')">Check-Up</a>'           
                    . '<a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
                    . '<a onclick="encenderAlarmaButton({idVehiculo},1,1)" href="javascript:void 0" title="Encender Alarma"><img class="iconoDesactivar" src="../images/activar.jpg" /></a>'
                    . '<a onclick="apagarAlarmaButton({idVehiculo},0,1)" href="javascript:void 0" title="Apagar Alarma"><img class="iconoDesactivar" src="../images/desactivar.png" /></a>';
            }
            
        }
        elseif($grid->id=="HistoricosGrid"){
            $column->ItemTemplate = '            
            <!-- <a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>-->'
            . '<!--<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>-->';
        }elseif($grid->id=="historialpeticiones"){
            //if($rolUsuarioPedido == '3'){
            $column->ItemTemplate = '<a id="btnMensajes_{idPeticion}" href="#idPeticion={idPeticion}" class="cta" data-toggle="modal" data-target="#popup_verMensajes" onclick="verMensajes({idPeticion}, {numMensajes})" class="">Ver mensajes ({numMensajes}) </a>'
            . '<a href="javascript:void(0);" onclick="window.open(\'../ajaxcall2/exportamensajepeti.php?idPeticion={idPeticion}\', \'_blank\');" title="Descargar mensajes" >
                <img class="iconoDesactivar" src="../images/icon_upload.png" />
            </a>'
            /*. '<a href="javascript:void(0);" onclick="window.open(\'../ajaxcall2/exportarmapa.php?idPeticion={idPeticion}\', \'_blank\');" title="Descargar mapa">
                <img class="iconoDesactivar" src="../images/green-dot.png" />
            </a>'*/
            . '<a href="javascript:void(0);" title="Descargar mapa" class="cta" data-toggle="modal" data-target="#popup_mapaZonarecorrido" onclick="cargarMapaUsuarioPeticiones({idPeticion});">
                <img class="iconoDesactivar" src="../images/green-dot.png" />
            </a>';
            /*} else{
            $column->ItemTemplate = '            
            <a href="frmUsuario.php?id={idUsuario}" class="kgrLinkEdit"></a>'
            . '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>';
            }*/
        }elseif($grid->id=="peticiones_patrulleros"){
            //if($rolUsuarioPedido == '3'){
                $column->ItemTemplate = '<a id="btnMensajesPat_{idPeticion}" href="#idPeticion={idPeticion}" class="cta" data-toggle="modal" data-target="#popup_chatMensajesPatrullero" onclick="verMensajes2({idPeticion}, {numMensajes})" class="">Ver mensajes ({numMensajes}) </a>';
            /*} else{
            $column->ItemTemplate = '            
            <a href="frmUsuario.php?id={idUsuario}" class="kgrLinkEdit"></a>'
            . '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>';
            }*/
        }elseif($grid->id=="accesos_patrulleros"){
            //$column->ItemTemplate = '<a id="btnEstacionamientosPat_{idInicioSesion}" href="#idInicioSesion={idInicioSesion}" class="cta" data-toggle="modal" data-target="#popup_estacionamientosPatrullero" onclick="verEstacionamientosPatrulla({idInicioSesion}, {estacionamientos})" class="">Estacionamientos ({estacionamientos}) </a>';
        }
        elseif($grid->id=="comites"){
            $column->ItemTemplate = '            
            <a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
            .'<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>'
            // . '<a class="btnDesactivarUsuario" onclick="muestraDesactivarUsuario({idUsuario},\'usuariosGrid\',\'usuarios\',{activo})"  href="#fancyDesactivarUsuario" title="Activar/Desactivar usuario"><img src="../images/{nombreImg}" class="iconoDesactivar" ></a>'
            ;
        }
        elseif($grid->id=="escalonamientos"){
            $column->ItemTemplate = ' '           
            . '<a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
            . '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>';
        } 
        elseif ($grid->id=="usuariosAdministrativo"){
            $column->ItemTemplate = '<a href="editarUsuario.php?id={idUsuario}" class="kgrLinkEdit"></a>' .
            '<a class="kgrLinkDelete"  onclick="deleteUsuarioAdministrativo({idUsuario})"  title="Eliminar"></a>'.
            '<a  onclick="enviarCorreoAdministrativo({idUsuario})"title="Enviar datos al Correo"><img src="../images/enviarcorreo.png" class="iconoDesactivar"  style="filter: brightness(0) invert(1);cursor: pointer;" ></a>';
           
        }
        elseif($grid->id=="telefonosEmergenciaGrid"){
            $column->ItemTemplate = '
            <a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
            . '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>'
            . '<a class="btnDesactivarUsuario" onclick="muestraDesactivarUsuario({idEmergencia},\'telefonosEmergenciaGrid\',\'emergecia\',{activo})"  href="#fancyDesactivarUsuario" title="Activar/Desactivar usuario"><img src="../images/{nombreImg}" class="iconoDesactivar" ></a>';
        }
        else{
            $column->ItemTemplate = '            
            <a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
            . '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>'
            // . '<a class="btnDesactivarUsuario" onclick="muestraDesactivarUsuario({idUsuario},\'usuariosGrid\',\'usuarios\',{activo})"  href="#fancyDesactivarUsuario" title="Activar/Desactivar usuario"><img src="../images/{nombreImg}" class="iconoDesactivar" ></a>'
            ;
        }
        
        $column->Align = "center";
        $column->HeaderText = "Acciones";
        $column->Width = "100px";
        $grid->MasterTable->AddColumn($column);
    }

    public function defineColumnTypePassword($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Contraseña";
        $column->ItemTemplate = '
        
        <input type="password" value={password} id="btnShowPassword{idUsuario}" disabled style="border: none !important; text-align:center;">  

        <a href="javascript:void 0" onclick="verPasswordFromGridPatrullas(btnShowPassword{idUsuario}.id)" title="Ver contraseña"><img class="iconoDesactivar" src="../images/eye.png" /> </input>
                    
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }
    
    protected function defineColumnEditDesaparecidos($grid, $idRol = ""){
        $column = new GridCustomColumn();
        if($grid->id=="gridPersonas"){
           if ($idRol == "1" || $idRol == "2") {
                $column->ItemTemplate .= '<a class="cta" onclick="activarPersonaPerdida({idRptPersona},{activo})" href="javascript:void 0" title={personaActiva}> <img class="iconoDesactivar" src="../images/flash-edit.png" /> </a>'
                . '<a class="kgrLinkDelete" onclick="eliminarPersonaDesaparecida({idRptPersona})" href="javascript:void 0" title="Eliminar"></a>';
            }        
        }
        $column->Align = "center";
        $column->HeaderText = "Acciones";
        $column->Width = "auto";
        $grid->MasterTable->AddColumn($column);
    }

    public function defineColumnReporteStatus($grid) {
        $column = new GridCustomColumn();
        $column->HeaderText = "Reporte Status";
        $column->ItemTemplate = '
            <a 
                class="btn"
                onclick="muestraReporteStatus({idPeticion}, {comiteUsuario})"
                href="#modal"
                data-toggle="modal" 
                data-target="#popup_repStatus">
                Ver
            </a>
        ';
        $column->Width = "80px";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }
    public function defineColumnReportePatrullero($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Reporte Patrullero";
        $column->ItemTemplate = '
            <a 
                onclick="muestraReportePatrullero({idPeticion})"
                href="#modal"
                data-toggle="modal" 
                data-target="#popup_rep_patrullero">
                Ver
            </a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }

    public function defineColumnReporteAsignacionPatrullero($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Reporte de asignaci&oacute;n patrullero";
        $column->ItemTemplate = '
            <a class="btn"
                onclick="muestraReporteAsignacionPatrullero({idAsignacion})"
                href="#modal"
                data-toggle="modal" 
                data-target="#popup_rep_asignacion_patrullero">
                Ver
            </a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }

    public function defineColumnMensajePatrullero($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Mensaje Patrullero";
        $column->ItemTemplate = '
            <a 
            
                id="btnMensajes_{idPeticion}" 
                href="#idPeticion={idPeticion}" 
                class="cta" 
                data-toggle="modal" 
                data-target="#popup_verMensajes" 
                onclick="verMensajes({idPeticion}, {numMensajes})" 
                class="">Ver mensajes ({numMensajes}) </a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }

    
    public function defineColumnChatPatrullero($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Chat Patrullero - Operador";
        $column->ItemTemplate = '
            <a  class="btn"
                id="btnMensajesPat_{idPeticion}" 
                href="#idPeticion={idPeticion}" 
                class="cta" 
                data-toggle="modal" 
                data-target="#popup_chatMensajesPatrullero" 
                onclick="verMensajes2({idPeticion}, {numMensajes})" 
                class="">Ver mensajes ({numMensajes}) </a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }

    public function defineColumnTotalTiempoLoggueadoPorSesion($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Tiempo loggeado";
        $column->ItemTemplate = '
            <a 
                class="btn"
                data-toggle="modal"
                data-target="#popup_planosPatrulla"
                onclick="verPlanosEnTiempoLogueadoSesionPatrulla({idInicioSesion})"
                style="color: rgb(255 255 255 / 75%);"> {tiempoLoggeado} </a>
            ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    public function defineColumnTotalEstacionamientosPorSesion($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Veh&iacute;culo estacionado";
        $column->ItemTemplate = '
            <a 
                id="btnEstacionamientosPat_{idInicioSesion}" 
                href="#idInicioSesion={idInicioSesion}" 
                class="btn" 
                data-toggle="modal"
                data-target="#popup_estacionamientosPatrullero" 
                onclick="verEstacionamientosPatrulla({idInicioSesion}, {estacionamientos})" 
                class="" style="color: rgb(255 255 255 / 75%); background: #ff7e16;">{totalEstacionado}</a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    public function defineColumnTotalDesconexionesPorSesion($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Desconexiones de internet";
        $column->ItemTemplate = '
            <a 
                id="btnDesconexionesPat_{idInicioSesion}" 
                href="#idInicioSesion={idInicioSesion}" 
                class="btn" 
                data-toggle="modal"
                data-target="#popup_desconexionesPatrullero" 
                onclick="verDesconexionesPatrulla({idInicioSesion}, {desconexionesRed})" 
                class="" style="color: rgb(255 255 255 / 75%); background: red;">{totalDesconexion}</a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    public function defineColumnTotalAsignacionesPorSesion($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Asignaciones";
        $column->ItemTemplate = '
            <a 
                id="btnAsignacionesPat_{idInicioSesion}" 
                href="#idInicioSesion={idInicioSesion}" 
                class="btn" 
                data-toggle="modal"
                data-target="#popup_asignacionesPatrullero" 
                onclick="verAsignacionesPatrulla({idInicioSesion}, {totalAsignaciones})" 
                class="" style="color: rgb(255 255 255 / 75%); background: gray;">{totalAsignaciones}</a>
        ';

        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    public function defineColumnLiberarUnidad($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Liberar unidades";

        $column->ItemTemplate = '
            <a class="btn"
                style="color: rgb(255 255 255 / 75%); padding:10px;"
                onclick="liberarUnidadFromGrid({idVehiculo}, {estatusId}, {idInicioSesion})">
                {liberacionUnidad}
            </a>
        ';       

        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }

    public function defineColumnCoordenadasBotonSilencioso($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Coordenadas";

        $column->ItemTemplate = '
        {latitud}, {longitud}
            <a class="btn"
                a target="_blank" class="btn btn-primary" href="https://maps.google.com/?q={latitud},{longitud}"
                style="padding:10px;margin:0px 15px 0px 15px"
                onclick="">
                Ver en Google Maps
            </a>
        ';       

        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }
    
     public function defineColumnReportesMascotaVista($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Reportes de mascota vista";
        $column->ItemTemplate = '
            <a 
                id="btnReportesMascota_{idRptMascota}" 
                href="#idInicioSesion={idRptMascota}" 
                class="btn" 
                data-toggle="modal"
                data-target="#popup_reportesMascota" 
                onclick="verReportesMascotaVista({idRptMascota}, {reportesMascotaVista})" 
                class="" style="color: rgb(255 255 255 / 75%); background: #22649d; padding: 3px;">Total reportes: {reportesMascotaVista}</a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    public function defineColumnVerImagenesMascota($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Im&aacute;genes de la mascota";
        $column->ItemTemplate = '
            <a 
                class="cta" 
                data-toggle="modal"
                data-target="#popup_imagenesMascota" 
                onclick="verImagenesMascota({idRptMascota})" 
                >Ver</a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    public function defineColumnActivarPersonaPerdida($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Acciones";
        $column->ItemTemplate = '
            <a 
                class="cta" 
                onclick="activarPersonaPerdida({idRptPersona},{activo})"> {personaActiva}
            </a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    public function defineColumnVerImagenesPersona($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Im&aacute;genes de la persona";
        $column->ItemTemplate = '
            <a 
                class="btn"
                data-toggle="modal"
                data-target="#popup_imagenesPersonaPerdida" 
                onclick="verImagenesPersonaPerdida({idRptPersona})" 
                >Ver</a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    public function defineColumnImagenBuzonCiudadano($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Evidencia";
        $column->ItemTemplate = '
            <a
                class="btn"
                data-toggle="modal"
                data-target="#popup_evidenciasBoton"
                onclick="verEvidenciaBuzon({idBuzonCiudadano})"
                >Ver</a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }

    public function defineColumnReportesPersonaVista($grid){
        $column = new GridCustomColumn();
        $column->HeaderText = "Reportes de persona vista";
        $column->ItemTemplate = '
            <a 
                id="btnReportesPersona_{idRptPersona}" 
                href="#idInicioSesion={idRptPersona}" 
                class="btn" 
                data-toggle="modal"
                data-target="#popup_reportesPersona" 
                onclick="verReportesPersonaVista({idRptPersona}, {reportesPersonaVista})" 
                class="" style="color: rgb(255 255 255 / 75%); background: #22649d; padding: 3px;">Total reportes: {reportesPersonaVista}</a>
        ';
        $column->Width = "auto";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);   
    }

    protected function defineColumnEditMascotasDesaparecidas($grid, $idRol = ""){
        $column = new GridCustomColumn();
        if($grid->id=="gridMascotas"){
           if ($idRol == "1" || $idRol == "2") {
                $column->ItemTemplate .= '<a class="kgrLinkDelete" onclick="eliminarMascotaDesaparecida({idRptMascota})" href="javascript:void 0" title="Eliminar mascota"></a>';
            }        
        }
        $column->Align = "center";
        $column->HeaderText = "Acciones";
        $column->Width = "auto";
        $grid->MasterTable->AddColumn($column);
    }


    public function defineColumnReporteStatusAsignacion($grid) {
        $column = new GridCustomColumn();
        $column->HeaderText = "Operador";
        $column->ItemTemplate = '
            <a 
                class="btn"
                onclick="muestraReporteStatusAsignacion({idPeticion})"
                href="#modal"
                data-toggle="modal" 
                data-target="#popup_repStatusAsignacion">
                Ver Operadores
            </a>
        ';
        $column->Width = "100px";
        $column->Align = "center";
        $grid->MasterTable->AddColumn($column);
    }
 public function defineColumnRecorridoUsuario($grid)

    {

        $column = new GridCustomColumn();

        $column->HeaderText = "Zona de recorrido del usuario";

        $column->ItemTemplate = '

        <a 

        id="btnMapa_{idPeticion}" 

        class="cta" 

        data-toggle="modal" 

        data-target="#popup_mapaZonarecorrido" 

        onclick="cargarMapaUsuarioPeticiones({idPeticion})">

        Ver Zona de Recorrido

         </a>';
    
        $column->Width = "auto";

        $column->Align = "center";

        $grid->MasterTable->AddColumn($column);

    }





}