<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/historialSegundoPrimerPlanoDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class historialSegundoPrimerPlanoObj {
    private $_idHistorial2Plano  = 0;
    private $_fechaHora2plano = "";
    private $_fechaHora1plano = "";
    private $_tiempoInactivo = "";
    private $_idUsuarioTurno = "";
    private $_idPeticion = "";
    private $_idAsignado = "";
    private $_idInicioSesion = "";
    private $_peticionesObtenidas = "";
    private $_asignacionesObtenidas = "";

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    public function ActualizarCampoHistorialSegundoPrimerPlano($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new historialSegundoPrimerPlanoDB();
        $resAct = $objDB->updateCampoHistorialSegundoPrimerPlanoBD($param);
        return $resAct;
    }

    public function GuardarHistorialSegundoPrimerPlano(){
        $objDB = new historialSegundoPrimerPlanoDB();
        $this->_idHistorial2Plano = $objDB->insertHistorialSegundoPrimerPlanoBD($this->getParams());
    }

    private function getParams($update = false){
        $param[0] = $this->_fechaHora2plano;
        $param[1] = $this->_fechaHora1plano;
        $param[2] = $this->_tiempoInactivo;
        $param[3] = $this->_idUsuarioTurno;
        $param[4] = $this->_idPeticion;
        $param[5] = $this->_idAsignado;
        $param[6] = $this->_idInicioSesion;
        $param[7] = $this->_peticionesObtenidas;
        $param[8] = $this->_asignacionesObtenidas;
        return $param;
    }


    public function obtHistorial2PlanoByIdAsignacion($idAsignacion){
        $ds = new historialSegundoPrimerPlanoDB();
        $obj = new historialSegundoPrimerPlanoObj ();
        $datosBD = new datosBD();
        $result = $ds->obtHistorial2PlanoByIdAsignacionBD($idAsignacion);

        return $datosBD->setDatos($result, $obj);
    }

    public function obtTodos2PlanosPorAsignacion($idAsignacion){
        $array = array();
        $ds = new historialSegundoPrimerPlanoDB();
        $datosBD = new datosBD();
        $result = $ds->obtTodos2PlanosPorAsignacionDB($idAsignacion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function obtRegistros2PlanoPorSesion($idInicioSesion){
        $array = array();
        $ds = new historialSegundoPrimerPlanoDB();
        $datosBD = new datosBD();
        $result = $ds->obtRegistros2PlanoPorSesionDB($idInicioSesion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function obtSegundoPlanoPorAsignacion($idAsignacion){
        $array = array();
        $ds = new historialSegundoPrimerPlanoDB();
        $datosBD = new datosBD();
        $result = $ds->obtSegundoPlanoPorAsignacionDB($idAsignacion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
}
