<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/infolegalCategoriasDB.php';
include_once  $dirname.'/database/datosBD.php';

class infolegalCategoriasObj{
    private $_idInfoLCat = 0;    
    private $_nombre =  '';
    private $_activo = 0;
    private $_fechaCreacion = '0000-00-00 00:00:00';
    private $_idUsuarioCmb = 0;
    private $_fechaUltCambio = '0000-00-00 00:00:00';
    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion
    public function ObtInfolegalCategorias($activo=-1){
        $array = array();
        $ds = new infolegalCategoriasDB();
        $datosBD = new datosBD();

        $result = $ds->ObtInfolegalCategoriasDB($activo);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    /*
    //Obtener CatLugaresObjs por su id
    public function obtenerCatLugaresObjById($id){
        $ds = new infolegalCategoriasDB();
        $obj = new infolegalCategoriasObj();
        $datosBD = new datosBD();
        $result = $ds->obtenerCatLugaresObjById($id);

        return $datosBD->setDatos($result, $obj);
    }
    // guardar CatLugaresObjs
    public function GuardarCatLugaresObj(){
        $objDB = new infolegalCategoriasDB();
        return $this->_idDatoUsuario = $objDB->insertcatLugaresDB($this->getParams());
    }
    //Eliminar CatLugaresObjs
    public function EliminarCatLugaresObj($idDatoUsuario)
    {
        $objDB = new infolegalCategoriasDB();
        $param[0] = $idDatoUsuario;
        return $objDB->deletecatLugaresDB($param);
    }
    public function ActualizarCampo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new infolegalCategoriasDB();
        $resAct = $objDB->updateCampoDB($param);
        return $resAct;
    }

    private function getParams($ctr=false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;
        $this->_fechaUltCambio = $dateTime;

        $param[0] = $this->_tipoLugarId;
        $param[1] = $this->_nombre;
        $param[2] = $this->_codigo;
        $param[3] = $this->_urlImg;
        $param[4] = $this->_activo;
        $param[5] = $this->_idUsuarioCmb;
        return $param;
    }
    */
    public function ActualizarCampo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new infolegalCategoriasDB();
        $resAct = $objDB->updateCampoInfoLegalDB($param);
        return $resAct;
    }

    public function GetInfoLegalGrid(){
       $DataServices = new DataServices();
       $dbConn = $DataServices->getConnection();
       $ds = new MySQLiDataSource($dbConn);
       $uDB = new infolegalCategoriasDB();
       $ds = $uDB->infoLegalDataSet($ds);
       $grid = new KoolGrid("infoLegalGrid");

       $this->defineGridInfoLegal($grid, $ds);
       $this->defineColumnInfoLegal($grid, "idInfoLCat", "ID", false, true);
       $this->defineColumnInfoLegal($grid, "nombre", "Nombre", true, false, 1,"100px");
       $this->defineColumnInfoLegal($grid, "activo", "Activo", false, true, 1,"80px");
       $this->defineColumnEditUser($grid);

       //pocess grid
       $grid->Process();

       return $grid;
   }

   //Private Functions
   private function defineGridInfoLegal($grid, $ds)
   {
       //create and define grid
       $grid->scriptFolder = "../brules/KoolControls/KoolGrid";
       $grid->styleFolder="office2010blue";
       $grid->Width = "860px";

       $grid->RowAlternative = true;
       $grid->AjaxEnabled = true;
       $grid->AjaxLoadingImage =  "../brules/KoolControls/KoolAjax/loading/5.gif";
       $grid->Localization->Load("../brules/KoolControls/KoolGrid/localization/es.xml");

       $grid->AllowInserting = true;
       $grid->AllowEditing = true;
       $grid->AllowDeleting = true;
       $grid->AllowSorting = true;
       $grid->ColumnWrap = true;
       $grid->AllowScrolling = true;
       //$grid->MasterTable->Height = "540px";
       $grid->MasterTable->ColumnWidth = "90px";
       $grid->AllowResizing = true;

       $grid->MasterTable->DataSource = $ds;
       $grid->MasterTable->AutoGenerateColumns = false;
       $grid->MasterTable->Pager = new GridPrevNextAndNumericPager();
       $grid->MasterTable->Pager->ShowPageSize = true;
       $grid->MasterTable->Pager->PageSizeOptions = "10,25,50,100,150";
       //Show Function Panel
       $grid->MasterTable->ShowFunctionPanel = true;
       //Insert Settings
       $grid->MasterTable->InsertSettings->Mode = "Form";
       $grid->MasterTable->EditSettings->Mode = "Form";
       $grid->MasterTable->InsertSettings->ColumnNumber = 1;
       $grid->ClientSettings->ClientEvents["OnRowConfirmEdit"] = "Handle_OnRowConfirmEdit";
       $grid->ClientSettings->ClientEvents["OnConfirmInsert"] = "Handle_OnConfirmInsert";
   }
   //define the grid columns
   private function defineColumnInfoLegal($grid,$name_field, $name_header, $visible=true, $read_only=false, $validator=0, $width = "90px")
   {
      //  if($name_field == 'tipoJornadaId') {
      //      $column = new GridDropDownColumn();
      //      $jornadaObj = new catTipojornadaObj();
      //      $jornadaArr = $jornadaObj->ObtcatTipojornada();
      //      $column->AddItem('-- Seleccionar --',NULL);
      //      foreach($jornadaArr as $jornadaTmp)
      //      {
      //          $column->AddItem($jornadaTmp->nombre,$jornadaTmp->idTipoJornada);
      //      }
      //  }elseif ($name_field == 'catBTId') {
      //      $column = new GridDropDownColumn();
      //      $bolsaObj = new catBolsatrabajoObj();
      //      $bolsaArr = $bolsaObj->ObtCatBolsaTrabajo(1);
      //      $column->AddItem('-- Seleccionar --',NULL);
      //      foreach($bolsaArr as $bolsaTmp)
      //      {
      //          $column->AddItem($bolsaTmp->nombre,$bolsaTmp->idCatBT);
      //      }
      //  }
       // else if($name_field == 'editcol'){
       //     $column = new GridDropDownColumn();
       //     $column->AddItem('<a class="btnEditarColaborador" onclick="muestraEditarColaborador({idUsuario},\'{nombre}\')"  href="#fancyEditarColaborador" title="Editar Colaborador"><img src="../images/icon_cargo.png" class="iconoDesactivar" ></a>', 1);
       //     $column->AddItem('', 0);
       // }
      //  else{
           $column = new gridboundcolumn();
      //  }

       if($validator > 0)
           $column->addvalidator($this->GetValidatorUser ($validator));

       $column->Visible = $visible;
       $column->DataField = $name_field;
       $column->HeaderText = $name_header;
       $column->ReadOnly = $read_only;
       $column->Width = $width;
       $grid->MasterTable->AddColumn($column);
   }
   //validar campo
   private function GetValidatorUser($type){
       switch ($type) {
           case 1: //required
               $validator = new RequiredFieldValidator();
               $validator->ErrorMessage = "Campo requerido";
               return $validator;
               break;
           case 2:
               $validator = new RegularExpressionValidator();
               $validator->ValidationExpression = "/^([0-9])+$/"; // Only accept integer.
               $validator->ErrorMessage = "Escriba un valor numerico";
               return $validator;
               break;
       }
   }
   //define la columna de acciones
   private function defineColumnEditUser($grid){
       $column = new GridCustomColumn();
       $column->ItemTemplate = '
           <a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
           . '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>'
           . '<a class="btnDesactivarUsuario" onclick="muestraDesactivarUsuario({idInfoLCat},\'infoLegalGrid\',\'infoLegalCat\',{activo})"  href="#fancyDesactivarUsuario" title="Activar/Desactivar usuario"><img src="../images/{nombreImg}" class="iconoDesactivar" ></a>';
       $column->Align = "center";
       $column->HeaderText = "Acciones";
       $column->Width = "120px";
       $grid->MasterTable->AddColumn($column);
   }
}
