<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/common/DataServices.php';

class comunicadosDB {

  //obtiene todos los datosUsuario
  public function GetallComunicados($activo, $tipoOpc){
      $ds = new DataServices();
      $query = array();
      $param[0] = "";

      if($activo>0){
        $query[] = " activo=$activo ";
      }  

      if($tipoOpc=="turista"){
        $query[] = " opcTurista=1 ";
      }

      if($tipoOpc=="ciudadano"){
        $query[] = " opcCiudadano=1 ";
      }

      //En caso de llevar filtro
      if(count($query) > 0){
        $wordWhere = " WHERE ";
        $setWhere = implode(" AND ", $query);
        // echo $setWhere;
        $param[0] = $wordWhere.$setWhere;          
      }

      $result = $ds->Execute("GetallComunicados", $param);
      return $result;
  }

  //Otener tarea por id
  public function obtenerComunicadosById($id)
  {
      $ds = new DataServices();
      $param[0]= $id;
      $result = $ds->Execute("obtenerComunicadosById", $param);
      $ds->CloseConnection();

      return $result;
  }
  //Inserta informacion
  public function insertComunicadosDB($param){
      $ds = new DataServices();
      $result = $ds->Execute("insertComunicadosDB", $param, true);
      $ds->CloseConnection();
      return $result;
  }


  //Delete informacion
  public function deleteComunicadosDB($param){
      $ds = new DataServices();
      $result = $ds->Execute("deleteComunicadosDB", $param, false, true);
      $ds->CloseConnection();
      return $result;
  }
  //actualiza campo
  public function updateComunicadosCampoDB($param){
        $ds = new DataServices();
        $result = $ds->Execute("updateComunicadosCampoDB", $param, false, true);
        $ds->CloseConnection();
        return $result;
  }

  public function comunicadosDataSet($ds)
  {
      $dsO = new DataServices();
      $param = null;

      $ds->SelectCommand = $dsO->ExecuteDS("getComunicadoForGrid", $param);
      $ds->UpdateCommand = $dsO->ExecuteDS("updateComunicadoGrid", $param);
      $ds->DeleteCommand = $dsO->ExecuteDS("deleteComunicadoGrid", $param);
      $ds->InsertCommand = $dsO->ExecuteDS("insertComunicadoGrid", $param);
      $dsO->CloseConnection();

      return $ds;
  }
}
