<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/common/DataServices.php';

class rptPersonasDB {

  //Obtener coleccion de reporte personas
  public function ObtRptPersonasDB(){
    $ds = new DataServices();
    $param[0] = "";      
    $result = $ds->Execute("ObtRptPersonasDB", $param);
    $ds->CloseConnection();
    return $result;
  }

  //Obtener coleccion de reporte personas
  public function ObtRptPersonasActivasDB($activo){
    $ds = new DataServices();
    $param[0] = $activo;      
    $result = $ds->Execute("ObtRptPersonasActivasDB", $param);
    $ds->CloseConnection();
    return $result;
  }
  
  //Obtener coleccion de reporte personas
  public function ObtTodasPersonasPerdidasDB($date, $dateFin){
    $ds = new DataServices();
    $param[0] = "WHERE fechaCreacion>= '".$date." 00:00:00' AND fechaCreacion <= '".$dateFin." 23:59:59' ORDER BY fechaCreacion DESC";      
    $result = $ds->Execute("ObtTodasPersonasPerdidasDB", $param);
    $ds->CloseConnection();
    return $result;
  }

  public function ObtRptGridPersonasDB($ds, $date='', $dateFin=''){
    $dsO = new DataServices();
    if($date != '' && $dateFin != ''){
      $param[0] = "WHERE fechaCreacion>= '".$date." 00:00:00' AND fechaCreacion <= '".$dateFin." 23:59:59' AND encontrada = 0 ORDER BY fechaCreacion DESC";
    }else{
      $param[0] = ""; 
    }
    $ds->SelectCommand = $dsO->ExecuteDS("ObtRptPersonasDB", $param);

    $dsO->CloseConnection();
    return $ds;
  }

  //Obtener persona por su id
  public function ObtRptPersonaPorIdDB($id)
  {
    $ds = new DataServices();
    $param[0]= $id;
    $result = $ds->Execute("ObtRptPersonaPorIdDB", $param);
    $ds->CloseConnection();

    return $result;
  }

  public function insertarRptPersonaDB($param){
    $ds = new DataServices();
    $result = $ds->Execute("insertarRptPersonaDB", $param, true);
    $ds->CloseConnection();
    return $result;
  }

  public function updateCampoReportePersonasBD($param){
    $ds = new DataServices();
    $result = $ds->Execute("updateCampoReportePersonasBD", $param, false, true);
    $ds->CloseConnection();
    return $result;
  }

  public function totalPersonasPerdidasDB($activo){
    $ds = new DataServices();
    $param[0] = $activo;      
    $result = $ds->Execute("totalPersonasPerdidasDB", $param);
    $ds->CloseConnection();
    return $result;
  }

  public function eliminarPersonaPerdidaByIdDB($idRptPersona) {
    $dtServices = new DataServices();
    $params = array();

    $params[0] = $idRptPersona;
    $result = $dtServices->Execute("eliminarPersonaPerdidaByIdDB", $params);
    $dtServices->CloseConnection();

    return $result;
  }

  public function updateCampoRptPersonasBD($param){
    $ds = new DataServices();
    $result = $ds->Execute("updateCampoRptPersonasBD", $param, false, true);
    $ds->CloseConnection();
  
    return $result;
  }

  public function ObtRptGridPersonasEncontradasDB($ds, $date='', $dateFin=''){
    $dsO = new DataServices();
    if($date != '' && $dateFin != ''){
      $param[0] = "WHERE fechaCreacion>= '".$date." 00:00:00' AND fechaCreacion <= '".$dateFin." 23:59:59' AND encontrada = 1 ORDER BY fechaCreacion DESC";
    }else{
      $param[0] = "";  
    }
    $ds->SelectCommand = $dsO->ExecuteDS("ObtRptPersonasDB", $param);
    $dsO->CloseConnection();
    return $ds;
  }
}
