function getRealContentHeight() {
  var header = $.mobile.activePage.find("div[data-role='header']:visible");
  var footer = $.mobile.activePage.find("div[data-role='footer']:visible");
  var content = $.mobile.activePage.find("div[data-role='content']:visible:visible");
  var viewport_height = $(window).height();

  var content_height = viewport_height - header.outerHeight() - footer.outerHeight();
  if ((content.outerHeight() - header.outerHeight() - footer.outerHeight()) <= viewport_height) {
    content_height -= (content.outerHeight() - content.height());
  }
  return content_height;
}

//Metodos para cargar el mapa para usar google places

//Metodo de eror para el mapa
function geoError(err) {
  app.preloader.hide();
  // $('.loading_content').hide();
  // console.log("*geoError*");
  var message = 'code: ' + err.code + '\n' + 'message: ' + err.message + '\n';
  if (err.code == 1) {
    var message = 'Por favor verifique el gps este encendido';
  }
  app.dialog.alert(message);
}
//Fin de metodo para cargar el mapa de los establecimientos Cercanos con google places


//>>>>>>>>>>Mapa estatico de donde se llevo a cabo el reporte ciudadan






// **************************** INICIO FUNCIONES JAIR WEB **************************************
var pintarotravez;
var desepintar;
var infowindow = null;
var map;
var directionsDisplayPeticion;
var markersInicio = [];
var markersVehiculos = [];
var markersVehiculosPatrulleros = [];
var markersPeticiones = [];
var markerPeticion;
var markerAsignado;
var markersCercanos = [];
//var markersPeticionesAsignadas = [];
//var markersPeticionesTodas = [];
var markerUSR;
var markerUSR1;
var markerUNIDAD1;
var directionsService;
var markersCircles = [];
var infowindowPatrulla;
var arrPeticionesClick = [];
var directionsService;
var directionsRenderer;

var markerPatrulla;
var infowindow2;
var infowindowNuevoAsignado;
var markerCiudadano;
var markerNuevoAsignado;

var markersVehiculosAsignados = [];

//>>>>>>>>>>Mapa para el boton panico
function initializeMapPanico() {
  console.log("Inicia mapa");
  directionsService = new google.maps.DirectionsService();
  directionsRenderer = new google.maps.DirectionsRenderer({
    preserveViewport: true,
    polylineOptions: {
      strokeColor: 'gray',
      strokeOpacity: 0.8,
      strokeWeight: 4,
    },
  });

  $('#' + idDivMapa).empty();
  if ("geolocation" in navigator) {
    navigator.geolocation.getCurrentPosition(function (position) {
      var options = {
        zoom: 15,
        center: {
          lat: position.coords.latitude,
          lng: position.coords.longitude
        },
        mapTypeId: "roadmap",
        mapTypeControl: true,
        gestureHandling: 'greedy',
      };

      map = new google.maps.Map(document.getElementById(idDivMapa), options);

      markerPatrulla = new google.maps.Marker({
        map: map,
        draggable: false,
      });

      markerCiudadano = new google.maps.Marker({
        map: map,
        draggable: false,
      });

      /*markerNuevoAsignado = new google.maps.Marker({
        map: map,
        draggable: false,
      });*/

      directionsDisplayPeticion = new google.maps.DirectionsRenderer();
    });
  } else {
    alertify.warning("Es necesario permitir la detecci&oacute;n de ubicaci&oacute;n en su navegador.");
  }
}

var mapAlarmasStatus = "";
var mapAlarmas;
var directionsDisplayAlarma;
var markersAlarmas = [];
function initializeMapAlarmas(idDivAlarmas) {
  mapAlarmasStatus = idDivAlarmas;
  $('#' + mapAlarmasStatus).empty();
  if ("geolocation" in navigator) {
    navigator.geolocation.getCurrentPosition(function (position) {
      var options = {
        zoom: 15,
        center: {
          lat: position.coords.latitude,
          lng: position.coords.longitude
        },
        mapTypeId: "roadmap",
        mapTypeControl: true,
        gestureHandling: 'greedy',
      };
      mapAlarmas = new google.maps.Map(document.getElementById(mapAlarmasStatus), options);
      directionsDisplayAlarma = new google.maps.DirectionsRenderer();
    });
  } else {
    alertify.warning("Es necesario permitir la detecci&oacute;n de ubicaci&oacute;n en su navegador.");
  }
}

function getAlarmas() {
  var params = {
    funct: "obtenerAlarmasMapa",
  };

  ajaxData(params, function (data) {
    if (data.success) {
      actualizarAlarmasMapa(data.alarmas);
    }
  });
}

function actualizarAlarmasMapa(vehiculos) {
  vehiculos.forEach(function (vehiculo) {

    var continuar = true;
    var encontrado = false;

    markersAlarmas.forEach(function (markerObj) {
      if (markerObj["id"] == vehiculo.vehiculoId && !encontrado) {
        changeMarkerPosition(markerObj.marker, vehiculo.latitud, vehiculo.longitud);
        continuar = false;
        encontrado = true;

        if (vehiculo.tipoVehiculoId == 4) {
          if (vehiculo.activoV == 0) {
            var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
          } else if (vehiculo.estatusAlarma == 1) {
            var url = '../upload/iconos_tipovehiculo/alarma.png';
            var accionBtnAlarma = 'Encender';
          } else {
            var url = '../upload/iconos_tipovehiculo/alarma_e.png';
            var accionBtnAlarma = 'Apagar';
          }
          markerObj.marker.setIcon(url);
          //$("#spanBtnAlarma_" + vehiculo.vehiculoId).html(accionBtnAlarma);
        }
      }
    });

    if (continuar) {
      // console.log(vehiculo);
      if (vehiculo.latitud != '' && vehiculo.longitud != '') {
        // console.log(vehiculo.latitud);
        switch (vehiculo.tipoVehiculoId) {
          case '4':
            if (vehiculo.activoV == 0) {
              var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
            } else {
              var url = '../upload/iconos_tipovehiculo/alarma.png';
            }
            break;
          case '3':
            var url = '../upload/iconos_tipovehiculo/ambulancia.png';
            break;
          case '2':
            var url = '../upload/iconos_tipovehiculo/bomberos.png';
            break;
          case '1':
            var url = '../upload/iconos_tipovehiculo/patrulla.png';
            break;
          default:
            var url = '';
            break;
        }
        // var url = '../images/patrulla.png';

        if (vehiculo.tipoVehiculoId == 4) {
          if (vehiculo.activoV == 0) {
            var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
          } else if (vehiculo.estatusAlarma == 1) {
            var url = '../upload/iconos_tipovehiculo/alarma.png';
            var accionBtnAlarma = 'Encender';
          } else {
            var url = '../upload/iconos_tipovehiculo/alarma_e.png';
            var accionBtnAlarma = 'Apagar';
          }
        }

        //  if (bandLocalizar==1) {
        var contentString = '';
        if (vehiculo.tipoVehiculoId != 4) {
          contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
          contentString += '<p><b>Conductor: </b>' + vehiculo.conductor + '</p>';
        } else {
          contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
          contentString += '<p><a class="btn btn-warning" onclick="encenderAlarma(' + vehiculo.vehiculoId + ', 0, 1)" id="btnAlarmaApagar_' + vehiculo.vehiculoId + '"><span id="spanBtnAlarma_' + vehiculo.vehiculoId + '"><i class="fa fa-microphone-slash" aria-hidden="true"></i>&nbsp;Apagar</span></a>' +
            '&nbsp;&nbsp;<a class="btn btn-success" onclick="encenderAlarma(' + vehiculo.vehiculoId + ', 1, 1)" id="btnAlarmaEncender_' + vehiculo.vehiculoId + '"><span id="spanBtnAlarma_' + vehiculo.vehiculoId + '"><i class="fa fa-microphone" aria-hidden="true"></i>&nbsp;Encender</span></a>' +
            '</p>';
        }

        var infowindow = new google.maps.InfoWindow({
          content: contentString
        });

        var markerUN = new google.maps.Marker({
          map: mapAlarmas,
          draggable: false,
          position: {
            lat: parseFloat(vehiculo.latitud),
            lng: parseFloat(vehiculo.longitud)
          },
          icon: {
            url: url
          },
        });

        markerUN.addListener('click', function () {
          infowindow.open(map, markerUN);
        });

        var markerObj = new Object();
        markerObj.id = vehiculo.vehiculoId;
        markerObj.marker = markerUN;
        markersAlarmas.push(markerObj);
      }
    }
  });
}

var vehiculos_lenght_ant;
var vehiculos_lenght_nue;
//Funcion del boton Alarmas disponibles - muestra iconos de vehiculos

function actualizaVehiculosMapa(vehiculos) {
  vehiculos_lenght_ant = vehiculos_lenght_nue;
  vehiculos_lenght_nue = vehiculos.length;

  if (vehiculos_lenght_ant < vehiculos_lenght_nue) {
    obtenerVehiculosMapa();
  }

  if (vehiculos_lenght_ant > vehiculos_lenght_nue) {
    clearMarkers();
  }

  //clearMarkers();
  $("#contList").empty();
  // console.log(markersPeticiones);
  vehiculos.forEach(function (vehiculo) {
    var continuar = true;
    var encontrado = false;

    markersVehiculos.forEach(function (markerObj) {
      if (markerObj["id"] == vehiculo.vehiculoId && !encontrado) {
        changeMarkerPosition(markerObj.marker, vehiculo.latitud, vehiculo.longitud);
        continuar = false;
        encontrado = true;

        if (vehiculo.tipoVehiculoId == 4) {
          if (vehiculo.activoV == 0) {
            var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
          } else if (vehiculo.estatusAlarma == 1) {
            var url = '../upload/iconos_tipovehiculo/alarma.png';
            var accionBtnAlarma = 'Encender';
          } else {
            var url = '../upload/iconos_tipovehiculo/alarma_e.png';
            var accionBtnAlarma = 'Apagar';
          }
          markerObj.marker.setIcon(url);
          //$("#spanBtnAlarma_" + vehiculo.vehiculoId).html(accionBtnAlarma);
        }
      }
    });

    if (continuar) {
      if (vehiculo.latitud != '' && vehiculo.longitud != '') {
        var url = '';  // Default URL for icon

        switch (vehiculo.tipoVehiculoId) {
          case '4':  // Only handle type 4 here
            if (vehiculo.activoV == 0) {
              var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
            } else if (vehiculo.estatusAlarma == 1) {
              var url = '../upload/iconos_tipovehiculo/alarma.png';
              var accionBtnAlarma = 'Encender';
            } else {
              var url = '../upload/iconos_tipovehiculo/alarma_e.png';
              var accionBtnAlarma = 'Apagar';
            }
            break;
          default:
            var url = '';
            break;
        }

        var contentString = '';
        if (vehiculo.tipoVehiculoId == 4) {
          contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
          contentString += '<p><a class="btn btn-warning" onclick="encenderAlarma(' + vehiculo.vehiculoId + ', 0, 1)" id="btnAlarmaApagar_' + vehiculo.vehiculoId + '"><span id="spanBtnAlarma_' + vehiculo.vehiculoId + '"><i class="fa fa-microphone-slash" aria-hidden="true"></i>&nbsp;Apagar</span></a>' +
            '&nbsp;&nbsp;<a class="btn btn-success" onclick="encenderAlarma(' + vehiculo.vehiculoId + ', 1, 1)" id="btnAlarmaEncender_' + vehiculo.vehiculoId + '"><span id="spanBtnAlarma_' + vehiculo.vehiculoId + '"><i class="fa fa-microphone" aria-hidden="true"></i>&nbsp;Encender</span></a>' +
            '</p>';
        }

        var infowindow = new google.maps.InfoWindow({
          content: contentString
        });

        var markerUN = new google.maps.Marker({
          map: map,
          draggable: false,
          position: {
            lat: parseFloat(vehiculo.latitud),
            lng: parseFloat(vehiculo.longitud)
          },
          icon: {
            url: url
          },
        });

        markerUN.addListener('click', function () {
          infowindow.open(map, markerUN);
        });

        var markerObj = new Object();
        markerObj.id = vehiculo.vehiculoId;
        markerObj.marker = markerUN;
        markersVehiculos.push(markerObj);

        if (idAlarmaBuscada != "") {
          if (idAlarmaBuscada == vehiculo.vehiculoId) {
            infowindow.open(map, markerUN);
          }
        }

        // Only create a circle for tipoVehiculoId = 4
        if (vehiculo.tipoVehiculoId == 4) {
          var circle = new google.maps.Circle({
            strokeColor: 'black',
            strokeOpacity: 0.4,
            strokeWeight: 2,
            fillColor: 'green',
            fillOpacity: 0.2,
            center: {
              lat: parseFloat(vehiculo.latitud),
              lng: parseFloat(vehiculo.longitud)
            },
            map: map,
            radius: 250,
          });

          var lastZoom = 14;
          var rMin = 150, rMax = 300, step = 10;
          var intID;
          circle.setMap(map);
          setAnimation();

          function setAnimation() {
            var direction = 1;
            intID = setInterval(function () {
              var radius = circle.getRadius();
              if ((radius > rMax) || (radius < rMin)) {
                direction *= -1;
              }
              circle.setRadius(radius + direction * step);
            }, 50);
          }

          google.maps.event.addListener(map, 'zoom_changed', function () {
            clearInterval(intID);
            var zoom = map.getZoom();
            if (zoom > lastZoom) {
              rMax /= 2;
              rMin /= 2;
              step /= 2;
            } else {
              rMax *= 2;
              rMin *= 2;
              step *= 2;
            }
            lastZoom = zoom;
            circle.setRadius(rMax);
            setAnimation();
          });

          var markerObj2Circle = new Object();
          markerObj2Circle.id = vehiculo.vehiculoId;
          markerObj2Circle.marker = circle;
          markersCircles.push(markerObj2Circle);
        }
      }
    }
  });
}


function dibujarCirculos() {
  var params = {
    funct: "obtenerVehiculosMapa",
  };

  ajaxData(params, function (data) {
    if (data.success) {
      actualizaVehiculosMapaCirculos(data.vehiculosdisponibles);
    }
  });
}


function crearMarkersCircles(vehiculos) {

  clearMarkers2();
  // Limpiar los marcadores existentes
  markersVehiculosPatrulleros.forEach((markerObj) => {
    // Eliminar marcador del mapa
    markerObj.marker.setMap(null);
  });
  // Vaciar el arreglo
  markersVehiculosPatrulleros.length = 0;
  vehiculos.forEach(function (vehiculo) {
    // Comprobamos los vehículos tipo 1 (patrullas)
    if (vehiculo.tipoVehiculoId == 1) {
      if (vehiculo.estatusId == 1 && vehiculo.estatusAlarma == 1) {
        // Si estatusId es 1 y estatusAlarma es 1, es patrulla libre
        // Solo creamos el marcador sin círculo
        var url = '../upload/iconos_tipovehiculo/patrulla_libre.png';

        // Generar contenido para el infowindow
        var contentString = '';
        contentString += '<p><b>Patrulla disponible: </b>' + vehiculo.unidad + '</p>';
        contentString += '<p><b>Conductor: </b>' + vehiculo.conductor + '</p>';
        contentString += '<p><a id="asignarBtn" class="btn btn-primary" onclick="asignarUnidad(' + vehiculo.idUserTurno + ')">Asignar</a></p>';

        var infowindow = new google.maps.InfoWindow({
          content: contentString
        });

        var markerUNCircle = new google.maps.Marker({
          map: map,
          draggable: false,
          position: {
            lat: parseFloat(vehiculo.latitud),
            lng: parseFloat(vehiculo.longitud)
          },
          icon: {
            url: url
          },
        });

        markerUNCircle.addListener('click', function () {
          infowindow.open(map, markerUNCircle);
        });

        // Almacenar solo el marcador sin círculo
        var markerObjCircle = new Object();
        markerObjCircle.id = vehiculo.idUserTurno;
        markerObjCircle.marker = markerUNCircle;
        markersVehiculosPatrulleros.push(markerObjCircle);
      }
    }

    // Ahora comprobamos los vehículos tipo 4 (alarmas)
    if (vehiculo.tipoVehiculoId == 4) {
      // Si el vehículo es de tipo 4 (alarma), se crea el círculo y marcador
      var circle = new google.maps.Circle({
        strokeColor: 'black',
        strokeOpacity: 0.4,
        strokeWeight: 2,
        fillColor: 'green',
        fillOpacity: 0.2,
        center: {
          lat: parseFloat(vehiculo.latitud),
          lng: parseFloat(vehiculo.longitud)
        },
        map: map,
        radius: 250,
      });

      var lastZoom = 14;
      var rMin = 150, rMax = 300, step = 10;
      var intID;
      circle.setMap(map);
      setAnimation();

      function setAnimation() {
        var direction = 1;
        intID = setInterval(function () {
          var radius = circle.getRadius();
          if ((radius > rMax) || (radius < rMin)) {
            direction *= -1;
          }
          circle.setRadius(radius + direction * step);
        }, 50);
      }

      google.maps.event.addListener(map, 'zoom_changed', function () {
        clearInterval(intID);

        const zoom = map.getZoom();
        let circleRadius;
        console.log(zoom)
        // Escala dinámica inversa basada en el nivel de zoom
        if (zoom >= 0 && zoom <= 5) {
          circleRadius = 500; // Vista continental, círculo más grande
        } else if (zoom >= 6 && zoom <= 10) {
          circleRadius = 100; // Vista regional, círculo más grande
        } else if (zoom >= 11 && zoom <= 15) {
          circleRadius = 100; // Vista de ciudad, círculo más pequeño
        } else if (zoom >= 16 && zoom <= 19) {
          circleRadius = 100; // Vista de calle, círculo aún más pequeño
        } else if (zoom == 20) {
          circleRadius = 20; // Vista de calle, círculo aún más pequeño
        } else {
          circleRadius = 10;
        }

        // Aplicar el nuevo radio al círculo
        circle.setRadius(circleRadius);

        // Reiniciar la animación con los nuevos valores
        rMax = circleRadius;
        rMin = circleRadius / 2; // La mitad del tamaño máximo
        step = rMax / 50; // Ajustar el paso según el tamaño
        setAnimation();
      });



      // google.maps.event.addListener(map, 'zoom_changed', function () {
      //   clearInterval(intID);
      //   var zoom = map.getZoom();
      //   if (zoom > lastZoom) {
      //     rMax /= 2;
      //     rMin /= 2;
      //     step /= 2;
      //   } else {
      //     rMax *= 2;
      //     rMin *= 2;
      //     step *= 2;
      //   }
      //   lastZoom = zoom;
      //   circle.setRadius(rMax);
      //   setAnimation();
      // });

      // Establecer la URL del icono para la alarma
      var url;
      if (vehiculo.activoV == 0) {
        url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
      } else if (vehiculo.estatusAlarma == 1) {
        url = '../upload/iconos_tipovehiculo/alarma.png';
      } else {
        url = '../upload/iconos_tipovehiculo/alarma_e.png';
      }

      // Generar contenido para el infowindow
      var contentString = '';
      contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
      contentString += '<p><a class="btn btn-warning" onclick="encenderAlarma(' + vehiculo.vehiculoId + ', 0, 1)" id="btnAlarmaApagar_' + vehiculo.vehiculoId + '"><span id="spanBtnAlarma_' + vehiculo.vehiculoId + '"><i class="fa fa-microphone-slash" aria-hidden="true"></i>&nbsp;Apagar</span></a>' +
        '&nbsp;&nbsp;<a class="btn btn-success" onclick="encenderAlarma(' + vehiculo.vehiculoId + ', 1, 1)" id="btnAlarmaEncender_' + vehiculo.vehiculoId + '"><span id="spanBtnAlarma_' + vehiculo.vehiculoId + '"><i class="fa fa-microphone" aria-hidden="true"></i>&nbsp;Encender</span></a>' +
        '</p>';

      var infowindow = new google.maps.InfoWindow({
        content: contentString
      });

      var markerUNCircle = new google.maps.Marker({
        map: map,
        draggable: false,
        position: {
          lat: parseFloat(vehiculo.latitud),
          lng: parseFloat(vehiculo.longitud)
        },
        icon: {
          url: url
        },
      });

      markerUNCircle.addListener('click', function () {
        infowindow.open(map, markerUNCircle);
      });

      // Almacenar el círculo y marcador en arrays
      var markerObj2Circle = new Object();
      markerObj2Circle.id = vehiculo.vehiculoId;
      markerObj2Circle.marker = circle;
      markersCircles.push(markerObj2Circle);

      var markerObjCircle = new Object();
      markerObjCircle.id = vehiculo.vehiculoId;
      markerObjCircle.marker = markerUNCircle;
      markersVehiculos.push(markerObjCircle);
    }




















  });
}


//Actualizar marcadores MSA
function actualizaVehiculosMapaCirculos(vehiculos) {
  if (markersCircles.length == 0 || markersVehiculos.length == 0) {
    crearMarkersCircles(vehiculos);

  }

  vehiculos.forEach(function (vehiculo) {
    markersCircles.forEach(function (markerObj2Circle) {
      if (markerObj2Circle["id"] == vehiculo.vehiculoId) {
        changeMarkerPosition2(markerObj2Circle.marker, vehiculo.latitud, vehiculo.longitud);
      }
    });

    markersVehiculos.forEach(function (markerObjCircle) {
      if (markerObjCircle["id"] == vehiculo.vehiculoId) {
        changeMarkerPosition(markerObjCircle.marker, vehiculo.latitud, vehiculo.longitud);
      }
    });
  });
}



function actualizaVehiculosAsignados(asignados) {
  if (markersCircles.length == 0 || markersVehiculosAsignados.length == 0) {
    crearMarkersCircles(asignados);

  }

  asignados.forEach(function (asignado) {
    markersCircles.forEach(function (markerObj2Circle) {
      if (markerObj2Circle["id"] == asignado.vehiculoId) {
        changeMarkerPosition2(markerObj2Circle.marker, asignado.latitud, asignado.longitud);
      }
    });

    markersVehiculosAsignados.forEach(function (markerObjCircle) {
      if (markerObjCircle["id"] == asignados.vehiculoId) {
        changeMarkerPosition(markerObjCircle.marker, asignado.latitud, asignado.longitud);
      }
    });
  });
}


function actualizaPeticionesMapa(peticiones) {
  $("#cont_peticiones_mapa").empty();
  let hayAtendidas = false;
  let hayNoAtendidas = false;

  // Verificamos si hay peticiones atendidas o no atendidas
  peticiones.forEach(function (peticion) {
    if (peticion.usuarioOperadorId > 0) {
      hayAtendidas = true;
    } else {
      hayNoAtendidas = true;
    }
  });

  // Solo agregamos los contenedores si hay peticiones correspondientes
  if (hayAtendidas) {
    $("#cont_peticiones_mapa").append('<div id="peticioneslistatendidas"><h3>Peticiones Atendidas</h3></div>');
  }
  if (hayNoAtendidas) {
    $("#cont_peticiones_mapa").append('<div id="peticionesnoatendidas"><h3>Peticiones No Atendidas</h3></div>');
  }
  arrPeticionesPorAsignar = [];

  if (desplegarInfoPeticion) {
    console.log($("#peticionIdSelected").val());

    peticiones.forEach(function (peticion) {
      //console.log(peticion);

      var continuar = true;
      var encontrado = false;
      markersPeticiones.forEach(function (markerObj) {

        if (markerObj["id"] == peticion.idPeticion && !encontrado) {
          changeMarkerPosition(markerObj.marker, peticion.latitud, peticion.longitud);
          continuar = false;
          encontrado = true;
        }
      });

      if (peticion.latitud != '' && peticion.longitud != '' && peticion.latitud != null && peticion.longitud != null) {
        var band = 0;
        for (var i = 0; i < arrPeticionesPorAsignar.length; i++) {
          if (arrPeticionesPorAsignar[i].idPeticion == peticion.idPeticion) { //Se actualiza
            arrPeticionesPorAsignar[i] = peticion;
            band = 1;
            break;
          }
        }

        var html = "";
        var selectedClass = "";

        //Calculamos la diferencia de tiempo para usar color en la peticion (actualizar con la libreria moment.js)
        var peticionTiempoClass = "orange";
        var horaActual = new Date();
        var horaPeticion = new Date(peticion.fechaAsignacion);
        var tiempoDiferencia = horaActual - horaPeticion;

        //si ya pasaron 5 minutos y la peticion no se ha atendido
        if ((tiempoDiferencia / 60000) >= 5) {
          peticionTiempoClass = "red";
        } else if ((tiempoDiferencia / 60000) < 5) { //si son menos de 5 minutos en los que la peticion no se ha atendido
          peticionTiempoClass = "orange";
        }

        itemsSelected = localStorage.getItem('idsSelected');
        //Validamos que tenga informacion guardada de peticiones recibidas
        if (itemsSelected != "" && itemsSelected != null) {
          var items = itemsSelected.split(",");
          if (items.includes(peticion.idPeticion + "")) {
            peticionTiempoClass = "green";
          }
        }
        if (band == 0) {
          arrPeticionesPorAsignar.push(peticion);
          //resaltamos la peticion seleccionada
          if (selected == peticion.idPeticion) {
            selectedClass = " green_selected";
          }

          html += "<div class='row'>";
          html += '<div class="col-md-10 contenedor_peticion cont_peticion' + selectedClass + '" id="cont_list_' + peticion.idPeticion + '" onclick="verMarcadorMapa(' + peticion.latitud + ',' + peticion.longitud + ');seleccionarList(' + peticion.idPeticion + ', ' + idOperador + ');">';
          html += "<div id='painting_areaPeticion_" + peticion.idPeticion + "' class='col-md-1 painting_areaPeticion " + peticionTiempoClass + "'></div>";
          html += '<div class="col-md-8 "><span>#' + peticion.idPeticion + '</span></div><br>';
          html += '<div class="col-md-8 text-blco"><span>' + peticion.nombreUsuario + '</span></div>';

          switch (peticion.tipoPeticionId) {
            case '0':
              html += '<div><img src="../upload/iconos_tipovehiculo/ambulancia.png"  class="class_iconTipo"  alt=""></div>';
              break;
            case '1':
              html += '<div><img src="../upload/iconos_tipovehiculo/bomberos.png" class="class_iconTipo" alt=""></div>';
              break;
            case '2':
              html += '<div><img src="../upload/iconos_tipovehiculo/patrulla.png" class="class_iconTipo" alt=""></div>';
              break;
            default:
          }
          html += '</div>';
          html += '</div>';


          if (peticion.usuarioOperadorId > 0) { // Si la petición está atendida
            $("#peticioneslistatendidas").append(html);
          } else {
            $("#peticionesnoatendidas").append(html); // Agregar a las peticiones no atendidas
          }
        }
      }
    });

  } else {
    markersPeticiones.forEach(function (markerObj) {
      markerObj.marker.setMap(null); // Elimina el marcador del mapa
    });
    markersPeticiones = [];

    peticiones.forEach(function (peticion) {
      var continuar = true;
      var encontrado = false;

      if (peticion.latitud != '' && peticion.longitud != '' && peticion.latitud != null && peticion.longitud != null) {
        var band = 0;
        for (var i = 0; i < arrPeticionesPorAsignar.length; i++) {
          if (arrPeticionesPorAsignar[i].idPeticion == peticion.idPeticion) {
            arrPeticionesPorAsignar[i] = peticion;
            band = 1;
            break;
          }
        }

        var html = "";
        var selectedClass = "";
        //Calculamos la diferencia de tiempo para usar color en la peticion (actualizar con la libreria moment.js)
        var peticionTiempoClass = "orange";
        var horaActual = new Date();
        var horaPeticion = new Date(peticion.fechaAsignacion);
        var tiempoDiferencia = horaActual - horaPeticion;

        if ((tiempoDiferencia / 60000) >= 5) {
          peticionTiempoClass = "red";
        } else if ((tiempoDiferencia / 60000) < 5) {
          peticionTiempoClass = "orange";
        }
        //Validamos que tenga informacion guardada de peticiones recibidas

        itemsSelected = localStorage.getItem('idsSelected');
        if (itemsSelected != "" && itemsSelected != null) {
          var items = itemsSelected.split(",");
          if (items.includes(peticion.idPeticion + "")) {
            peticionTiempoClass = "green";
          }
        }

        if (band == 0) {
          arrPeticionesPorAsignar.push(peticion);
          if (selected == peticion.idPeticion) {
            selectedClass = " green_selected";
          }

          html += "<div class='row'>";
          html += '<div class="col-md-10 contenedor_peticion cont_peticion' + selectedClass + '" id="cont_list_' + peticion.idPeticion + '" onclick="verMarcadorMapa(' + peticion.latitud + ',' + peticion.longitud + ');seleccionarList(' + peticion.idPeticion + ', ' + idOperador + ');">';
          html += "<div id='painting_areaPeticion_" + peticion.idPeticion + "' class='col-md-1 painting_areaPeticion " + peticionTiempoClass + "'></div>";
          html += '<div class="col-md-8 "><span>#' + peticion.idPeticion + '</span></div><br>';
          html += '<div class="col-md-8 text-blco"><span>' + peticion.nombreUsuario + '</span></div>';

          html += '</div>';
          html += '</div>';
          if (peticion.usuarioOperadorId > 0) {
            $("#peticioneslistatendidas").append(html); // Agregar a las peticiones atendidas
          } else {
            $("#peticionesnoatendidas").append(html);
          }



        }

        contentString = '';
        contentString += '<p><a class="btn btn-primary peticion" onclick="preparaVerPeticion(' + peticion.idPeticion + ')">Ver petici&oacute;n</a>' +
          '<br><br><a target="_blank" class="btn btn-primary" href="https://maps.google.com/?q=' + peticion.latitud + ',' + peticion.longitud + '">Compartir coordenadas</a>' +
          '</p>';

        var infowindow = new google.maps.InfoWindow({
          content: contentString
        });

        var url = (peticion.estatusId == 1 || peticion.estatusId == 5) ? '../images/user-icon-2.png' : '../images/user-icon.png';

        var icon = {
          url: url,
          scaledSize: new google.maps.Size(50, 50), // scaled size
          origin: new google.maps.Point(0, 0), // origin
          anchor: new google.maps.Point(0, 0)
        };

        var markerUSR2 = new google.maps.Marker({
          map: map,
          draggable: false,
          // animation: google.maps.Animation.DROP,
          position: {
            lat: parseFloat(peticion.latitud),
            lng: parseFloat(peticion.longitud)
          }
        });

        markerUSR2.setIcon(icon);


        markerUSR2.addListener('click', function () {
          infowindow.open(map, markerUSR2);
        });

        var markerObj = new Object();
        markerObj.id = peticion.idPeticion;
        markerObj.marker = markerUSR2;
        //console.log(markerObj);
        markersPeticiones.push(markerObj);




      }




    });
  }

}

function dataCrearDivList(arrPeticion) {
  var html = "";
  $("#contList").empty();
  for (var i = 0; i < arrPeticion.length; i++) {
    html += '<div id="cont_list_' + arrPeticion[i].idPeticion + '" onclick="verMarcadorMapa(lat,long);">'
    html += '<div>Petici&oacute;n: <span>' + arrPeticion[i].idPeticion + '</span></div>'
    html += '<div>Usuario que solicita: <span>' + arrPeticion[i].idPeticion + '</span></div>'
    html += '<div>Tel&eacute;fono: <span>' + arrPeticion[i].idPeticion + '</span></div>'
    html += '</div>'
    $("#contList").append(html);
    // console.log(arrPeticion[i]);
  }
}

function actualizaPeticionMapa(peticion, vehiculos, asignado) {
  $("#infoUnidadSeleccionada").html("");
  //Se crea el marker del usuario
  if (peticion.latitud != '' && peticion.longitud != '') {

    var url = (peticion.estatusId == 1 || peticion.estatusId == 5) ? '../images/user-icon-2.png' : '../images/user-icon.png';

    var contentString = '';
    contentString += '<p>Petici&oacute;n: <b>' + peticion.idPeticion + '</b></p>';
    contentString += '<p>Usuario que solicita: <b>' + peticion.nombreUsuario + '</b></p>';
    contentString += '<p>Tel&eacute;fono: <b>' + peticion.telefono + '</b></p>';

    var calle = "";
    var numero = "";
    var colonia = "";
    var cp = "";
    var numComite = "";

    if (peticion.calle != null && peticion.calle != undefined && peticion.calle != "") {
      calle = peticion.calle;
    }
    if (peticion.numero != null && peticion.numero != undefined && peticion.numero != "") {
      numero = peticion.numero;
    }
    if (peticion.colonia != null && peticion.colonia != undefined && peticion.colonia != "") {
      colonia = peticion.colonia;
    }
    if (peticion.cp != null && peticion.cp != undefined && peticion.cp != "") {
      cp = peticion.cp;
    }
    if (peticion.numComite != null && peticion.numComite != undefined && peticion.numComite != "") {
      numComite = peticion.numComite;
    }

    contentString += '<p>Direcci&oacute;n: <b>' + calle + ' ' + numero + ' ' + colonia + ' ' + cp + '</b></p>';
    contentString += '<p>Comit&eacute;: <b>' + numComite + '</b></p>';

    //contentString += (peticion.estatusId == 2 && peticion.nombreConductor != null) ? '<p>Nombre conductor asignado: <b>' + peticion.nombreConductor : '</b></p>';
    //var contentBoton = '<div class="col-md-6"><a class="btn btn-primary finalizar" onclick="cancelarPeticion(' + asignado.idUserTurno + ')">Finalizar</a></div>';
    var contentBoton = '<div class="col-md-6"><a class="btn btn-primary llamar" href="tel:' + peticion.telefono + '"><i class="fa fa-phone"></i>Llamar</a>';

    $("#infoPeticionSeleccionada").html('<h4>Informaci&oacute;n petici&oacute;n</h4>' + contentString);
    $("#infoBotones").html(contentBoton);
    $("#btn-finalizar").html('<div class="col-md-6"><a class="btn btn-primary finalizar" onclick="cancelarPeticion(' + peticion.usuarioTurnoId + ',' + asignado.idUserTurno + ',' + asignado.latitud + ',' + asignado.longitud + ')"><i class="fa fa-check"></i>Finalizar</a></div>');

    var infowindow = new google.maps.InfoWindow({
      content: contentString
    });


    changeMarkerPosition(markerCiudadano, parseFloat(peticion.latitud), parseFloat(peticion.longitud));
    markerCiudadano.setIcon(icon);

    markerCiudadano.addListener('click', function () {
      infowindow.open(map, markerCiudadano);
    });
  }

  //Si  la peticion no se ha asignado se muestran todas las unidades disponibles

  if (peticion.estatusId == 1 || peticion.estatusId == 5) {
    //obtUnidadesCercanas(peticion, vehiculos);
  } else if (peticion.estatusId == 2) {
    //var url = '../images/patrulla.png';
    switch (peticion.tipoPeticionId) {
      case '0':
        var url = '../upload/iconos_tipovehiculo/ambulancia.png';
        break;
      case '1':
        var url = '../upload/iconos_tipovehiculo/bomberos.png';
        break;
      case '2':
        var url = '../upload/iconos_tipovehiculo/patrulla.png';
        break;
      default:
        var url = '../images/patrulla.png';
        break;
    }

    var contentString = '';

    contentString += '<p>Alarma: <b>' + asignado.unidad + '</b></p>';
    contentString += '<b>Conductor: <p>' + asignado.conductor + '</b></p>';
    // contentString += '<p><a class="btn btn-primary" onclick="cancelarUnidad('+asignado.idUserTurno+')">Cancelar unidad</a>'+
    // '</p>';

    var contentBoton = '<div class="col-md-6"><a class="btn btn-primary cancelar" onclick="cancelarUnidad(' + asignado.idUserTurno + ')">Cancelar unidad</a></div>';
    // Cambiar el icono al crear el marcador
    var url = '';
    if (asignado.estatusId == 2) {
      // Mantener el icono normal
      url = '../upload/iconos_tipovehiculo/patrulla.png';
    } else if (asignado.estatusId == 1 && asignado.estatusAlarma == 1) {
      // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
      url = '../upload/iconos_tipovehiculo/patrulla_libre.png';
    } else if (asignado.estatusId == 1 && asignado.estatusAlarma == 2) {
      // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
      url = '../upload/iconos_tipovehiculo/patrulla_ocupada.png';
    }
    // Cambiar el icono a 'patrulla_disponible.png' si el patrullero está vinculado
    if (asignado.nombre && asignado.nombre !== 'No vinculado a un patrullero') {
      url = '../upload/iconos_tipovehiculo/patrulla.png';
    }
    marcador.setIcon(url);

    var infowindow = new google.maps.InfoWindow({
      content: contentString + contentBoton
    });

    markerUNIDAD1 = new google.maps.Marker({
      map: map,
      draggable: false,
      // animation: google.maps.Animation.DROP,
      position: {
        lat: parseFloat(asignado.latitud),
        lng: parseFloat(asignado.longitud)
      },
      icon: {
        url: url
      },
    });


    markerUNIDAD1.addListener('click', function () {
      $("#infoUnidadSeleccionada").html('<h4>Informaci&oacute;n alarma</h4>' + contentString);
      infowindow.open(map, markerUNIDAD1);
    });
    markersInicio.push(markerUNIDAD1);
    //trazarRutaUnidadUsr(asignado.latitud, asignado.longitud, peticion.latitud, peticion.longitud);
    $("#infoUnidadSeleccionada").html('<h4>Informaci&oacute;n alarma</h4>' + contentString);
    $("#infoBotones").append(contentBoton);
  } else if (peticion.estatusId > 2) {

  }

}

/* trazar mapa de usuario solicitud ayuda
function trazarRutaUnidadUsr(posLatUnidad, posLonUnidad, posLatUsrAyuda, posLonUsrAyuda) {
  //NO PINTAR 2/MARZO/2020
  var pintar = false;
  if (pintar) {
    var origin = new google.maps.LatLng(posLatUnidad, posLonUnidad);
    var destination = new google.maps.LatLng(posLatUsrAyuda, posLonUsrAyuda);
    directionsService = new google.maps.DirectionsService();
    var request = {
      origin: origin,
      destination: destination,
      travelMode: google.maps.TravelMode.DRIVING,
    };
    directionsService.route(request, function (response, status) {
      if (status == google.maps.DirectionsStatus.OK) {
        directionsDisplayPeticion.setMap(null);
        directionsDisplayPeticion.setDirections(response);
        directionsDisplayPeticion.setMap(map);
        directionsDisplayPeticion.setOptions({
          suppressMarkers: true
        });
      } 
    });
  }
}*/


// function setMapOnAll(map) {
//     for (var i = 0; i < markersInicio.length; i++) {
//       markersInicio[i].setMap(map);
//       // map.removeOverlay(markersInicio[i]);
//     }
// }

function getDistanceToCoords(lat1, lon1, lat2, lon2) {
  function _deg2rad(deg) {
    return deg * (Math.PI / 180);
  }

  var R = 6371; // Radius of the earth in km
  var dLat = _deg2rad(lat2 - lat1); // deg2rad below
  var dLon = _deg2rad(lon2 - lon1);
  var a =
    Math.sin(dLat / 2) * Math.sin(dLat / 2) +
    Math.cos(_deg2rad(lat1)) * Math.cos(_deg2rad(lat2)) *
    Math.sin(dLon / 2) * Math.sin(dLon / 2);
  var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
  var d = R * c; // Distance in km
  // console.log("toFixed(2)");
  // console.log(d.toFixed(2));
  return d.toFixed(2);
}

function obtUnidadesCercanas(peticion, vehiculos) {
  //console.log("obtUnidadesCercanas linea 618");
  //console.log(peticion);
  html = '';
  var vehCercanos = [];
  // var rechazoRes = 10;
  /*var options = {
    maximumAge: 600000,         // Se aceptan posiciones mientras no se revase de 10 minutos
    timeout: 30000,             // mientras no exista una posición almacenada en cache, invocara la llamada de error despues de 30 segundos
    enableHighAccuracy: false   // verdadero si necesita una alta posición
  };*/
  //navigator.geolocation.getCurrentPosition(function (position) {
  var lat1 = peticion.latitud;
  var lon1 = peticion.longitud;

  $.each(vehiculos, function (index, value) {
    var colIndex = vehiculos[index];

    if (colIndex != undefined) {
      lat2 = colIndex['latitud'];
      lon2 = colIndex['longitud'];
      km = getDistanceToCoords(lat1, lon1, lat2, lon2);
      //kmF = 19;//Math.round(km * 100) / 100;
      // console.log(km + ' Km');

      dataSuc = {
        idUserTurno: colIndex['idUserTurno'],
        conductor: colIndex['conductor'],
        idUserTurno: colIndex['idUserTurno'],
        latitud: colIndex['latitud'],
        longitud: colIndex['longitud'],
        matricula: colIndex['matricula'],
        tipoVehiculoId: colIndex['tipoVehiculoId'],
        turnoId: colIndex['turnoId'],
        unidad: colIndex['unidad'],
        usuarioVehiculoId: colIndex['usuarioVehiculoId'],
        km: parseFloat(km),
        vehiculoId: colIndex['vehiculoId'],
        idRechazoPatrulla: colIndex['idRechazoPatrulla'],
        idPeticion: colIndex['idPeticion'],
        estatusAlarma: colIndex['estatusAlarma'],
        idComite: colIndex['idComite'],
        soloComite: colIndex['soloComite'],
        distanciaAlarma: colIndex['distanciaAlarma']
        // rechazo:  rechazoRes
      };


      if (peticion.opcComite == 1 && peticion.idComiteUsuario == colIndex['idComite'] && parseFloat(km) <= (colIndex['distanciaAlarma'] / 100)) {
        //console.log("division entre 100");
        //console.log((colIndex['distanciaAlarma']/100));
        vehCercanos.push(dataSuc);
      }

      // Validamos si esta a menos de 100m de una alarma 28/03/2020 Rafa
      //Alarmas con distancia mayor a 100m se discriminan
      //if (parseFloat(km) < 0.1) {
      //vehCercanos.push(dataSuc);
      //}

      if (vehCercanos.length == 0) {
        if (parseFloat(km) < 10) {
          vehCercanos.push(dataSuc);
        }
      }

      let existente = vehCercanos.filter(vehCercanos => vehCercanos.idUserTurno == colIndex['idUserTurno']);

      if (existente.length == 0 && colIndex['tipoVehiculoId'] != '4' && parseFloat(km) < 0.1) {
        vehCercanos.push(dataSuc);
      }

      for (var x in vehCercanos) {
        if (vehCercanos[x].idPeticion <= colIndex['idPeticion'] && vehCercanos[x].idUserTurno == colIndex['idUserTurno']) {
          vehCercanos.splice(x, 1);
          vehCercanos.push(dataSuc);
        }
      }
      //vehCercanos.sort((a, b) => {  return a.km - b.kms;});
    }
  });

  //alert("vehiculos cercanos");
  //console.log(vehCercanos);
  //ejemplo real
  for (r = 0; r < (vehCercanos.length - 1); r++) {
    for (s = 0; s < (vehCercanos.length - r); s++) {
      kmTemp1 = vehCercanos[s].km;
      if (vehCercanos[s + 1] != undefined) {
        kmTemp2 = vehCercanos[s + 1].km;

        if (kmTemp1 > kmTemp2) {
          aux = vehCercanos[s]; //guardamos el numero mayor en el auxiliar
          vehCercanos[s] = vehCercanos[s + 1]; //guardamos el numero menor en el lugar correspondiente
          vehCercanos[s + 1] = aux; //asignamos el auxiliar en el lugar correspondiente
        }
      }
    }
  }
  // console.log(peticion.tipoPeticionId);
  if (peticion.tipoPeticionId == 4) {
    actualizaPeticionVecinal(peticion, vehCercanos);
  } else {
    // console.log("cercanos");
    actualizaPeticionMapaCercano(peticion, vehCercanos);
  }

  //console.log(vehCercanos);
  //},geoError, options);
}



function actualizaPeticionMapaCercano(peticion, vehCercanos) {
  // clearMarkers();
  var arrayVehiculosExcluidos = [];
  var arrayAlarmasExcluidos = [];
  var arrayVehiculoUnicos = [];
  $("#infoUnidadSeleccionada").html("");
  //Se crea el marker del usuario
  // console.log(vehCercanos);

  vehCercanos.forEach(function (vehiculo) {
    if (vehiculo.idPeticion == peticion.idPeticion) {
      arrayVehiculosExcluidos.push(vehiculo.idUserTurno);
    }
  });
  //Si  la peticion no se ha asignado se muestran todas las unidades disponibles
  if (peticion.estatusId == 1 || peticion.estatusId == 5) {
    rechazo = 0;
    var rechazoRes = 0;
    vehCercanos.forEach(function (vehiculo) {


      var continuar = true;
      var encontrado = false;
      markersCercanos.forEach(function (markerObj) {
        if (markerObj["id"] == vehiculo.vehiculoId && !encontrado) {
          changeMarkerPosition(markerObj.marker, vehiculo.latitud, vehiculo.longitud);
          continuar = false;
          encontrado = true;

          if (vehiculo.tipoVehiculoId == 4) {
            if (vehiculo.activoV == 0) {
              var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
            } else if (vehiculo.estatusAlarma == 1) {
              var url = '../upload/iconos_tipovehiculo/alarma.png';
              var accionBtnAlarma = 'Encender';
            } else {
              var url = '../upload/iconos_tipovehiculo/alarma_e.png';
              var accionBtnAlarma = 'Apagar';
            }
            markerObj.marker.setIcon(url);
            //$("#spanBtnAlarma_" + vehiculo.vehiculoId).html(accionBtnAlarma);
          }
        }

      });

      // console.log(continuar);
      // if(continuar){
      var noPrint = 0;
      var bandLocalizar = 0;
      if (vehiculo.idPeticion > 0) {
        if (vehiculo.idPeticion == peticion.idPeticion) {
          rechazoRes = 1;
          noPrint = 1;

        } else {
          // arrayVehiculosExcluidos.push(vehiculo.idUserTurno);
          if (arrayVehiculosExcluidos.includes(vehiculo.idUserTurno)) { /// si la unidad ya fue excluida se ignora
            rechazoRes = 1;
          } else {
            if (arrayVehiculoUnicos.includes(vehiculo.idUserTurno)) {
              noPrint = 1;
            } else {
              noPrint = 0;
              arrayVehiculoUnicos.push(vehiculo.idUserTurno);
            }
            rechazoRes = 0;
          }

        }
      } else { /// es otra peticion
        if (arrayVehiculoUnicos.includes(vehiculo.idUserTurno)) {
          noPrint = 1;
        } else {
          noPrint = 0;
          arrayVehiculoUnicos.push(vehiculo.idUserTurno);
        }
        rechazoRes = 0;
      }
      if (noPrint == 0) {


        // console.log(arrayVehiculosExcluidos);
        switch (peticion.tipoPeticionId) {
          case '0':
            if (rechazoRes == 0) {
              if (rechazo == 0) {
                rechazo = 1;
                bandLocalizar = 1;
                var url = '../upload/iconos_tipovehiculo/ubicacion-ambulancia.png';
              } else {
                var url = '../upload/iconos_tipovehiculo/ambulancia.png';
              }
            } else {
              var url = '../upload/iconos_tipovehiculo/ambulancia.png';
            }
            break;
          case '1':
            if (rechazoRes == 0) {
              if (rechazo == 0) {
                rechazo = 1;
                bandLocalizar = 1;
                var url = '../upload/iconos_tipovehiculo/ubicacion-bomberos.png';
              } else {
                var url = '../upload/iconos_tipovehiculo/bomberos.png';
              }
            } else {
              var url = '../upload/iconos_tipovehiculo/bomberos.png';
            }
            break;
          case '2':
            if (rechazoRes == 0) {
              if (rechazo == 0) {
                rechazo = 1;
                bandLocalizar = 1;
                var url = '../upload/iconos_tipovehiculo/ubicacion-patrulla.png';
              } else {
                var url = '../upload/iconos_tipovehiculo/patrulla.png';
              }
            } else {
              var url = '../upload/iconos_tipovehiculo/patrulla.png';
            }

            break;
          default:
            var url = '../images/patrulla.png';
            break;
        }

        if (vehiculo.tipoVehiculoId == 4) {
          if (vehiculo.activoV == 0) {
            var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
          } else if (vehiculo.estatusAlarma == 1) {
            var url = '../upload/iconos_tipovehiculo/alarma.png';
            var accionBtnAlarma = 'Encender';
          } else {
            var url = '../upload/iconos_tipovehiculo/alarma_e.png';
            var accionBtnAlarma = 'Apagar';
          }
        }



        //  if (bandLocalizar==1) {
        var contentString = '';
        if (vehiculo.tipoVehiculoId != 4) {
          contentString += '<p>Alarma: <b>' + vehiculo.unidad + '</b></p>';
          contentString += '<p>Conductor: <b>' + vehiculo.conductor + '</b></p>';
          contentString += '<p><a class="btn btn-primary asignar" onclick="asignarUnidad(' + vehiculo.idUserTurno + ')">Asignar</a></p>'
        } else {
          // console.log("ALARMA");
          // console.log(vehiculo);
          contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
          contentString += '<p><a class="btn btn-warning" onclick="encenderAlarma(' + vehiculo.vehiculoId + ',0, 1)" id="btnAlarmaApagar_' + vehiculo.vehiculoId + '"><span id="spanBtnAlarma_' + vehiculo.vehiculoId + '"><i class="fa fa-microphone-slash" aria-hidden="true"></i>&nbsp;Apagar</span></a>' +
            '&nbsp;&nbsp;<a class="btn btn-success" onclick="encenderAlarma(' + vehiculo.vehiculoId + ',1, 1)" id="btnAlarmaEncender_' + vehiculo.vehiculoId + '"><span id="spanBtnAlarma_' + vehiculo.vehiculoId + '"><i class="fa fa-microphone" aria-hidden="true"></i>&nbsp;Encender</span></a>' +
            '</p>';

        }

        var infowindow = new google.maps.InfoWindow({
          content: contentString
        });

        var animacion = "";
        if (bandLocalizar == 1) {
          animacion = google.maps.Animation.BOUNCE;
        }
        if (continuar) {
          var markerUN = new google.maps.Marker({
            map: map,
            draggable: false,
            // animation: google.maps.Animation.DROP,
            position: {
              lat: parseFloat(vehiculo.latitud),
              lng: parseFloat(vehiculo.longitud)
            },
            icon: {
              url: url
            },
            animation: animacion,
          });

          markerUN.addListener('click', function () {
            infowindow.open(map, markerUN);
          });

          var markerObj = new Object();
          markerObj.id = vehiculo.vehiculoId;
          markerObj.marker = markerUN;
          // console.log(markerObj);
          markersCercanos.push(markerObj);
        }
        //markersInicio.push(markerUN);
        if (bandLocalizar == 1) {
          // console.log("1 Ver u");
          contentCercana = '<div class="col-md-6"><a class="btn btn-primary" onclick="verMarcadorMapa(' + vehiculo.latitud + ',' + vehiculo.longitud + ')">Unidad mas cercana</a></div>';
          $("#infoBotones").append(contentCercana);
          // asignar de forma automatica a la patrulla
          var params = {
            //funct: 'asignaPatrullaTurno',
            idTurno: vehiculo.idUserTurno,
            idPeticion: peticion.idPeticion,

          };
          // ajaxData(params, function(data){
          //   if(data.success){
          //     alertify.success("Petici&oacute;n asignada correctamente a la unidad seleccionada");
          //   }else{
          //     alertify.warning("No se ha podido asignar a la unidad seleccionada");
          //   }
          // });
        }
      }
      // }
    });
  }
}


function changeMarkerPosition(marker, latitud, longitud) {
  var latlng = new google.maps.LatLng(latitud, longitud);
  marker.setPosition(latlng);
}

function changeMarkerPosition2(marker1, latitud1, longitud1) {
  var latlng1 = new google.maps.LatLng(latitud1, longitud1);
  marker1.setCenter(latlng1);
}

var valorentrada = 0;

function panicoVecinal(peticion, unidades, asignado, almComite, distPetiAlarm, dataAsignado, dataAlarma, nombreOpe, notificarPatrulla) {
  //console.log(dataAlarma);
  encenderAlarmaCentral = 1;
  $("#infoUnidadSeleccionada").html("");

  $("#infoPeticionSeleccionada").html("");
  $("#infoDispositivoSeleccionado").html("");
  $("#infoUnidadSeleccionada").html("");
  $("#infoPatrullaSeleccionada").html("");
  $("#infoAsignadoSeleccionada").html("");

  //Se crea el marker del usuario
  if (peticion.latitud != '' && peticion.longitud != '') {
    // console.log(peticion.latitud);

    if (desplegarInfoPeticion) {
      var contentString = '';
      var contentDispositivoInfo = '';
      contentString += '<div class="divTable"><div class="divTableBody">';
      contentString += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Petici&oacute;n: </p>
        </div>
        <div class="divTableCell infPeti-value">
          ${peticion.idPeticion}
        </div>
      </div>`;
      contentString += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Usr. que solicita: </p>
        </div>
        <div class="divTableCell infPeti-value">
          ${peticion.nombreUsuario}
        </div>
      </div>`;

      var tipoBotonActivoPeticion = "---";
      if (peticion.tipoBoton == "Panico") {
        tipoBotonActivoPeticion
          = "P&aacute;nico"
      } else if (peticion.tipoBoton == "Llavero") {
        tipoBotonActivoPeticion
          = "Ll&aacute;vero"
      } else if (peticion.tipoBoton == "Silencioso") {
        tipoBotonActivoPeticion
          = "Silencioso"
      } else if (peticion.tipoBoton == "Camioneta") {
        tipoBotonActivoPeticion
          = "Shelly"
      }

      contentString += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Bot&oacute;n presionado: </p>
        </div>
        <div class="divTableCell infPeti-value">
          ${tipoBotonActivoPeticion}
        </div>
      </div>`;
      contentString += `<input type="hidden" name="usuarioId" id="usuarioId" value="${peticion.usuarioId}">`;
      contentString += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Tel&eacute;fono: </p>
        </div>
        <div class="divTableCell infPeti-value">
          ${peticion.telefono == null ? "Sin teléfono" : peticion.telefono}
        </div>
      </div>`;
      var calle = "";
      var numero = "";
      var colonia = "";
      var cp = "";
      var numComite = "";

      if (peticion.calle != null && peticion.calle != undefined && peticion.calle != "") {
        calle = peticion.calle;
      }
      if (peticion.numero != null && peticion.numero != undefined && peticion.numero != "") {
        numero = peticion.numero;
      }
      if (peticion.colonia != null && peticion.colonia != undefined && peticion.colonia != "") {
        colonia = peticion.colonia;
      }
      if (peticion.cp != null && peticion.cp != undefined && peticion.cp != "") {
        cp = peticion.cp;
      }
      if (peticion.nombreComite != null && peticion.nombreComite != undefined && peticion.nombreComite != "") {
        numComite = peticion.nombreComite;
      } else {
        numComite = '--';
      }
      contentString += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Direcci&oacute;n: </p>
        </div>
        <div class="divTableCell infPeti-value">
          ${calle} ${numero} ${colonia} ${cp}
        </div>
      </div>`;
      contentString += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Comit&eacute;: </p>
        </div>
        <div class="divTableCell infPeti-value">
          ${numComite}
        </div>
      </div>`;
      let usrComentarios = '--';
      if (peticion.comentarios !== undefined && peticion.comentarios !== "") {
        if (peticion.comentarios != null) {
          usrComentarios = peticion.comentarios;
        }
        contentString += `<div class="divTableRow">
          <div class="divTableCell infPeti-lbl">
            <p>Comentarios: </p>
          </div>
          <div class="divTableCell infPeti-value">
            ${usrComentarios} 
          </div>
        </div>`;
      }
      contentString += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>El usuario que está atendiendo la petición es : </p>
        </div>
        <div class="divTableCell infPeti-value">
          ${nombreOpe}
        </div>
      </div>`;

      contentString += '</div></div>';
      //contentString += '</div></div>';
      const permisosApp = JSON.parse(peticion.permissionsApp);
      
      contentDispositivoInfo += '<div class="divTable"><div class="divTableBody">';
      contentDispositivoInfo += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Permiso 1ER plano: </p>
        </div>
        <div class="divTableCell infPeti-value">`;
      permisosApp.geolocation_fine === true
        ? contentDispositivoInfo += 'Habilitado'
        : contentDispositivoInfo += '<span style="color: red">DESHABILITADO</span>';
      contentDispositivoInfo += `
        </div>
      </div>`;
      contentDispositivoInfo += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Permiso 2DO plano: </p>
        </div>
        <div class="divTableCell infPeti-value">`;
      permisosApp.geolocation_background === true
        ? contentDispositivoInfo += 'Habilitado'
        : contentDispositivoInfo += '<span style="color: red">DESHABILITADO</span>';
      contentDispositivoInfo += `
        </div>
      </div>`;
      contentDispositivoInfo += `<div class="divTableRow">
        <div class="divTableCell infPeti-lbl">
          <p>Estado de la app:</p>
        </div>
        <div class="divTableCell infPeti-value">`;
      permisosApp.fg === true
        ? contentDispositivoInfo += '<span id="estadoApp" data-estado="1">Abierta</span>'
        : contentDispositivoInfo += '<span id="estadoApp" data-estado="0">Minimizada o cerrada</span>';
      contentDispositivoInfo += `
        </div>
      </div>`;
      contentDispositivoInfo += '</div></div>';
      //contentString += (peticion.estatusId == 2 && peticion.nombreConductor != null) ? '<p>Nombre conductor asignado: <b>' + peticion.nombreConductor : '</b></p>';
      var contentBoton = '<div class="col-md-6"><a class="btn btn-primary finalizar" onclick="cancelarPeticion(' + peticion.usuarioTurnoId + ',' + asignado.idUserTurno + ',' + dataAsignado.idAsignacion + ',' + asignado.latitud + ',' + asignado.longitud + ',' + dataAlarma.vehiculoId + ')">Finalizar</a></div>';
      contentBoton += '<div class="col-md-6"><a class="btn btn-primary llamar" href="tel:' + peticion.telefono + '">Llamar</a>';

      infowindow2 = new google.maps.InfoWindow({
        content: contentString + contentBoton
      });
      // console.log("hola")


      if (!markerCiudadano || !markerCiudadano.getMap()) {
        // Si no existe o no está asignado a un mapa, crear el marcador
        markerCiudadano = new google.maps.Marker({
          map: map,
          draggable: false,
        });
      } else {
        // Si el marcador ya existe, asegúrate de que esté asociado al mapa actual
        markerCiudadano.setMap(map);
      }

      var url = (peticion.estatusId == 1 || peticion.estatusId == 5) ? '../images/user-icon-2.png' : '../images/user-icon.png';

      var icon = {
        url: url,
        scaledSize: new google.maps.Size(50, 50), // scaled size
        origin: new google.maps.Point(0, 0), // origin
        anchor: new google.maps.Point(0, 0)
      };

      changeMarkerPosition(markerCiudadano, parseFloat(peticion.latitud), parseFloat(peticion.longitud));
      markerCiudadano.setIcon(icon);

      markerCiudadano.addListener('click', function () {
        infowindow2.open(map, markerCiudadano);
      });

      // boton de finalizacion y desacionacion 


      var Infoboton = '<div class="col-md-6"><a class="btn btn-primary finalizar" onclick="cancelarPeticion(' + peticion.usuarioTurnoId + ',' + asignado.idUserTurno + ',' + dataAsignado.idAsignacion + ',' + asignado.latitud + ',' + asignado.longitud + ',' + dataAlarma.vehiculoId + ')">Finalizar</a></div>';
      Infoboton += '<div class="col-md-6"><a class="btn btn-primary llamar" href="tel:' + peticion.telefono + '">Llamar</a></div>';
      if (dataAsignado.asignacionAceptada == 1 || dataAsignado.asignacionAceptada == "1") {
        Infoboton += '<div class="col-md-6"><a class="btn btn-warning" onclick="desasignarUnidad(' + dataAsignado.idAsignacion + ',' + asignado.latitud + ',' + asignado.longitud + ')">Desasignar vehiculo</a></div>';
      }
      //markersInicio.push(markerUSR);
      $("#infoPeticionSeleccionada").html('<h4>Informaci&oacute;n petici&oacute;n</h4>' + contentString);
      $("#infoDispositivoSeleccionado").html('<h4>Informaci&oacute;n dispositivo</h4>' + contentDispositivoInfo);
      $("#infoBotones").html(Infoboton);
    }


    if (peticion.usuarioTurnoVehiculoId == 0 || peticion.usuarioTurnoVehiculoId == null) {
      //console.log("Sin patrulla asignada");
      //obtUnidadesCercanas(peticion, unidades);
      dibujarCirculos();
    } else if (peticion.estatusId == 2) {

      clearMarkers2();

      var contentString = '';
      var unidadAsign = "";
      var matriAsign = "";
      var NombreAsign = "";
      var calleP = "";
      var numeroP = "";
      var coloniaP = "";
      var cpP = "";
      var numComiteP = "";




      if (asignado.unidad != undefined && asignado.unidad != null) {
        unidadAsign = asignado.unidad;
        matriAsign = asignado.matricula;
        NombreAsign = asignado.conductor;
      } else {
        unidadAsign = "Sin asignaci&oacute;n";
      }

      contentString += '<p><b>Unidad: </b>' + unidadAsign + '</p>';
      contentString += '<p><b>Matricula: </b>' + matriAsign + '</p>';
      contentString += '<p><b>Nombre: </b>' + NombreAsign + '</p>';

      if (peticion.calle != null && peticion.calle != undefined && peticion.calle != "") {
        calleP = peticion.calle;
      }
      if (peticion.numero != null && peticion.numero != undefined && peticion.numero != "") {
        numeroP = peticion.numero;
      }
      if (peticion.colonia != null && peticion.colonia != undefined && peticion.colonia != "") {
        coloniaP = peticion.colonia;
      }
      if (peticion.cp != null && peticion.cp != undefined && peticion.cp != "") {
        cpP = peticion.cp;
      }
      if (peticion.nombreComite != null && peticion.nombreComite != undefined && peticion.nombreComite != "") {
        numComiteP = peticion.nombreComite;
      }

      var contentBoton = "";

      if (asignado.vehiculoId != undefined && asignado.vehiculoId != null && asignado.vehiculoId != "" && asignado.tipoVehiculoId == 4) {
        contentBoton += '<p><a class="btn btn-warning" onclick="encenderAlarma(' + asignado.vehiculoId + ',0, 1)" id="btnAlarmaApagar_' + asignado.vehiculoId + '">' +
          '<i class="fa fa-volume-off" aria-hidden="true"></i>&nbsp;Apagar</a>' +
          '&nbsp;&nbsp;<a class="btn btn-success" onclick="encenderAlarma(' + asignado.vehiculoId + ',1, 1)" id="btnAlarmaEncender_' + asignado.vehiculoId + '">' +
          '<i class="fa fa-volume" aria-hidden="true"></i>&nbsp;Encender</a>' +
          '</p>';
      }


      if (asignado.tipoVehiculoId < 4) {
        contentBoton += '<p><a class="btn btn-warning" onclick="desasignarUnidad(' + dataAsignado.idAsignacion + ',' + asignado.latitud + ',' + asignado.longitud + ')">Desasignar vehiculo</a></p>';
      }

      contentBoton += '<p><a target="_blank" class="btn btn-primary" href="https://maps.google.com/?q=' + peticion.latitud + ',' + peticion.longitud + '">Compartir coordenadas</a></p>';


      infowindowPatrulla = new google.maps.InfoWindow({
        content: contentString + contentBoton
      });

      switch (asignado.tipoVehiculoId) {
        case '3':
          var url = '../upload/iconos_tipovehiculo/ambulancia.png';
          break;
        case '2':
          var url = '../upload/iconos_tipovehiculo/bomberos.png';
          break;
        case '1':
          var url = '../upload/iconos_tipovehiculo/patrulla_ocupada.png';
          break;
        default:
          var url = '../upload/iconos_tipovehiculo/patrulla_ocupada.png';
          break;
      }

      if (dataAsignado.asignacionAceptada == 1 || dataAsignado.asignacionAceptada == "1") {
        console.log("holaaaaaaaaa");

        if (!markerPatrulla) {
            markerPatrulla = new google.maps.Marker({
                map: map,
                draggable: false,
            });
    
            // Establecer la posición y el ícono
            changeMarkerPosition(markerPatrulla, parseFloat(asignado.latitud), parseFloat(asignado.longitud));
            markerPatrulla.setIcon(url);
    
            markerPatrulla.addListener('click', function () {
                infowindowPatrulla.open(map, markerPatrulla);
            });
        }

      }

    }

    if (desplegarInfoPeticion) {
      let ALM_COMITE_ASIGNADA = '1';
      let ALM_PMI_ASIGNADA = '2';
      let ALM_COMITE_FUERA_RANGO = '3';
      let ALM_COMITE_OCUPADA = '4';
      var contentString = '';
      contentString += '<div class="divTable"><div class="divTableBody">';
      contentString += `<div class="divTableRow">
      <div class="divTableCell infPeti-lbl">
        Alarma:
      </div>
      <div class="divTableCell infPeti-value">
        ${((dataAlarma.unidad != undefined) ? dataAlarma.unidad : "Sin Asignaci&oacute;n")}
      </div>
    </div>`;
      // contentString += '<p><b>Alarma: </b>' + ((asignado.unidad != undefined) ? asignado.unidad : "Sin Asignaci&oacute;n") + '</p>';
      contentString += `<div class="divTableRow">
      <div class="divTableCell infPeti-lbl">
        E. Asignaci&oacute;n:
      </div>
      <div class="divTableCell infPeti-value">
        ${peticion.statusAsignacion}
      </div>
    </div>`;

      // contentString += "<p><b>Status Asignaci&oacute;n: </b>" + peticion.statusAsignacion + "</p>";
      switch (peticion.statusAsignacionId) {
        case ALM_COMITE_FUERA_RANGO:
          contentString += `<div class="divTableRow">
          <div class="divTableCell infPeti-lbl">
            Distancia:
          </div>
          <div class="divTableCell infPeti-value">
            No disponible
          </div>
        </div>`;
          break;

        case ALM_COMITE_OCUPADA:
          contentString += `<div class="divTableRow">
          <div class="divTableCell infPeti-lbl">
            Alm.Comit&eacute;:
          </div>
          <div class="divTableCell infPeti-value">
            ${almComite}
          </div>
        </div>`;
          break;

        case ALM_COMITE_ASIGNADA:
          contentString += `<div class="divTableRow">
          <div class="divTableCell infPeti-lbl">
            E. Comunicaci&oacute;n:
          </div>
          <div class="divTableCell infPeti-value">
            ${((peticion.statusComunicacion == null) ? "--" : peticion.statusComunicacion)}
          </div>
        </div>`;
          break;

        case ALM_PMI_ASIGNADA:
          contentString += `<div class="divTableRow">
          <div class="divTableCell infPeti-lbl">
            E. Comunicaci&oacute;n:
          </div>
          <div class="divTableCell infPeti-value">
            ${((peticion.statusComunicacion == null) ? "--" : peticion.statusComunicacion)}
          </div>
        </div>`;
          break;
      }
      contentString += '</div></div>';
      $("#infoUnidadSeleccionada").html('<h4>Informaci&oacute;n Alarma</h4>' + contentString);
    }

    // Mostar información de patrulla al aceptar peticion - MSA
    if (desplegarInfoPeticion) {
      if ((asignado.latitud == null && asignado.longitud == null) || (peticion.usuarioTurnoVehiculoId == 0)) {

        dibujarCirculos();
        if (desepintar == 1) {
          desepintar = 0
          directionsRenderer.setMap(null);
          clearMarkers2();
        }
      }
  
      // // console.log(asignado)
      // if ((asignado.latitud == null && asignado.longitud == null) || (peticion.usuarioTurnoVehiculoId == 0)) {

      //   dibujarCirculos();
      //   if (desepintar == 1) {
      //     desepintar = 0
      //     directionsRenderer.setMap(null);
      //     clearMarkers2();
      //   }

      //   var contentString = '';
      //   contentString += '<div class="divTable"><div class="divTableBody">';
      //   contentString += `<div class="divTableRow">
      //     <div class="divTableCell infPeti-lbl">
      //       Vehiculo no asignado: 
      //     </div>
      //     <div class="divTableCell infPeti-value">
      //       Esperando datos
      //     </div>
      //   </div>`;
      // } else {
      //   desepintar = 1
      //   var contentString = '';
      //   contentString += '<div class="divTable"><div class="divTableBody">';
      //   contentString += `<div class="divTableRow">
      //   <div class="divTableCell infPeti-lbl">
      //     Hora Asignacion: 
      //   </div>
      //   <div class="divTableCell infPeti-value">
      //     ${peticion.fechaAsignacion.substr(10, 14)}
      //   </div>
      // </div>`;
      //   contentString += `<div class="divTableRow">
      //   <div class="divTableCell infPeti-lbl">
      //     Nombre conductor: 
      //   </div>
      //   <div class="divTableCell infPeti-value">
      //     ${asignado.conductor}
      //   </div>
      // </div>`;
      //   contentString += `<div class="divTableRow">
      //   <div class="divTableCell infPeti-lbl">
      //     Matricula:
      //   </div>
      //   <div class="divTableCell infPeti-value">
      //     ${asignado.matricula}
      //   </div>
      // </div>`;
      //   contentString += `<div class="divTableRow">
      //   <div class="divTableCell infPeti-lbl">
      //     Unidad: 
      //   </div>
      //   <div class="divTableCell infPeti-value">
      //     ${asignado.unidad}
      //   </div>
      // </div>`;
      //   function DistanciaTiempoTraffico() {
      //     const punto_peticion = { lat: parseFloat(peticion.latitud), lng: parseFloat(peticion.longitud) }; //Ciudadano
      //     const punto_asignado = { lat: parseFloat(asignado.latitud), lng: parseFloat(asignado.longitud), }; //Patrulla
      //     directionsRenderer.setMap(map);
      //     const route = {
      //       origin: punto_peticion,
      //       destination: punto_asignado,
      //       travelMode: 'DRIVING' //Define vehicle - Default: Driving
      //     }
      //     directionsService.route(route,
      //       function (response, status) { // anonymous function to capture directions
      //         if (status !== 'OK') {
      //           console.log('Directions request failed due to ' + status);
      //           return;
      //         } else {
      //           directionsRenderer.setDirections(response); // Add route to the map
      //           directionsRenderer.setOptions({ suppressMarkers: true });
      //           var directionsData = response.routes[0].legs[0]; // Get data about the mapped route
      //           if (!directionsData) {
      //             console.log('Directions request failed');
      //             return;
      //           } else {
      //             //document.getElementById('msg_time').innerHTML += " Driving distance is " + directionsData.distance.text + " (" + directionsData.duration.text + ").";
      //             document.getElementById('msg_distance').innerHTML = directionsData.distance.text; //Print data of distance
      //             document.getElementById('msg_time').innerHTML = directionsData.duration.text; //Print data of time 
      //           }
      //         }
      //       }
      //     );
      //   }

      //   DistanciaTiempoTraffico();

      //   contentString += `<div class="divTableRow">
      //   <div class="divTableCell infPeti-lbl">
      //     Distancia aproximada: 
      //   </div>
      //   <div class="divTableCell infPeti-value">
      //     <p id="msg_distance"> </p>
      //   </div>
      // </div>`;
      //   contentString += `<div class="divTableRow">
      //   <div class="divTableCell infPeti-lbl">
      //     Tiempo de espera aproximado: 
      //   </div>
      //   <div class="divTableCell infPeti-value">
      //     <p id="msg_time"> </p>
      //   </div>
      // </div>`;
      // }
      // contentString += '</div></div>';
      // $("#infoPatrullaSeleccionada").html('<h4>Informaci&oacute;n Patrulla</h4>' + contentString);
    }
    // ------ Fin información patrulla 
    if (desplegarInfoPeticion) {
      // quitar comentario para los patrulleros 

      // if (dataAsignado.asignacionAceptada == 1 || dataAsignado.asignacionAceptada == "1") {
      //   pintarotravez = 1
      //   // Limpiar los marcadores existentes
      //   markersVehiculosPatrulleros.forEach((markerObj) => {
      //     // Eliminar marcador del mapa
      //     markerObj.marker.setMap(null);
      //   });

      //   if (markerAsignado) {
      //     markerAsignado.setMap(null); // Eliminar el marcador del mapa
      //     markerAsignado = null;       // Liberar la referencia
      //   }


      //   var contentString = '';

      //   if (dataAsignado.fechaHoraNotificacion != null) {

      //     contentString += '<div class="divTable"><div class="divTableBody">';
      //     contentString += `<div class="divTableRow">
      //       <div class="divTableCell infPeti-lbl">
      //         Hora Notificaci&oacute;n: 
      //       </div>
      //       <div class="divTableCell infPeti-value">
      //         ${dataAsignado.fechaHoraNotificacion.substr(10, 14)}
      //       </div>
      //     </div>`;

      //   }



      //   contentString += `<div class="divTableRow">
      //   <div class="divTableCell infPeti-lbl">
      //     Tipo de asignaci&oacute;n: 
      //   </div>
      //   <div class="divTableCell infPeti-value">
      //     ${dataAsignado.tipoAsignacion}
      //   </div>
      // </div>`;

      //   contentString += `<div class="divTableRow">
      //   <div class="divTableCell infPeti-lbl">
      //     Hora de respuesta a la notificaci&oacute;n:
      //   </div>
      //   <div class="divTableCell infPeti-value">
      //     ${dataAsignado.fechaHoraAceptacionNegacion.substr(10, 14)}
      //   </div>
      // </div>`;

      //   // Aquí añadimos el botón debajo de las filas
      //   let contentBoton = '';
      //   if (asignado.tipoVehiculoId < 4) {
      //     contentBoton = '<p><a class="btn btn-warning" onclick="desasignarUnidad(' + dataAsignado.idAsignacion + ',' + asignado.latitud + ',' + asignado.longitud + ')">Desasignar vehiculo</a></p>';
      //   }

      //   // Añadir el botón al final del contentString
      //   //contentString += contentBoton;



      // } else if (dataAsignado.asignacionAceptada == null || dataAsignado.asignacionAceptada == 'null') {
      //   if (markerPatrulla) {
      //     markerPatrulla.setMap(null); // Elimina el marcador del mapa
      //     markerPatrulla = null; // Asegúrate de que markerPatrulla se vuelve null después de eliminarlo
      // }
      //   pintarotravez = 1
      //   var contentString = '';
      //   contentString += '<div class="divTable"><div class="divTableBody">';
      //   contentString += `<div class="divTableRow">
      //     <div class="divTableCell infPeti-lbl">
      //       Unidad notificada: 
      //     </div>
      //     <div class="divTableCell infPeti-value">
      //       ${dataAsignado.unidad}
      //     </div>
      //   </div>`;
      //   contentString += `<div class="divTableRow">
      //     <div class="divTableCell infPeti-lbl">
      //       Noficaci&oacute;n enviada:
      //     </div>
      //     <div class="divTableCell infPeti-value">
      //     ${dataAsignado.fechaHoraNotificacion}
      //     </div>
      //   </div>`;

      //   // Crear o actualizar la ventana de información
      //   if (!infowindow) {
      //     infowindow = new google.maps.InfoWindow();
      //   }

      //   // Actualizar el contenido de la ventana de información

      //   console.log(dataAsignado)
      //   var ventanainfo = '<p><b>Patrulla Notificadad: </b>' + dataAsignado.unidad + '</p>';
      //   ventanainfo += '<p><b>Matricula: </b>' + dataAsignado.matricula + '</p>';
      //   ventanainfo += `<p><a target="_blank" class="btn btn-primary" href="https://maps.google.com/?q=${dataAsignado.latitud},${dataAsignado.longitud}">Compartir coordenadas del patrullero</a></p>`;

      //   infowindow.setContent(ventanainfo);

      //   // Icono personalizado
      //   var url = '../upload/iconos_tipovehiculo/patrulla_ocupada.png';
      //   var icon = {
      //     url: url,
      //     scaledSize: new google.maps.Size(32, 32), // scaled size
      //     origin: new google.maps.Point(0, 0), // origin
      //     anchor: new google.maps.Point(0, 0)  // anchor
      //   };

      //   // Crear o actualizar el marcador
      //   if (!markerAsignado) {
      //     // Si el marcador no existe, crear uno nuevo
      //     markerAsignado = new google.maps.Marker({
      //       map: map,
      //       draggable: false,
      //       position: {
      //         lat: parseFloat(dataAsignado.latitud),
      //         lng: parseFloat(dataAsignado.longitud)
      //       },
      //       icon: icon
      //     });

      //     // Agregar evento de clic al marcador
      //     markerAsignado.addListener('click', function () {
      //       infowindow.open(map, markerAsignado);
      //     });
      //   } else {
      //     // Si el marcador ya existe, actualizar su posición e icono
      //     markerAsignado.setPosition({
      //       lat: parseFloat(dataAsignado.latitud),
      //       lng: parseFloat(dataAsignado.longitud)
      //     });
      //     markerAsignado.setIcon(icon);
      //   }


      //   markersVehiculosPatrulleros.forEach(function (markerObj, index) {
      //     // Verificar si el marcador coincide
      //     if (markerObj.id == dataAsignado.idUsuarioTurno) {
      //       console.log("Eliminando marcador con ID:", markerObj.id);
      //       // Eliminar el marcador del mapa
      //       markerObj.marker.setMap(null);
      //       // Eliminar el marcador de la lista
      //       markersVehiculosPatrulleros.splice(index, 1);
      //     }
      //   });









      // } else {

      //   if (pintarotravez == 1) {
      //     pintarotravez = 0;
      //     if (markerAsignado) {
      //       markerAsignado.setMap(null); // Eliminar el marcador del mapa
      //       markerAsignado = null;       // Liberar la referencia
      //       clearMarkers2();
      //     }
      //     dibujarCirculos();
      //   }

      //   var contentString = '';
      //   contentString += '<div class="divTable"><div class="divTableBody">';
      //   contentString += `<div class="divTableRow">
      //     <div class="divTableCell infPeti-lbl">
      //       Vehiculo no asignado: 
      //     </div>
      //     <div class="divTableCell infPeti-value">
      //       Esperando datos holaaaaa
      //     </div>
      //   </div>`;
      // }
      // contentString += '</div></div>';


      // $("#infoAsignadoSeleccionada").html('<h4>Informaci&oacute;n Asignado</h4>' + contentString);

    }


  }
}

function actualizaPeticionVecinal(peticion, vehCercanos) {
  // console.log(peticion);
  // console.log(vehCercanos);
  // clearMarkers();
  var arrayVehiculosExcluidos = [];
  var arrayVehiculoUnicos = [];
  var arraAlarmasPrendidas = [];
  var arrayAlarmasExcluidos = [];
  $("#infoUnidadSeleccionada").html("");

  // 31/03/2020 JCS Enceder alarma del centro de mando
  if (encenderAlarmaCentral == 1) {
    encenderAlarmaCentral = 0;
    //console.log("Encender alarma central");
    // var nombreBoton = "btnAlarmaEncender_"+$("#alarmaCentroMandoId").val();
    // $("#"+nombreBoton).trigger("click");
    // $("#"+nombreBoton).click();
    //encenderAlarma($("#alarmaCentroMandoId").val(), 1, 0);
  }
  //console.log("continua...");


  // JAIR 30/03/2020
  //Dar clic a la peticion si no se le ha hecho clic antes
  if (vehCercanos.length == 0) {
    if (arrPeticionesClick.indexOf(peticion.idPeticion) == -1) {
      $("#cont_list_" + peticion.idPeticion).click();
      arrPeticionesClick.push(peticion.idPeticion);
    }

    //Enviamos datos de fault a asignarPatrullaTurno
    var params = {
      // funct: 'asignaPatrullaTurno',
      idTurno: 0,
      idPeticion: peticion.idPeticion,
      peticionAsignada: peticion.asignado
    };

    ajaxData(params, function (data) {
      if (data.success) {
        alertify.success("Petici&oacute;n asignada correctamente a la unidad seleccionada");
        verMarcadorMapa(peticion.latitud, peticion.longitud);
        seleccionarList(peticion.idPeticion, idOperador);
      } else {
        alertify.warning("No se ha asignado una unidad a la peticion");
      }
      //SE QUEDA ASI PARA DEMO   
      // console.log("Voy a tratar de encender la alarma comite");
      //RHS validar que no prenda otras alarmas cuando ya se hizo la solicitud
      if (peticion.asignado == 0) {
        //No encendemos alarma ya que no tenemos ninguna cerca
        //encenderAlarma(vehiculo.vehiculoId, 1); //JGP HACMEOS POR EMERGENCIA DE DEMO ENCEDIDO DE ALARMA (CORREGUIR CON CALMA)                        
      }


    });
  }


  //Se crea el marker del usuario
  // console.log("opc comite: "+peticion.opcComite);
  //JAIR 20/03/2020 OPCION PARA ASIGNAR LA ALARMA DEL COMITE
  if (peticion.opcComite == 1) {
    // console.log("Opcion de alarma del comite");
    //Si  la peticion no se ha asignado se muestran todas las unidades disponibles
    if (peticion.estatusId == 1 || peticion.estatusId == 5) {
      rechazo = 0;
      var rechazoRes = 0;
      vehCercanos.forEach(function (vehiculo) {
        // console.log(peticion.idComiteUsuario+" "+vehiculo.idComite);
        //JAIR 20/03/2020 VALIDAR QUE LA ALARMA SEA LA DEL COMITE DEL USUARIO
        if (peticion.idComiteUsuario == vehiculo.idComite) {
          // console.log(vehiculo);
          var noPrint = 0;
          var bandLocalizar = 0;
          if (vehiculo.idPeticion > 0) {
            if (vehiculo.idPeticion == peticion.idPeticion) {
              rechazoRes = 1;
              noPrint = 1;

            } else {
              // arrayVehiculosExcluidos.push(vehiculo.idUserTurno);
              if (arrayVehiculosExcluidos.includes(vehiculo.idUserTurno)) { /// si la unidad ya fue excluida se ignora
                rechazoRes = 1;
              } else {
                if (arrayVehiculoUnicos.includes(vehiculo.idUserTurno)) {
                  noPrint = 1;
                } else {
                  noPrint = 0;
                  arrayVehiculoUnicos.push(vehiculo.idUserTurno);
                }
                rechazoRes = 0;
              }

            }
          } else { /// es otra peticion
            if (arrayVehiculoUnicos.includes(vehiculo.idUserTurno)) {
              noPrint = 1;
            } else {
              noPrint = 0;
              arrayVehiculoUnicos.push(vehiculo.idUserTurno);
            }
            rechazoRes = 0;
          }


          if (noPrint == 0) {
            // console.log("Entramos al if del PRINT 0 comite");
            if (rechazoRes == 0) {
              if (rechazo == 0) {
                rechazo = 1;
                bandLocalizar = 1;
                var url = '../upload/iconos_tipovehiculo/ubicacion-patrulla.png';
              } else {
                var url = '../upload/iconos_tipovehiculo/patrulla.png';
              }
            } else {
              var url = '../upload/iconos_tipovehiculo/patrulla.png';
            }

            if (vehiculo.tipoVehiculoId == 4) {
              if (vehiculo.activoV == 0) {
                var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
              } else if (vehiculo.estatusAlarma == 1) {
                var url = '../upload/iconos_tipovehiculo/alarma.png';
                var accionBtnAlarma = 'Encender';
                if (bandLocalizarAlarma == 0) {
                  if (arraAlarmasPrendidas.length == 0) { /// si la alarma ya esta prendida  se ignora
                    bandLocalizarAlarma = 1;
                    /// se enciende la alarma
                    //RHS validar que no prenda otras alarmas cuando ya se hizo la solicitud
                    if (peticion.asignado == 0) {
                      encenderAlarma(vehiculo.vehiculoId, 1);
                    }

                  }

                }
              } else {
                var url = '../upload/iconos_tipovehiculo/alarma_e.png';
                var accionBtnAlarma = 'Apagar';
              }
            }

            //  if (bandLocalizar==1) {
            var contentString = '';
            if (vehiculo.tipoVehiculoId != 4) {
              contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
              contentString += '<p><b>Conductor: </b>' + vehiculo.conductor + '</p>';
              contentString += '<p><a class="btn btn-primary" onclick="asignarUnidad(' + vehiculo.idUserTurno + ')">Asignar</a></p>'
            } else {
              // console.log("ALARMA");
              // console.log(vehiculo);
              contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
              contentString += '<p><a class="btn btn-warning" onclick="encenderAlarma(' + vehiculo.vehiculoId + ',0, 1)" id="btnAlarmaApagar_' + vehiculo.vehiculoId + '"><i class="fa fa-volume-off" aria-hidden="true"></i>&nbsp;Apagar</a>' +
                '&nbsp;&nbsp;<a class="btn btn-success" onclick="encenderAlarma(' + vehiculo.vehiculoId + ',1, 1)" id="btnAlarmaEncender_' + vehiculo.vehiculoId + '"><i class="fa fa-volume" aria-hidden="true"></i>&nbsp;Encender</a>' +
                '</p>';

            }

            infowindowNuevoAsignado = new google.maps.InfoWindow({
              content: contentString
            });

            var animacion = "";
            if (bandLocalizar == 1 && vehiculo.tipoVehiculoId != 4) {
              animacion = google.maps.Animation.BOUNCE;
            }

            /*var markerUN = new google.maps.Marker({
              map: map,
              draggable: false,
              // animation: google.maps.Animation.DROP,
              position: {
                lat: parseFloat(vehiculo.latitud),
                lng: parseFloat(vehiculo.longitud)
              },
              icon: {
                url: url
              },
              animation: animacion,
            });*/

            /*changeMarkerPosition(markerNuevoAsignado, parseFloat(vehiculo.latitud), parseFloat(vehiculo.longitud));
            markerNuevoAsignado.setIcon(url);
            markerNuevoAsignado.setAnimation(google.maps.Animation.DROP);

            markerNuevoAsignado.addListener('click', function () {
              infowindowNuevoAsignado.open(map, markerNuevoAsignado);
            });*/
            //markersInicio.push(markerUN);
            if (bandLocalizar == 1) {
              // console.log("1 Ver u comite");
              contentCercana = '<div class="col-md-6"><a class="btn btn-primary" onclick="verMarcadorMapa(' + vehiculo.latitud + ',' + vehiculo.longitud + ')">Unidad mas cercana</a></div>';
              $("#infoBotones").append(contentCercana);
              // asignar de forma automatica a la patrulla
              var params = {
                //funct: 'asignaPatrullaTurno',
                idTurno: vehiculo.idUserTurno,
                idPeticion: peticion.idPeticion,
                peticionAsignada: peticion.asignado
              };
              ajaxData(params, function (data) {
                if (data.success) {
                  alertify.success("Petici&oacute;n asignada correctamente a la unidad seleccionada");
                  verMarcadorMapa(peticion.latitud, peticion.longitud);
                  seleccionarList(peticion.idPeticion, idOperador);
                } else {
                  alertify.warning("No se ha podido asignar a la unidad seleccionada");
                }
                //SE QUEDA ASI PARA DEMO   
                // console.log("Voy a tratar de encender la alarma comite");
                //RHS validar que no prenda otras alarmas cuando ya se hizo la solicitud
                if (peticion.asignado == 0) {
                  encenderAlarma(vehiculo.vehiculoId, 1); //JGP HACMEOS POR EMERGENCIA DE DEMO ENCEDIDO DE ALARMA (CORREGUIR CON CALMA)                        
                }


              });
            }
          }

        } //fin si el vehiculo tiene el mismo comite que el usuario de la peticion

      });

    }
  } else {
    //OPCION ORIGINAL PARA ASIGNAR CUALQUIER ALARMA
    // console.log(vehCercanos);
    var bandLocalizarAlarma = 0;

    vehCercanos.forEach(function (vehiculo) {

      // console.log(vehiculo);
      if (vehiculo.tipoVehiculoId == 4 && vehiculo.estatusAlarma == 2) {
        arraAlarmasPrendidas.push(vehiculo.idUserTurno);
      }
      if (vehiculo.idPeticion == peticion.idPeticion) {
        arrayVehiculosExcluidos.push(vehiculo.idUserTurno);
      }

      //JAIR 17/04/2020 
      //Excluir alarmar si es solo comite
      if (vehiculo.soloComite == 1) {
        //Se escluyo por solo comite
        arrayAlarmasExcluidos.push(vehiculo.idUserTurno);
      }
    });

    //Si  la peticion no se ha asignado se muestran todas las unidades disponibles
    if (peticion.estatusId == 1 || peticion.estatusId == 5) {
      rechazo = 0;
      var rechazoRes = 0;
      vehCercanos.forEach(function (vehiculo) {
        // console.log(vehiculo);
        var noPrint = 0;
        var bandLocalizar = 0;
        if (vehiculo.idPeticion > 0) {
          if (vehiculo.idPeticion == peticion.idPeticion) {
            rechazoRes = 1;
            noPrint = 1;
          } else {
            // arrayVehiculosExcluidos.push(vehiculo.idUserTurno);
            if (arrayVehiculosExcluidos.includes(vehiculo.idUserTurno)) { /// si la unidad ya fue excluida se ignora
              rechazoRes = 1;
            } else {
              if (arrayVehiculoUnicos.includes(vehiculo.idUserTurno)) {
                noPrint = 1;
              } else {
                noPrint = 0;
                arrayVehiculoUnicos.push(vehiculo.idUserTurno);
              }
              rechazoRes = 0;
            }

          }
        } else { /// es otra peticion
          if (arrayVehiculoUnicos.includes(vehiculo.idUserTurno)) {
            noPrint = 1;
          } else {
            noPrint = 0;
            arrayVehiculoUnicos.push(vehiculo.idUserTurno);
          }
          if (arrayAlarmasExcluidos.includes(vehiculo.idUserTurno)) {
            rechazoRes = 1;
          } else {
            rechazoRes = 0;
          }
        }
        if (noPrint == 0) {
          // console.log("Entramos al if del PRINT 0")
          if (rechazoRes == 0) {
            if (rechazo == 0) {
              rechazo = 1;
              bandLocalizar = 1;
              var url = '../upload/iconos_tipovehiculo/ubicacion-patrulla.png';
            } else {
              var url = '../upload/iconos_tipovehiculo/patrulla.png';
            }
          } else {
            var url = '../upload/iconos_tipovehiculo/patrulla.png';
          }

          if (vehiculo.tipoVehiculoId == 4) {
            if (vehiculo.activoV == 0) {
              var url = '../upload/iconos_tipovehiculo/alarma_desconectada.png';
            } else if (vehiculo.estatusAlarma == 1) {
              var url = '../upload/iconos_tipovehiculo/alarma.png';
              var accionBtnAlarma = 'Encender';
              if (bandLocalizarAlarma == 0) {
                if (arraAlarmasPrendidas.length == 0) { /// si la alarma ya esta prendida  se ignora
                  bandLocalizarAlarma = 1;
                  /// se enciende la alarma
                  //encenderAlarma(vehiculo.vehiculoId, 1);//JAIR COMENTADO 20/04/2020
                }

              }
            } else {
              var url = '../upload/iconos_tipovehiculo/alarma_e.png';
              var accionBtnAlarma = 'Apagar';
            }
          }

          //  if (bandLocalizar==1) {
          var contentString = '';
          if (vehiculo.tipoVehiculoId != 4) {
            contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
            contentString += '<p><b>Conductor: </b>' + vehiculo.conductor + '</p>';
            contentString += '<p><a class="btn btn-primary" onclick="asignarUnidad(' + vehiculo.idUserTurno + ')">Asignar</a></p>'
          } else {
            // console.log("ALARMA");
            // console.log(vehiculo);
            contentString += '<p><b>Alarma: </b>' + vehiculo.unidad + '</p>';
            contentString += '<p><a class="btn btn-warning" onclick="encenderAlarma(' + vehiculo.vehiculoId + ',0, 1)" id="btnAlarmaApagar_' + vehiculo.vehiculoId + '"><i class="fa fa-volume-off" aria-hidden="true"></i>&nbsp;Apagar</a>' +
              '&nbsp;&nbsp;<a class="btn btn-success" onclick="encenderAlarma(' + vehiculo.vehiculoId + ',1, 1)" id="btnAlarmaEncender_' + vehiculo.vehiculoId + '"><i class="fa fa-volume" aria-hidden="true"></i>&nbsp;Encender</a>' +
              '</p>';

          }

          infowindowNuevoAsignado = new google.maps.InfoWindow({
            content: contentString
          });

          var animacion = "";
          if (bandLocalizar == 1 && vehiculo.tipoVehiculoId != 4) {
            animacion = google.maps.Animation.BOUNCE;
          }

          /*var markerUN = new google.maps.Marker({
            map: map,
            draggable: false,
            // animation: google.maps.Animation.DROP,
            position: {
              lat: parseFloat(vehiculo.latitud),
              lng: parseFloat(vehiculo.longitud)
            },
            icon: {
              url: url
            },
            animation: animacion,
          });*/

          //dibujarCirculos();
          /*changeMarkerPosition(markerNuevoAsignado, parseFloat(vehiculo.latitud), parseFloat(vehiculo.longitud));
          markerNuevoAsignado.setIcon(url);
          markerNuevoAsignado.setAnimation(google.maps.Animation.DROP);
        
          markerNuevoAsignado.addListener('click', function () {
            infowindowNuevoAsignado.open(map, markerNuevoAsignado);
          });*/
          //markersInicio.push(markerUN);
          if (bandLocalizar == 1) {
            // console.log("1 Ver u");
            contentCercana = '<div class="col-md-6"><a class="btn btn-primary" onclick="verMarcadorMapa(' + vehiculo.latitud + ',' + vehiculo.longitud + ')">Unidad mas cercana</a></div>';
            $("#infoBotones").append(contentCercana);
            // asignar de forma automatica a la patrulla
            var params = {
              //  funct: 'asignaPatrullaTurno',
              idTurno: vehiculo.idUserTurno,
              idPeticion: peticion.idPeticion,
              peticionAsignada: peticion.asignado
            };
            ajaxData(params, function (data) {
              if (data.success) {
                alertify.success("Petici&oacute;n asignada correctamente a la unidad seleccionada");
                verMarcadorMapa(peticion.latitud, peticion.longitud);
                seleccionarList(peticion.idPeticion, idOperador);
              } else {
                alertify.warning("No se ha podido asignar a la unidad seleccionada");
              }
              //SE QUEDA ASI PARA DEMO   
              // console.log("Voy a tratar de encender la alarma");
              //RHS validar que no prenda otras alarmas cuando ya se hizo la solicitud
              if (peticion.asignado == 0) {
                encenderAlarma(vehiculo.vehiculoId, 1); //JGP HACMEOS POR EMERGENCIA DE DEMO ENCEDIDO DE ALARMA (CORREGUIR CON CALMA)                        
              }
            });
          }
        }
      });
    }
  }
}

function clearMarkers() {
  /*if (markersVehiculos.length > 0) {
    if (typeof directionsDisplayPeticion !== "undefined") {
      directionsDisplayPeticion.setMap(null);
    }
    markersVehiculos.forEach(function (markerObj) {
      markerObj.marker.setMap(null);
    });
  }*/

  /*if (markersCircles.length > 0) {
    markersCircles.forEach(function (markerObj) {
      markerObj.marker.setMap(null);
    });
  }*/

  if (markersPeticiones.length > 0) {
    markersPeticiones.forEach(function (markerObj) {
      markerObj.marker.setMap(null);
    });
  }

  if (markersCercanos.length > 0) {
    markersCercanos.forEach(function (markerObj) {
      markerObj.marker.setMap(null);
    });
  }

  if (markersInicio.length > 0) {
    markersInicio.forEach(function (markerObj) {
      markerObj.setMap(null);
    });
  }

  if (typeof markerUSR !== "undefined") {
    markerUSR.setMap(null);
    markerUSR = undefined;
  }

  if (typeof markerUNIDAD1 !== "undefined") {
    markerUNIDAD1.setMap(null);
  }

  markersPeticiones = [];
  markersCercanos = [];
  markersInicio = [];

  if (typeof directionsDisplayPeticion !== "undefined") {
    directionsDisplayPeticion.setMap(null);
  }
}

function clearMarkers2() {
  // Limpiar marcadores de vehículos
  if (markersVehiculos.length > 0) {
    if (typeof directionsDisplayPeticion !== "undefined") {
      directionsDisplayPeticion.setMap(null);
    }
    markersVehiculos.forEach(function (markerObj) {
      if (markerObj.marker) {  // Verificar si marker existe
        markerObj.marker.setMap(null);
      }
    });
  }

  // Limpiar círculos
  if (markersCircles.length > 0) {
    markersCircles.forEach(function (markerObj) {
      if (markerObj.marker) {  // Verificar si marker existe
        markerObj.marker.setMap(null);
      }
    });
  }

  // Limpiar marcadores de patrulleros
  if (Object.keys(MarcadoresPatrulleros).length > 0) {
    for (var id in MarcadoresPatrulleros) {
      var marcador = MarcadoresPatrulleros[id];
      if (marcador) {  // Verificar si el marcador existe
        marcador.setMap(null);
      }
    }
  }

  // Limpiar las listas de marcadores
  markersVehiculos = [];
  markersCircles = [];
  MarcadoresPatrulleros = [];
}

//llamada a ajaxFunctions.php para checar estatus del shelly
function demoChecarShelly() {
  //Checar shelly prendido demo 
  var params = {
    funct: 'checarshellydemo',
    idAlarma: 88, // CAMBIAR ID PARA PREDETERMINAR SHELLY
  };

  ajaxData(params, function (data) {
    if (data.success) {
      if (data.encendido === 1) {
        console.log("activar peticion")
      } else if (data.encendido === 0) {
        console.log("sin peticion")
      }
    } else {
      console.log("Peticion activa: " + data.peticionActiva)
    }
  });
}


// Mapa de Patrulleros 
// Variables globales
var mapaPatrulleros;
var MarcadoresPatrulleros = [];  // Ahora usamos un objeto para almacenar los marcadores con sus IDs

function initializeMapaPatrulleros() {
  mapaPatrulleros = 'mapaPatrulleros';
  $('#mapaPatrulleros').empty();

  if ("geolocation" in navigator) {
    navigator.geolocation.getCurrentPosition(function (position) {
      var options = {
        zoom: 15,
        center: {
          lat: position.coords.latitude,
          lng: position.coords.longitude
        },
        mapTypeId: "roadmap",
        mapTypeControl: true,
        gestureHandling: 'greedy',
      };
      mapaPatrullero = new google.maps.Map(document.getElementById(mapaPatrulleros), options);
    });
  } else {
    alertify.warning("Es necesario permitir la detección de ubicación en su navegador.");
  }
}

// Función para obtener los patrulleros con sus datos y ubicaciones
function GetPatrulleros() {
  var params = {
    funct: "obtenerPatrulleros",
  };

  ajaxData(params, function (data) {
    if (data.success) {
      actualizarMapaPatrulleros(data.veiculos);
    }
  });
}

// Función para actualizar los patrulleros en el mapa

function actualizarMapaPatrulleros(vehiculos) {
  vehiculos.forEach(patrullero => {
    var idVehiculo = patrullero.idVehiculo;
    var lat = parseFloat(patrullero.latitud);
    var lng = parseFloat(patrullero.longitud);

    if (MarcadoresPatrulleros[idVehiculo]) {
      console.log(patrullero);
      // Si el marcador ya existe, solo actualizamos su posición si ha cambiado
      var marcadorExistente = MarcadoresPatrulleros[idVehiculo];
      var posicionActual = marcadorExistente.getPosition();

      if (posicionActual.lat() !== lat || posicionActual.lng() !== lng) {
        marcadorExistente.setPosition({ lat: lat, lng: lng });
      }

      // Cambiar el icono según el estado del vehículo
      var url = '';
      if (patrullero.estatusId == 2) {
        // Mantener el icono normal
        url = '../upload/iconos_tipovehiculo/patrulla.png';
      } else if (patrullero.estatusId == 1 && patrullero.estatusAlarma == 1) {
        // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
        url = '../upload/iconos_tipovehiculo/patrulla_libre.png';
      } else if (patrullero.estatusId == 1 && patrullero.estatusAlarma == 2) {
        // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
        url = '../upload/iconos_tipovehiculo/patrulla_ocupada.png';
      }

      marcadorExistente.setIcon(url);


    } else {
      // Si el marcador no existe, lo creamos
      var marcador = new google.maps.Marker({
        position: { lat: lat, lng: lng },
        map: mapaPatrullero,
        title: `Unidad: ${patrullero.unidad} - Matrícula: ${patrullero.matricula}`,
        id: idVehiculo  // Asignar ID del marcador
      });

      // Cambiar el icono al crear el marcador
      var url = '';
      if (patrullero.estatusId == 2) {
        // Mantener el icono normal
        url = '../upload/iconos_tipovehiculo/patrulla.png';
      } else if (patrullero.estatusId == 1 && patrullero.estatusAlarma == 1) {
        // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
        url = '../upload/iconos_tipovehiculo/patrulla_libre.png';
      } else if (patrullero.estatusId == 1 && patrullero.estatusAlarma == 2) {
        // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
        url = '../upload/iconos_tipovehiculo/patrulla_ocupada.png';
      }
      // Cambiar el icono a 'patrulla_disponible.png' si el patrullero está vinculado
      if (patrullero.nombre && patrullero.nombre !== 'No vinculado a un patrullero') {
        url = '../images/patrulla_disponible.png';
      }
      marcador.setIcon(url);

      // Definir el contenido del InfoWindow
      var contentString = `
        <div>
          <p>Unidad: ${patrullero.unidad}</p>
          <p>Matrícula: ${patrullero.matricula}</p>
          <p>Nombre del patrullero: ${patrullero.nombre || 'No vinculado a un patrullero'}</p>
        </div>
      `;
      var contentBoton = "";  // Si tienes botones o más contenido adicional

      // Crear InfoWindow con el contenido
      var infowindowPatrulla = new google.maps.InfoWindow({
        content: contentString + contentBoton
      });

      // Añadir evento 'click' para abrir el InfoWindow cuando se haga clic en el marcador
      marcador.addListener('click', function () {
        infowindowPatrulla.open(mapaPatrullero, marcador);
      });

      // Guardamos el marcador en la lista global
      MarcadoresPatrulleros[idVehiculo] = marcador;
    }
  });

  // Eliminar los marcadores que ya no están en la lista de vehículos actual
  for (var id in MarcadoresPatrulleros) {
    if (!vehiculos.find(patrullero => patrullero.idVehiculo === id)) {
      MarcadoresPatrulleros[id].setMap(null);  // Eliminar del mapa
      delete MarcadoresPatrulleros[id];  // Eliminar del objeto
    }
  }
}



//---------------------------------JBJF

//Funcion del boton  muestra iconos de vehiculos
function GetPatrulleros2() {
  var params = {
    funct: "obtenerPatrulleros",
  };

  ajaxData(params, function (data) {
    if (data.success) {
      actualizarMapaPatrulleros2(data.veiculos);
    }
  });
}

function actualizarMapaPatrulleros2(vehiculos) {
  vehiculos.forEach(patrullero => {

    var idVehiculo = patrullero.idVehiculo;
    var lat = parseFloat(patrullero.latitud);
    var lng = parseFloat(patrullero.longitud);

    if (MarcadoresPatrulleros[idVehiculo]) {
      // Si el marcador ya existe, solo actualizamos su posición si ha cambiado
      var marcadorExistente = MarcadoresPatrulleros[idVehiculo];
      var posicionActual = marcadorExistente.getPosition();

      if (posicionActual.lat() !== lat || posicionActual.lng() !== lng) {
        marcadorExistente.setPosition({ lat: lat, lng: lng });
      }

      // Cambiar el icono según el estado del vehículo
      var url = '';
      if (patrullero.estatusId == 2) {
        // Mantener el icono normal
        url = '../upload/iconos_tipovehiculo/patrulla.png';
      } else if (patrullero.estatusId == 1 && patrullero.estatusAlarma == 1) {
        // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
        url = '../upload/iconos_tipovehiculo/patrulla_libre.png';
      } else if (patrullero.estatusId == 1 && patrullero.estatusAlarma == 2) {
        // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
        url = '../upload/iconos_tipovehiculo/patrulla_ocupada.png';
      }

      marcadorExistente.setIcon(url);

    } else {
      // Si el marcador no existe, lo creamos
      var marcador = new google.maps.Marker({
        position: { lat: lat, lng: lng },
        map: map,
        title: `Unidad: ${patrullero.unidad} - Matrícula: ${patrullero.matricula}`,
        id: idVehiculo  // Asignar ID del marcador
      });

      // Cambiar el icono al crear el marcador
      var url = '';
      if (patrullero.estatusId == 2) {
        // Mantener el icono normal
        url = '../upload/iconos_tipovehiculo/patrulla.png';
      } else if (patrullero.estatusId == 1 && patrullero.estatusAlarma == 1) {
        // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
        url = '../upload/iconos_tipovehiculo/patrulla_libre.png';
      } else if (patrullero.estatusId == 1 && patrullero.estatusAlarma == 2) {
        // Cambiar el icono a 'patrulla_libre.png' si el estado es 1 y estatusAlarma es 1
        url = '../upload/iconos_tipovehiculo/patrulla_ocupada.png';
      }
      // Cambiar el icono a 'patrulla_disponible.png' si el patrullero está vinculado
      if (patrullero.nombre && patrullero.nombre !== 'No vinculado a un patrullero') {
        url = '../upload/iconos_tipovehiculo/patrulla.png';
      }
      marcador.setIcon(url);

      // Definir el contenido del InfoWindow
      var contentString = `
        <div>
          <p>Unidad: ${patrullero.unidad}</p>
          <p>Matrícula: ${patrullero.matricula}</p>
          <p>Nombre del patrullero: ${patrullero.nombre || 'No vinculado a un patrullero'}</p>
        </div>
      `;
      var contentBoton = "";  // Si tienes botones o más contenido adicional

      // Crear InfoWindow con el contenido
      var infowindowPatrulla = new google.maps.InfoWindow({
        content: contentString + contentBoton
      });

      // Añadir evento 'click' para abrir el InfoWindow cuando se haga clic en el marcador
      marcador.addListener('click', function () {
        infowindowPatrulla.open(map, marcador);
      });

      // Guardamos el marcador en la lista global
      MarcadoresPatrulleros[idVehiculo] = marcador;
    }
  });

  // Eliminar los marcadores que ya no están en la lista de vehículos actual
  for (var id in MarcadoresPatrulleros) {
    if (!vehiculos.find(patrullero => patrullero.idVehiculo === id)) {
      MarcadoresPatrulleros[id].setMap(null);  // Eliminar del mapa
      delete MarcadoresPatrulleros[id];  // Eliminar del objeto
    }
  }
}

