-- Jair
-- 3/04/2019

CREATE TABLE IF NOT EXISTS `cat_tipo_vehiculos` (
  `idTipoVehiculo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(200) DEFAULT NULL,
  `activo` int(1) DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  `usuarioRegistroId` int DEFAULT NULL,
  `fechaActualizacion` datetime DEFAULT NULL,
  `usuarioActualizacionId` int DEFAULT NULL,
  PRIMARY KEY (`idTipoVehiculo`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;



CREATE TABLE IF NOT EXISTS `cat_equipamientos` (
  `idEquipo` int(11) NOT NULL AUTO_INCREMENT,
  `tipoVehiculoId` int DEFAULT NULL,
  `nombre` varchar(200) DEFAULT NULL,
  `cantidad` int DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  `usuarioRegistroId` int DEFAULT NULL,
  `fechaActualizacion` datetime DEFAULT NULL,
  `usuarioActualizacionId` int DEFAULT NULL,
  PRIMARY KEY (`idEquipo`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;

ALTER TABLE `cat_estatus` ADD `familiaId` INT(1) NULL DEFAULT NULL AFTER `idEstatus`;
ALTER TABLE `cat_estatus` ADD `usuarioRegistraId` INT NULL DEFAULT NULL AFTER `fechaCreacion`;


CREATE TABLE IF NOT EXISTS `cat_tipos_usuario` (
  `idTipoUsuario` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(200) DEFAULT NULL,
  `activo` int(1) DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  `usuarioRegistroId` int DEFAULT NULL,
  `fechaActualizacion` datetime DEFAULT NULL,
  `usuarioActualizacionId` int DEFAULT NULL,
  PRIMARY KEY (`idTipoUsuario`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;

CREATE TABLE IF NOT EXISTS `cat_turnos` (
  `idTurno` int(11) NOT NULL AUTO_INCREMENT,
  `tipoVehiculoId` int DEFAULT NULL,
  `nombre` varchar(200) DEFAULT NULL,
  `activo` int(1) DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  `usuarioRegistroId` int DEFAULT NULL,
  `fechaActualizacion` datetime DEFAULT NULL,
  `usuarioActualizacionId` int DEFAULT NULL,
  PRIMARY KEY (`idTurno`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;



CREATE TABLE IF NOT EXISTS `cat_tipo_peticiones` (
  `idTipoPeticion` int(11) NOT NULL AUTO_INCREMENT,
  `tipoVehiculoId` int DEFAULT NULL,
  `nombre` varchar(200) DEFAULT NULL,
  `activo` int(1) DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  `usuarioRegistroId` int DEFAULT NULL,
  `fechaActualizacion` datetime DEFAULT NULL,
  `usuarioActualizacionId` int DEFAULT NULL,
  PRIMARY KEY (`idTipoPeticion`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;

CREATE TABLE IF NOT EXISTS `vehiculos` (
  `idVehiculo` int(11) NOT NULL AUTO_INCREMENT,
  `tipoVehiculoId` int DEFAULT NULL,
  `idsEquipamiento` varchar(200) DEFAULT NULL,
  `matricula` varchar(200) DEFAULT NULL,
  `unidad` varchar(200) DEFAULT NULL,
  `activo` int(1) DEFAULT NULL,
  `estatusId` int(1) DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  `usuarioRegistroId` int DEFAULT NULL,
  `fechaActualizacion` datetime DEFAULT NULL,
  `usuarioActualizacionId` int DEFAULT NULL,
 	 PRIMARY KEY (`idVehiculo`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;

CREATE TABLE IF NOT EXISTS `coordenadas_vehiculo` (
  `idCoordenadas` int(11) NOT NULL AUTO_INCREMENT,
  `vehiculoId` int DEFAULT NULL,
  `registroId` int DEFAULT NULL,
  `latitud` varchar(200) DEFAULT NULL,
  `longitud` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`idCoordenadas`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;



CREATE TABLE IF NOT EXISTS `usuario_vehiculo` (
  `idUsuarioVehiculo` int(11) NOT NULL AUTO_INCREMENT,
  `usuarioId` int DEFAULT NULL,
  `nombre` varchar(200) DEFAULT NULL,
  `aPaterno` varchar(200) DEFAULT NULL,
  `aMaterno` varchar(200) DEFAULT NULL,
  `identificador` varchar(200) DEFAULT NULL,
  `telefono` varchar(200) DEFAULT NULL,
  `activo` int(1) DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  `usuarioRegistroId` int DEFAULT NULL,
  `fechaActualizacion` datetime DEFAULT NULL,
  `usuarioActualizacionId` int DEFAULT NULL,
  PRIMARY KEY (`idUsuarioVehiculo`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;

CREATE TABLE IF NOT EXISTS `usuarios_turno` (
  `idUserTurno` int(11) NOT NULL AUTO_INCREMENT,
  `usuarioVehiculoId` int DEFAULT NULL,
  `turnoId` int DEFAULT NULL,
  `vehiculoId` int DEFAULT NULL,
  `horaInicio` datetime DEFAULT NULL COMMENT 'hora de inicio del turno',
  `horaFin` datetime DEFAULT NULL COMMENT 'hora de fin del turno',
  `fechaInicio` datetime DEFAULT NULL COMMENT 'fecha y hora real del inicio del turno',
  `fechaFin` datetime DEFAULT NULL COMMENT 'fecha y hora real del fin del turno',
  `activo` int(1) DEFAULT NULL,
  PRIMARY KEY (`idUserTurno`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;

CREATE TABLE IF NOT EXISTS `historico_usuarios_turno` (
  `idHistoricoUT` int(11) NOT NULL AUTO_INCREMENT,
  `jsonUserTurn` text DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  PRIMARY KEY (`idHistoricoUT`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;


CREATE TABLE IF NOT EXISTS `peticiones` (
  `idPeticion` int(11) NOT NULL AUTO_INCREMENT,
  `tipoPeticionId` int DEFAULT NULL,
  `usuarioId` int DEFAULT NULL,
  `registroId` int DEFAULT NULL,
  `usuarioTurnoId` int DEFAULT NULL,
  `nombre` varchar(200) DEFAULT NULL,
  `fechaCreacion` datetime DEFAULT NULL,
  `usuarioOperadorId` int DEFAULT NULL,
  `fechaAsignacion` datetime DEFAULT NULL COMMENT 'fecha en que el operador asigno un vehiculo a la peticion',
  `fechaFinalizacion` datetime DEFAULT NULL,
  `coordenadasInicio` text DEFAULT NULL,
  `coordenadasFin` text DEFAULT NULL,
  `estatusId` int DEFAULT NULL,
  `activo` int(1) DEFAULT NULL,
  PRIMARY KEY (`idPeticion`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;


CREATE TABLE IF NOT EXISTS `peticion_coordenadas` (
  `idCoordenadasPet` int(11) NOT NULL AUTO_INCREMENT,
  `latitud` text DEFAULT NULL,
  `longitud` text DEFAULT NULL,
  `peticionId` int DEFAULT NULL,
  `registroId` int DEFAULT NULL,
  PRIMARY KEY (`idCoordenadasPet`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;




-- 5/04/2019
-- Jair
ALTER TABLE `coordenadas_vehiculo` CHANGE `latitud` `latitud` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;
ALTER TABLE `coordenadas_vehiculo` CHANGE `longitud` `longitud` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;

-- 05/04/2019
--Miguel
ALTER TABLE `peticion_coordenadas` ADD `usuarioId` INT(11) NULL AFTER `peticionId`;

-- 08/04/2019
--Miguel
ALTER TABLE `cat_estatus` ADD `numero` INT(11) NULL DEFAULT NULL AFTER `idEstatus`;


-- 19/09/2019
--Carlos
ALTER TABLE `cat_tipo_vehiculos` ADD `imagen` VARCHAR(200) NULL COMMENT 'Imagen del vehiculo' AFTER `activo`;
INSERT INTO `cat_tipo_vehiculos` (`idTipoVehiculo`, `nombre`, `activo`, `imagen`, `fechaCreacion`, `usuarioRegistroId`, `fechaActualizacion`, `usuarioActualizacionId`) VALUES (NULL, 'Patrulla', '1', 'patrulla.png', '2019-09-19 00:00:00', '1', '2019-09-19 00:00:00', '1');
INSERT INTO `cat_tipo_vehiculos` (`idTipoVehiculo`, `nombre`, `activo`, `imagen`, `fechaCreacion`, `usuarioRegistroId`, `fechaActualizacion`, `usuarioActualizacionId`) VALUES (NULL, 'Bombero', '1', 'bombero.png', '2019-09-19 00:00:00', '1', '2019-09-19 00:00:00', '1');
INSERT INTO `cat_tipo_vehiculos` (`idTipoVehiculo`, `nombre`, `activo`, `imagen`, `fechaCreacion`, `usuarioRegistroId`, `fechaActualizacion`, `usuarioActualizacionId`) VALUES (NULL, 'Ambulancia', '1', 'ambulancia.png', '2019-09-19 00:00:00', '1', '2019-09-19 00:00:00', '1');


-- 23/09/2019
-- Jair
ALTER TABLE `peticiones` ADD `tiempoAtendio` DOUBLE NULL DEFAULT NULL ;
ALTER TABLE `peticiones` CHANGE `tiempoAtendio` `tiempoAtendio` VARCHAR(200) NULL DEFAULT NULL;


ALTER TABLE `peticiones` CHANGE `tiempoAtendio` `tiempoAtendio` TIME NULL DEFAULT NULL;


-- 25/09/2019
-- Jair
INSERT INTO `cat_tipo_vehiculos` (`idTipoVehiculo`, `nombre`, `activo`, `imagen`, `fechaCreacion`, `usuarioRegistroId`, `fechaActualizacion`, `usuarioActualizacionId`) VALUES (NULL, 'Alarma', '1', 'alarma.png', '2019-09-25 17:32:00.000000', '1', NULL, NULL);
ALTER TABLE `vehiculos` ADD `alarmaId` TEXT NULL DEFAULT NULL ;

INSERT INTO `vehiculos` (`idVehiculo`, `tipoVehiculoId`, `idsEquipamiento`, `matricula`, `unidad`, `activo`, `estatusId`, `fechaCreacion`, `usuarioRegistroId`, `fechaActualizacion`, `usuarioActualizacionId`, `alarmaId`) VALUES (NULL, '4', NULL, 'ALM-001', 'ALM-001', '1', '1', '2019-09-25 17:42:00.000000', '1', NULL, NULL, '80065AE7D1A695B347A5D2F3D7B9C350195D0F94');
INSERT INTO `vehiculos` (`idVehiculo`, `tipoVehiculoId`, `idsEquipamiento`, `matricula`, `unidad`, `activo`, `estatusId`, `fechaCreacion`, `usuarioRegistroId`, `fechaActualizacion`, `usuarioActualizacionId`, `alarmaId`) VALUES (NULL, '4', NULL, 'ALM-002', 'ALM-002', '1', '1', '2019-09-25 17:42:00.000000', '1', NULL, NULL, '80065AE7D1A695B347A5D2F3D7B9C350195D0F94');
INSERT INTO `vehiculos` (`idVehiculo`, `tipoVehiculoId`, `idsEquipamiento`, `matricula`, `unidad`, `activo`, `estatusId`, `fechaCreacion`, `usuarioRegistroId`, `fechaActualizacion`, `usuarioActualizacionId`, `alarmaId`) VALUES (NULL, '4', NULL, 'ALM-003', 'ALM-003', '1', '1', '2019-09-25 17:42:00.000000', '1', NULL, NULL, '80065AE7D1A695B347A5D2F3D7B9C350195D0F94');

INSERT INTO `usuarios` (`idUsuario`, `idRol`, `nombre`, `email`, `password`, `activo`, `tipoValidacion`, `valido`, `fechaCreacion`, `fechaAct`) VALUES (NULL, '4', 'ConductorAlarm', 'conductorA@framelova.com', '123', '1', '2', '1', '2019-09-20 12:10:57.000000', NULL);

INSERT INTO `usuario_vehiculo` (`idUsuarioVehiculo`, `usuarioId`, `nombre`, `aPaterno`, `aMaterno`, `identificador`, `telefono`, `activo`, `fechaCreacion`, `usuarioRegistroId`, `fechaActualizacion`, `usuarioActualizacionId`) VALUES (NULL, '20', 'Usuario', 'Conductor', 'Alarma', 'CALM-001', '****', '1', '2019-09-25 06:40:00.000000', '1', NULL, NULL);

INSERT INTO `usuarios_turno` (`idUserTurno`, `usuarioVehiculoId`, `turnoId`, `vehiculoId`, `horaInicio`, `horaFin`, `fechaInicio`, `fechaFin`, `activo`) VALUES (NULL, '20', '1', '10', '2019-09-25 07:00:00.000000', '2019-09-25 17:00:00.000000', '2019-09-25 00:00:00.000000', '2019-09-25 00:00:00.000000', '1');
INSERT INTO `coordenadas_vehiculo` (`idCoordenadas`, `vehiculoId`, `registroId`, `latitud`, `longitud`) VALUES (NULL, '10', '1', '19.22242', '-98.44165');


-- 26/09/2019
-- Jair
ALTER TABLE `vehiculos` ADD `estatusAlarma` INT(1) NULL DEFAULT NULL ;
ALTER TABLE `vehiculos` CHANGE `estatusAlarma` `estatusAlarma` INT(1) NULL DEFAULT '1';

-- 03/10/2019
-- Jair
ALTER TABLE `mensajes` CHANGE `idConcepto` `idConcepto` INT(11) NOT NULL DEFAULT '1' COMMENT 'Representa si es mensaje de chat (0) o notificacion a unidad (1)';
ALTER TABLE `mensajes` ADD `imagen` VARCHAR(200) NULL DEFAULT NULL ;


-- 02/03/2020
-- Jair
ALTER TABLE `datos_usuarios` ADD `calle` VARCHAR(250) NULL DEFAULT NULL AFTER `telefono`, ADD `numero` VARCHAR(100) NULL DEFAULT NULL AFTER `calle`, ADD `colonia` VARCHAR(250) NULL DEFAULT NULL AFTER `numero`, ADD `cp` VARCHAR(5) NULL DEFAULT NULL AFTER `colonia`, ADD `numComite` VARCHAR(50) NULL DEFAULT NULL AFTER `cp`;

-- 10/03/2020
-- Rafael
CREATE TABLE cat_ayudas (
  idAyuda INT NOT NULL AUTO_INCREMENT,
  alias VARCHAR(50) NULL,
  titulo VARCHAR(150) NULL,
  descripcion TEXT NULL,
  fechaCreacion DATETIME NULL,
  tipo INT(1) NOT NULL DEFAULT 1,
  urlImg VARCHAR(200) null,
  PRIMARY KEY (idAyuda)
);

ALTER TABLE datos_usuarios 
ADD idComite int NULL; 

CREATE TABLE cat_comites (
  idComite INT NOT NULL AUTO_INCREMENT,
  nombre VARCHAR(50) NULL,
  PRIMARY KEY (idComite)
);

-- 11/03/2020
-- Rafael
INSERT INTO cat_ayudas (
  alias,
  titulo,
  descripcion,
  fechaCreacion,
  tipo,
  urlImg
) VALUES(
  'app_inicio',
  'Inicio',
  'Ayuda pantalla inicio',
  null,
  0,
  'app_inicio.jpg'
);
INSERT INTO cat_ayudas (
  alias,
  titulo,
  descripcion,
  fechaCreacion,
  tipo,
  urlImg
) VALUES(
  'app_crear_cuenta',
  'Crear Cuenta',
  'Ayuda crear cuenta',
  null,
  0,
  'app_crear_cuenta.jpg'
);
INSERT INTO cat_ayudas (
  alias,
  titulo,
  descripcion,
  fechaCreacion,
  tipo,
  urlImg
) VALUES(
  'app_detalle_notificacion',
  'Detalle Notificacion',
  'Ayuda detalles de notificacion',
  null,
  0,
  'app_detalle_notificacion.jpg'
);
INSERT INTO cat_ayudas (
  alias,
  titulo,
  descripcion,
  fechaCreacion,
  tipo,
  urlImg
) VALUES(
  'app_notificaciones',
  'Notificaciones',
  'Ayuda de notificaciones',
  null,
  0,
  'app_notificaciones.jpg'
);
INSERT INTO cat_ayudas (
  alias,
  titulo,
  descripcion,
  fechaCreacion,
  tipo,
  urlImg
) VALUES(
  'app_telefonos_emergencia',
  'Telefonos de emergencia',
  'Ayuda de telefonos de emergencia',
  null,
  0,
  'app_telefonos_emergencia.jpg'
);
INSERT INTO cat_ayudas (
  alias,
  titulo,
  descripcion,
  fechaCreacion,
  tipo,
  urlImg
) VALUES(
  'app_peticion_activa',
  'Peticion Activa',
  'Ayuda de peticion activa',
  null,
  0,
  'app_peticion_activa.jpg'
);
INSERT INTO cat_ayudas (
  alias,
  titulo,
  descripcion,
  fechaCreacion,
  tipo,
  urlImg
) VALUES(
  'app_buzonciudadano',
  'Buzon ciudadano',
  'Ayuda de buzon ciudadano',
  null,
  0,
  'app_buzonciudadano.jpg'
);


INSERT INTO cat_comites (nombre) VALUES('1');
INSERT INTO cat_comites (nombre) VALUES('2');
INSERT INTO cat_comites (nombre) VALUES('4');
INSERT INTO cat_comites (nombre) VALUES('10');
INSERT INTO cat_comites (nombre) VALUES('117');
INSERT INTO cat_comites (nombre) VALUES('123');
INSERT INTO cat_comites (nombre) VALUES('144');
INSERT INTO cat_comites (nombre) VALUES('1ra');
INSERT INTO cat_comites (nombre) VALUES('Andador 4');
INSERT INTO cat_comites (nombre) VALUES('Atlixcayotl 2000');
INSERT INTO cat_comites (nombre) VALUES('Bernardo reyes');
INSERT INTO cat_comites (nombre) VALUES('comiteprueba');
INSERT INTO cat_comites (nombre) VALUES('Ejemplo');
INSERT INTO cat_comites (nombre) VALUES('Gabino barreda');
INSERT INTO cat_comites (nombre) VALUES('Huauchinango');
INSERT INTO cat_comites (nombre) VALUES('Juaquin Beltran 1');
INSERT INTO cat_comites (nombre) VALUES('Ni�os heroes 1ra seccion');
INSERT INTO cat_comites (nombre) VALUES('No lo se');
INSERT INTO cat_comites (nombre) VALUES('Revolucion');
INSERT INTO cat_comites (nombre) VALUES('Reforma');
INSERT INTO cat_comites (nombre) VALUES('Unidos por siempre');
INSERT INTO cat_comites (nombre) VALUES('Vecinos seguros');

-- 19/03/2020
-- Rafael
ALTER TABLE vehiculos ADD idComite int DEFAULT 0;


-- 20/03/2020
-- Jair
ALTER TABLE `peticiones` ADD `opcComite` INT(1) NULL DEFAULT '0' AFTER `tiempoAtendio`;

-- 26/03/2020
-- Jair
ALTER TABLE `vehiculos` ADD `cuenta` VARCHAR(200) NULL DEFAULT NULL AFTER `idComite`;

-- 27/03/2020
-- Jair
ALTER TABLE `peticiones` ADD `cerradoEnApp` INT(1) NOT NULL DEFAULT '0' AFTER `opcComite`;
UPDATE peticiones SET cerradoEnApp=1 WHERE `estatusId`=3;


-- 30/03/2020
-- Jair
ALTER TABLE `historico_usuarios_turno` ADD `tipoHist` INT(2) NULL DEFAULT NULL AFTER `fechaCreacion`;

-- 2/04/2020
-- Jair
ALTER TABLE `cat_comites` ADD `mostrar` INT(1) NOT NULL DEFAULT '1' AFTER `nombre`;

-- 17/04/2020
-- Jair
ALTER TABLE `vehiculos` ADD `soloComite` INT(1) NOT NULL DEFAULT '0' AFTER `cuenta`;

--25/04/2020
--Jonathan
--Agregar columnas para server y token
ALTER TABLE `vehiculos` 
ADD `server` VARCHAR(50) NOT NULL DEFAULT '' , 
ADD `token` VARCHAR(50) NOT NULL DEFAULT '';

-- 29/04/2020
-- Jair
CREATE TABLE cat_cuentas (
  idCuenta INT NOT NULL AUTO_INCREMENT,
  nombre VARCHAR(50) NULL,
  usario VARCHAR(200) NULL,
  password VARCHAR(200) NULL,
  token text NULL,
  PRIMARY KEY (idCuenta)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;


ALTER TABLE peticiones ADD asignado int DEFAULT 0;

alter table peticiones add permissionsApp varchar(250) null;



CREATE TABLE cat_error_codes(
	idErrorCode INT PRIMARY KEY AUTO_INCREMENT,
    errorCode VARCHAR(100) NULL,
    descripcion VARCHAR(250) NULL
);


 alter table peticiones
  add primerEncendidoCM varchar(50) null;
  alter table peticiones
  add segundoEncendidoCM varchar(50) null;
  alter table peticiones
  add encendidoAlm text null;


alter table peticiones add atendidoOperador int default 0 null;
  create table cat_escalonamiento(
	idEscalonamiento int not null primary key auto_increment,
    nombre varchar(50) null,
    puesto varchar(100) null,
    email varchar(50) null,
    telefono varchar(15) null,
    tiempoNotificacionMin int null,
    alertaMail int null,
    alertatelefono int null
); 

alter table usuarios add comentarios varchar(250);

insert into roles (rol, fechaCreacion) VALUES('Supervisor', NOW());
insert into roles (rol, fechaCreacion) VALUES('Analista', NOW());
insert into roles (rol, fechaCreacion) VALUES('Dashboard', NOW());

DELIMITER $$
DROP FUNCTION IF EXISTS `json_extract_c`$$
CREATE FUNCTION `json_extract_c`(
details TEXT,
required_field VARCHAR (255)
) RETURNS TEXT CHARSET latin1
READS SQL DATA
DETERMINISTIC
BEGIN
  DECLARE search_term TEXT;
  SET details = SUBSTRING_INDEX(details, "{", -1);
  SET details = SUBSTRING_INDEX(details, "}", 1);
  SET search_term = CONCAT('"', SUBSTRING_INDEX(required_field,'$.', - 1), '"');
  IF INSTR(details, search_term) > 0 THEN
    RETURN TRIM(
      BOTH '"' FROM SUBSTRING_INDEX(
        SUBSTRING_INDEX(
          SUBSTRING_INDEX(
            details,
            search_term,
            - 1
          ),
          ',"',
          1
        ),
        ':',
        -1
      )
    );
  ELSE
    RETURN NULL;
  END IF;
END$$
DELIMITER ;

-- 26/02/2021
-- Cristhian
CREATE TABLE IF NOT EXISTS `opiniones` (
  `idOpinion` INT(11) NOT NULL AUTO_INCREMENT,
  `usuarioId` INT DEFAULT NULL,
  `comentario` TEXT DEFAULT NULL,
  `fechaCreacion` DATETIME DEFAULT NULL,
  PRIMARY KEY (`idOpinion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

-- 11/03/2021
-- Cristhian
INSERT INTO roles(rol, fechaCreacion) VALUES ('Ciudadano a Pie', NOW());

ALTER TABLE codigo_validacion ADD email VARCHAR(100), ADD telefono VARCHAR(15);

ALTER TABLE datos_usuarios ADD urlFoto VARCHAR(100);

-- 23/03/2021
-- Cristhian
ALTER TABLE `datos_usuarios` ADD INDEX(`usuarioId`);

ALTER TABLE `datos_usuarios` ADD CONSTRAINT `datusr_usuarioIdFK` 
FOREIGN KEY (`usuarioId`) REFERENCES `usuarios`(`idUsuario`) 
ON DELETE CASCADE ON UPDATE NO ACTION;

SELECT du.usuarioId
FROM datos_usuarios du
WHERE NOT EXISTS (
  SELECT NULL
  FROM usuarios u
  WHERE u.idUsuario = du.usuarioId
);

-- 07/04/2021
-- Cristhian

CREATE TABLE cat_status_asignacion (
	idStatusAsignacion INT(11) NOT NULL AUTO_INCREMENT,
	status VARCHAR(300) NULL DEFAULT NULL,
	fechaCreacion DATETIME NULL DEFAULT NULL,
	PRIMARY KEY (idStatusAsignacion)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

INSERT INTO cat_status_asignacion (status, fechaCreacion)
VALUES ("Alarma comite asignada", NOW());

INSERT INTO cat_status_asignacion (status, fechaCreacion)
VALUES ("Alarma PMI asignada", NOW());

INSERT INTO cat_status_asignacion (status, fechaCreacion)
VALUES ("Alarma comite no asignada por distancia", NOW());

INSERT INTO cat_status_asignacion (status, fechaCreacion)
VALUES ("Alarma comite no asignada, ocupada", NOW());

ALTER TABLE peticiones ADD statusAsignacionId INT(11) NULL DEFAULT NULL;

ALTER TABLE peticiones ADD INDEX (statusAsignacionId);

ALTER TABLE peticiones 
ADD CONSTRAINT `FK_peticiones_statusAsignacionId` 
FOREIGN KEY (statusAsignacionId) 
REFERENCES cat_status_asignacion(idStatusAsignacion) 
ON DELETE NO ACTION 
ON UPDATE NO ACTION;

CREATE TABLE cat_status_comunicacion (
	idStatusComunicacion INT(11) NOT NULL AUTO_INCREMENT,
	codigo INT NULL DEFAULT NULL,
	status VARCHAR(300) NULL DEFAULT NULL,
	fechaCreacion DATETIME NULL DEFAULT NULL,
	PRIMARY KEY (idStatusComunicacion)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

INSERT INTO cat_status_comunicacion (codigo, status, fechaCreacion)
VALUES (0, "Alarma respondio peticion", NOW());

INSERT INTO cat_status_comunicacion (codigo, status, fechaCreacion)
VALUES (-20002, "Alarma no respondio", NOW());

INSERT INTO cat_status_comunicacion (codigo, status, fechaCreacion)
VALUES (-20104, "Alarma mal configurada", NOW());

INSERT INTO cat_status_comunicacion (codigo, status, fechaCreacion)
VALUES (-20571, "Alarma fuera de linea", NOW());

INSERT INTO cat_status_comunicacion (codigo, status, fechaCreacion)
VALUES (-20580, "Alarma mal configurada", NOW());

INSERT INTO cat_status_comunicacion (codigo, status, fechaCreacion)
VALUES (-20651, "La alarma necesita una actualizacion de token", NOW());

ALTER TABLE peticiones ADD statusComunicacionId INT(11) NULL DEFAULT NULL;

ALTER TABLE peticiones ADD INDEX (statusComunicacionId);

ALTER TABLE `peticiones` 
ADD CONSTRAINT `FK_peticiones_statusComunicacionId` 
FOREIGN KEY (`statusComunicacionId`) 
REFERENCES `cat_status_comunicacion`(`idStatusComunicacion`) 
ON DELETE NO ACTION 
ON UPDATE NO ACTION;

ALTER TABLE peticiones 
ADD comiteUsuario INT(11) NULL DEFAULT NULL COMMENT 'este es el comite al que pertenecia el usuario al momento de hacer la peticion';

ALTER TABLE peticiones 
ADD segundoEncendidoAlm VARCHAR(50) NULL DEFAULT NULL COMMENT 'status de un segundo encendido para la alarma que se encuentra en la calle';

-- 06/05/2021
-- Cristhian

CREATE TABLE cambios_usuarios (
	idCambioUsuario INT(11) NOT NULL AUTO_INCREMENT,
	usuarioMonitor INT(11) NULL DEFAULT NULL COMMENT 'id del usuario que realizo el cambio',
  usuarioId INT(11) NULL DEFAULT NULL COMMENT 'id del usario al que se le hizo el cambio',
  campo VARCHAR(70) NULL DEFAULT NULL,
  valorAnterior TEXT NULL DEFAULT NULL,
  valorNuevo TEXT NULL DEFAULT NULL,
	fechaCreacion DATETIME NULL DEFAULT NULL,
	PRIMARY KEY (idCambioUsuario)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

-- 21/06/2021
-- Jared
INSERT INTO cat_configuraciones VALUES(NULL, 'Estado de cerco geografico', 'activo', CURRENT_TIMESTAMP, NULL);
ALTER TABLE codigo_validacion ADD fechaCreacion DATETIME;

-- 09/09/21
-- Jared
INSERT INTO cat_configuraciones VALUES(NULL, 'Uso de ubicaci�n en segundo plano', 'Para aumentar la eficiencia con los cuerpos policiales en tu petici�n de auxilio, permite a <b>SACH Ciudadano Alerta</b> usar tu <b>ubicaci�n en segundo plano</b>. <br><br><b>SACH Ciudadano</b> usar� esta funci�n para tener un seguimiento de tu ubicaci�n a�n cuando la app no est� en uso, y esta captura de datos se har� �nicamente cuando lo permitas y cuando hayas realizado una petici�n de auxilio.', CURRENT_TIMESTAMP, NULL);


-- MSA 03/05/2023
ALTER TABLE rpt_mascotas ADD activo int NULL;

-- MSA 15/05/2023
ALTER TABLE rpt_mascotas ADD idUsuario int NULL;
ALTER TABLE rpt_personas ADD idUsuario int NULL;

-- MSA 18/05/2023 Agregar ubicacion donde fue vista la mascota
ALTER TABLE resp_mascotas ADD ubicacion text NULL;
ALTER TABLE resp_mascotas ADD idUsuario int NULL;

-- MSA 22/05/2023 Agregar API Firebase a BDs
INSERT INTO cat_configuraciones(nombre, valor, fechaCreacion) VALUES("API Firebase", "", now()); 

-- MSA 22/05/2023 Tabla para guardar urls de imagenes de mascotas vistas 
CREATE TABLE imagenes_mascotasVistas(
	idImgMascotaVista INT(11) NOT NULL AUTO_INCREMENT,
  rptMascotaId INT(11) NOT NULL,
  urlImg varchar(50) NOT NULL,
  fechaCreacion datetime NOT NULL,
  PRIMARY KEY (idImgMascotaVista)
);

-- MSA 22/05/23 Tabla para guardar reportes de persona desaparecida vista
CREATE TABLE resp_personas(
	idRespPersona INT(11) NOT NULL AUTO_INCREMENT,
  rptPersonaId INT(11) NULL,
  nombreContacto varchar(200) NULL,
  emailContacto varchar(200) NULL,
  telContacto  varchar(20) NULL,
  descripcion TEXT NULL,
  fechaVisto datetime NULL,
  fechaCreacion datetime NULL,
  ubicacion text NULL,
  idUsuario INT(11) NOT NULL,
  PRIMARY KEY (idRespPersona)
);

-- MSA 22/05/2023 Tabla para guardar urls de imagenes de personas vistas 
CREATE TABLE imagenes_personasVistas(
	idImgPersonaVista INT(11) NOT NULL AUTO_INCREMENT,
  rptPersonaId INT(11) NOT NULL,
  urlImg varchar(50) NOT NULL,
  fechaCreacion datetime NOT NULL,
  PRIMARY KEY (idImgPersonaVista)
);

-- MSA 25/05/2023 Agregar campos a tabla de personas desaparecidas
ALTER TABLE rpt_personas ADD encontrada int NULL;
ALTER TABLE rpt_personas ADD fechaEncontrado datetime NULL;
ALTER TABLE rpt_personas ADD descripcion text NULL; 
ALTER TABLE rpt_personas ADD nombreContacto varchar(100) NULL;
ALTER TABLE rpt_personas ADD correoContacto varchar(100) NULL;

-- MSA 24/08/2023 Campo para diferenciar numeros de telefonos tipo whatsapp
ALTER TABLE cat_telefonosemergencia ADD tipoTelefono int NULL COMMENT '0=tel normal, 1=whatsapp'

-- 11/08/23
-- BEAR --
CREATE TABLE IF NOT EXISTS globallog(
  idLoG INT(11) NOT NULL AUTO_INCREMENT COMMENT "id de log que se va creando cuando los usuario hagan una accion como inserta,actualizar,eliminar",
  nombreDelaVista varchar(200) NOT NULL COMMENT "nombre de la vista que se realizo la accion",
  idUsuario INT(11) NOT NULL COMMENT "Usuario que realizo la Accion",
  jsonLog text NOT NULL COMMENT "Datos de la accion y a que usuario o alarma ect; Dio de alta , modifico o elimino",
  cat_tipoLog INT(11) NOT NULL COMMENT "TIPO DE LOG A DIFERENTE ACCION DIFERENTE TIPO DE LOG",
  fechaCreacion datetime COMMENT"FECHA DE CREACION",
  PRIMARY KEY (idLoG)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;
-- 18/08/23
--BEAR--
ALTER TABLE usuarios ADD permiso int(11) null DEFAULT null COMMENT " permiso para los usuarios administradores"

CREATE TABLE IF NOT EXISTS cat_log(
  IdcatalogoLog  INT(11) NOT NULL AUTO_INCREMENT COMMENT "id de Log ",
  Nombre varchar(200) NOT NULL COMMENT "nombre del log",
  PRIMARY KEY (IdcatalogoLog)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

-- datos para llenar el cat_log
INSERT INTO cat_log (IdcatalogoLog,Nombre) VALUES (null,'Alta Usuario Administrativo');

INSERT INTO cat_log (IdcatalogoLog,Nombre) VALUES (null,'Editar Usuario Administrativo'); 

INSERT INTO cat_log (IdcatalogoLog,Nombre) VALUES (null,'Eliminar Usuario Administrativo'); 

INSERT INTO cat_log (IdcatalogoLog,Nombre) VALUES (null,'Editar Datos Ciudadano');

INSERT INTO cat_log (IdcatalogoLog,Nombre) VALUES (null,'Editar Usuarios Ciudadano'); 

INSERT INTO cat_log (IdcatalogoLog,Nombre) VALUES (null,'Editar Datos de Alarma'); 
-- fin 

CREATE TABLE IF NOT EXISTS trgUsuarios(
  idTrgUsuarios int(11) NOT NULL AUTO_INCREMENT COMMENT"id del trigger",
  idUsuario int(11) COMMENT"id de usuario de la tabla usuarios",
  idRol  int(11) COMMENT"id de ROL del usuarios",
  nombre varchar(150) COMMENT"Nombre de usuario",
  email varchar(100) COMMENT"Correo del usuario",
  password varchar(50)COMMENT"Password del usuario",
  activo char(1) COMMENT"Activo de usuario",
  tipoValidacion char(1) COMMENT"Tipo de validacion del usuario mediante correo o msj",
  valido char(1) COMMENT"Valido",
  fechaCreacion datetime COMMENT "Fecha de creacion de usuario",
  comentarios varchar(250)COMMENT"comentario",
  permiso int(11)COMMENT"permiso solo para los usuarios administradores",
  accion varchar(250) COMMENT"Accion que se realizo si es aliminar o update",
  fechaCreacionTrg datetime COMMENT"fecha de cracion del trigger",
  PRIMARY KEY(idTrgUsuarios)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

------------------- Triggers o dispalador  tabla usuarios guarda el contenido anterior cuando se actualiza un dato
CREATE TRIGGER TRGUsuarios BEFORE UPDATE ON usuarios 
FOR EACH ROW INSERT INTO trgUsuarios(idUsuario,idRol,nombre,email,password,activo,tipoValidacion,valido,fechaCreacion,comentarios,permiso,accion,fechaCreacionTrg)
VALUES (OLD.idUsuario,OLD.idRol,OLD.nombre,OLD.email,OLD.password,OLD.activo,OLD.tipoValidacion,OLD.valido,OLD.fechaCreacion,OLD.comentarios,OLD.permiso,"Usuario Actualizado Datos anteriores.",NOW())


------------------ Triggers para usuarios eliminados 
CREATE TRIGGER DELEUSUARIOS  AFTER DELETE ON usuarios
FOR EACH ROW INSERT INTO trgUsuarios (idUsuario,idRol,nombre,email,password,activo,tipoValidacion,valido,fechaCreacion,comentarios,permiso,accion,fechaCreacionTrg)
VALUES (OLD.idUsuario,OLD.idRol,OLD.nombre,OLD.email,OLD.password,OLD.activo,OLD.tipoValidacion,OLD.valido,OLD.fechaCreacion,OLD.comentarios,OLD.permiso,"Usuario Eliminados Datos anteriores.",NOW())


-- Bear 27-08-23

CREATE TABLE IF NOT EXISTS trgdatosusuarios(
  idTrgDatos int (11) NOT NULL AUTO_INCREMENT COMMENT"id del trigger",
  idDatoUsuario int(11) COMMENT"id de usuario datos usuarios",
  usuarioId  int(11) COMMENT"id de usuario",
  clave varchar(50) COMMENT"clave de usuario",
  nombre varchar(50) COMMENT"nombre de usuario",
  aPaterno varchar(50) COMMENT"apellido paterno del usurio",
  aMaterno varchar(50) COMMENT"apellido materno del usuario",
  telefono varchar(50) COMMENT "telefono del usuario",
  calle varchar (250) COMMENT"nombre de la calle donde vive el usuario",
  numero varchar (200) COMMENT"numero de la propieda o vivienda donde vive el usuario",
  colonia varchar (250) COMMENT"nombre del la colonia donde vive el usuario",
  cp varchar (5) COMMENT"codigo postal donde vive el usuario",
  numComite varchar(50) COMMENT"",
  fechaCreacion datetime COMMENT"fecha de creacion del usuario",
  fechaAct datetime COMMENT"fecha de actualicion del usuario",
  idComite int(11) COMMENT"id de comite donde el usuario pertenece",
  urlFoto varchar(100) COMMENT"Foto del usuario",
  comentario text COMMENT"comentrario accion",
  fechaCreacionTrg datetime COMMENT"fecha de cracion del trigger",
  PRIMARY KEY(idTrgDatos)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

CREATE TRIGGER TRGDatosUsuariosUP BEFORE UPDATE ON datos_usuarios FOR EACH ROW INSERT INTO trgdatosusuarios
  (idDatoUsuario,usuarioId,clave,nombre,aPaterno,aMaterno,telefono,calle,numero,colonia,cp,numComite,fechaCreacion,fechaAct,idComite,urlFoto,comentario,fechaCreacionTrg)
	VALUES 
  (OLD.idDatoUsuario,OLD.usuarioId,OLD.clave,OLD.nombre,OLD.aPaterno,
  OLD.aMaterno,OLD.telefono,OLD.calle,OLD.numero,OLD.colonia,OLD.cp,OLD.numComite,OLD.fechaCreacion,
  OLD.fechaAct,OLD.idComite,OLD.urlFoto,"Usuario Actualizado Datos anteriores.",Now())

--TABLA alarma con datos anteriosres 
CREATE TABLE IF NOT EXISTS datosalarmaold (
  idAlarma int(11) NOT NULL AUTO_INCREMENT COMMENT"ID DE alarma",
  idVehiculo  int(11) COMMENT"ID de vehiculo tabla vehiculos",
  tipoVehiculoId int(11) COMMENT"tipo de vehicuolo",
  matricula varchar(200) COMMENT"Matricula del vehicula",
  activo int(1) COMMENT"activacion del vehiculo",
  alarmaId text COMMENT"mac del dispsositivo en el caso de alarma",
  idComite int(11) COMMENT"ID de comite que pertenece la alarma",
  cuenta varchar(200) COMMENT"cuenta que pertenece la alarma",
  soloComite int(1) COMMENT"alarma que solo funcione como solo comite",
  token varchar(50) COMMENT"token de la alarma ",
  distanciaAlarma int(11) COMMENT"distancia de alarma",
  latitud varchar(200) COMMENT"latitud de la alarma",
  longitud varchar(200) COMMENT"longitud de alarma",
  fechaCreacionAlarma datetime COMMENT"fecha de creacion de la alarma",
  PRIMARY KEY(idAlarma)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

-- formularios bear 18/09/20

CREATE TABLE `servidorestplink` (
  `Idservidor` int NOT NULL AUTO_INCREMENT,
  `servidor` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `fechaCreacion` datetime DEFAULT NULL,
  PRIMARY KEY (`Idservidor`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO servidorestplink(servidor, fechaCreacion) values ('https://use1-wap.tplinkcloud.com',	'2023-06-13 11:10:42');
INSERT INTO servidorestplink(servidor, fechaCreacion) values ('https://aps1-wap.tplinkcloud.com',	'2023-06-13 11:30:43');
INSERT INTO servidorestplink(servidor, fechaCreacion) values ('https://eu-wap.tplinkcloud.com',	'2023-06-13 11:31:36');

CREATE TABLE IF NOT EXISTS cat_estatus_formulario (
  idEstatusFormulario int(11) NOT NULL AUTO_INCREMENT COMMENT"ID estatus formulario",
  nombre_estatus varchar(200)  COMMENT"Nombre del estatus",
  PRIMARY KEY(idEstatusFormulario)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;


CREATE TABLE IF NOT EXISTS formularios (
  idFormulario int(11) NOT NULL AUTO_INCREMENT COMMENT"ID DE formulario",
  nombre  varchar(200) COMMENT"Nombre del formulario",
  descripcion  varchar(200) COMMENT "Descripcion del formulario",
  idEstatusFormulario int(11)  COMMENT"ID estatus formulario",
  fecha_inicio datetime COMMENT"fecha de inicio del formulario",
  fecha_finalizacion datetime COMMENT"fecha de finalizacion del formulario",
  horaFecha_creacion datetime COMMENT"fecha de creacion del formulario",
  horaFecha_actualizacion datetime COMMENT"fecha de Actualizacion del formulario",
  idUsuario int(11) COMMENT"id de usuario que creo el formulario",
  idUsuarioUP int(11) COMMENT"id Usuario que actuaizo el formulario",
  PRIMARY KEY(idFormulario),
	FOREIGN KEY(idEstatusFormulario) REFERENCES cat_estatus_formulario(idEstatusFormulario)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;



CREATE TABLE IF NOT EXISTS grupos_formularios (
	idGruposFormularios int(11) Not NULL AUTO_INCREMENT COMMENT"ID DE GRUPOS FORMULARIOS",
  nombre_grupos varchar(200) COMMENT"Nombre del grupo",
  numero_orden int(11) COMMENT" numero de onde",
  idFormulario int(11)  COMMENT"ID DE formulario",
  PRIMARY KEY(idGruposFormularios),
  FOREIGN KEY(idFormulario) REFERENCES formularios(idFormulario)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;


CREATE TABLE IF NOT EXISTS cat_tipo_pregunta (
  idTipoPreguntas int(11) NOT NULL AUTO_INCREMENT COMMENT"ID DE TIPO DE PREGUNTA",
  tipo_pregunta varchar(200)  COMMENT"TIPO DE PREGUNTA",
  PRIMARY KEY(idTipoPreguntas)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;





CREATE TABLE IF NOT EXISTS pregunta_formularios (
	idPreguntaFormulario int(11) NOT NULL AUTO_INCREMENT COMMENT"ID DE pregrunta formulario",
  idFormulario  int(11) COMMENT"ID DE formulario",
  pregunta  text COMMENT "pregunta creada",
  orden_pregunta int(11) COMMENT"orden de como va ir acomodado el formulario",
  idTipoPreguntas int(11) COMMENT"ID de tipo de pregunta, tipo de pregunta abierta o ocion multiple",
  fechaHora_Creacion datetime COMMENT"fecha de creacion de la pregrunta",
  fechaHora_Actualizacion datetime  COMMENT"fecha de actualizacion de formulario",
  idGruposFormularios int (11) COMMENT"id de grupos formularios",
  PRIMARY KEY(idPreguntaFormulario),
  FOREIGN KEY(idFormulario) REFERENCES formularios(idFormulario),
  FOREIGN KEY(idTipoPreguntas) REFERENCES cat_tipo_pregunta(idTipoPreguntas),
  FOREIGN KEY(idGruposFormularios) REFERENCES grupos_formularios(idGruposFormularios)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;






CREATE TABLE IF NOT EXISTS opciones_pregunta (
	idOpcionPregunta int(11) NOT NULL AUTO_INCREMENT COMMENT"ID DE opciones de pregunta respuesta multiple",
  valor  varchar(200) COMMENT"valor de la respuesta ",
  idPreguntaFormulario int(11) COMMENT"ID DE pregrunta",
  horaFecha_creacion datetime COMMENT"fecha de creacion",
  horaFecha_actualizacion datetime COMMENT"fecha de actualiazacion",
  PRIMARY KEY(idOpcionPregunta),
  FOREIGN KEY(idPreguntaFormulario) REFERENCES pregunta_formularios(idPreguntaFormulario)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;




CREATE TABLE IF NOT EXISTS respuestas_preguntas_formularios (
	idRespuestaPregunta int(11) NOT NULL AUTO_INCREMENT COMMENT"ID de respuesta formulario",
  idPreguntaFormulario int(11) COMMENT"ID DE pregrunta formulario ",
  idUsuario int (11) COMMENT"ID DE Usuario que coontesto",
	idOpcionPregunta int (11) COMMENT"ID DE opciones pregunta",
  respuesta text COMMENT"respuesta de la pregunta",
  fechaHora_respuesta datetime  COMMENT"fecha de respuesta",
  PRIMARY KEY(idRespuestaPregunta),
  FOREIGN KEY(idPreguntaFormulario) REFERENCES pregunta_formularios(idPreguntaFormulario),
  FOREIGN KEY(idOpcionPregunta) REFERENCES opciones_pregunta(idOpcionPregunta)
)ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0;

-- MSA 15/01/2024 Agregar uso de segundo plano
INSERT INTO cat_configuraciones (nombre, valor, fechaCreacion) VALUES ('Uso de ubicación en segundo plano', 'Para ser eficientes con los cuerpos policiales en tu petición de auxilio, permite a <b>Tehuacan Ciudadano Alerta</b> usar tu ubicación en segundo plano. <br><br><b>SACH Ciudadano Alerta</b> usará la ubicación en segundo plano para tener un seguimiento de tu ubicación aún cuando la app no está en uso, esta captura de datos se hará únicamente cuando lo permitas y hayas realizado una petición de auxilio.', now());

-- MSA 16/01/2024 Agregar fecha caducidad y fechaActualizacion reporte 
ALTER TABLE rpt_mascotas ADD fechaActualizacion datetime NULL;
ALTER TABLE rpt_mascotas ADD fechaCaducidad datetime NULL;

-- MSA 16/01/2024 Agregar campo para registrar si ya se encontro y la fecha
ALTER TABLE rpt_mascotas ADD encontrada int NULL;
ALTER TABLE rpt_mascotas ADD fechaEncontrado datetime NULL;

-- MSA 17/01/24 Creacion tabla catalogo botones llavero
CREATE TABLE cat_botones_llavero (
  idBoton int(11) NOT NULL primary key auto_increment,
  identificador varchar(25) NOT NULL,
  color varchar(12) NOT NULL,
  fechaRegistro datetime NOT NULL,
  comentarios varchar(150) NULL
);

-- ADD COLUMN historialInicioSesion
ALTER TABLE historialInicioSesion ADD vehiculoId INT NOT NULL ;


-- Nuevas ayudas
INSERT INTO cat_ayudas(alias, titulo, descripcion, tipo, urlImg) VALUES('app_boton_llavero','Boton llavero', 'Ayuda boton llavero',0,'app_boton_llavero.jpg');
INSERT INTO cat_ayudas(alias, titulo, descripcion, tipo, urlImg) VALUES('app_conectar_boton_llavero','Conectar boton llavero', 'Ayuda conexion boton llavero',0,'app_conectar_boton_llavero.jpg');
INSERT INTO cat_ayudas(alias, titulo, descripcion, tipo, urlImg) VALUES('app_personas_extraviadas','Personas extraviadas', 'Ayuda visualizar todas personas extraviadas',0,'app_personas_extraviadas.jpg');
INSERT INTO cat_ayudas(alias, titulo, descripcion, tipo, urlImg) VALUES('app_reportar_persona_extraviada','Reportar persona extraviada', 'Ayuda reportar persona extraviada',0,'app_reportar_persona_extraviada.jpg');
INSERT INTO cat_ayudas(alias, titulo, descripcion, tipo, urlImg) VALUES('app_persona_vista','Persona vista', 'Ayuda reportar persona vista',0,'app_persona_vista.jpg');
INSERT INTO cat_ayudas(alias, titulo, descripcion, tipo, urlImg) VALUES('app_mascotas_perdidas','Mascotas perdidas', 'Ayuda visualizacion todas mascotas perdidas',0,'app_mascotas_perdidas.jpg');
INSERT INTO cat_ayudas(alias, titulo, descripcion, tipo, urlImg) VALUES('app_mascota_perdida_reportar','Ayuda mascota perdida reportar', 'Ayuda reportar una mascota perdida',0,'app_mascota_perdida_reportar.jpg');
INSERT INTO cat_ayudas(alias, titulo, descripcion, tipo, urlImg) VALUES('app_reportar_mascota_vista','Reportar mascota vista', 'Ayuda reportar mascota vista',0,'app_reportar_mascota_vista.jpg');

ALTER TABLE `mensajes` ADD `idUserEnviado` INT NOT NULL COMMENT 'enviado a que usuario' AFTER `idTipoMensaje`;
ALTER TABLE cat_botones_llavero ADD UUID TEXT NULL COMMENT ' para ios ' AFTER comentarios;
