<?php
$dirname = dirname(__DIR__);
include_once $dirname.'/brules/PHPExcel/PHPExcel.php';
include_once $dirname.'/brules/buzonCiudadanoObj.php';
include_once $dirname.'/common/config.php';
include_once $dirname.'/common/globalFunctions.php';

$fechaInicioBuzonCiudadano = $_GET['fechaInicioBuzonCiudadano'];
$fechaFinBuzonCiudadano = $_GET['fechaFinBuzonCiudadano'];

$connectionStatus = mysqli_connect($cfg_server,$cfg_user, $cfg_pw, $cfg_db);

$query='
  SELECT 
  A.idBuzonCiudadano,
  B.nombre as nombreTipo,
  A.mensaje,
  A.evidencias,
  CASE
    WHEN A.testigo = "0" THEN "No"
    WHEN A.testigo = "1" THEN "Si"
  END AS testigoTexto,
  CASE
    WHEN A.anonimo = "0" THEN "No"
    WHEN A.anonimo = "1" THEN "Si"
  END AS anonimoTexto,
  A.nombreCiudadano,
  A.telefono,
  A.fechaCreacion
  FROM  buzon_ciudadano A
  LEFT JOIN cat_tipocontactos B on B.idTipoC=A.tipoContacto
  WHERE A.fechaCreacion>= \''.$fechaInicioBuzonCiudadano.' 00:00:00\' 
  AND A.fechaCreacion <= \''.$fechaFinBuzonCiudadano.' 23:59:59\' 
  ORDER BY A.fechaCreacion DESC;
';

$titulosColumnas = array(
  "ID", 
  "Tipo Contacto", 
  "Mensaje", 
  "Evidencia", 
  "Testigo", 
  "Anonimo", 
  "Nombre Ciudadano", 
  "Celular", 
  "Fecha Creacion"
);

$columnas = array(
  'idBuzonCiudadano', 
  'nombreTipo', 
  'mensaje', 
  'evidencias', 
  'testigoTexto', 
  'anonimoTexto', 
  'nombreCudadano', 
  'telefono', 
  'fechaCreacion'
);
      
//ejecutamos query
$result =  mysqli_query($connectionStatus, $query);
$info_campos = $result->fetch_fields();
    
if (PHP_SAPI == 'cli') die('Este archivo solo se puede ver desde un navegador web');

// Se crea el objeto PHPExcel
$objPHPExcel = new PHPExcel();

// Se asignan las propiedades del libro
$objPHPExcel->getProperties()->setCreator("Framelova") //Author
->setLastModifiedBy("Framelova") //Ultimo usuario que lo modifico
->setTitle("Reporte de buzon ciudadano")
->setSubject("Buzon Ciudadano")
->setDescription("Reporte de buzon ciudadano por fecha asignada")
->setKeywords("Reporte Buzon Ciudadano")
->setCategory("Buzon Ciudadano");
            
//inyectamos titulos de columnas
$totalTituloCol = count($titulosColumnas);
$colB = 'A';
$FilaTitulo = 1;

for($i=1; $i<=$totalTituloCol; $i++){
  $objPHPExcel->getActiveSheet()->setCellValue($colB.$FilaTitulo, $titulosColumnas[$i-1]);
  $colB++;
}

//inyectamos filas
$contLetra = "$colB"."1";
$iIns=2;

$colA = 'A';
$filaActual = 2;
    
$lastCol = 'A';

// Agregamos la columna de los datos del reporte:
for($i=0; $i<(count($columnas)+1); $i++){
  $lastCol++;
}


while ($row=mysqli_fetch_array($result)) {
  for($i=1; $i<=(count($columnas)); $i++){
    //obtenemos el tipo para saber si tiene otro tratamiento
    $type = $info_campos[$i-1]->type;

    if($type == 12){//fecha
      $dateForm=explode(" ",$row[$i-1]);
      $dateForm1=explode("-",$dateForm[0]);
      // $fecha = (isset($dateForm1[2])) ? ($dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1]) : "";
      // $dateForm1F= $dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1];
      $dateForm1F = (isset($dateForm1[2])) ? ($dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1]) : "--";

      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, $dateForm1F);
      $colA++;
    }else{
      //$objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, utf8_encode($row[$i-1]));
      //$objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, $row[$i-1]);
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, (($row[$i-1] == NULL) ? "--" : utf8_encode($row[$i-1])));
      $colA++;
    } 
  } 
  $colA = 'A';
  $filaActual++;
}
 
$estiloTituloColumnas = array('font' => array('name'=> 'Arial','bold'=> true,'size'=>10,'color'=> array('rgb' => '000000')),'alignment' => array('horizontal'=>PHPExcel_Style_Alignment::HORIZONTAL_CENTER,'vertical'=>PHPExcel_Style_Alignment::VERTICAL_CENTER,'wrap'=>TRUE));

$estiloInformacion = new PHPExcel_Style();
$estiloInformacion->applyFromArray(array('font' => array('name'=>'Arial', 'size'=>8, 'color'=> array('rgb' => '000000'))));
$objPHPExcel->getActiveSheet()->getStyle('A1:'.$lastCol.'1')->applyFromArray($estiloTituloColumnas);

for($j = 'A'; $j < $lastCol; $j++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);
}

// Se asigna el nombre a la hoja
$objPHPExcel->getActiveSheet()->setTitle('BuzonCiudadano');

// Se activa la hoja para que sea la que se muestre cuando el archivo se abre
$objPHPExcel->setActiveSheetIndex(0);

// Inmovilizar paneles
$objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,2);

$titletmp = "Buzon ciudadano-".$fechaInicioBuzonCiudadano;
$titleFile = "Reporte-".$titletmp.".xls";
header('Content-Type: application/vnd.ms-excel');
header("Content-Disposition: attachment;filename=$titleFile");
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

$objWriter->save('php://output');

exit;
ob_flush();

?>