<?php
$dirname = dirname(__DIR__);
include_once $dirname.'/brules/PHPExcel/PHPExcel.php';
include_once $dirname.'/brules/datosUsuarioObj.php';
include_once $dirname.'/brules/vehiculosObj.php';
include_once $dirname.'/brules/catStatusAsignacionObj.php';
include_once $dirname.'/common/config.php';
include_once $dirname.'/common/globalFunctions.php';

$fechaPeticiones = $_GET['fechaPeticiones'];
$fechaPeticionesFin = $_GET['fechaPeticionFin'];

//echo $fechaPeticiones;
//echo $fechaPeticionesFin;
$connectionStatus = mysqli_connect($cfg_server,$cfg_user, $cfg_pw, $cfg_db);

// Las columnas deben de estar en el orden en que son expuestas en el reporte:
$query = '
  SELECT
    a.idPeticion, 
    d.nombre AS tipo_peticion, 
    b.nombre AS usuario_peticion,
    g.matricula AS nombre_usuario_turno,
    csa.status AS statusAsignacion,
    a.statusAsignacionId,
    csc.status AS statusComunicacion,
    a.fechaCreacion,
    i.nombre AS comite,
    cc.nombre AS comiteEnPeticion, 
    f.nombre AS operador, 
    a.fechaAsignacion, 
    a.fechaFinalizacion, 
    a.coordenadasInicio, 
    a.coordenadasFin, 
    c.nombre AS estatus,
    a.tiempoAtendio,
    a.permissionsApp,
    a.usuarioId,
    cv.latitud,
    cv.longitud
  FROM peticiones a 
  LEFT JOIN usuarios b ON a.usuarioId=b.idUsuario 
  LEFT JOIN cat_estatus c ON a.estatusId=c.numero AND c.familiaId=1 
  LEFT JOIN cat_tipo_vehiculos d ON d.idTipoVehiculo=a.tipoPeticionId 
  LEFT JOIN usuarios_turno e ON e.idUserTurno=a.usuarioTurnoId 
  LEFT JOIN usuarios f ON f.idUsuario=a.usuarioOperadorId 
  LEFT JOIN vehiculos g ON g.idVehiculo=e.vehiculoId 
  LEFT JOIN datos_usuarios h ON h.usuarioId = b.idUsuario
  LEFT JOIN cat_comites i ON i.idComite = h.idComite
  LEFT JOIN cat_status_asignacion csa ON csa.idStatusAsignacion = a.statusAsignacionId 
  LEFT JOIN cat_status_comunicacion csc ON csc.idStatusComunicacion = a.statusComunicacionId
  LEFT JOIN cat_comites cc ON cc.idComite = a.comiteUsuario
  LEFT JOIN coordenadas_vehiculo cv ON cv.vehiculoId = g.idVehiculo
  WHERE a.fechaCreacion >= \''.$fechaPeticiones.' 00:00:00\' AND a.fechaCreacion <= \''.$fechaPeticionesFin.' 23:59:59\'
  ORDER BY a.fechaCreacion DESC;
';

$titulosColumnas = array(
  "ID",
  "Tipo Peticion",
  "Usuario",
  "Asignado(a)", 
  "Status Asignacion",
  "Reporte Asignacion",
  "Status Comunicacion",
  "Fecha Peticion",
  "Comite Actual",
  "Comite Anterior", 
  "Operador",
  "Fecha Asignacion",
  "Fecha Finalizacion",
  "Coordenadas Inicio",
  "Coordenadas Fin",
  "Estado", 
  "Tiempo Atendido"
);

$columnas = array(
  'idPeticion',
  'tipo_peticion',
  'usuario_peticion',
  'nombre_usuario_turno', 
  'statusAsignacion',
  'statusComunicacion',
  'fechaCreacion',
  'comite',
  'comiteEnPeticion',
  'operador',
  'fechaAsignacion',
  'fechaFinalizacion',
  'coordenadasInicio',
  'coordenadasFin',
  'estatus', 
  'tiempoAtendio'
);
  
  //return json_encode(array("mensaje"=>'no recibi forma'));
  
  //ejecutamos query
  $result =  mysqli_query($connectionStatus, $query);
  //echo "result <br>";
  //print_r($result);echo "<br><br>";
  //echo "Termina result<br>";
  $info_campos = $result->fetch_fields();

  /*echo "<pre>";
  print_r($result);
  echo "</pre>";*/
        
  if (PHP_SAPI == 'cli') die('Este archivo solo se puede ver desde un navegador web');

    // Se crea el objeto PHPExcel
    $objPHPExcel = new PHPExcel();

    // Se asignan las propiedades del libro
    $objPHPExcel->getProperties()->setCreator("Framelova") //Author
    ->setLastModifiedBy("Framelova") //Ultimo usuario que lo modifico
    ->setTitle("Reporte de peticiones")
    ->setSubject("Peticiones")
    ->setDescription("Reporte de peticiones por fecha asignada")
    ->setKeywords("Reporte Peticiones")
    ->setCategory("Peticiones");
        
				
    //inyectamos titulos de columnas
    $totalTituloCol = count($titulosColumnas);
    $colB = 'A';
    $FilaTitulo = 1;

    for($i=1; $i<=$totalTituloCol; $i++){
      $objPHPExcel->getActiveSheet()->setCellValue($colB.$FilaTitulo, $titulosColumnas[$i-1]);
      $colB++;
    }

    //inyectamos filas
    $contLetra = "$colB"."1";
    $iIns=2;

    $colA = 'A';
    $filaActual = 2;
        
    $lastCol = 'A';
    
    // Agregamos la columna de los datos del reporte:
    for($i=0; $i<(count($columnas)+1); $i++){
      $lastCol++;
    }


$datosUsuarioObj = new datosUsuarioObj();
$vehiculosObj = new vehiculosObj();
$functions = new globalFunctions();

while ($row=mysqli_fetch_array($result)) {
  /*echo "<pre>";
  print_r($row);
  echo "</pre>";*/
  for($i=1; $i<=(count($columnas)+1); $i++){
    // insertamos los datos del reporte en la columna E (#5):
    if ($colA == 'F') {
      $dtsReporte = "";

      $coordPeticion = explode(",", $row["coordenadasInicio"]);
      $peticionLat = $coordPeticion[0];
      $peticionLong = $coordPeticion[1];

      if ($row["statusAsignacionId"] == catStatusAsignacionObj::ALM_PMI_ASIGNADA) {
        $distPetiAlarmPmi = $functions->getDistanceToCoords(
          $peticionLat, $peticionLong,
          $row["latitud"], $row["longitud"]
        );
        $dtsReporte .= "Alarma PMI {";
        $dtsReporte .= "Distancia: " . ($distPetiAlarmPmi * 1000) . " mts";
        $dtsReporte .= ", Coordenadas: " . $row["latitud"] . ", " . $row["longitud"];
        $dtsReporte .= " }, ";
      }
      // if ($row["statusAsignacionId"] == catStatusAsignacionObj::ALM_COMITE_FUERA_RANGO) {
      // obtener la distancia entre la peticion y la alarma comite:
      $dtsUsuario = $datosUsuarioObj->obtDatosUsuarioPorUsuarioId($row["usuarioId"]);
      if ($dtsUsuario->idComite == 0 || $dtsUsuario->idComite == NULL) {
        $dtsReporte .= "Alarma Comite { Sin comite }";
      } else {
        $alarmaComite = $vehiculosObj->VehiculosPorComite($dtsUsuario->idComite);
        $almCmtLat = $alarmaComite->latitud;
        $almCmtLong = $alarmaComite->longitud;

        $distPetiAlarm = $functions->getDistanceToCoords(
          $peticionLat, $peticionLong,
          $almCmtLat, $almCmtLong
        );

        // $objPHPExcel->setActiveSheetIndex(0)->setCellValue(($colA . $filaActual), "$distPetiAlarm km");
        // $colA++; 
        $dtsReporte .= "Alarma Comite {";
        if ($row["statusAsignacionId"] == catStatusAsignacionObj::ALM_PMI_ASIGNADA ||
          $row["statusAsignacionId"] == catStatusAsignacionObj::ALM_COMITE_FUERA_RANGO ||
          $row["statusAsignacionId"] == catStatusAsignacionObj::ALM_COMITE_OCUPADA) {
          $dtsReporte .= " No. Alarma: $alarmaComite->matricula,";
        }
        $dtsReporte .= " Distancia: " . ($distPetiAlarm * 1000) . " mts";
        $dtsReporte .= ", Coordenadas: $almCmtLat, $almCmtLong";
        $dtsReporte .= " }";
      }

      // obtener los permisos del dispositivo del usuario:
      if ($row["permissionsApp"] != NULL) {
        $permisosApp = json_decode($row["permissionsApp"]);
        $permisoGeolo = (
          $permisosApp->geolocation_coarse == true &&
          $permisosApp->geolocation_fine == true &&
          $permisosApp->geolocation_background == true
        ) ? "activado" : "desactivado";

        // $objPHPExcel->setActiveSheetIndex(0)->setCellValue(($colA . $filaActual), $permisoGeolo);
        // $colA++;
        $dtsReporte .= ", Dispositivo Usuario {";
        $dtsReporte .= " SO: $permisosApp->so, Version SO: $permisosApp->version_so, Permiso Ubicacion: $permisoGeolo ";
        $dtsReporte .= "}";
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue(($colA . $filaActual), $dtsReporte);
        $colA++;
      }
    } else {
      //obtenemos el tipo para saber si tiene otro tratamiento
      $type = $info_campos[$i-1]->type;

      if($type == 12){//fecha
        $dateForm=explode(" ",$row[$i-1]);
        $dateForm1=explode("-",$dateForm[0]);
        // $fecha = (isset($dateForm1[2])) ? ($dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1]) : "";
        // $dateForm1F= $dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1];
        $dateForm1F = (isset($dateForm1[2])) ? ($dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1]) : "--";

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, $dateForm1F);
        $colA++;
      }else{
        //$objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, utf8_encode($row[$i-1]));
        //$objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, $row[$i-1]);
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, (($row[$i-1] == NULL) ? "--" : utf8_encode($row[$i-1])));
        $colA++;
      }
    }
  } 
  $colA = 'A';
  $filaActual++;
}
 
    //ponemos estilo a las columnas y filass
		//$objPHPExcel->getActiveSheet()->getColumnDimension($colA)->setWidth(50);

    //<editor-fold defaultstate="collapsed" desc="Estilos columnas" >
    $estiloTituloColumnas = array('font' => array('name'=> 'Arial','bold'=> true,'size'=>10,'color'=> array(
        'rgb' => '000000')),'alignment' => array('horizontal'=>PHPExcel_Style_Alignment::HORIZONTAL_CENTER,'vertical'=>PHPExcel_Style_Alignment::VERTICAL_CENTER,'wrap'=>TRUE));

    $estiloInformacion = new PHPExcel_Style();
    $estiloInformacion->applyFromArray(array('font' => array('name'=>'Arial', 'size'=>8, 'color'=> array('rgb' => '000000'))));

		$objPHPExcel->getActiveSheet()->getStyle('A1:'.$lastCol.'1')->applyFromArray($estiloTituloColumnas);
    
    for($j = 'A'; $j < $lastCol; $j++){
      $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);
    }
    // Se asigna el nombre a la hoja
    $objPHPExcel->getActiveSheet()->setTitle('FormularioWeb');

    // Se activa la hoja para que sea la que se muestre cuando el archivo se abre
    $objPHPExcel->setActiveSheetIndex(0);

    // Inmovilizar paneles
    $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,2);

    $titletmp = "Peticiones-".$fechaPeticiones;
    $titleFile = "Reporte-".$titletmp.".xls";
    header('Content-Type: application/vnd.ms-excel');
    header("Content-Disposition: attachment;filename=$titleFile");
    header('Cache-Control: max-age=0');

    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

    $objWriter->save('php://output');
    
    exit;
    ob_flush();

?>