<?php
/*
 *  © 2012 Framelova. All rights reserved. Privacy Policy
 *  Creado: 27/10/2015
 *  Por: Jonathan Guerrero Pérez - JGP
 *  Descripción: Language Object
 */
$pathDB = 'database/';
$pathComm = 'brules/';

if(file_exists('../database/LanguageDB.php')){
    $pathDB = '../database/';
    $pathComm = '../brules/';
}

// require_once $pathComm."KoolControls/KoolGrid/koolgrid.php";
// require_once $pathComm."KoolControls/KoolAjax/koolajax.php";
// require_once $pathComm."KoolControls/KoolUploader/kooluploader.php";
// include_once $pathComm.'KoolControls/KoolGrid/ext/datasources/MySQLiDataSource.php';
include_once $pathDB.'LanguageDB.php';

class Language{
    
    //Private Fields
    private $_idLanguage = 0; 
    private $_name = '';    
    private $_imgFlag = '';    
    private $_active = 0;    
    private $_btnRestart = '';    
    private $_btnNext = '';    
    private $_btnSave = '';
    private $_textFinal = '';
    private $_textStart = '';
    private $_textExcel = '';
    private $_textBien = '';
    private $_textReg = '';
    private $_textMal = '';
    private $_textPes = '';
    private $_textAdvisor = '';
    
    //Get set Methods
    // <editor-fold desc="getters and setters">
    public function setIDLanguage($value)
    {$this->_idLanguage = $value;}
    public function getIDLanguage()
    {return $this->_idLanguage;}
    
    public function setName($value)
    {$this->_name = $value;}
    public function getName()
    {return $this->_name;}      
    
    public function setImgFlag($value)
    {$this->_imgFlag = $value;}
    public function getImgFlag()
    {return $this->_imgFlag;}      
    
    public function setActive($value)
    {$this->_active = $value;}
    public function getActive()
    {return $this->_active;}  
    
    public function setBtnRestart($value)
    {$this->_btnRestart = $value;}
    public function getBtnRestart()
    {return $this->_btnRestart;}  
    
    public function setBtnNext($value)
    {$this->_btnNext = $value;}
    public function getBtnNext()
    {return $this->_btnNext;}  
    
    public function setBtnSave($value)
    {$this->_btnSave = $value;}
    public function getBtnSave()
    {return $this->_btnSave;}  
    
    public function setTextFinal($value)
    {$this->_textFinal = $value;}
    public function getTextFinal()
    {return $this->_textFinal;}
    
    public function setTextStart($value)
    {$this->_textStart = $value;}
    public function getTextStart()
    {return $this->_textStart;}
    
    public function setTextExcel($value)
    {$this->_textExcel = $value;}
    public function getTextExcel()
    {return $this->_textExcel;}
    
    public function setTextBien($value)
    {$this->_textBien = $value;}
    public function getTextBien()
    {return $this->_textBien;}
    
    public function setTextReg($value)
    {$this->_textReg = $value;}
    public function getTextReg()
    {return $this->_textReg;}
    
    public function setTextMal($value)
    {$this->_textMal = $value;}
    public function getTextMal()
    {return $this->_textMal;}
    
    public function setTextPes($value)
    {$this->_textPes = $value;}
    public function getTextPes()
    {return $this->_textPes;}
    
    public function setTextAdvisor($value)
    {$this->_textAdvisor = $value;}
    public function getTextAdvisor()
    {return $this->_textAdvisor;}
// </editor-fold>
        
    //Get the Operator grid
    public function GetLanguageGrid(){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection(); 
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new LanguageDB();
        $ds = $uDB->LanguageDataSet($ds);
        $grid = new KoolGrid("languagesGrid");
        
        $this->defineGrid($grid, $ds);
        
        $this->defineColumn($grid, "idLanguage", "Id Idioma", false, true);
        $this->defineColumn($grid, "name", "Idioma", true, false, 1);
        //$this->defineColumn($grid, "imgFlag", "Bandera", true, false, 1);  
        $this->defineColumn($grid, "imgFlag", "Bandera", true, false, 0);
        $this->defineColumn($grid, "btnRestart", "Texto reiniciar", true, false, 1);
        $this->defineColumn($grid, "btnNext", "Texto siguiente", true, false, 1);
        $this->defineColumn($grid, "btnSave", "Texto guardar", true, false, 1);
        $this->defineColumn($grid, "textFinal", "Texto final", true, false, 1);
        $this->defineColumn($grid, "textStart", "Texto final", true, false, 1);
        
        $this->defineColumn($grid, "textExcel", "Texto Excelente", false, false, 1);
        $this->defineColumn($grid, "textBien", "Texto Bien", false, false, 1);
        $this->defineColumn($grid, "textReg", "Texto Regular", false, false, 1);
        $this->defineColumn($grid, "textMal", "Texto Mal", false, false, 1);
        $this->defineColumn($grid, "textPes", "Texto Pesimo", false, false, 1);
        
        $this->defineColumn($grid, "textAdvisor", "Texto Advisor", false, false, 1);
        
        $this->defineColumn($grid, "active", "Activo", true, false, 0);
        $this->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();
        
        return $grid;
    }
    
    //Private Functions
    private function defineGrid($grid, $ds)
    {
        //create and define grid		
        $grid->scriptFolder = "../brules/KoolControls/KoolGrid";
        $grid->styleFolder="default";
        $grid->Width = "760px";
        
        $grid->RowAlternative = true;
        $grid->AjaxEnabled = true;		
        $grid->AjaxLoadingImage =  "../brules/KoolControls/KoolAjax/loading/5.gif";
        $grid->Localization->Load("../brules/KoolControls/KoolGrid/localization/es.xml");	

        $grid->AllowInserting = true;		
        $grid->AllowEditing = true;
        $grid->AllowDeleting = true;		
        $grid->AllowSorting = true;
        $grid->ColumnWrap = true;

        $grid->MasterTable->DataSource = $ds;		
        $grid->MasterTable->AutoGenerateColumns = false;			
        $grid->MasterTable->Pager = new GridPrevNextAndNumericPager();
        
        //Show Function Panel
	$grid->MasterTable->ShowFunctionPanel = true;
	//Insert Settings
	$grid->MasterTable->InsertSettings->Mode = "Form";
        $grid->MasterTable->EditSettings->Mode = "form";
        //$grid->MasterTable->EditSettings->InputFocus = "HideGrid";
        $grid->MasterTable->EditSettings->Mode = "Form";
	$grid->MasterTable->InsertSettings->ColumnNumber = 1;
        
    }
    
     //define the grid columns    
    private function defineColumn($grid, $name_field, $name_header, $visible=true, $read_only, $validator=0)
    {
        if ($name_field == 'active') {
            $column = new GridBooleanColumn();
            $column->UseCheckBox = true;
        }
        elseif ($name_field == 'imgFlag') {
            $kul = new KoolUploader('');
            $kul->width = "50px";
            $kul->height = "50px";
            echo $kul->RegisterScript(false);
            $column = new GridFileColumn();                                    
            $column->AllowedExtension = "jpg,png";
            $column->BaseDirectory = '../uploads/imgflags';
            $column->IdColumn = 'idLanguage';
            $column->MultipleUpload = false;
            $column->AllowDelete = true;            
            $kulhandle = new KoolUploadHandler();
            $kulhandle->allowedExtension = "jpg,png";
            $kulhandle->allowDelete = true;
            echo $kulhandle->handleUpload();
        }
        else{        
            $column = new gridboundcolumn();	
        }  
        
        if($validator > 0)
            $column->addvalidator($this->GetValidator ($validator));
        
        $column->DataField = $name_field;
        $column->HeaderText = $name_header;
        $column->ReadOnly = $read_only;
        $column->Visible = $visible;
        $grid->MasterTable->AddColumn($column);
    }
    
    private function GetValidator($type){
        
        switch ($type) {
            case 1: //required
                $validator = new RequiredFieldValidator();
                $validator->ErrorMessage = "Campo requerido";
                return $validator;
                break;
        }
    }
    
    private function defineColumnEdit($grid)
    {
        $column = new grideditdeletecolumn();
        $column->Align = "center";
        $column->HeaderText = "Acciones";
        $grid->MasterTable->AddColumn($column);	        
    }
    
    
    /**
    * GetAllLanguages
    * Get all the companies into the Database
    * 
    * @return An array with language objects
    */
    public function GetAllLanguages($onlyActive){
        $arrRes = array();
        $objDS = new LanguageDB();
        
        $result = $objDS->GetAllLanguages($onlyActive);
        
                
        if ($result)
        {
            while($myRows = mysqli_fetch_array($result)) 
            {
                $tmp = new Language();
                $tmp->setIDLanguage($myRows['idLanguage']);
                $tmp->setName($myRows['name']);
                $tmp->setImgFlag($myRows['imgFlag']);
                $tmp->setActive($myRows['active']);
                                
                $arrRes[$tmp->getIDLanguage()] = $tmp;
                
            }
        }
        
        return $arrRes;
    }
        
    
    //obtener el lenguaje por id
    public function LanguageByID($id){
        $objDS = new LanguageDB();
        $result = $objDS->LanguageByID($id);
        
        if ($result)
        {
            
            $myRows = mysqli_fetch_array($result);
            if($myRows == false) return;
            $this->_idLanguage = $myRows['idLanguage'];                                                
            $this->_name = $myRows['name'];
            $this->_imgFlag = $myRows['imgFlag'];
            $this->_active = $myRows['active'];
            $this->_btnRestart = $myRows['btnRestart'];
            $this->_btnNext = $myRows['btnNext'];
            $this->_btnSave = $myRows['btnSave'];
            $this->_textFinal = $myRows['textFinal'];
            $this->_textStart = $myRows['textStart'];
            $this->_textExcel = $myRows['textExcel'];
            $this->_textBien = $myRows['textBien'];
            $this->_textReg = $myRows['textReg'];
            $this->_textMal = $myRows['textMal'];
            $this->_textPes = $myRows['textPes'];
            $this->_textAdvisor = $myRows['textAdvisor'];
        }
    }
    
    public function getLagCaritsArr(){
        $langCaritasArr[1] = $this->_textExcel;
        $langCaritasArr[2] = $this->_textBien;
        $langCaritasArr[3] = $this->_textReg;
        $langCaritasArr[4] = $this->_textMal;
        $langCaritasArr[5] = $this->_textPes;
        
        return $langCaritasArr;
    }
}
?>