<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/buzonCiudadanoDB.php';
include_once  $dirname.'/database/datosBD.php';
include "../common/config.php";
include_once  $dirname.'/brules/configuracionesGridObj.php';

class buzonCiudadanoObj extends configuracionesGridObj{
    private $_idBuzonCiudadano = 0;
    private $_tipoContacto = 0;
    private $_anonimo =  0;
    private $_mensaje =  0;
    private $_testigo =  0;
    private $_nombreCiudadano = '';
    private $_telefono = '';
    private $_evidencias = '';
    private $_fechaCreacion = '0000-00-00 00:00:00';

    //extras
    private $_nombre = '';

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion de buzonCiudadano por rango de fecha
    public function ObtTodosbuzonCiudadano($date = '', $dateFin = ''){
        $array = array();
        $ds = new buzonCiudadanoDB();
        $datosBD = new datosBD();

        $result = $ds->ObtTodosbuzonCiudadanoDB($date, $dateFin);
        $array = $datosBD->arrDatosObj($result);

        return $array;
    }

    //Actualiza algun dato del mensaje por su id y su nombre de columna
    public function ActualizarMensaje($campo, $valor, $id)
    {
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new buzonCiudadanoDB();
        $resAct = $objDB->ActualizarMensajeDB($param);
        return $resAct;
    }


    //Obtener coleccion de buzonCiudadanoObjs
    public function GetAllbuzonCiudadanoObj($peticionId = "", $order = "DESC"){
        $array = array();
        $ds = new buzonCiudadanoDB();
        $datosBD = new datosBD();
        $result = $ds->GetallbuzonCiudadanoObj($peticionId, $order);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
    //Obtener coleccion de buzonCiudadanoObjs
    public function GetAllbuzonCiudadanoObjByRpt($idTipoRpt,$idRpt){
        $ds = new buzonCiudadanoDB();
        $obj = new buzonCiudadanoObj();
        $datosBD = new datosBD();
        $result = $ds->GetAllbuzonCiudadanoObjByRptDB($idTipoRpt,$idRpt);
        return  $datosBD->setDatos($result, $obj);;
    }
    //Obtener buzonCiudadanoObjs por su id
    public function obtenerbuzonCiudadanoObjById($id){
        $ds = new buzonCiudadanoDB();
        $obj = new buzonCiudadanoObj();
        $datosBD = new datosBD();
        $result = $ds->obtenerbuzonCiudadanoObjById($id);

        return $datosBD->setDatos($result, $obj);
    }
    // guardar buzonCiudadanoObjs
    public function GuardarbuzonCiudadanoObj(){
        $objDB = new buzonCiudadanoDB();
        $this->_idBuzonCiudadano = $objDB->insertBuzonCiudadanoDB($this->getParams());
    }
    //Eliminar buzonCiudadanoObjs
    public function EliminarbuzonCiudadanoObj($idBuzonCiudadano)
    {
        $objDB = new buzonCiudadanoDB();
        $param[0] = $idBuzonCiudadano;
        return $objDB->deletebuzonCiudadanoDB($param);
    }


    private function getParams($ctr=false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;
        // $this->_fechaUltCambio = $dateTime;

        $param[0] = $this->_tipoContacto;
        $param[1] = $this->_testigo;
        $param[2] = $this->_nombreCiudadano;
        $param[3] = $this->_telefono;
        $param[4] = $this->_mensaje;
        $param[5] = $this->_anonimo;
        $param[6] = $this->_evidencias;
        $param[7] = $this->_fechaCreacion;

        return $param;
    }
    public function reportesbuzonCiudadano($date = '', $dateFin=''){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        if($date == ''){
            $today = getdate();
            $mon="";
            $day="";
            $year="";

            if($today['mon']<10){
                $mon="0".($today['mon']);
            }else{
                $mon=$today['mon'];
            }
           
            $date=$today['year']."-".$mon."-".$today['mday'];
        }

        if($dateFin == ''){
            $today = getdate();
            $mon="";
            $day="";
            $year="";

            if($today['mon']<10){
                $mon="0".($today['mon']);
            }else{
                $mon=$today['mon'];
            }
           
            $dateFin=$today['year']."-".$mon."-".$today['mday'];
        }

            // $result = $this->ObtTodosbuzonCiudadano($date, $dateFin);
            $DataServices = new DataServices();
            $dbConn = $DataServices->getConnection();
            $ds = new MySQLiDataSource($dbConn);
            $uDB = new buzonCiudadanoDB();
            $ds = $uDB->ObtTodosbuzonCiudadanoGridDB($ds, $date, $dateFin);
            $grid = new KoolGrid("gridBuzonCiudadano");
            $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
            $configGrid = new configuracionesGridObj();
            
            $configGrid->defineGrid($grid, $ds);
            $configGrid->defineColumn($grid, "idBuzonCiudadano", "ID",  true, true, 0, "", "auto");
            $configGrid->defineColumn($grid, "tipoContacto", "Tipo Contacto",  true, true, 0, "", "auto");
            $configGrid->defineColumn($grid, "mensaje", "Mensaje",  true, true, 0, "", "auto");
            $configGrid->defineColumn($grid, "testigoTexto", "Testigo",  true, true, 0, "", "auto");
            $configGrid->defineColumn($grid, "anonimoTexto", "An&oacute;nimo",  true, true, 0, "", "auto");
            $configGrid->defineColumn($grid, "nombreCiudadano", "Nombre Ciudadano",  true, true, 0, "", "auto");
            $configGrid->defineColumn($grid, "telefono", "Celular",  true, true, 0, "", "auto");
            $configGrid->defineColumn($grid, "fechaCreacion", "Fecha Creaci&oacute;n",  true, true, 0, "", "auto");
            $configGrid->defineColumnImagenBuzonCiudadano($grid);
            $grid->Process();    
            return $grid;

            //         if(count($result)>0){
            //             foreach($result as $item){
            //                           $anonimo=($item->anonimo==1)?"SI":"NO";
            //                           $testigo=($item->testigo==1)?"SI":"NO";
            //                           $evidencia=($item->evidencias!=null)?'<a href="../upload/buzon_ciudadano/'.$item->evidencias.'">'.$item->evidencias.'</a>':"Sin evidencia";
            //                           $nombreCiudadano=($item->nombreCiudadano=="")?"Anonimo":$item->nombreCiudadano;
            //                           $telefono=($item->telefono==0)?"Anonimo":$item->telefono;
            //                           $html .= '
            //                           <tr>
            //                               <td>'.$item->idBuzonCiudadano.'</td>
            //                               <td>'.$item->nombreTipo.'</td>
            //                               <td>'.substr($item->mensaje, 0,20).'... <a id="btnModal_'.$item->idBuzonCiudadano.'" href="#modal" onclick="muestraMensajePrincipal('.$item->idBuzonCiudadano.')" class="kgrLinkEdit" data-toggle="modal" data-target="#modal_mensaje_principal"><strong>Ver mas</strong></a></td>
            //                               <td>'.$evidencia.'</td>
            //                               <td>'.$testigo.'</td>
            //                               <td>'.$anonimo.'</td>
            //                               <td>'.$nombreCiudadano.'</td>
            //                               <td>'.$telefono.'</td>
            //                               <td>'.convertirFechaVista($item->fechaCreacion).'</td>';
            //                         $html .= '</tr> ';
            //                       }
            //                 }


            //     $html .= '
            //         </tbody>
            //     </table>
            //     </div>
            // ';
            // return $html;
    }
}
