<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/catCuentasDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class catCuentasObj extends configuracionesGridObj {
    private $_idCuenta = 0;
    private $_nombre = '';

    private $_mostrar = 0;

    //get y set
    public function __get($name) {             
        return $this->{"_".$name};
    }
    public function __set($name, $value) {        
        $this->{"_".$name} = $value;
    }

    public function CuentaPorId($id){
        $ds = new catCuentasBD();
        $obj = new catCuentasObj();
        $datosBD = new datosBD();
        $result = $ds->CuentaPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    public function CuentaPorNombre($nombre = ""){
        $ds = new catCuentasBD();
        $obj = new catCuentasObj();
        $datosBD = new datosBD();
        $result = $ds->CuentaPorNombreDB($nombre);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de roles
    public function GetAllCuentas($mostrar = ""){
        $ds = new catCuentasBD();
        $array = array();
        $datosBD = new datosBD();

        $result = $ds->GetAllCuentas($mostrar);
        $array = $datosBD->arrDatosObj($result);

        return $array;            
    }

    public function getShelly($dato =""){  
        $ds = new catCuentasBD();//traer a la clase
        $array = array();// hacer el array
        $datosBD = new datosBD();//conexion a la base
        $result = $ds->getShellyDB($dato);//pasar valores a la clase
        $array = $datosBD->arrDatosObj($result);//regresa valores y del servidor
        return $array;  
    }

    public function ActualizarCampoCuenta($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new catCuentasBD();
        $resAct = $objDB->updateCampoCuentaBD($param);
        return $resAct;
    }

    public function GetCuentasGrid($mostrar = ""){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new catCuentasBD();
        $ds = $uDB->CuentasDataSet($ds, $mostrar);
        $grid = new KoolGrid("comites");
        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idCuenta", "ID", true, true);
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1, "");
        $configGrid->defineColumn($grid, "mostrar", "Mostrar en app", true, false, 0, "");
        

        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }

    // metodo para traer la cuentas de la base de datos 
    public function CuentaAllObj(){
        $ds = new catCuentasBD();
        $obj = new catCuentasObj();
        $datosBD = new datosBD();

        $result = $ds->CuentaAllBD();

        return $datosBD->arrDatosObj($result, $obj);
    }

}
