<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/codigoValidacionDB.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';
include_once  $dirname.'/database/datosBD.php';

class codigoValidacionObj extends configuracionesGridObj{
    private $_idCodigoVal = 0;
    private $_codigo = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion de codigoValidacion
    public function GetAllCodigoValidacion(){
        $array = array();
        $ds = new codigoValidacionDB();

        $datosBD = new datosBD();
        $result = $ds->GetallCodigoValidacion();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener codigoValidacion por su id
    public function obtenerCodigoValidacionByCodigo($codigo){
        $ds = new codigoValidacionDB();
        $obj = new codigoValidacionObj();
        $datosBD = new datosBD();
        $result = $ds->obtenerCodigoValidacionByCodigo($codigo);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener codigoValidacion por su id
    public function validarCodigoCiudadanoPie($codigo, $email, $celular) {
        $codigoValidacionDB = new codigoValidacionDB();
        $datosBD = new datosBD();
        
        $result = $codigoValidacionDB->validarCodigoCiudadanoPieDB($codigo, $email, $celular);
        $data = $datosBD->setDatos($result);

        return $data;
    }
    // guardar codigoValidacion
    public function GuardarcodigoValidacion($email, $celular){
        $objDB = new codigoValidacionDB();
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $fechaCreacion = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual

        return $this->_idCodigoVal = $objDB->insertcodigoValidacionDB($this->_codigo, $email, $celular, $fechaCreacion);
    }

    public function GuardarCodigoValidacionCiudadanoPie($email, $celular){
        $objDB = new codigoValidacionDB();
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $fechaCreacion = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        return $this->_idCodigoVal = $objDB->insertCodigoValidacionCiudadanoPieDB($this->_codigo, $email, $celular, $fechaCreacion);
    }

    //Eliminar codigoValidacion
    public function EliminarcodigoValidacion($idCodigoVal)
    {
        $objDB = new codigoValidacionDB();
        $param[0] = $idCodigoVal;
        return $objDB->deletecodigoValidacionDB($param);
    }

    public function GetAllCodigosValidacionByDateGrid($date='', $dateFin=''){
      $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
      $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
      if($date == ''){
          $today = getdate();
          $mon="";
          $day="";
          $year="";

          if($today['mon']<10){
              $mon="0".($today['mon']);
          }else{
              $mon=$today['mon'];
          }
         
          $date=$today['year']."-".$mon."-".$today['mday'];
      }

      if($dateFin == ''){
          $today = getdate();
          $mon="";
          $day="";
          $year="";

          if($today['mon']<10){
              $mon="0".($today['mon']);
          }else{
              $mon=$today['mon'];
          }
         
          $dateFin=$today['year']."-".$mon."-".$today['mday'];
      }
      

      $DataServices = new DataServices();
      $dbConn = $DataServices->getConnection();
      $ds = new MySQLiDataSource($dbConn);
      $uDB = new codigoValidacionDB();
      $ds = $uDB->CodigosValidacionByDateDataSet($ds, $date, $dateFin);
      
      $grid = new KoolGrid("historialcodigosvalidacion");
      $configGrid = new configuracionesGridObj();

      $configGrid->defineGrid($grid, $ds);
      $configGrid->defineColumn($grid, "idCodigoVal", "ID", true, true);
      $configGrid->defineColumn($grid, "codigo", "C&oacute;digo", true, true);
      $configGrid->defineColumn($grid, "email", "Email", true, true, 0, "", "200px");
      $configGrid->defineColumn($grid, "telefono", "Celular", true, true);
      $configGrid->defineColumn($grid, "fechaCreacion", "Fecha de creaci&oacute;n", true, true, 0, "", "120px");

      //pocess grid
      $grid->Process();

      return $grid;

  }

    private function getParams($ctr=false)
    {   
        $param[0] = $this->_codigo;

        return $param;
    }
}
