<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/comunicadosDB.php';
include_once  $dirname.'/database/datosBD.php';

class comunicadosObj {
    private $_idComunicado = 0;
    private $_titulo = '';
    private $_descripcionCorta = '';
    private $_contenido = '';
    private $_urlComunicado =  '';
    private $_imgComunicado = '';
    private $_opcVisto = 0;
    private $_vistoPor = '';
    private $_opcTurista = '';
    private $_opcCiudadano =  '';
    private $_compartir = 0;
    private $_activo = 0;
    private $_fechaPublicacion =  '0000-00-00 00:00:00';
    private $_fechaDespublicacion = '0000-00-00 00:00:00';
    private $_fechaCreacion = '0000-00-00 00:00:00';
    private $_idUsuarioCmb = 0;
    private $_fechaUltCambio = '0000-00-00 00:00:00';

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion de comunicadoss
    public function GetAllComunicados($activo=0, $tipoOpc=""){
        $array = array();
        $ds = new comunicadosDB();
        $datosBD = new datosBD();
        $result = $ds->GetallComunicados($activo, $tipoOpc);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener comunicadoss por su id
    public function obtenerComunicadosById($id){
        $ds = new comunicadosDB();
        $obj = new comunicadosObj();
        $datosBD = new datosBD();
        $result = $ds->obtenerComunicadosById($id);

        return $datosBD->setDatos($result, $obj);
    }
    // guardar comunicadoss
    public function GuardarComunicados(){
        $objDB = new comunicadosDB();
        return $this->_idDatoUsuario = $objDB->insertComunicadosDB($this->getParams());
    }
    //Eliminar comunicadoss
    public function EliminarComunicados($idDatoUsuario)
    {
        $objDB = new comunicadosDB();
        $param[0] = $idDatoUsuario;
        return $objDB->deleteComunicadosDB($param);
    }
    public function ActualizarCampo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new comunicadosDB();
        $resAct = $objDB->updateComunicadosCampoDB($param);
        return $resAct;
    }

    private function getParams($ctr=false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;
        $this->_fechaUltCambio = $dateTime;

        $param[0] = $this->_titulo;
        $param[1] = $this->_descripcionCorta;
        $param[2] = $this->_contenido;
        $param[3] = $this->_urlComunicado;
        $param[4] = $this->_imgComunicado;
        $param[5] = $this->_opcVisto;
        $param[6] = $this->_vistoPor;
        $param[7] = $this->_opcTurista;
        $param[8] = $this->_opcCiudadano;
        $param[9] = $this->_compartir;
        $param[10] = $this->_activo;
        $param[11] = $this->_fechaPublicacion;
        $param[12] = $this->_fechaDespublicacion;
        $param[13] = $this->_idUsuarioCmb;
        return $param;
    }


    public function GetComunicadosGrid(){
       $DataServices = new DataServices();
       $dbConn = $DataServices->getConnection();
       $ds = new MySQLiDataSource($dbConn);
       $uDB = new comunicadosDB();
       $ds = $uDB->comunicadosDataSet($ds);
       $grid = new KoolGrid("comunicadosGrid");

       $this->defineGridComunicados($grid, $ds);
       $this->defineColumnComunicados($grid, "idComunicado", "ID", false, true);
       $this->defineColumnComunicados($grid, "titulo", "Titulo", true, false, 1,"100px");
       $this->defineColumnComunicados($grid, "descripcionCorta", "Descripcion", true, false, 1,"300px");
       $this->defineColumnComunicados($grid, "contenido", "Contenido", true, false, 1,"400px");
       $this->defineColumnComunicados($grid, "urlComunicado", "URL", true, false, 1,"100px");
       $this->defineColumnComunicados($grid, "opcTurista", "Turista", true, false, 0,"100px");
       $this->defineColumnComunicados($grid, "opcCiudadano", "Ciudadano", true, false, 0,"100px");
       $this->defineColumnComunicados($grid, "compartir", "Compartir", true, false, 0,"100px");
       $this->defineColumnComunicados($grid, "activo", "Activo", false, true, 1,"80px");
       $this->defineColumnEditUser($grid);

       //pocess grid
       $grid->Process();

       return $grid;
   }

   //Private Functions
   private function defineGridComunicados($grid, $ds)
   {
       //create and define grid
       $grid->scriptFolder = "../brules/KoolControls/KoolGrid";
       $grid->styleFolder="office2010blue";
       $grid->Width = "860px";

       $grid->RowAlternative = true;
       $grid->AjaxEnabled = true;
       $grid->AjaxLoadingImage =  "../brules/KoolControls/KoolAjax/loading/5.gif";
       $grid->Localization->Load("../brules/KoolControls/KoolGrid/localization/es.xml");

       $grid->AllowInserting = true;
       $grid->AllowEditing = true;
       $grid->AllowDeleting = true;
       $grid->AllowSorting = true;
       $grid->ColumnWrap = true;
       $grid->AllowScrolling = true;
       //$grid->MasterTable->Height = "540px";
       $grid->MasterTable->ColumnWidth = "90px";
       $grid->AllowResizing = true;

       $grid->MasterTable->DataSource = $ds;
       $grid->MasterTable->AutoGenerateColumns = false;
       $grid->MasterTable->Pager = new GridPrevNextAndNumericPager();
       $grid->MasterTable->Pager->ShowPageSize = true;
       $grid->MasterTable->Pager->PageSizeOptions = "10,25,50,100,150";
       //Show Function Panel
       $grid->MasterTable->ShowFunctionPanel = true;
       //Insert Settings
       $grid->MasterTable->InsertSettings->Mode = "Form";
       $grid->MasterTable->EditSettings->Mode = "Form";
       $grid->MasterTable->InsertSettings->ColumnNumber = 1;
       $grid->ClientSettings->ClientEvents["OnRowConfirmEdit"] = "Handle_OnRowConfirmEdit";
       $grid->ClientSettings->ClientEvents["OnConfirmInsert"] = "Handle_OnConfirmInsert";
   }
   //define the grid columns
   private function defineColumnComunicados($grid,$name_field, $name_header, $visible=true, $read_only=false, $validator=0, $width = "90px")
   {
       if($name_field == 'opcTurista') {
         $column = new GridBooleanColumn();
         $column->UseCheckBox = true;
       }elseif ($name_field == 'opcCiudadano') {
         $column = new GridBooleanColumn();
         $column->UseCheckBox = true;
       }elseif ($name_field == 'compartir') {
         $column = new GridBooleanColumn();
         $column->UseCheckBox = true;
       }
       else{
           $column = new gridboundcolumn();
       }

       if($validator > 0)
           $column->addvalidator($this->GetValidatorUser ($validator));

       $column->Visible = $visible;
       $column->DataField = $name_field;
       $column->HeaderText = $name_header;
       $column->ReadOnly = $read_only;
       $column->Width = $width;
       $grid->MasterTable->AddColumn($column);
   }
   //validar campo
   private function GetValidatorUser($type){
       switch ($type) {
           case 1: //required
               $validator = new RequiredFieldValidator();
               $validator->ErrorMessage = "Campo requerido";
               return $validator;
               break;
           case 2:
               $validator = new RegularExpressionValidator();
               $validator->ValidationExpression = "/^([0-9])+$/"; // Only accept integer.
               $validator->ErrorMessage = "Escriba un valor numerico";
               return $validator;
               break;
       }
   }
   //define la columna de acciones
   private function defineColumnEditUser($grid){
       $column = new GridCustomColumn();
       $column->ItemTemplate = '
           <a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
           . '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>'
           . '<a class="btnDesactivarUsuario" onclick="muestraDesactivarUsuario({idComunicado},\'comunicadosGrid\',\'comunicados\',{activo})"  href="#fancyDesactivarUsuario" title="Activar/Desactivar usuario"><img src="../images/{nombreImg}" class="iconoDesactivar" ></a>';
       $column->Align = "center";
       $column->HeaderText = "Acciones";
       $column->Width = "120px";
       $grid->MasterTable->AddColumn($column);
   }
}
