<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/documentosUsuarioDB.php';
include_once  $dirname.'/database/datosBD.php';

class documentosUsuarioObj {
    private $_idDocumento = 0;
    private $_tipoDocId = 0;
    private $_valido = 0;
    private $_fechaCreacion = '0000-00-00 00:00:00';
    private $_idUsuarioCmb =  0;
    private $_fechaUltCambio = '0000-00-00 00:00:00';
    private $_urlImg = '';

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion de DocumentoUsuarioss
    public function GetAllDocumentoUsuarios(){
        $array = array();
        $ds = new documentoUsuariosDB();
        $datosBD = new datosBD();
        $result = $ds->GetallDocumentoUsuarios();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener DocumentoUsuarioss por su id
    public function obtenerDocumentoUsuariosById($id){
        $ds = new documentoUsuariosDB();
        $obj = new documentosUsuarioObj();
        $datosBD = new datosBD();
        $result = $ds->obtenerDocumentoUsuariosById($id);

        return $datosBD->setDatos($result,$obj);
    }
    // guardar DocumentoUsuarioss
    public function GuardarDocumentoUsuario(){
        $objDB = new documentoUsuariosDB();
        $this->_idDocumento = $objDB->insertDocumentoUsuarioDB($this->getParams());
    }
    //Eliminar DocumentoUsuarioss
    public function EliminarDocumentoUsuarios($idDatoUsuario)
    {
        $objDB = new documentoUsuariosDB();
        $param[0] = $idDatoUsuario;
        return $objDB->deleteDocumentoUsuariosDB($param);
    }
    public function ActualizarCampo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new documentoUsuariosDB();
        $resAct = $objDB->updateCampoDB($param);
        return $resAct;
    }

    private function getParams($ctr=false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;        

        $param[0] = $this->_tipoDocId;
        $param[1] = $this->_valido;
        $param[2] = $this->_fechaCreacion;
        $param[3] = $this->_urlImg;

        return $param;
    }
}
