<?php
$dirname = dirname(__DIR__);

include_once  $dirname . '/database/formulariosBD.php';
include_once  $dirname . '/database/datosBD.php';
include_once  $dirname . '/brules/configuracionesGridObj.php';

class formulariosObJ  extends configuracionesGridObj
{

    private $_idFormulario  = 0;
    private $_nombre = "";
    private $_descripcion = "";
    private $_idEstatusFormulario  = 0;
    private $_fecha_inicio = "";
    private $_fecha_finalizacion = "";
    private $_horaFecha_creacion = "";
    private $_horaFecha_actualizacion = "";
    private $_idUsuario = 0;
    private $_idUsuarioUP = 0;
    private $_PermisoROL = "";
    private $_version = '';




    //get y set

    public function __get($name)
    {
        return $this->{"_" . $name};
    }

    public function __set($name, $value)
    {
        $this->{"_" . $name} = $value;
    }



    public function GuardarFormulario(){
        $objDB = new formulariosBD();
        $this->_idFormulario = $objDB->insertFormulariosBD($this->getParams());
    }



    private function getParams()
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $params[0] = $this->_nombre;
        $params[1] = $this->_descripcion;
        $params[2] = $this->_idEstatusFormulario;
        $params[3] = $this->_horaFecha_creacion;
        $params[4] = $this->_idUsuario;
        return $params;
    }

    public function ActualizarCampoAlarmaByformularioid($campo, $valor, $formularioId)
    {
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $formularioId;
        $objDB = new formulariosBD();
        $resAct = $objDB->updateCampoAlarmaByformularioidBD($param);
        return $resAct;
    }

    public function ObtFormulariosGrid($rolId = "")
    {
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new formulariosBD();
        $ds = $uDB->FormularioDataSet($ds, "", $rolId);
        $grid = new KoolGrid("Formulario");
        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idFormulario", "ID", true, true, 1, "", "auto");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, true, 1, "", "auto");
        $configGrid->defineColumn($grid, "descripcion", "Descripcion", true, true, 1, "", "auto");
        $configGrid->defineColumn($grid, "nombre_estatus", "Estatus del formulario", true, true, 1, "", "auto");

        $configGrid->defineColumnEdit($grid, $rolId);
        $grid->Process();
        return $grid;
    }
    
    public function GetFormurarioPorId($id){
        $ds = new formulariosBD();
        $obj = new formulariosObJ();
        $datosBD = new datosBD();
        $result = $ds->GetFormurarioPorIdBD($id);
        return $datosBD->setDatos($result, $obj);
    }
    public function getAllformulario (){
        $array = array();
        $ds = new formulariosBD();
        $datosBD = new datosBD();
        $result = $ds->getAllformularioBD();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
}