<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/historialInicioSesionDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class historialInicioSesionObj extends configuracionesGridObj {
    private $_idInicioSesion = 0;
    private $_fechaHoraInicioSesion = "";
    private $_fechaHoraCierreSesion = "";
    private $_tiempoLoggeado = "";
    private $_idUsuarioTurno = "";
    private $_idUsuario = "";
    private $_vehiculoId = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    public function obtIdInicioSesionPorHoraUsuario($fechaInicio, $idUsuario){
        $ds = new historialInicioSesionDB();
        $obj = new historialInicioSesionObj();
        $datosBD = new datosBD();
        $result = $ds->obtIdInicioSesionPorHoraUsuarioBD($fechaInicio, $idUsuario);

        return $datosBD->setDatos($result, $obj);
    }

    public function obtDatosUsrLogginPorIdInicio($idInicioSesion){
        $ds = new historialInicioSesionDB();
        $obj = new historialInicioSesionObj();
        $datosBD = new datosBD();
        $result = $ds->obtDatosUsrLogginPorIdInicioBD($idInicioSesion);

        return $datosBD->setDatos($result, $obj);
    }

    public function ActualizarCampoHistorialInicioSesion($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new historialInicioSesionDB();
        $resAct = $objDB->updateCampoHistorialInicioSesionBD($param);
        return $resAct;
    }

    public function GuardarHistorialInicioSesion(){
        $objDB = new historialInicioSesionDB();
        $this->_idInicioSesion = $objDB->insertHistorialInicioSesionBD($this->getParams());
    }

    private function getParams($update = false){
        $param[0] = $this->_fechaHoraInicioSesion;
        $param[1] = $this->_idUsuarioTurno;
        $param[2] = $this->_idUsuario;
        $param[3] = $this->_vehiculoId;
        return $param;
    }

    public function GetAllAccesosSesionesByDateGrid($date='', $dateFin=''){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        if($date == ''){
            $today = getdate();
            $mon="";
            $day="";
            $year="";

            if($today['mon']<10){
                $mon="0".($today['mon']);
            }else{
                $mon=$today['mon'];
            }
           
            $date=$today['year']."-".$mon."-".$today['mday'];
        }

        if($dateFin == ''){
            $today = getdate();
            $mon="";
            $day="";
            $year="";

            if($today['mon']<10){
                $mon="0".($today['mon']);
            }else{
                $mon=$today['mon'];
            }
           
            $dateFin=$today['year']."-".$mon."-".$today['mday'];
        }

        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new historialInicioSesionDB();
        $ds = $uDB->AccesosPatrullerosByDateDataSet($ds, $date, $dateFin, 1);
        $grid = new KoolGrid("accesos_patrulleros");
        $configGrid = new configuracionesGridObj();
        
        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idInicioSesion", "ID Inicio Sesi&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaHoraInicioSesion", "Fecha Inicio Sesi&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaHoraCierreSesion", "Fecha Cierre Sesi&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "unidad", "Unidad", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "matricula", "Matricula", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "usuarioCerrarSesion", "Usuario en cerrar sesi&oacute;n", true, true, 0, "", "auto");

        $configGrid->defineColumnTotalTiempoLoggueadoPorSesion($grid);
        $configGrid->defineColumnTotalEstacionamientosPorSesion($grid);
        $configGrid->defineColumnTotalDesconexionesPorSesion($grid);
        $configGrid->defineColumnTotalAsignacionesPorSesion($grid);
        //pocess grid
        $grid->Process();

        return $grid;
    }
}
