<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/peticionCoordenadasDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class peticionCoordenadasObj  extends configuracionesGridObj{
    private $_idCoordenadasPet = 0;
    private $_latitud = '';
    private $_longitud = 0;
    private $_peticionId = 0;
    private $_registroId = 0;
    private $_usuarioId = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function PeticionCoordenadasPorId($id){
        $ds = new peticionCoordenadasDB();
        $obj = new peticionCoordenadasObj();
        $datosBD = new datosBD();
        $result = $ds->PeticionCoordenadasPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtPeticionCoordenadas($campo = "", $textoBuscar = "", $empresaId = ""){
        $array = array();
        $ds = new peticionCoordenadasDB();
        $datosBD = new datosBD();
        $result = $ds->ObtPeticionCoordenadasDB($campo, $textoBuscar, $empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosPeticionCoordenadas($empresaId = ""){
        $array = array();
        $ds = new peticionCoordenadasDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosPeticionCoordenadasDB($empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ActualizarCampoPeticionCoordendas($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new peticionCoordenadasBD();
        $resAct = $objDB->updateCampoPeticionCoordenadasBD($param);
        return $resAct;
    }

    public function GuardarPeticionCoordenadas(){
        $objDB = new peticionCoordenadasBD();
        $this->_idCoordenadasPet = $objDB->insertPeticionCoordenadasUserBD($this->getParams());
    }

    public function ActualizarPeticionCoordenadas(){
        $objDB = new peticionCoordenadasBD();
        $this->_idCoordenadasPet = $objDB->updatePeticionCoordenadasBD($this->getParams(true));
    }

    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual


        $param[0] = $this->_latitud;
        $param[1] = $this->_longitud;

        if($update){//UPDATE
            $param[2] = $this->_idCoordenadasPet;
        }else{//INSERT
            $param[2] = $this->_peticionId;
            $param[3] = $this->_registroId;
            $param[4] = $this->_usuarioId;
        }

        return $param;
    }

    //Grid personal
     public function ObtPeticionCoordenadasGrid($usuarioId = ""){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new peticionCoordenadasDB();
        $ds = $uDB->PeticionCoordenadasDataSet($ds, $usuarioId);
        $grid = new KoolGrid("PeticionCoordenadasGrid");

        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idPeticion", "ID", false, true);
        // $configGrid->defineColumn($grid, "empresaId", "Empresa", true, false, 1, "90px");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1);
        $configGrid->defineColumn($grid, "activo", "Activo", true, false, 0);
        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }
    //Private Functions
    public function ActualizarCampoPeticionCoordendasBYPet($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new peticionCoordenadasBD();
        $resAct = $objDB->updateCampoPeticionCoordenadasBYPetBD($param);
        return $resAct;
    }
    public function PeticionCoordenadasPorIdPeticion($id){
        $ds = new peticionCoordenadasBD();
        $obj = new peticionCoordenadasObj();
        $datosBD = new datosBD();
        $result = $ds->PeticionCoordenadasPorIdPeticionDB($id);

        return $datosBD->setDatos($result, $obj);
    }
    public function DeletePeticionCoordenadasPorIdUsuario($id){
        $objDB = new peticionCoordenadasBD();
        return $objDB->DeletePeticionCoordenadasPorIdUsuarioDB($id);
    }
}
