<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/rechazosPatrullaDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class rechazosPatrullaObj  extends configuracionesGridObj{
    private $_idRechazoPatrulla = 0;
    private $_idVehiculo = '';
    private $_idPeticion = 0;
    private $_fechaCreacion = "";
    private $_motivo = "";

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function rechazosPatrullaPorIdPeticion($idvehivulo,$idPeticion){
        $ds = new rechazosPatrullaDB();
        $obj = new rechazosPatrullaObj();
        $datosBD = new datosBD();
        $result = $ds->rechazosPatrullaPorIdPeticionDB($idvehivulo,$idPeticion);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtrechazosPatrulla($campo = "", $textoBuscar = "", $empresaId = ""){
        $array = array();
        $ds = new rechazosPatrullaDB();
        $datosBD = new datosBD();
        $result = $ds->ObtrechazosPatrullaDB($campo, $textoBuscar, $empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosrechazosPatrulla($empresaId = ""){
        $array = array();
        $ds = new rechazosPatrullaDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosrechazosPatrullaDB($empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ActualizarCamporechazosPatrulla($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new rechazosPatrullaDB();
        $resAct = $objDB->updateCampoVehiculoBD($param);
        return $resAct;
    }

    public function GuardarRechazosPatrulla(){
        $objDB = new rechazosPatrullaDB();
        $this->_idRechazoPatrulla = $objDB->insertRechazosPatrullaBD($this->getParams());
    }
    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_idVehiculo;
        $param[1] = $this->_idPeticion;
        $param[2] = $this->_fechaCreacion;
        $param[3] = $this->_motivo;

        return $param;
    }


    //Private Functions


}
