<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/rptMascotasDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class rptMascotasObj extends configuracionesGridObj{
    private $_idRptMascota = 0;
    private $_nombreContacto = '';
    private $_emailContacto =  '';
    private $_telContacto = '';
    private $_nombreMascota = '';
    private $_fechaExtraviado = '0000-00-00 00:00:00';
    private $_fechaExtraviado2 = '0000-00-00 00:00:00';
    private $_colExtraviado = '';
    private $_descripcion = '';
    private $_fechaCreacion = '0000-00-00 00:00:00';
    private $_activo = 0;
    private $_idUsuario = 0;
    private $_fechaActualizacion = '0000-00-00 00:00:00';
    private $_fechaCaducidad = '0000-00-00 00:00:00';
    private $_encontrada = 0;
    private $_fechaEncontrado = '0000-00-00 00:00:00';

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion de reporte mascotas activas
    public function ObtRptMascotas($activo=1){
        $array = array();
        $ds = new rptMascotasDB();
        $datosBD = new datosBD();
        $result = $ds->ObtRptMascotasDB($activo);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de todas mascotas
    public function ObtTodasMascotasPerdidasObj(){
        $array = array();
        $ds = new rptMascotasDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodasMascotasPerdidasDB();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }


    //Obtener mascota por su id
    public function obtRptMascotaPorId($id){
        $ds = new rptMascotasDB();
        $obj = new rptMascotasObj();
        $datosBD = new datosBD();
        $result = $ds->obtRptMascotaPorIdDB($id);

        return $datosBD->setDatos($result,$obj);
    }

    // guardar
    public function GuardarRptMascota(){
        $objDB = new rptMascotasDB();
        return $this->_idRptMascota = $objDB->insertarRptMascotaDB($this->getParams());
    }

    /*
    //Eliminar rptMascotasObjs
    public function EliminarrptMascotasObj($idDatoUsuario)
    {
        $objDB = new rptMascotasDB();
        $param[0] = $idDatoUsuario;
        return $objDB->deleterptMascotasDB($param);
    }
    public function ActualizarCampo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new rptMascotasDB();
        $resAct = $objDB->updateCampoDB($param);
        return $resAct;
    }
    */

    private function getParams($ctr=false)
    {
        $dateByZone = obtDateTimeZone();
        $daymas15dias = new DateTime("15 days", new DateTimeZone("America/Mexico_City"));
        $this->_fechaCaducidad = $daymas15dias->format("Y-m-d H:i:s");

        $this->_fechaCreacion = $dateByZone->fechaHora;
        $this->_fechaActualizacion = $dateByZone->fechaHora;
        $this->_encontrada = 0;
        //$this->_fechaExtraviado = $dateByZone->fechaHora;

        $param[0] = $this->_nombreContacto;
        $param[1] = $this->_emailContacto;
        $param[2] = $this->_telContacto;
        $param[3] = $this->_nombreMascota;
        $param[4] = $this->_colExtraviado;
        $param[5] = $this->_descripcion;
        $param[6] = $this->_fechaCreacion;
        $param[7] = $this->_fechaExtraviado;
        $param[8] = $this->_activo;
        $param[9] = $this->_idUsuario;
        $param[10] = $this->_fechaActualizacion;
        $param[11] = $this->_fechaCaducidad;
        $param[12] = $this->_encontrada;

        return $param;
    }

    public function reportesMascotas($date = '', $dateFin='',  $idRol){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new rptMascotasDB();
        $ds = $uDB->ObtRptMascotasGridDB($ds, $date, $dateFin);
        $grid = new KoolGrid("gridMascotas");
        $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
        $configGrid = new configuracionesGridObj();
        
        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idRptMascota", "ID",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "nombreContacto", "Contacto",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "emailContacto", "Email",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "descripcion", "Descripcion",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "nombreMascota", "Nombre de la mascota",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaExtraviado2", "Fecha de extravio",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaCreacion", "Fecha de creación",  true, true, 0, "", "auto");
        // $configGrid->defineColumn($grid, "activo", "Activo",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaActualizacion", "Fecha de actualización de reporte",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaCaducidad2", "Fecha de caducidad de reporte",  true, true, 0, "", "auto");
        $configGrid->defineColumnVerImagenesMascota($grid);
        $configGrid->defineColumnReportesMascotaVista($grid);
        $configGrid->defineColumnEditMascotasDesaparecidas($grid, $idRol);
        $grid->Process();
        return $grid;
    }

    public function updateCampoRptMascotas($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;
        $objDB = new rptMascotasDB();
        $resAct = $objDB->updateCampoRptMascotasBD($param);
        return $resAct;
    }

    public function eliminarMascotaPerdidaById($idRptMascota) {
        $rptMascotasDB = new rptMascotasDB();
        $result = $rptMascotasDB->eliminarMascotaPerdidaByIdDB($idRptMascota);

        return $result;
    }

}
