<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/rptPersonasDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class rptPersonasObj extends configuracionesGridObj{
    private $_idRptPersona = 0;
    private $_activo = '';
    // private $_nombreContacto = '';
    // private $_emailContacto =  '';
    // private $_telContacto = '';
    // private $_folio = '';
    // // private $_nombrePersona = '';
    // private $_sexo = 0;
    // private $_fechaNacimiento = '0000-00-00 00:00:00';
    // private $_fechaNacimiento2 = '0000-00-00 00:00:00';
    // private $_edad = '';
    // private $_estatura = '';
    // private $_complexion = '';
    // private $_cara = '';
    // private $_cabello = '';
    // private $_nariz = '';
    // private $_orejas = '';
    // private $_boca = '';
    // private $_bigote = '';
    // private $_peso = '';
    // private $_tez = '';
    // private $_frente = '';
    // private $_cejas = '';
    // private $_ojos = '';
    // private $_labios = '';
    // private $_pomulos = '';
    // private $_barba = '';
    // private $_menton = '';
    // private $_lugarExtravio = '';
    // private $_seniasParticulares = '';
    // private $_vestimentaCalzado = '';
    // private $_fechaExtraviado = '0000-00-00 00:00:00';
    // private $_fechaExtraviado2 = '0000-00-00 00:00:00';
    //Datos necesarios
    private $_nombrePersona = '';
    private $_urlImg = '';
    private $_urlImgBoletin = '';    
    private $_lugarExtravio = '';
    private $_numeroContacto = '';
    private $_fechaExtraviado = '0000-00-00 00:00:00';
    private $_fechaExtraviado2 = '0000-00-00 00:00:00';
    private $_fechaCreacion = '0000-00-00 00:00:00';
    private $_idUsuario = 0;
    private $_encontrada = 0;
    private $_fechaEncontrado = '0000-00-00 00:00:00';
    private $_descripcion = '';
    private $_nombreContacto = '';
    private $_correoContacto = '';

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    public function ObtRptPersonasPerdidas(){
        $array = array();
        $ds = new rptPersonasDB();
        $datosBD = new datosBD();
        $result = $ds->ObtRptPersonasDB();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ObtRptPersonasPerdidasActivas($activo){
        $array = array();
        $ds = new rptPersonasDB();
        $datosBD = new datosBD();
        $result = $ds->ObtRptPersonasActivasDB($activo);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
    
    public function ObtTodasPersonasPerdidas(){
        $lastDate = new DateTime("-1 year", new DateTimeZone("America/Mexico_City"));
        $date = $lastDate->format("Y-m-d");
        $currentDate = new DateTime("now", new DateTimeZone('America/Mexico_City'));
        $dateFin = $currentDate->format('Y-m-d');

        $array = array();
        $ds = new rptPersonasDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodasPersonasPerdidasDB($date, $dateFin);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de reporte de personas
    public function ObtRptPersonas($date = '', $dateFin='', $idRol){
        // $result = $ds->ObtRptPersonasDB($activo);
    
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new rptPersonasDB();
        $ds = $uDB->ObtRptGridPersonasDB($ds, $date, $dateFin);
        $grid = new KoolGrid("gridPersonas");
        $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
        $configGrid = new configuracionesGridObj();
        
        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idRptPersona", "ID",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "nombrePersona", "Persona extraviada",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "lugarExtravio", "Lugar",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaExtraviado2", "Fecha de extravio",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaCreacion", "Fecha de creaci&oacute;n",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "numeroContacto", "Num. Contacto",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "nombreContacto", "Nombre contacto",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "correoContacto", "Email contacto",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "descripcion", "Descripci&oacute;n",  true, true, 0, "", "auto");   
        $configGrid->defineColumn($grid, "activo", "Activo",  true, true, 0, "", "auto"); 
        $configGrid->defineColumnVerImagenesPersona($grid);
        // $configGrid->defineColumnActivarPersonaPerdida($grid);
        $configGrid->defineColumnReportesPersonaVista($grid);
        $configGrid->defineColumnEditDesaparecidos($grid, $idRol);
        $grid->Process();    
        return $grid;
    }

    //Obtener persona por su id
    public function ObtRptPersonaPorId($id){
        $ds = new rptPersonasDB();
        $obj = new rptPersonasObj();
        $datosBD = new datosBD();
        $result = $ds->ObtRptPersonaPorIdDB($id);

        return $datosBD->setDatos($result,$obj);
    }

    public function GuardarRptPersona(){
        $objDB = new rptPersonasDB();
        return $this->_idRptPersona = $objDB->insertarRptPersonaDB($this->getParams());
    }

    private function getParams($ctr=false)
    {
        $dateByZone = obtDateTimeZone();
        $this->_fechaCreacion = $dateByZone->fechaHora;
        $this->_encontrada = 0;

        $param[0] = $this->_nombrePersona;
        $param[1] = $this->_numeroContacto;
        $param[2] = $this->_lugarExtravio;
        $param[3] = $this->_fechaExtraviado;
        $param[4] = $this->_fechaCreacion;
        $param[5] = $this->_idUsuario;
        $param[6] = $this->_encontrada;
        $param[7] = $this->_descripcion;
        $param[8] = $this->_nombreContacto;
        $param[9] = $this->_correoContacto;

        return $param;
    }

    public function ActualizarCampoReportePersonas($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = ($id > 0) ? $id : 0;

        $objDB = new rptPersonasDB();
        $resAct = $objDB->updateCampoReportePersonasBD($param);
        return $resAct;
    }

    public function totalPersonasPerdidas($activo){
        $ds = new rptPersonasDB();
        $obj = new rptPersonasObj();
        $datosBD = new datosBD();
        $result = $ds->totalPersonasPerdidasDB($activo);
        return $datosBD->setDatos($result,$obj);
    }

    public function eliminarPersonaPerdidaById($idRptPersona) {
        $rptPersonasDB = new rptPersonasDB();
        $result = $rptPersonasDB->eliminarPersonaPerdidaByIdDB($idRptPersona);

        return $result;
    }

    public function updateCampoRptPersonas($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;
        $objDB = new rptPersonasDB();
        $resAct = $objDB->updateCampoRptPersonasBD($param);
        return $resAct;
    }

     //Obtener coleccion de reporte de personas
     public function ObtRptPersonasEncontradas($date = '', $dateFin='', $idRol){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new rptPersonasDB();
        $ds = $uDB->ObtRptGridPersonasEncontradasDB($ds, $date, $dateFin);
        $grid = new KoolGrid("gridPersonas");
        $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
        $configGrid = new configuracionesGridObj();
        
        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idRptPersona", "ID",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "nombrePersona", "Persona extraviada",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "lugarExtravio", "Lugar",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaExtraviado2", "Fecha de extravio",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaEncontrado", "Fecha reportada como encontrada",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "numeroContacto", "Num. Contacto",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "nombreContacto", "Nombre contacto",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "correoContacto", "Email contacto",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "descripcion", "Descripci&oacute;n",  true, true, 0, "", "auto");   
        $configGrid->defineColumn($grid, "activo", "Activo",  true, true, 0, "", "auto");
        $configGrid->defineColumnVerImagenesPersona($grid);
        // $configGrid->defineColumnActivarPersonaPerdida($grid);
        $configGrid->defineColumnReportesPersonaVista($grid);
        $configGrid->defineColumnEditDesaparecidos($grid, $idRol);
        $grid->Process();    
        return $grid;
    }
}
