<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/usuarioVehiculoDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class usuarioVehiculoObj  extends configuracionesGridObj{
    private $_idUsuarioVehiculo = 0;
    private $_usuarioId = 0;
    private $_nombre = '';
    private $_aPaterno = '';
    private $_aMaterno = '';
    private $_identificador = '';
    private $_telefono = '';
    private $_activo = 0;
    private $_fechaCreacion = '';
    private $_usuarioRegistroId = 0;
    private $_fechaActualizacion = '';
    private $_usuarioActualizacionId = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function UsuarioVehiculoPorId($id){
        $ds = new usuarioVehiculoDB();
        $obj = new usuarioVehiculoObj();
        $datosBD = new datosBD();
        $result = $ds->UsuarioVehiculoPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtUsuarioVehiculo($campo = "", $textoBuscar = "", $empresaId = ""){
        $array = array();
        $ds = new usuarioVehiculoDB();
        $datosBD = new datosBD();
        $result = $ds->ObtUsuarioVehiculoDB($campo, $textoBuscar, $empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosUsuarioVehiculo($empresaId = ""){
        $array = array();
        $ds = new usuarioVehiculoDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosUsuarioVehiculoDB($empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ActualizarCampoUsuarioVehiculo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new usuarioVehiculoBD();
        $resAct = $objDB->updateCampoUsuarioVehiculoBD($param);
        return $resAct;
    }

    public function GuardarUsuarioVehiculo(){
        $objDB = new usuarioVehiculoDB();
        $this->_idUsuarioVehiculo = $objDB->insertUsuarioVehiculoBD($this->getParams());
    }
    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_usuarioId;
        $param[1] = $this->_nombre;
        $param[2] = $this->_aPaterno;
        $param[3] = $this->_aMaterno;
        $param[4] = $this->_identificador;
        $param[5] = $this->_telefono;
        $param[6] = $this->_activo;
        $param[7] = $this->_fechaCreacion;
        $param[8] = $this->_usuarioRegistroId;

        return $param;
    }

    //Grid personal
     public function ObtUsuarioVehiculoGrid($usuarioId = ""){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new usuarioVehiculoDB();
        $ds = $uDB->UsuarioVehiculoDataSet($ds, $usuarioId);
        $grid = new KoolGrid("UsuarioVehiculoGrid");

        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idUsuarioVehiculo", "ID", false, true);
        // $configGrid->defineColumn($grid, "empresaId", "Empresa", true, false, 1, "90px");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1);
        $configGrid->defineColumn($grid, "activo", "Activo", true, false, 0);
        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }
    //Private Functions
    

    public function GuardarUsuarioAlarma($usuarioAlarma, $nombre, $aPaterno, $aMaterno, $matrculaAlarma, $telefono, $activo, $fechaCreacion, $usuarioRegistroId){
        $objDB = new usuarioVehiculoDB();

        $param[0] = $usuarioAlarma;
        $param[1] = $nombre;
        $param[2] = $aPaterno;
        $param[3] = $aMaterno;
        $param[4] = $matrculaAlarma;
        $param[5] = $telefono;
        $param[6] = $activo;
        $param[7] = $fechaCreacion;
        $param[8] = $usuarioRegistroId;

        $this->_idUsuarioVehiculo = $objDB->insertUsuarioVehiculoBD($param);
    }

    public function getUsuarioporid($id){
        $ds = new usuarioVehiculoDB();
        $obj = new usuarioVehiculoObj();
        $datosBD = new datosBD();
        $result = $ds->getUsuarioporidBD($id);

        return $datosBD->setDatos($result, $obj);

    }

}
