<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/usuariosBD.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';
include_once  $dirname.'/brules/rolesObj.php';

class usuariosObj extends configuracionesGridObj{
    private $_idUsuario = 0;
    private $_idRol = 0;
    private $_nombre = '';
    private $_email = '';
    private $_password = '';
    private $_celular = '';
    private $_activo = 0;        
    private $_tipoValidacion = '';
    private $_valido = '';
    private $_fechaCreacion = '0000-00-00 00:00:00';    
    //extras
    private $_usuarioActivo = '';
    private $_nombreImg = '';
    private $_fechaAct = '';
    private $_telefono = '';
    // private $_editcol = '';
    private $_permiso = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //logueo de usuario
    public function LoginUser($email, $password){
        $usrDS = new usuariosBD();
        $datosBD = new datosBD();
        $obj = new usuariosObj();

        $result = $usrDS->LoginUser($email, $password);
        return $datosBD->setDatos($result, $obj);
    }
    //usuario por id
    public function UserByID($id)
    {
        $usrDS = new usuariosBD();
        $obj = new usuariosObj();
        $datosBD = new datosBD();
        $result = $usrDS->UserByID($id);
        
        return $datosBD->setDatos($result,$obj);
              
    }
    
    //Usuario por email (para recupera la contrasenia)
    public function UserByEmail($email)
    {
        $usrDS = new usuariosBD();
        $obj = new usuariosObj();
        $datosBD = new datosBD();
        $result = $usrDS->UserByEmailDB($email);
        return $datosBD->setDatos($result,$obj);
    }

    //Usuario por no. contrato e email
    public function UserByContractEmail($contrat, $email)
    {
        $usrDS = new usuariosBD();
        $datosBD = new datosBD();
        $result = $usrDS->UserByContractEmailDB($contrat, $email);
        return $datosBD->setDatos($result);
    }
    
    //region
    //Grid usuarios
     public function GetUsersGrid($rolUsuarioPedido = "",$idRol = 0){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new usuariosBD();
        $ds = $uDB->UsersDataSet($ds, $rolUsuarioPedido, $idRol);
        $grid = new KoolGrid("usuarios");
        $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idUsuario", "ID", true, true);
        $configGrid->defineColumn($grid, "idRol", "Rol", false, true, 1, "");
        $configGrid->defineColumn($grid, "tipoUsuario", "Tipo Ciudadano", true, true, 1, "");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, true, 1, "");      
        $configGrid->defineColumn($grid, "nombreDU", "Nombre", false, false, 1, "");
        $configGrid->defineColumn($grid, "aPaternoDU", "Apellido Paterno", false, false, 1, "");
        $configGrid->defineColumn($grid, "aMaternoDU", "Apellido Materno", false, false, 1, "");
        $configGrid->defineColumn($grid, "telefono", "Tel&eacute;fono", false, false, 1, "");
        $configGrid->defineColumn($grid, "calle", "Calle", false, false, 0, "");
        $configGrid->defineColumn($grid, "numero", "N&uacute;mero", false, false, 0, "");
        $configGrid->defineColumn($grid, "colonia", "Colonia", false, false, 0, "");
        $configGrid->defineColumn($grid, "cp", "CP", false, false, 0, "");
        $configGrid->defineColumn($grid, "email", "Correo Electr&oacute;nico", true, false, 1, "EMAIL");
        //$configGrid->defineColumn($grid, "nombreComite", "Comite", true, false, 1, "");
        $configGrid->defineColumn($grid, "idComite", "Comit&eacute;", true, true, 1, "");
        $configGrid->defineColumn($grid, "password", "Contraseña", true, true, 1, "");                            
        //$configGrid->defineColumn($grid, "usuarioActivo", "Activo", true, true, 1, "", "60px");
        //$configGrid->defineColumn($grid, "editcol", "", true, true, 1, "", "40px");
        $configGrid->defineColumn($grid, "activo", "Activo", false, true, 1, "", "80px");
        
        if(strpos($rolUsuarioPedido, "3") || strpos($rolUsuarioPedido, "10")){
            $configGrid->defineColumn($grid, "valido", "V&aacute;lido", true, true, 0, "", "80px");
        }
        $configGrid->defineColumn($grid, "comentarios", "Comentarios", false, true, 0, "");

        $configGrid->defineColumnEdit($grid, $rolUsuarioPedido, $idRol);

        //pocess grid
        $grid->Process();

        return $grid;
    }

    public function GetPatrullerosGrid($idRol = 0){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new usuariosBD();
        $ds = $uDB->PatrullerosDataSet($ds);
        $grid = new KoolGrid("usuarios");
        $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idUsuario", "ID", true, true, "auto");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1, "", "auto");      
        $configGrid->defineColumn($grid, "email", "Correo Electr&oacute;nico", true, false, 1, "EMAIL", "auto");
        $configGrid->defineColumnTypePassword($grid);   
        $configGrid->defineColumn($grid, "celular", "No. Celular", true, false, 1, "", "auto");                           
        $configGrid->defineColumn($grid, "activo", "Activo", true, true, 1, "", "auto");
        //$configGrid->defineColumn($grid, "valido", "V&aacute;lido", true, false, 0, "", "80px");
        $configGrid->defineColumnEdit($grid, '4', $idRol);
        //pocess grid
        $grid->Process();
        return $grid;
    }
    
    public function GuardarUsuario(){
        $objDB = new usuariosBD();
        $this->_idUsuario = $objDB->insertUsuarioDB($this->getParams());
    }

    public function GuardarUsuarioCiudadanoPie($params) {
        $objDB = new usuariosBD();
        $this->_idUsuario = $objDB->insertUsuarioCiudadanoPieDB($params);
    }

    public function GuardarNuevoPatrullero($params) {
        $objDB = new usuariosBD();
        $this->_idUsuario = $objDB->insertNuevoPatrulleroDB($params);
    }

    public function EditarUsuario(){
        $objDB = new usuariosBD();
        return $objDB->actualizarUsuarioDB($this->getParams(true));
    }
    public function EditarUsuarioAdmin(){
        $objDB = new usuariosBD();
        return $objDB->actualizarUsuarioDB($this->getParams3(true));
    }
    public function EditarUsuarioPatrullero(){
        $objDB = new usuariosBD();
        return $objDB->actualizarUsuarioPatrulleroDB($this->getParams2());
    }

    private function getParams3($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;
        $this->_fechaAct = $dateTime;

        $param[0] = $this->_idRol;
        $param[1] = $this->_nombre;
        $param[2] = $this->_email;
        $param[3] = $this->_password;                
        $param[4] = $this->_activo;
        $param[5] = $this->_permiso;

        if(!$update){            
            $param[6] = $this->_fechaCreacion;
        }
        else{        
            $param[6] = $this->_fechaAct;
            $param[7] = $this->_idUsuario;
        }

        return $param;
    }

    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;
        $this->_fechaAct = $dateTime;

        $param[0] = $this->_idRol;
        $param[1] = $this->_nombre;
        $param[2] = $this->_email;
        $param[3] = $this->_password;                
        $param[4] = $this->_activo;

        if(!$update){
	    $param[5] = $this->_tipoValidacion;            
            $param[6] = $this->_valido;
            $param[7] = $this->_fechaCreacion;
        }
        else{        
            $param[6] = $this->_fechaAct;
            $param[7] = $this->_idUsuario;
        }

        return $param;
    }

    private function getParams2(){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaAct = $dateTime;

        $param[0] = $this->_idRol;
        $param[1] = $this->_nombre;
        $param[2] = $this->_email;
        $param[3] = $this->_password;    
        $param[4] = $this->_celular;                
        $param[5] = $this->_activo;
        $param[6] = $this->_valido;    
        $param[7] = $this->_fechaAct;
        $param[8] = $this->_idUsuario;
        
        return $param;
    }

    public function ActualizarUsuario($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new usuariosBD();
        $resAct = $objDB->updateUsuarioDB($param);
        return $resAct;
    }
    public function obtUsuariosByIdRol($idRol, $activo=1)
    {
        $array = array();
        $ds = new usuariosBD();
        $datosBD = new datosBD();

        $result = $ds->obtUsuariosByIdRolDB($idRol, $activo);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
    //Obtener todos los usuarios
    public function obtTodosUsuarios($opcObj=true)
    {
        $array = array();
        $ds = new usuariosBD();
        $datosBD = new datosBD();
        $result = $ds->obtTodosUsuariosDB();        

        if($opcObj==true){
           $array = (array)$datosBD->arrDatosObj($result);
            // $array = (array)arrDatosObj($result);
        }else{
           $array = $datosBD->arrDatosObj($result);  
           // $array = arrDatosObj($result);           
        }
        
        return $array;
    } 

    public function obtTodosUsuariosPorRol($idRol)
    {
        $usuariosBD = new usuariosBD();
        $datosBD = new datosBD();
        $result = $usuariosBD->obtTodosUsuariosPorRolDB($idRol);
        $data = $datosBD->arrDatosObj($result);

        return $data;
    } 


    public function checkDoubleLogin($token, $idUsuario) {
        $usuariosBD = new usuariosBD();
        $datosBD = new datosBD();

        $result = $usuariosBD->checkDoubleLoginBD($token, $idUsuario);
        $data = $datosBD->setDatos($result);

        return $data;
    }

    public function checkPeticionActiva($idUsuario) {
        $usuariosBD = new usuariosBD();
        $datosBD = new datosBD();

        $result = $usuariosBD->checkPeticionActivaBD($idUsuario);
        $data = $datosBD->setDatos($result);
        if ($data->hayPeticionActiva == 1) {
            return true;
        }
        
        return false;
    }

    public function validateCredentials($email, $password) {
        $usuariosBD = new usuariosBD();
        $datosBD = new datosBD();

        $result = $usuariosBD->validateCredentialsBD($email, $password);
        $data = $datosBD->setDatos($result);

        return $data;
    }

    public function getUsersFormMsgPush($roles) {
        $usuariosBD = new usuariosBD();
        $datosBD = new datosBD();

        $result = $usuariosBD->getUsersFormMsgPushDB($roles);
        $data = $datosBD->arrDatosObj($result);

        return $data;
    }

    public function verficarComiteConAlarma($idUsuario) {
        $usuariosBD = new usuariosBD();
        $datosBD = new datosBD();

        $result = $usuariosBD->getComiteBD($idUsuario);
        $data = $datosBD->setDatos($result);
        if ($data->idComite != NULL) {

            $result = $usuariosBD->verficarComiteConAlarmaBD($idUsuario);
            $data = $datosBD->setDatos($result);
            if ($data->idVehiculo == NULL) {
                return false;
            }
        }

        return true;
    }

    public function getComite($idUsuario) {
        $usuariosBD = new usuariosBD();
        $datosBD = new datosBD();
        $result = $usuariosBD->getComiteBD($idUsuario);
        $data = $datosBD->setDatos($result);
        
        return $data;
    }

    public function deleteUserById($idUsuario) {
        $usuariosDB = new usuariosBD();

        $result = $usuariosDB->deleteUserByIdDB($idUsuario);

        return $result;
    }

    public function deshabilitarPatrulleroById($idUsuario) {
        $usuariosDB = new usuariosBD();

        $result = $usuariosDB->deshabilitarPatrulleroByIdDB($idUsuario);

        return $result;
    }

    public function activarPatrulleroById($idUsuario) {
        $usuariosDB = new usuariosBD();

        $result = $usuariosDB->activarPatrulleroByIdDB($idUsuario);

        return $result;
    }
    
     public function GuardarUsuarioAdministrador(){
        $objDB = new usuariosBD();
        $this->_idUsuario = $objDB->GuardarUsuarioAdministrador($this->getParamsAdministrador());
        return $this->_idUsuario;
    }

    private function getParamsAdministrador(){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_idRol;
        $param[1] = $this->_nombre;
        $param[2] = $this->_email;
        $param[3] = $this->_password;                
        $param[4] = $this->_activo;
        $param[5] = $this->_fechaCreacion;
        $param[6] = $this->_tipoValidacion;
        $param[7] = $this->_permiso;
       
        
      
        
        return $param;
    }


    public function getUsuarioAdministrador($rolUsuarioPedido = "",$idRol){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new usuariosBD();
        $ds = $uDB->UserAdministrativo($ds, $rolUsuarioPedido, $idRol);
               
        $grid = new KoolGrid("usuariosAdministrativo");
        $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idUsuario", "ID", true, true);
        $configGrid->defineColumn($grid, "idRol", "Rol", false, true, 1, "");
        $configGrid->defineColumn($grid, "tipoUsuario", "Tipo Usuario", true, true, 1, "");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, true, 1, "");
        $configGrid->defineColumn($grid, "email", "Correo Electr&oacute;nico", true, false, 1, "EMAIL");
       
        $configGrid->defineColumn($grid, "activo", "Activo", true, false, 1, "EMAIL");
        $configGrid->defineColumnEdit($grid, $rolUsuarioPedido, $idRol);

        // //pocess grid
        $grid->Process();

        return $grid;
    }

    public function deleteUsuario($idUsuario){
        $objDB = new usuariosBD();
        $resAct = $objDB->deleteUsuario($idUsuario);
        return $resAct;
    }

    public function ValidadCorreo($correo){
        $usrDS = new usuariosBD();
        $obj = new usuariosObj();
        $datosBD = new datosBD();
        $result = $usrDS->ValidadCorreoBD($correo);
        
        return $datosBD->setDatos($result,$obj);        

    }
    
    public function DatosUser($idUser){
        $usrDS = new usuariosBD();
        $obj = new usuariosObj();
        $datosBD = new datosBD();
        $result = $usrDS->DatosUserBD($idUser);
        
        return $datosBD->setDatos($result,$obj);        

    }

    public function TraerUsuariosPorIdRol($idRol){
        $array = array();
        $ds = new usuariosBD();
        $datosBD = new datosBD();

        $result = $ds->TraerUsuariosPorIdRolBD($idRol);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ValidacionUser($idUser){
        $usrDS = new usuariosBD();
        $obj = new usuariosObj();
        $datosBD = new datosBD();
        $result = $usrDS->ValidacionUserBD($idUser);
        return $datosBD->setDatos($result,$obj);     
    }
}
