<?php
$dirname = dirname(__DIR__);
include_once  $dirname . '/database/vehiculosDB.php';
include_once  $dirname . '/database/datosBD.php';
include_once  $dirname . '/brules/configuracionesGridObj.php';

class vehiculosObj  extends configuracionesGridObj
{
    private $_idVehiculo = 0;
    private $_tipoVehiculosId = '';
    private $_usuarioId = 0;
    private $_registroId = 0;
    private $_usuarioTurnoId = 0;
    private $_fechaCreacion = '';
    private $_usuarioOperadorId = 0;
    private $_fechaAsignacion = '';
    private $_fechaFinalizacion = '';
    private $_coordenadasInicio = '';
    private $_coordenadasFin = '';
    private $_estatusId = 0;
    private $_activo = 0;
    private $_estatusAlarma = 0;

    private $_alarmaId = '';
    private $_idComite = '';
    private $_cuenta = '';
    private $_soloComite = 0;

    private $_server = '';
    private $_token = '';

    //get y set
    public function __get($name)
    {
        return $this->{"_" . $name};
    }
    public function __set($name, $value)
    {
        $this->{"_" . $name} = $value;
    }

    //personal por id
    public function VehiculosPorId($id)
    {
        $ds = new vehiculosDB();
        $obj = new vehiculosObj();
        $datosBD = new datosBD();
        $result = $ds->VehiculosPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    public function VehiculosPorComite($id)
    {
        $ds = new vehiculosDB();
        $obj = new vehiculosObj();
        $datosBD = new datosBD();
        $result = $ds->VehiculosPorComiteDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtVehiculos($campo = "", $textoBuscar = "", $empresaId = "")
    {
        $array = array();
        $ds = new vehiculosDB();
        $datosBD = new datosBD();
        $result = $ds->ObtVehiculosDB($campo, $textoBuscar, $empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosVehiculos($tipoVehiculoId = "", $estatusId = "", $activo = "")
    {
        $array = array();
        $ds = new vehiculosDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosVehiculosDB($tipoVehiculoId, $estatusId, $activo);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function vehiculosInicioSesion()
    {
        $array = array();
        $ds = new vehiculosDB();
        $datosBD = new datosBD();
        $result = $ds->vehiculosInicioSesionDB();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de roles
    public function GetAllVehiculos($mostrar = "")
    {
        $ds = new vehiculosDB();
        $array = array();
        $datosBD = new datosBD();

        $result = $ds->GetAllVehiculos($mostrar);
        $array = $datosBD->arrDatosObj($result);

        return $array;
    }


    public function ActualizarCampoVehiculos($campo, $valor, $id)
    {
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new vehiculosDB();
        $resAct = $objDB->updateCampoVehiculoBD($param);
        return $resAct;
    }

    public function ActualizarCampoAlarmaByAlarmaId($campo, $valor, $alarmaId)
    {
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $alarmaId;

        $objDB = new vehiculosDB();
        $resAct = $objDB->updateCampoAlarmaByAlarmaIdBD($param);
        return $resAct;
    }

    public function GuardarVehiculos()
    {
        $objDB = new vehiculosDB();
        $this->_idVehiculo = $objDB->insertVehiculoBD($this->getParams());
    }
    private function getParams($update = false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_tipoVehiculoId;
        $param[1] = $this->_idsEquipamiento;
        $param[2] = $this->_matricula;
        $param[3] = $this->_unidad;
        $param[4] = $this->_activo;
        $param[5] = $this->_estatusId;
        $param[6] = $this->_fechaCreacion;
        $param[7] = $this->_usuarioRegistroId;

        return $param;
    }

    //Grid personal
    public function ObtVehiculosGrid($usuarioId = "")
    {
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new vehiculosDB();
        $ds = $uDB->VehiculosDataSet($ds, $usuarioId);
        $grid = new KoolGrid("VehiculosGrid");

        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idVehiculo", "ID", false, true);
        // $configGrid->defineColumn($grid, "empresaId", "Empresa", true, false, 1, "90px");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1);
        $configGrid->defineColumn($grid, "activo", "Activo", true, false, 0);
        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }

    //>>>>RHS>>>>
    public function ObtAlarmasGrid($rolId = "")
    {


        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new vehiculosDB();
        $ds = $uDB->VehiculosDataSet($ds, "", $rolId);
        $grid = new KoolGrid("Alarmas");
        $configGrid = new configuracionesGridObj();

        //campos que se podraneditar segun el rol (false si puede editar el campo, true no puede editar el campo)
        //cambios que se realicen aqui tendran que modificar la query
        $nombre = false;
        $identificador = false;
        $latitud = false;
        $longitud = false;
        $comite = false;
        $cuenta = false;
        $distancia = false;
        $soloComite = false;

        if ($rolId == "5") {
            $nombre = true;
            $identificador = true;
            $latitud = true;
            $longitud = true;
            $comite = true;
            $cuenta = true;
            $soloComite = true;
        }

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idVehiculo", "ID", true, true, 1, "", "auto");
        $configGrid->defineColumn($grid, "matricula", "Nombre", true, $nombre, 1, "", "auto");
        $configGrid->defineColumn($grid, "alarmaId", "Identificador", true, $identificador, 1, "", "auto");
        $configGrid->defineColumn($grid, "latitud", "Latitud", true, $latitud, 1, "", "auto");
        $configGrid->defineColumn($grid, "longitud", "Longitud", true, $longitud, 1, "", "auto");
        $configGrid->defineColumn($grid, "idComite", "Comite", true, $comite, 1, "", "auto");
        $configGrid->defineColumn($grid, "cuenta", "Cuenta", true, $cuenta, 1, "", "auto");
        $configGrid->defineColumn($grid, "distanciaAlarma", "Distancia", true, $distancia, 1, "", "auto");
        $configGrid->defineColumn($grid, "soloComite", "Solo comite", true, $soloComite);
        $configGrid->defineColumn($grid, "activo", "En linea", true, true, 1, "", "auto");


        $configGrid->defineColumnEdit($grid, $rolId);

        //pocess grid
        $grid->Process();

        return $grid;
    }

    //<<<<RHS<<<<

    public function obtenerDataTableAlarmas($idTable = "", $activo = "")
    {
        $alarmas = $this->ObtTodosVehiculos(4, "", $activo);
        $html = '
            <div class="datable_bootstrap">
                <table id="' . $idTable . '" class="table table-striped table-bordered table-condensed dataTable no-footer dt-responsive" role="grid" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th>Id<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                            <th>Nombre<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                            <th>Estatus<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                            <th>Fecha Ult. Act.<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                        </tr>
                    </thead>
                    <tbody>
                    ';
        if (count($alarmas) > 0) {
            foreach ($alarmas as $item) {
                $estatus = ($item->activo == 1) ? "En linea" : "Fuera de linea";
                $fecha = ($item->fechaActualizacion != '') ? convertirFechaVistaConHora($item->fechaActualizacion) : '';
                $html .= '
                                <tr>
                                    <td>' . $item->idVehiculo . '</td>
                                    <td>' . $item->unidad . '</td>
                                    <td>' . $estatus . '</td>
                                    <td>' . $fecha . '</td>
                                    ';
                $html .= '</tr> ';
            }
        }


        $html .= '
                    </tbody>
                </table>
                </div>';

        return $html;
    }

    public function GuardarAlarma($matrculaAlarma, $fechaCreacion, $identificadorAlarma, $comiteAlarma, $cuentaAlarma, $appServerUrl)
    {

        $vehiculoDB = new vehiculosDB();

        $param[0] = 4; //Tipo vehiculo
        //$param[1] = null; //equipamiento
        $param[1] = $matrculaAlarma; //Matricula
        $param[2] = $matrculaAlarma; //Unidad
        $param[3] = 1; //Activo
        $param[4] = 1; //Status
        $param[5] = $fechaCreacion; //FEcha creacion
        $param[6] = 1; // Usuario de registro
        //$param[7] = null; //fechaActualizacion
        //$param[9] = null; //Usuario actualizacion id
        $param[7] = $identificadorAlarma; //identificador alarma
        $param[8] = 1; //Status alarma
        $param[9] = $comiteAlarma; //idComite
        $param[10] = $cuentaAlarma; //Cuenta
        $param[11] = $appServerUrl; //Server

        $this->_idVehiculo = $vehiculoDB->insertAlarma($param);
    }

    public function GetAlarmaByName($nombreAlarma)
    {
        $ds = new vehiculosDB();
        $obj = new vehiculosObj();
        $datosBD = new datosBD();
        $result = $ds->VehiculosByNameDB($nombreAlarma);

        return $datosBD->setDatos($result, $obj);
    }

    public function GetUnidadesPatrullasGrid($idRol = 0)
    {
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new vehiculosDB();
        $ds = $uDB->UnidadesDataSet($ds, $idRol);
        $grid = new KoolGrid("unidadesPatrullas");
        $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "tipoVehiculoId", "Tipo Veh&iacute;culo",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "unidad", "Unidad",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "matricula", "Matricula",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "activo", "Unidad activa",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "disponibilidadUnidad", "Estatus",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "idInicioSesion", "ID &uacute;ltima sesi&oacute;n activa",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaHoraInicioSesion", "&Uacute;ltimo inicio de sesi&oacute;n",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaHoraCierreSesion", "&Uacute;ltimo cierre de sesi&oacute;n",  true, true, 0, "", "auto");
        $configGrid->defineColumnLiberarUnidad($grid);

        //pocess grid
        $grid->Process();
        return $grid;
    }

    public function obtDatosVehiculoPorId($id)
    {
        $ds = new vehiculosDB();
        $obj = new vehiculosObj();
        $datosBD = new datosBD();
        $result = $ds->obtDatosVehiculoPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }


    // Metodo para traer todas la alarmas 
    public function getAlarmasAll($nombre)
    {
        $ds = new vehiculosDB();
        $array = array();
        $datosBD = new datosBD();
        $result = $ds->GetAlarmasPorCuentaBD($nombre);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }



    public function GuardarPatrulla($param)
    {
        $vehiculoDB = new vehiculosDB();
        $this->_idVehiculo = $vehiculoDB->insertAlarma($param);
    }

    // Metodo  para saber  metros de la alamma mas cerca si la peticion esta duera de rango 

    public function VerAlarma_masCercana($idPeticion)
    {
        $ds = new vehiculosDB();
        $obj = new vehiculosObj();
        $datosBD = new datosBD();

        $result = $ds->VerAlarma_masCercanaBD($idPeticion);

        return $datosBD->setDatos($result, $obj);
    }

    // Metodo para traer todas la alarmas 
    public function GetPatrulleros()
    {
        $ds = new vehiculosDB();
        $array = array();
        $datosBD = new datosBD();
        $result = $ds->GetPatrullerosBD();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    // Metodo para taer los datos del patrulleros como de la unidad esto se flega en app patrullero 

    public function GetPorIDPatrullero($id){
        $ds = new vehiculosDB();
        $obj = new vehiculosObj();
        $datosBD = new datosBD();

        $result = $ds->GetPorIDPatrulleroBD($id);

        return $datosBD->setDatos($result, $obj);

    }

    public function Get_Alarma_solo_comite($id){
        $ds = new vehiculosDB();
        $obj = new vehiculosObj();
        $datosBD = new datosBD();
        $result = $ds->Get_Alarma_solo_comiteBD($id);

        return $datosBD->setDatos($result, $obj);
    }


    public function GetPatrullaByMatricula($matricula)
{
    $ds = new vehiculosDB();
    $obj = new vehiculosObj();
    $datosBD = new datosBD();
    $result = $ds->VehiculosByMatriculaDB($matricula);

    return $datosBD->setDatos($result, $obj);
}


}



