<?php
ob_start();

/*==================================
 ===== reCAPTCHA V2 (checkbox) =====
 ========= Por Jared Gilbon ========
 ================================= */

# Aqui se debe poner la clave secreta del dominio
if (isset($_POST['captchaStatus'])) {
    define('SECRET_KEY', '6LefigYbAAAAAKTiqG73C6SIAreUJxdWTrUWE9sx');

    if (!isset($_POST["g-recaptcha-response"]) || empty($_POST["g-recaptcha-response"])) {
        # Error 1: No se intento resolver el captcha
        $errorCaptcha = 1;
        header('Location: index.php?errorCaptcha=' . $errorCaptcha);
        exit();
    }

    $token = $_POST["g-recaptcha-response"];
    $verificado = verificarToken($token, SECRET_KEY);
    if (!$verificado) {
        # Error 2: No se resolvio el captcha correctamente
        $errorCaptcha = 2;
        header('Location: index.php?errorCaptcha=' . $errorCaptcha);
        exit();
    }
}

# reCAPTCHA V2 FIN

function verificarToken($token, $secretKey)
{
    $url = "https://www.google.com/recaptcha/api/siteverify";
    $datos = [
        "secret" => $secretKey,
        "response" => $token
    ];
    $opciones = array(
        "http" => array(
            "header" => "Content-type: application/x-www-form-urlencoded\r\n",
            "method" => "POST",
            "content" => http_build_query($datos)
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado = file_get_contents($url, false, $contexto);

    # Si la conexión al servidor de GOOGLE falla
    if ($resultado === false) {
        return false;
    }

    $resultado = json_decode($resultado);
    $pruebaPasada = $resultado->success;
    return $pruebaPasada;
}

include_once 'brules/usuariosObj.php';
include_once 'brules/rolesObj.php';
include_once 'brules/registroDispositivosObj.php';
$userObj = new usuariosObj();
$rolesObj = new rolesObj();
$registroDispositivo = new registroDispositivo();

$usrEmail = stripslashes($_POST['usr_email']);
$usrPass = stripslashes($_POST['usr_pass']);

//verificar si existe usuario
// $user = $userObj->LogInUser(trim($usrEmail), trim($usrPass));
$user = $userObj->LogInUser(trim($usrEmail), str_replace("'", "", trim($usrPass)));

if ($user->idUsuario > 0) {
    if ($user->activo > 0) {
        $rolesObj->obtenerRolById($user->idRol);
	// Establecer el tiempo de vida de la cookie de sesión a 24 horas (86400 segundos)
ini_set("session.cookie_lifetime", 86400);
ini_set('session.gc_maxlifetime', 86400); // Configurar también el tiempo máximo en el servidor
        session_start();
        $_SESSION['idUsuario'] = $user->idUsuario;
        $_SESSION['idRol'] = $user->idRol;
        $_SESSION['myusername'] = $user->nombre;
        $_SESSION["status"] = "ok";
        $_SESSION["rol"] = $rolesObj->rol;

       




        if ($user->idRol == 1 || $user->idRol == 2 || $user->idRol == 5 || $user->idRol == 6 || $user->idRol == 9 || $user->idRol == 19 || $user->idRol == 20  || $user->idRol == 22  || $user->idRol == 23  || $user->idRol == 24  || $user->idRol == 25 || $user->idRol == 26 || $user->idRol == 27 || $user->idRol == 28   ) {
            header("location:admin/patrullas.php");
        } elseif ($user->idRol == 4 || $user->idRol == 13) {
            header("location:admin/patrullas.php");
        } elseif ($user->idRol == 7) {
            header("location:admin/histPeticiones.php");
        } elseif ($user->idRol == 8) {
            header("location:admin/dashboard.php");
        } elseif ($user->idRol == 11 || $user->idRol == 12 || $user->idRol == 14 || $user->idRol == 15) {
            header("location:admin/ciudadanos.php");
        } elseif ($user->idRol == 16) {
            header("location:admin/rptPersonas.php");
        } elseif ($user->idRol == 17 || $user->idRol == 18) {
            header("location:admin/mensajes.php");
        } elseif ($user->idRol == 21) {
            header("location:admin/rptMascotas.php");
        } else {
            header("location:index.php?login=error");
        }

    } else {
        header("location:index.php?login=inactivo");
    }
} else {
    header("location:index.php?login=error");
}

ob_flush();
?>