<?php

/*
 *  © 2012 Framelova. All rights reserved. Privacy Policy
 *  Creado: 27/10/2015
 *  Por: Jonathan Guerrero Pérez - JGP
 *  Descripción: User database object
 */

$pathComm = 'common/';
if(file_exists('../common/DataServices.php'))
    $pathComm = '../common/';

include_once $pathComm.'DataServices.php';

class QuestionnairesDB 
{
    
    //properties declarations
    public function QuestionnairesDataSet($ds)
    {		 
        $dsO = new DataServices();		
        $param = null;

        $ds->SelectCommand = $dsO->ExecuteDS("getQuestionnairesForGrid", $param);	
        $ds->UpdateCommand = $dsO->ExecuteDS("updateQuestionnaires", $param);
        $ds->DeleteCommand = $dsO->ExecuteDS("deleteQuestionnaires", $param);
        $ds->InsertCommand = $dsO->ExecuteDS("insertQuestionnaires", $param);
        $dsO->CloseConnection();
        return $ds;			
    }
    
    public function LanQuestDataSet($dsLanQuestions)
    {		 
        $dsO = new DataServices();		
        $param = null;

        $dsLanQuestions->SelectCommand = $dsO->ExecuteDS("getLangToQuestForGrid", $param);	
        $dsLanQuestions->UpdateCommand = $dsO->ExecuteDS("updateLangToQuest", $param);
        $dsLanQuestions->DeleteCommand = $dsO->ExecuteDS("deleteLangToQuest", $param);
        $dsLanQuestions->InsertCommand = $dsO->ExecuteDS("insertLangToQuest", $param);
        $dsO->CloseConnection();
        return $dsLanQuestions;			
    }	
     
    //obtener el cuestionario activo por id de la empresa
    public function GetQuestionnairesActiveByCompany($idcompany)
    {        
        $dsO = new DataServices();
        $params[0] = $idcompany;        
        
        $result = $dsO->Execute("GetQuestionnairesActiveByCompany", $params, false);
        $dsO->CloseConnection();
        return $result;
    }
    
    public function GetLanguageQuestionnaireByIDQuestionnaryAndIdLanguageDB($idEncuesta, $idIdioma)
    {        
        $dsO = new DataServices();
        $params[0] = $idEncuesta;        
        $params[1] = $idIdioma;  
        $result = $dsO->Execute("GetLanguageQuestionnaireByIDQuestionnaryAndIdLanguageDB", $params, false);
        $dsO->CloseConnection();
        return $result;
    }
    
    public function InsertLanguageQuestionnaireDB($idEncuesta, $idIdioma)
    {        
        $dsO = new DataServices();
        $params[0] = $idEncuesta;        
        $params[1] = $idIdioma;  
        $result = $dsO->Execute("InsertLanguageQuestionnaireDB", $params, TRUE);
        $dsO->CloseConnection();
        return $result;
    }
    
    public function InsertQuestionnaireDB($nombre, $descripcion, $cliente)
    {        
        $dsO = new DataServices();
        $params[0] = $nombre;        
        $params[1] = $descripcion;  
        $params[2] = $cliente;  
        $result = $dsO->Execute("InsertQuestionnaireDB", $params, TRUE);
        $dsO->CloseConnection();
        return $result;
    }
    
    //obtener los datos de la encuesta
    public function QuestionaryById($idQ)
    {        
        $dsO = new DataServices();
        $params[0] = $idQ;        
        
        $result = $dsO->Execute("QuestionaryById", $params, false);
        $dsO->CloseConnection();
        return $result;
    }
    
    public function QuestionaryByIdCliente($idCliente)
    {        
        $dsO = new DataServices();
        $params[0] = $idCliente;        
        
        $result = $dsO->Execute("QuestionaryByIdCliente", $params, false);
        $dsO->CloseConnection();
        return $result;
    }
    
}
?>