<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/common/DataServices.php';

class rptMascotasDB {

  //Obtener coleccion de reporte mascotas
  public function ObtRptMascotasDB($activo){
    $ds = new DataServices();
    $param[0] = $activo;
    $result = $ds->Execute("ObtRptMascotasDB", $param);
    $ds->CloseConnection();

    return $result;
  }
  
  public function ObtTodasMascotasPerdidasDB(){
    $ds = new DataServices();
    $param[0] = '';
    $result = $ds->Execute("ObtTodasMascotasPerdidasDB", $param);
    $ds->CloseConnection();

    return $result;
  }

  public function ObtRptMascotasGridDB($ds, $date='', $dateFin=''){
    $dsO = new DataServices();
    if($date != '' && $dateFin != ''){
      $param[0] = "WHERE fechaCreacion>= '".$date." 00:00:00' AND fechaCreacion <= '".$dateFin." 23:59:59' ORDER BY fechaCreacion DESC";
    }else{
      $param[0] = 'ORDER BY fechaCreacion DESC';  
    }

    $ds->SelectCommand = $dsO->ExecuteDS("ObtRptMascotasDB", $param);
    $dsO->CloseConnection();
    return $ds;
  }

  //Obtener mascota por su id
  public function obtRptMascotaPorIdDB($id)
  {
    $ds = new DataServices();
    $param[0]= $id;
    $result = $ds->Execute("obtRptMascotaPorIdDB", $param);
    $ds->CloseConnection();

    return $result;
  }

  //Inserta informacion
  public function insertarRptMascotaDB($param){
    $ds = new DataServices();
    $result = $ds->Execute("insertarRptMascotaDB", $param, true);
    $ds->CloseConnection();

    return $result;
  }

  public function updateCampoRptMascotasBD($param){
    $ds = new DataServices();
    $result = $ds->Execute("updateCampoRptMascotasBD", $param, false, true);
    $ds->CloseConnection();
  
    return $result;
  }

  public function eliminarMascotaPerdidaByIdDB($idRptMascota) {
    $dtServices = new DataServices();
    $params = array();

    $params[0] = $idRptMascota;
    $result = $dtServices->Execute("eliminarMascotaPerdidaByIdDB", $params);
    $dtServices->CloseConnection();

    return $result;
  }

}
