<?php

$pathComm = 'common/';
if (file_exists('../common/DataServices.php')) {
    $pathComm = '../common/';
}

include_once $pathComm . 'DataServices.php';

class saveDataDB {
    
    public function CheckExistQuestionsByQuestionnaires($idQ){
        $ds = new DataServices();
        
        $param[0]=$idQ;
        $result = $ds->Execute("CheckExistQuestionsByQuestionnaires", $param);
        $ds->CloseConnection();
        return $result;
    }
    
    public function createIDQuestionsDB($idQ){
        $ds = new DataServices();
        
        $param[0]=$idQ;
        $result = $ds->Execute("createIDQuestionsDB", $param, true);
        $ds->CloseConnection();
        return $result;
    }    
    
    //salvar los datos del formulario
    public function SaveDataFormDB($idQ, $idL, $data){
        $ds = new DataServices();
        //UPDATE savequestions SET dataJson='?' WHERE idQuestionary=?
        
        $param[0]=$idQ;
        $param[1]=$idL;
        $param[2]=$data;
        $result = $ds->Execute("SaveDataFormDB", $param, true);
        $ds->CloseConnection();
        return $result;
    }
    
    //obtener todas las preguntas por el id del cuestionario
    public function GetAllQuestions($idQ, $idL){
        $ds = new DataServices();
              
        $param[0]=$idQ;
        $param[1]=$idL;
        $result = $ds->Execute("GetAllQuestions", $param);		
        $ds->CloseConnection();
        return $result;
    }
    
    //obtener arreglo de idiomas por id cuestionario
    public function GetAllLanguageByIDQuestionnary($idQ){
        $ds = new DataServices();
              
        $param[0]=$idQ;
        $result = $ds->Execute("GetAllLanguageByIDQuestionnary", $param);		
        $ds->CloseConnection();
        return $result;
    }
    
    //salvar el orden de las preguntas
    public function SaveOrderQuestionsDB($data){
        $ds = new DataServices();
        $position = 1;      
        $result = array();
        foreach($data as $item){
            $id = (int)trim(str_replace("id_preg_", "", $item));
            //array_push($result, $item.'-'.$position);
            
            $param[0]=$position;
            $param[1]=$id;
            $res = $ds->Execute("SaveOrderQuestionsDB", $param, false, true);
            
            if($res > 0){
                $result[] = 1;
            }
            
            $position++;            
        }
              $ds->CloseConnection();          
        return $result;
    }
    
    //obtener pregunta por id 
    public function GetQuestionByID($id){
        $ds = new DataServices();
              
        $param[0]=$id;
        $result = $ds->Execute("GetQuestionByID", $param);		
        $ds->CloseConnection();
        return $result;
    }
    
    //actualiza los datos de la pregunta
    public function UpdateDataQuestionDB($idPreg, $data){
        $ds = new DataServices();        
        
        $param[0]=$data;
        $param[1]=$idPreg;        
        $res = $ds->Execute("UpdateDataQuestionDB", $param, false, true);
        
        if($res > 0){
            $result = $idPreg;
        }else{
            $result = 0;
        }
        $ds->CloseConnection();
        return $result;
    }
 
    //Elimina la pregunta por id
    public function DeleteQuestionById($idPreg){
        $ds = new DataServices();        
                
        $param[0]=$idPreg;        
        $res = $ds->Execute("DeleteQuestionById", $param, false, true);
        
        if($res > 0){
            $result = $idPreg;
        }else{
            $result = 0;
        }
        $ds->CloseConnection();
        return $result;
    }
    
    
}

?>