<?php
$dirname = dirname(__DIR__);
include_once  $dirname . '/common/DataServices.php';

class usuariosTurnoDB
{

    //Otener personal por id
    public function UsuariosTurnoPorIdDB($id)
    {
        $ds = new DataServices();
        $param[0] = ($id > 0) ? $id : 0;
        $result = $ds->Execute("UsuariosTurnoPorIdDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    public function obtUsuarioPorIdUsuarioTurnoDB($idUserTurno)
    {
        $ds = new DataServices();
        $param[0] = $idUserTurno;
        $result = $ds->Execute("obtUsuarioPorIdUsuarioTurnoDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    //Otener col de personal
    public function ObtTodosUsuariosTurnoDB($empresaId)
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if ($empresaId != "") {
            $query[] = " empresaId=$empresaId ";
        }

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }
        $result = $ds->Execute("ObtTodosUsuariosTurnoDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    //Otener col de personal
    public function ObtUsuariosTurnoDB($campo, $textoBuscar, $empresaId)
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if ($campo == "nombre" && $textoBuscar != "") {
            $query[] = " nombre LIKE '%" . $textoBuscar . "%' ";
        }

        if ($campo == "clave" && $textoBuscar != "") {
            $query[] = " claveMat LIKE '%" . $textoBuscar . "%' ";
        }

        if ($empresaId != "") {
            $query[] = " empresaId=$empresaId ";
        }

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }
        $result = $ds->Execute("ObtUsuariosTurnoDB", $param);
        $ds->CloseConnection();
        return $result;
    }


    public function ObtTodosVehiculosDisponiblesDB($idTipoVehiculo, $idPeticion)
    {
        $ds = new DataServices();
        $param[0] = ""; // Modificaci?n: Inicializa $param como un array vac?o en lugar de un array con un elemento vac?o
        $query = array();

        if ($idTipoVehiculo != "") {
            $query[] = "B.tipoVehiculoId IN ($idTipoVehiculo)"; // Modificaci?n: Utiliza [] para agregar elementos al array $query
        }
        if ($idPeticion != "") {
            $query[] = "E.idPeticion=$idPeticion"; // Modificaci?n: Utiliza [] para agregar elementos al array $query
        }

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            $param[0] = $wordWhere . $setWhere; // Modificaci?n: Agrega la cl?usula WHERE al array $param
        }

        // Verifica el contenido de $param para depurar
        //var_dump($param);

        $result = $ds->Execute("ObtTodosVehiculosDisponiblesDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function insertUsuarioTurnoBD($param)
    {
        $ds = new DataServices();
        $result = $ds->Execute("insertUsuarioTurnoBD", $param, true);
        $ds->CloseConnection();
        return $result;
    }

    public function updateCampoUsuarioTurnoBD($param)
    {
        $ds = new DataServices();
        $result = $ds->Execute("updateCampoUsuarioTurnoBD", $param, false, true);
        $ds->CloseConnection();
        return $result;
    }

    public function updateCampoUsuarioTurnoPorusuarioVehiculoIdBD($param)
    {
        $ds = new DataServices();
        $result = $ds->Execute("updateCampoUsuarioTurnoPorusuarioVehiculoIdBD", $param, false, true);
        $ds->CloseConnection();
        return $result;
    }

    public function UsuariosTurnoDataSet($ds, $usuarioId = "")
    {
        $dsO = new DataServices();
        $param[0] = "";
        $query = array();

        // if($usuarioId != ""){
        //     $query[] = " usuarioId=$usuarioId ";
        // }

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }

        $ds->SelectCommand = $dsO->ExecuteDS("ObtUsuariosTurnoDB", $param);
        $param[0] = $usuarioId;
        $ds->InsertCommand = $dsO->ExecuteDS("insUsuariosTurnoGrid", $param);
        $ds->UpdateCommand = $dsO->ExecuteDS("actUsuariosTurnoGrid", $param);
        $param = null;
        $ds->DeleteCommand = $dsO->ExecuteDS("eliminarUsuariosTurnoGrid", $param);
        $dsO->CloseConnection();

        return $ds;
    }

    public function ObtTodosVehiculosDisponiblesByIdDB($idTurno)
    {
        $ds = new DataServices();
        $param[0] = $idTurno;
        $result = $ds->Execute("ObtTodosVehiculosDisponiblesByIdDB", $param);
        $ds->CloseConnection();
        return $result;
    }
    public function UsuariosTurnoPorIdUserDB($id)
    {
        $ds = new DataServices();
        $param[0] = ($id != "") ? $id : 0;
        $result = $ds->Execute("UsuariosTurnoPorIdUserDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function insertUsuarioTurnoAlarmaBD($param)
    {
        $ds = new DataServices();
        $result = $ds->Execute("insertUsuarioTurnoAlarmaBD", $param, true);
        $ds->CloseConnection();
        return $result;
    }

    public function GetAllAlarmaswithCoordsDB()
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }
        $result = $ds->Execute("GetAllAlarmaswithCoordsDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function getVehiculoUsuarioTurnoByIdDB($idUserTurno)
    {
        $ds = new DataServices();
        $params = array(
            $idUserTurno
        );
        $result = $ds->Execute("getVehiculoUsuarioTurnoByIdDB", $params);
        $ds->CloseConnection();
        return $result;
    }

    public function VerificarVehiculoAsociadoBD($vehiculo)
    {
        $param[0] = $vehiculo;
        $ds = new DataServices();
        $result = $ds->Execute("ValidadPatrullaEnUsuariosTurnoBD", $param);
        $ds->CloseConnection();
        return $result;
    }
    public function metodoPorIDuserTurnoBD($id)
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();
        if ($id != "") {
            $query[] = " idUserTurno = $id";
        }

        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            $param[0] = $wordWhere . $setWhere;
        }
        $result = $ds->Execute("ObtTodosUsuariosTurnoDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function MetodoParaPatrullerosBD()
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        $query[] = "v.estatusId = 1";
        $query[] = "v.estatusAlarma = 1";
        $query[] = "v.tipoVehiculoId = 1";

        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            $param[0] = $wordWhere . $setWhere;
        }
       
        $result = $ds->Execute("MetodoParaPatrulleros", $param);
        $ds->CloseConnection();
        return $result;
    }
}
